/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authz.config.Role;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigMap;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyEnabledFlagValidator;
import com.floragunn.searchsupport.util.EsLogging;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FeMultiTenancyEnabledFlagValidatorTest {
    @ClassRule
    public static EsLogging esLogging = new EsLogging();
    @Mock
    private ConfigurationRepository configurationRepository;
    @Mock
    private FeMultiTenancyConfigurationProvider feMultiTenancyConfigurationProvider;
    @Mock
    private ClusterService clusterService;
    @Mock
    private ClusterState clusterState;
    @Mock
    private Metadata metadata;
    @Mock
    private ProjectMetadata projectMetadata;
    private static final String KIBANA_INDEX = ".kibana";
    private FeMultiTenancyEnabledFlagValidator feMultiTenancyEnabledFlagValidator;

    @Before
    public void setUp() throws Exception {
        this.feMultiTenancyEnabledFlagValidator = new FeMultiTenancyEnabledFlagValidator(this.feMultiTenancyConfigurationProvider, this.clusterService, this.configurationRepository);
        Mockito.when((Object)this.feMultiTenancyConfigurationProvider.getKibanaIndex()).thenReturn((Object)KIBANA_INDEX);
        Mockito.when((Object)this.clusterService.state()).thenReturn((Object)this.clusterState);
        Mockito.when((Object)this.clusterState.metadata()).thenReturn((Object)this.metadata);
    }

    @Test
    public void configEntry_shouldValidateFeMtEnabledFlag_valueChanges_thereIsKibanaIndex() throws Exception {
        Mockito.when((Object)this.metadata.getProject()).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectMetadata.getIndicesLookup()).thenReturn(new TreeMap(ImmutableMap.of((Object)".kibana_1.2.3", null)));
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"_"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot change the value of the 'enabled' flag to 'false'. Multitenancy cannot be disabled, please contact the support team."));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"_"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"_"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
    }

    @Test
    public void configEntry_shouldValidateFeMtEnabledFlag_valueChanges_thereIsNoKibanaIndex() throws Exception {
        Mockito.when((Object)this.metadata.getProject()).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectMetadata.getIndicesLookup()).thenReturn(new TreeMap());
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void configEntry_shouldValidateFeMtEnabledFlag_valueDoesNotChange() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)feMtConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configEntry_shouldDoNothing_configTypeNotSupported() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        Role role = (Role)Role.parse((DocNode)DocNode.of((String)"cluster_permissions", (Object)"*"), null).get();
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry((Object)role);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configEntry_shouldDoNothing_configIsNull() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigEntry(null);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void config_shouldValidateFeMtEnabledFlag_valueChanges_thereIsKibanaIndex() throws Exception {
        Mockito.when((Object)this.metadata.getProject()).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectMetadata.getIndicesLookup()).thenReturn(new TreeMap(ImmutableMap.of((Object)KIBANA_INDEX, null)));
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"frontend_multi_tenancy.default"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot change the value of the 'enabled' flag to 'false'. Multitenancy cannot be disabled, please contact the support team."));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"frontend_multi_tenancy.default"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"frontend_multi_tenancy.default"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
    }

    @Test
    public void config_shouldValidateFeMtEnabledFlag_valueChanges_thereIsNoKibanaIndex() throws Exception {
        Mockito.when((Object)this.metadata.getProject()).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectMetadata.getIndicesLookup()).thenReturn(new TreeMap());
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void config_shouldValidateFeMtEnabledFlag_valueDoesNotChange() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void config_shouldDoNothing_configTypeNotSupported() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        Role role = (Role)Role.parse((DocNode)DocNode.of((String)"cluster_permissions", (Object)"*"), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"name", (Object)role);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void config_shouldDoNothing_configIsNull() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(null);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void config_shouldDoNothing_configIsEmpty() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.empty((CType)FeMultiTenancyConfig.TYPE);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void config_shouldDoNothing_configWithUnsupportedKey() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"unsupported", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfig(newConfig);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configList_shouldValidateFeMtEnabledFlag_valueChanges_thereIsKibanaIndex() throws Exception {
        Mockito.when((Object)this.metadata.getProject()).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectMetadata.getIndicesLookup()).thenReturn(new TreeMap(ImmutableMap.of((Object)".kibana001", null)));
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"frontend_multi_tenancy.default"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"Cannot change the value of the 'enabled' flag to 'false'. Multitenancy cannot be disabled, please contact the support team."));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"frontend_multi_tenancy.default"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getAttribute(), (Matcher)Matchers.equalTo((Object)"frontend_multi_tenancy.default"));
        MatcherAssert.assertThat((Object)((ValidationError)validationErrors.get(0)).getMessage(), (Matcher)Matchers.equalTo((Object)"You try to enable multitenancy. This operation cannot be undone. Please use the 'sgctl.sh special enable-mt' command if you are sure that you want to proceed."));
    }

    @Test
    public void configList_shouldValidateFeMtEnabledFlag_valueChanges_thereIsNoKibanaIndex() throws Exception {
        Mockito.when((Object)this.metadata.getProject()).thenReturn((Object)this.projectMetadata);
        Mockito.when((Object)this.projectMetadata.getIndicesLookup()).thenReturn(new TreeMap());
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void configList_shouldValidateFeMtEnabledFlag_valueDoesNotChange() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Arrays.asList(newConfig, null));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(null);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Arrays.asList(newConfig, SgDynamicConfiguration.empty((CType)CType.ROLES)));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)feMtConfig);
        validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configList_shouldDoNothing_listContainsConfigWithUnsupportedType() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        Role role = (Role)Role.parse((DocNode)DocNode.of((String)"cluster_permissions", (Object)"*"), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)CType.ROLES, (String)"name", (Object)role);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configList_shouldDoNothing_listIsNull() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(null);
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configList_shouldDoNothing_listContainsOnlyNullElement() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(null));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configList_shouldDoNothing_listContainsEmptyConfig() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.empty((CType)FeMultiTenancyConfig.TYPE);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    @Test
    public void configList_shouldDoNothing_listContainsConfigWithUnsupportedKey() throws Exception {
        ConfigMap configMap = this.configMapWithConfig(SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"default", (Object)((FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)false), null).get())));
        this.feMultiTenancyEnabledFlagValidator.setConfigMap(configMap);
        FeMultiTenancyConfig feMtConfig = (FeMultiTenancyConfig)FeMultiTenancyConfig.parse((DocNode)DocNode.of((String)"enabled", (Object)true), null).get();
        SgDynamicConfiguration newConfig = SgDynamicConfiguration.of((CType)FeMultiTenancyConfig.TYPE, (String)"unsupported", (Object)feMtConfig);
        List validationErrors = this.feMultiTenancyEnabledFlagValidator.validateConfigs(Collections.singletonList(newConfig));
        MatcherAssert.assertThat((Object)validationErrors, (Matcher)Matchers.hasSize((int)0));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.metadata});
    }

    private ConfigMap configMapWithConfig(SgDynamicConfiguration<?> config) {
        return new ConfigMap.Builder("index").with(config).build();
    }
}

