/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.MapperService;

class IndexSettingsManager {
    static final String MIGRATION_MARKER = "sg_data_migrated_to_8_8_0";
    static final String MAPPINGS_PROPERTIES = "properties";
    private static final Logger log = LogManager.getLogger(IndexSettingsManager.class);
    private final StepRepository stepRepository;

    public IndexSettingsManager(StepRepository stepRepository) {
        this.stepRepository = Objects.requireNonNull(stepRepository, "Repository is required");
    }

    public BasicIndexSettings createIndexWithClonedSettings(String indexSettingsSource, String newIndexForCreation, boolean insertMigrationMarker) {
        String mappingsString;
        Strings.requireNonEmpty((String)indexSettingsSource, (String)"Index name setting source is required");
        Strings.requireNonEmpty((String)newIndexForCreation, (String)"New index name for creation is required");
        GetSettingsResponse settingsResponse = this.stepRepository.getIndexSettings(indexSettingsSource);
        Settings settings = IndexSettingsManager.extractSettings(settingsResponse, indexSettingsSource);
        int numberOfShards = settings.getAsInt("index.number_of_shards", Integer.valueOf(1));
        int numberOfReplicas = settings.getAsInt("index.number_of_replicas", Integer.valueOf(0));
        long mappingsTotalFieldsLimit = settings.getAsLong(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), Long.valueOf(1500L));
        Map<String, Object> mappingSources = this.loadMappingSources(indexSettingsSource);
        if (log.isInfoEnabled()) {
            mappingsString = DocNode.wrap(mappingSources).toJsonString();
            log.info("Index '{}' has '{}' shards, '{}' replicas and mapping fields limit '{}', mappings defined for index '{}'", (Object)indexSettingsSource, (Object)numberOfShards, (Object)numberOfReplicas, (Object)mappingsTotalFieldsLimit, (Object)mappingsString);
        }
        if (insertMigrationMarker) {
            IndexSettingsManager.extendMappingsWithMigrationMarker(mappingSources);
        }
        mappingsString = DocNode.wrap(mappingSources).toJsonString();
        log.debug("Final mappings in newly created index '{}'.", (Object)mappingsString);
        this.stepRepository.createIndex(newIndexForCreation, numberOfShards, numberOfReplicas, mappingsTotalFieldsLimit, mappingSources);
        return new BasicIndexSettings(numberOfShards, numberOfReplicas, mappingsTotalFieldsLimit, mappingsString);
    }

    public boolean isMigrationMarkerPresent(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        Map mappings = Optional.ofNullable(this.stepRepository.findIndexMappings(indexName)).map(GetMappingsResponse::getMappings).map(mappingsMap -> (MappingMetadata)mappingsMap.get(indexName)).map(MappingMetadata::getSourceAsMap).orElseThrow(() -> new StepException("Cannot load index mappings", StepExecutionStatus.CANNOT_LOAD_INDEX_MAPPINGS_ERROR, "Index '" + indexName + "'"));
        log.info("Index '{}' has defined mappings '{}'.", (Object)indexName, (Object)mappings);
        Map properties = (Map)mappings.get(MAPPINGS_PROPERTIES);
        if (Objects.isNull(properties)) {
            String details = "Is index '" + indexName + "' empty?";
            throw new StepException("Mappings for the index are not defined", StepExecutionStatus.EMPTY_MAPPINGS_ERROR, details);
        }
        return properties.containsKey(MIGRATION_MARKER);
    }

    public void addMigrationMarker(String indexName) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        HashMap<String, Object> sources = new HashMap<String, Object>();
        IndexSettingsManager.extendMappingsWithMigrationMarker(sources);
        this.stepRepository.updateMappings(indexName, sources);
    }

    private static Settings extractSettings(GetSettingsResponse response, String indexName) {
        return Optional.ofNullable(response).map(GetSettingsResponse::getIndexToSettings).map(settingsMap -> (Settings)settingsMap.get(indexName)).orElseThrow(() -> new StepException("Cannot find index settings", StepExecutionStatus.NO_SOURCE_INDEX_SETTINGS_ERROR, "Cannot load index '" + indexName + "' settings"));
    }

    private Map<String, Object> loadMappingSources(String indexName) {
        GetMappingsResponse indexMappingsResponse = this.stepRepository.findIndexMappings(indexName);
        return Optional.ofNullable(indexMappingsResponse).map(GetMappingsResponse::getMappings).map(mappingsMap -> (MappingMetadata)mappingsMap.get(indexName)).map(MappingMetadata::getSourceAsMap).orElseThrow(() -> new StepException("Cannot load mappings for index " + indexName, StepExecutionStatus.CANNOT_LOAD_INDEX_MAPPINGS_ERROR, null));
    }

    private static void extendMappingsWithMigrationMarker(Map<String, Object> mappingSources) {
        if (!mappingSources.containsKey(MAPPINGS_PROPERTIES)) {
            mappingSources.put(MAPPINGS_PROPERTIES, new HashMap());
        }
        Map mappingProperties = (Map)mappingSources.get(MAPPINGS_PROPERTIES);
        mappingProperties.put(MIGRATION_MARKER, ImmutableMap.of((Object)"type", (Object)"boolean"));
    }

    public record BasicIndexSettings(int numberOfShards, int numberOfReplicas, long mappingsTotalFieldsLimit, String mappings) {
    }
}

