/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.FrontendObjectCatalog;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.AddMigrationMarkerToGlobalTenantIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CheckIfIndicesAreBlockedStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CheckIndicesStateStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateBackupOfGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.DeleteGlobalIndexContentStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.DeleteTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.MarkerNodeRemoval;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.MigrationEnvironmentHelper;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateBackupIndicesStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateTenantsStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.UnblockDataIndicesStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.VerifyPreviousBackupStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.WriteBlockStep;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.Constants;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.mapper.MapperService;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MigrationStepsTest {
    private static final Logger log = LogManager.getLogger(MigrationStepsTest.class);
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(2000, 1, 1, 1, 1), ZoneOffset.UTC);
    public static final String TEMP_INDEX_NAME = "data_migration_temp_fe_2000_01_01_01_01_00";
    public static final String BACKUP_INDEX_NAME = "backup_fe_migration_to_8_8_0_2000_01_01_01_01_00";
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.unsupported.single_index_mt_enabled", true}).singleNode().sslEnabled().resources("multitenancy").enterpriseModulesEnabled().embedded().build();
    private final Clock clock = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    private DataMigrationContext context;
    @Mock
    private FeMultiTenancyConfigurationProvider multiTenancyConfigurationProvider;
    @Mock
    private FeMultiTenancyConfig feMultiTenancyConfig;
    @Rule
    public final MigrationEnvironmentHelper environmentHelper = new MigrationEnvironmentHelper(cluster, this.clock);

    @Before
    public void before() {
        this.context = new DataMigrationContext(new MigrationConfig(false), this.clock);
    }

    @Test
    public void shouldReportErrorWhenIndexForMigrationAreNotFound() {
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isFailure(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
    }

    @Test
    public void shouldReportErrorIfMultiTenancyConfigIsNotAvailable() {
        Mockito.when((Object)this.multiTenancyConfigurationProvider.getConfig()).thenReturn(Optional.empty());
        Mockito.when((Object)this.multiTenancyConfigurationProvider.getTenantNames()).thenReturn((Object)ImmutableSet.empty());
        Client client = cluster.getInternalNodeClient();
        StepRepository repository = new StepRepository(PrivilegedConfigClient.adapt((Client)client));
        PopulateTenantsStep populateTenantsStep = new PopulateTenantsStep(this.multiTenancyConfigurationProvider, repository);
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.MULTI_TENANCY_CONFIG_NOT_AVAILABLE_ERROR));
    }

    @Test
    public void shouldFindGlobalTenantIndexForVersion8_7_0() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotUseIndicesInLegacyVersion() {
        MigrationEnvironmentHelper.DoubleAliasIndex legacyPerformanceData = MigrationEnvironmentHelper.DoubleAliasIndex.forTenantWithPrefix(".kibana", "performance_data", "8.6.0");
        MigrationEnvironmentHelper.DoubleAliasIndex legacyEnterpriseTenant = MigrationEnvironmentHelper.DoubleAliasIndex.forTenantWithPrefix(".kibana", "enterprise_tenant", "8.6.0");
        MigrationEnvironmentHelper.DoubleAliasIndex legacyUserTenant = MigrationEnvironmentHelper.DoubleAliasIndex.forTenantWithPrefix(".kibana", "james_bond", "8.4.0");
        MigrationEnvironmentHelper.DoubleAliasIndex indexWithVersionMissMatch = MigrationEnvironmentHelper.DoubleAliasIndex.forTenantWithPrefix(".kibana", "command_tenant", "8.7.159");
        MigrationEnvironmentHelper.DoubleAliasIndex modernFinanceManagement = this.environmentHelper.doubleAliasForTenant("finance_management");
        MigrationEnvironmentHelper.DoubleAliasIndex modernBusinessIntelligence = this.environmentHelper.doubleAliasForTenant("business_intelligence");
        MigrationEnvironmentHelper.LegacyIndex olderBusinessIntelligence = modernBusinessIntelligence.toLegacyIndex("8.6.0");
        MigrationEnvironmentHelper.LegacyIndex oldestBusinessIntelligence = modernBusinessIntelligence.toLegacyIndex("8.4.0");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, legacyPerformanceData, legacyEnterpriseTenant, legacyUserTenant, modernFinanceManagement, modernBusinessIntelligence, indexWithVersionMissMatch, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX);
        this.environmentHelper.createLegacyIndex(olderBusinessIntelligence, oldestBusinessIntelligence);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
        Set tenantNames = tenants.stream().filter(tenantIndex -> !tenantIndex.belongsToUserPrivateTenant()).filter(tenantIndex -> !tenantIndex.belongsToGlobalTenant()).map(TenantIndex::tenantName).collect(Collectors.toSet());
        MatcherAssert.assertThat(tenantNames, (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{"finance_management", "business_intelligence"}));
        List<String> privateUserTenantIndexNames = tenants.stream().filter(TenantIndex::belongsToUserPrivateTenant).map(TenantIndex::indexName).toList();
        MatcherAssert.assertThat(privateUserTenantIndexNames, (Matcher)Matchers.hasSize((int)0));
    }

    @Test
    public void shouldFindGlobalTenantIndexForVersion8_7_1() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.1_001", ".kibana_8.7.1", ".kibana");
        this.environmentHelper.createIndex(globalTenantIndex, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindGlobalTenantIndexForVersion8_7_3() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.3_004", ".kibana_8.7.3", ".kibana");
        this.environmentHelper.createIndex(globalTenantIndex, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindGlobalTenantIndexForVersion8_7_0_pointedByAlias8_7_1() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.0_001", ".kibana_8.7.1", ".kibana");
        this.environmentHelper.createIndex(globalTenantIndex, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindGlobalTenantIndexForVersion8_7_1_pointedByAlias8_7_3() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.1_001", ".kibana_8.7.3", ".kibana");
        this.environmentHelper.createIndex(globalTenantIndex, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindTenantsIndicesForVersion8_7_0_pointedByAlias8_7_1() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.0_001", ".kibana_8.7.1", ".kibana");
        MigrationEnvironmentHelper.DoubleAliasIndex adminTenant = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_-152937574_admintenant_8.7.0_001", ".kibana_-152937574_admintenant", ".kibana_-152937574_admintenant_8.7.1");
        MigrationEnvironmentHelper.DoubleAliasIndex privateTenant = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_92668751_admin_8.7.0_001", ".kibana_92668751_admin", ".kibana_92668751_admin_8.7.1");
        this.environmentHelper.createIndex(globalTenantIndex, adminTenant, privateTenant, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)(tenants.stream().filter(TenantIndex::belongsToGlobalTenant).count() == 1L ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tenants.stream().map(TenantIndex::tenantName).filter(tenantName -> "admin_tenant".equals(tenantName)).count() == 1L ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindTenantsIndicesForVersion8_7_0_pointedByAlias8_7_3() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.0_001", ".kibana_8.7.3", ".kibana");
        MigrationEnvironmentHelper.DoubleAliasIndex adminTenant = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_-152937574_admintenant_8.7.0_001", ".kibana_-152937574_admintenant", ".kibana_-152937574_admintenant_8.7.3");
        MigrationEnvironmentHelper.DoubleAliasIndex privateTenant = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_92668751_admin_8.7.0_001", ".kibana_92668751_admin", ".kibana_92668751_admin_8.7.3");
        this.environmentHelper.createIndex(globalTenantIndex, adminTenant, privateTenant, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)2));
        MatcherAssert.assertThat((Object)(tenants.stream().filter(TenantIndex::belongsToGlobalTenant).count() == 1L ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)(tenants.stream().map(TenantIndex::tenantName).filter(tenantName -> "admin_tenant".equals(tenantName)).count() == 1L ? 1 : 0), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindGlobalTenantIndexForVersion8_7_11() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.11_004", ".kibana_8.7.11", ".kibana");
        this.environmentHelper.createIndex(globalTenantIndex, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        populateTenantsStep.execute(this.context);
        ImmutableList tenants = this.context.getTenantIndices();
        MatcherAssert.assertThat((Object)tenants, (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((TenantIndex)tenants.get(0)).belongsToGlobalTenant(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReportErrorWhenManyGlobalIndicesExist() {
        MigrationEnvironmentHelper.DoubleAliasIndex taskManagerIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_task_manager_8.7.0_001", ".kibana_task_manager_8.7.0", "kibana_task_manager");
        MigrationEnvironmentHelper.DoubleAliasIndex eventLogIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana-event-log-8.7.0-000001", ".kibana-event-log-8.7.0", ".kibana-event-log");
        MigrationEnvironmentHelper.DoubleAliasIndex dataIndex = new MigrationEnvironmentHelper.DoubleAliasIndex("iot-2020-09", "iot-2020", "iot");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex1 = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.11_004", ".kibana_8.7.11", ".kibana");
        MigrationEnvironmentHelper.DoubleAliasIndex globalTenantIndex2 = new MigrationEnvironmentHelper.DoubleAliasIndex(".kibana_8.7.10_001", ".kibana_8.7.10", ".kibana");
        this.environmentHelper.createIndex(globalTenantIndex1, globalTenantIndex2, taskManagerIndex, eventLogIndex);
        this.environmentHelper.createIndex("iot", 0, null, dataIndex);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.GLOBAL_TENANT_NOT_FOUND_ERROR));
    }

    @Test
    public void shouldNotReportErrorInCaseOfConflictBetweenUserPrivateTenantAndGlobalTenant() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, this.environmentHelper.doubleAliasForTenant("SGS_GLOBAL_TENANT"));
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldBreakMigrationProcessWhenGlobalTenantIndexIsNotFound() {
        List<MigrationEnvironmentHelper.DoubleAliasIndex> configuredTenantIndices = this.environmentHelper.getIndicesForConfiguredTenantsWithoutGlobal();
        this.environmentHelper.createIndex(configuredTenantIndices);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.GLOBAL_TENANT_NOT_FOUND_ERROR));
    }

    @Test
    public void shouldFindAllConfiguredTenants() {
        List<MigrationEnvironmentHelper.DoubleAliasIndex> configuredTenantIndices = this.environmentHelper.getIndicesForConfiguredTenantsWithoutGlobal();
        this.environmentHelper.createIndex(configuredTenantIndices);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)(configuredTenantIndices.size() + 1)));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices().size(), (Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(20)));
        List tenantsFoundByStep = this.context.getTenantIndices().stream().map(TenantIndex::tenantName).collect(Collectors.toList());
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        Object[] tenantsFromConfiguration = (String[])configurationProvider.getTenantNames().toArray(String[]::new);
        MatcherAssert.assertThat(tenantsFoundByStep, (Matcher)Matchers.containsInAnyOrder((Object[])tenantsFromConfiguration));
    }

    @Test
    public void shouldNotFindUserPrivateTenants() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices().map(TenantIndex::indexName), (Matcher)Matchers.contains((Object[])new String[]{MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()}));
    }

    @Test
    public void shouldFindLargeNumberOfTenants() {
        ArrayList<MigrationEnvironmentHelper.DoubleAliasIndex> indices = new ArrayList<MigrationEnvironmentHelper.DoubleAliasIndex>();
        indices.add(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        indices.addAll(this.environmentHelper.getIndicesForConfiguredTenantsWithoutGlobal());
        int numberOfPrivateTenants = 101;
        indices.addAll(this.environmentHelper.generatePrivateTenantNames(".kibana", 101));
        this.environmentHelper.createIndex(indices);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)(indices.size() - 101)));
    }

    @Test
    public void shouldUseIndexPrefixReadFromConfiguration() {
        String indexNamePrefix = "wideopenfindashboard";
        MigrationEnvironmentHelper.DoubleAliasIndex privateUserTenant = new MigrationEnvironmentHelper.DoubleAliasIndex(indexNamePrefix + "_8.7.0_001", indexNamePrefix + "_8.7.0", indexNamePrefix);
        MigrationEnvironmentHelper.DoubleAliasIndex definedTenantIndex = new MigrationEnvironmentHelper.DoubleAliasIndex(indexNamePrefix + "_1593390681_performancedata_8.7.0_001", indexNamePrefix + "_1593390681_performancedata_8.7.0", indexNamePrefix + "_1593390681_performancedata");
        this.environmentHelper.createIndex(indexNamePrefix, 0, null, definedTenantIndex);
        this.environmentHelper.createIndex(indexNamePrefix, 0, null, privateUserTenant);
        Mockito.when((Object)this.feMultiTenancyConfig.getIndex()).thenReturn((Object)indexNamePrefix);
        Mockito.when((Object)this.multiTenancyConfigurationProvider.getConfig()).thenReturn(Optional.of(this.feMultiTenancyConfig));
        Mockito.when((Object)this.multiTenancyConfigurationProvider.getTenantNames()).thenReturn((Object)ImmutableSet.of((Object)"performance_data"));
        Client client = cluster.getInternalNodeClient();
        StepRepository repository = new StepRepository(PrivilegedConfigClient.adapt((Client)client));
        PopulateTenantsStep populateTenantsStep = new PopulateTenantsStep(this.multiTenancyConfigurationProvider, repository);
        StepResult result = populateTenantsStep.execute(this.context);
        log.debug("Step result: '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)2));
        TenantIndex tenantIndex = this.context.getTenantIndices().stream().filter(Predicate.not(TenantIndex::belongsToGlobalTenant)).findAny().orElseThrow();
        MatcherAssert.assertThat((Object)tenantIndex.indexName(), (Matcher)Matchers.containsString((String)indexNamePrefix));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldDetectNewlyCreatedTenant() throws Exception {
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            String body = DocNode.of((String)"description", (Object)"Tenant created to test reading the newest multi-tenancy configuration").toJsonString();
            String newTenantName = "tenant-created-in-course-of-test-searching";
            GenericRestClient.HttpResponse response = client.putJson("/_searchguard/api/tenants/" + newTenantName, body, new Header[0]);
            try {
                log.debug("Create tenant status code '{}' and response body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
                this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, this.environmentHelper.doubleAliasForTenant(newTenantName));
                StepResult result = populateTenantsStep.execute(this.context);
                log.debug("Step result: '{}'.", (Object)result);
                MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
                MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)2));
                TenantIndex createdTenant = this.context.getTenantIndices().stream().filter(tenantIndex -> !tenantIndex.belongsToGlobalTenant()).findAny().orElseThrow();
                MatcherAssert.assertThat((Object)createdTenant.tenantName(), (Matcher)Matchers.equalTo((Object)newTenantName));
                MatcherAssert.assertThat((Object)createdTenant.belongsToUserPrivateTenant(), (Matcher)Matchers.equalTo((Object)false));
            }
            finally {
                response = client.delete("/_searchguard/api/tenants/" + newTenantName, new Header[0]);
                MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldReportErrorWhenAliasIsAssociatedWithTooManyIndices() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        MigrationEnvironmentHelper.DoubleAliasIndex index = this.environmentHelper.doubleAliasForTenant("management");
        String additionalIndex = index.indexName() + "_another_index";
        Client client = cluster.getInternalNodeClient();
        client.admin().indices().create(new CreateIndexRequest(index.indexName())).actionGet();
        this.environmentHelper.addCreatedIndex(index);
        client.admin().indices().create(new CreateIndexRequest(additionalIndex)).actionGet();
        try {
            IndicesAliasesRequest.AliasActions aliasAction = new IndicesAliasesRequest.AliasActions(IndicesAliasesRequest.AliasActions.Type.ADD).alias(index.shortAlias()).indices(new String[]{index.indexName(), additionalIndex});
            client.admin().indices().aliases(new IndicesAliasesRequest(Constants.DEFAULT_MASTER_TIMEOUT, Constants.DEFAULT_ACK_TIMEOUT).addAliasAction(aliasAction)).actionGet();
            StepException ex = (StepException)ThrowableAssert.assertThatThrown(() -> populateTenantsStep.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
            MatcherAssert.assertThat((Object)ex.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.CANNOT_RESOLVE_INDEX_BY_ALIAS_ERROR));
        }
        finally {
            client.admin().indices().delete(new DeleteIndexRequest(additionalIndex));
        }
    }

    @Test
    public void shouldCreateValidLegacyNames() {
        MigrationEnvironmentHelper.DoubleAliasIndex privateUserTenant = this.environmentHelper.doubleAliasForTenant("spock");
        MatcherAssert.assertThat((Object)privateUserTenant.indexName(), (Matcher)Matchers.equalTo((Object)".kibana_109651354_spock_8.7.0_001"));
        MatcherAssert.assertThat((Object)privateUserTenant.longAlias(), (Matcher)Matchers.equalTo((Object)".kibana_109651354_spock_8.7.0"));
        MatcherAssert.assertThat((Object)privateUserTenant.shortAlias(), (Matcher)Matchers.equalTo((Object)".kibana_109651354_spock"));
        MatcherAssert.assertThat((Object)privateUserTenant.getIndexNameInVersion("7.17.12"), (Matcher)Matchers.equalTo((Object)".kibana_109651354_spock_7.17.12_001"));
        MatcherAssert.assertThat((Object)privateUserTenant.getLongAliasInVersion("7.17.12"), (Matcher)Matchers.equalTo((Object)".kibana_109651354_spock_7.17.12"));
    }

    @Test
    public void shouldChooseIndicesRelatedToNewestVersion() {
        ImmutableList indices = ImmutableList.of((Object)"admin_tenant", (Object)"management", (Object)"kirk", (Object[])new String[]{"spock", "\u0142uk@sz"}).map(this.environmentHelper::doubleAliasForTenant).with((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)indices);
        this.environmentHelper.createLegacyIndex((MigrationEnvironmentHelper.LegacyIndex[])indices.map(index -> index.toLegacyIndex("7.17.12")).toArray(MigrationEnvironmentHelper.LegacyIndex[]::new));
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)3));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices().map(TenantIndex::indexName), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{".kibana_8.7.0_001", ".kibana_-152937574_admintenant_8.7.0_001", ".kibana_-1799980989_management_8.7.0_001"}));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(".kibana_-152937574_admintenant_7.17.12_001", ".kibana_-152937574_admintenant_7.17.12", ".kibana_-1799980989_management_7.17.12_001", ".kibana_-1799980989_management_7.17.12", ".kibana_3292183_kirk_7.17.12_001", ".kibana_3292183_kirk_7.17.12", ".kibana_739956815_uksz_7.17.12_001", ".kibana_739956815_uksz_7.17.12_001", ".kibana_109651354_spock_7.17.12_001", ".kibana_109651354_spock_7.17.12"), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldRecognizeTenantType() {
        ImmutableList indices = ImmutableList.of((Object)"admin_tenant", (Object)"kirk").map(this.environmentHelper::doubleAliasForTenant).with((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)indices);
        PopulateTenantsStep populateTenantsStep = this.createPopulateTenantsStep();
        StepResult result = populateTenantsStep.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getTenantIndices(), (Matcher)Matchers.hasSize((int)2));
        String global = this.context.getTenantIndices().stream().filter(TenantIndex::belongsToGlobalTenant).map(TenantIndex::tenantName).findFirst().orElseThrow();
        String configured = this.context.getTenantIndices().stream().filter(tenant -> !tenant.belongsToGlobalTenant()).filter(tenant -> !tenant.belongsToUserPrivateTenant()).map(TenantIndex::tenantName).findFirst().orElseThrow();
        MatcherAssert.assertThat((Object)global, (Matcher)Matchers.equalTo((Object)"SGS_GLOBAL_TENANT"));
        MatcherAssert.assertThat((Object)configured, (Matcher)Matchers.equalTo((Object)"admin_tenant"));
    }

    @Test
    public void shouldDetectIndexInYellowState() {
        CheckIndicesStateStep step = this.createCheckIndicesStateStep();
        this.environmentHelper.createIndex(".kibana", 25, Settings.EMPTY, MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        this.context.setBackupIndices(ImmutableList.empty());
        StepResult result = step.execute(this.context);
        log.debug("Check index step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
    }

    @Test
    public void shouldNotReportErrorWhenIndicesAreInGreenState() {
        CheckIndicesStateStep step = this.createCheckIndicesStateStep();
        ImmutableList indices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX, (Object[])new MigrationEnvironmentHelper.DoubleAliasIndex[0]);
        this.environmentHelper.createIndex(".kibana", 0, Settings.EMPTY, (MigrationEnvironmentHelper.DoubleAliasIndex[])indices.toArray(MigrationEnvironmentHelper.DoubleAliasIndex[]::new));
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName((ImmutableList<MigrationEnvironmentHelper.DoubleAliasIndex>)indices));
        this.context.setBackupIndices(ImmutableList.empty());
        StepResult result = step.execute(this.context);
        log.debug("Check index step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReportErrorWhenOnlyOneOfIndicesIsYellow() {
        CheckIndicesStateStep step = this.createCheckIndicesStateStep();
        ImmutableList indices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX);
        this.environmentHelper.createIndex(".kibana", 0, Settings.EMPTY, (MigrationEnvironmentHelper.DoubleAliasIndex[])indices.toArray(MigrationEnvironmentHelper.DoubleAliasIndex[]::new));
        this.environmentHelper.createIndex(".kibana", 25, Settings.EMPTY, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        indices = indices.with((Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName((ImmutableList<MigrationEnvironmentHelper.DoubleAliasIndex>)indices));
        this.context.setBackupIndices(ImmutableList.empty());
        StepResult result = step.execute(this.context);
        log.debug("Check index step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()));
    }

    @Test
    public void shouldBeConfiguredToAllowYellowIndices() {
        CheckIndicesStateStep step = this.createCheckIndicesStateStep();
        ImmutableList indices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX);
        this.environmentHelper.createIndex(".kibana", 0, Settings.EMPTY, (MigrationEnvironmentHelper.DoubleAliasIndex[])indices.toArray(MigrationEnvironmentHelper.DoubleAliasIndex[]::new));
        this.environmentHelper.createIndex(".kibana", 25, Settings.EMPTY, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        indices = indices.with((Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        this.context = new DataMigrationContext(new MigrationConfig(true), this.clock);
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName((ImmutableList<MigrationEnvironmentHelper.DoubleAliasIndex>)indices));
        this.context.setBackupIndices(ImmutableList.empty());
        StepResult result = step.execute(this.context);
        log.debug("Check index step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotFindBlockedIndices() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX));
        CheckIfIndicesAreBlockedStep step = new CheckIfIndicesAreBlockedStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()));
    }

    @Test
    public void shouldAllowWriteBlockOnGlobalTenantIndex() throws Exception {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        ImmutableList<TenantIndex> tenantIndices = MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        this.context.setTenantIndices(tenantIndices);
        CheckIfIndicesAreBlockedStep step = new CheckIfIndicesAreBlockedStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.put("/" + MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName() + "/_block/write");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldFindWriteBlockedIndices() throws Exception {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        ImmutableList<TenantIndex> tenantIndices = MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        this.context.setTenantIndices(tenantIndices);
        CheckIfIndicesAreBlockedStep step = new CheckIfIndicesAreBlockedStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.put("/" + managementTenantIndex.indexName() + "/_block/write");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"write"));
    }

    @Test
    public void shouldFindReadBlockedIndices() throws Exception {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        ImmutableList<TenantIndex> tenantIndices = MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        this.context.setTenantIndices(tenantIndices);
        CheckIfIndicesAreBlockedStep step = new CheckIfIndicesAreBlockedStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.put("/" + managementTenantIndex.indexName() + "/_block/read");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        }
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"read"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFindReadOnlyBlockedIndices() throws Exception {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        ImmutableList<TenantIndex> tenantIndices = MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        this.context.setTenantIndices(tenantIndices);
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        CheckIfIndicesAreBlockedStep step = new CheckIfIndicesAreBlockedStep(stepRepository);
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.put("/" + managementTenantIndex.indexName() + "/_block/read_only");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            try {
                StepResult result = step.execute(this.context);
                MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
                MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
                MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"read_only"));
            }
            finally {
                DocNode body = DocNode.of((String)"index.blocks.read_only", (Object)false);
                adminClient.putJson("/" + managementTenantIndex.indexName() + "/_settings", body.toJsonString(), new Header[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldFindMetadataBlockedIndices() throws Exception {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, managementTenantIndex);
        ImmutableList<TenantIndex> tenantIndices = MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(managementTenantIndex, MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        this.context.setTenantIndices(tenantIndices);
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        CheckIfIndicesAreBlockedStep step = new CheckIfIndicesAreBlockedStep(stepRepository);
        try (GenericRestClient adminClient = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = adminClient.put("/" + managementTenantIndex.indexName() + "/_block/metadata");
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            try {
                StepResult result = step.execute(this.context);
                MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
                MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
                MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"metadata"));
            }
            finally {
                DocNode body = DocNode.of((String)"index.blocks.metadata", (Object)false);
                adminClient.putJson("/" + managementTenantIndex.indexName() + "/_settings", body.toJsonString(), new Header[0]);
            }
        }
    }

    @Test
    public void shouldNotFindAnyBackupIndices() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        StepResult result = step.execute(this.context);
        log.info("Step response " + String.valueOf(result));
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldFindSingleBackupIndex() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        this.environmentHelper.createBackupIndex(backupIndex);
        StepResult result = step.execute(this.context);
        log.info("Find backup indices result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((String)this.context.getBackupIndices().get(0)), (Matcher)Matchers.equalTo((Object)backupIndex.indexName()));
    }

    @Test
    public void shouldFindManyBackupIndices_1() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        MigrationEnvironmentHelper.BackupIndex backupIndex6 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(5L));
        MigrationEnvironmentHelper.BackupIndex backupIndex7 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(6L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5, backupIndex6, backupIndex7);
        StepResult result = step.execute(this.context);
        log.info("Find backup indices result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)7));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{backupIndex1.indexName(), backupIndex2.indexName(), backupIndex3.indexName(), backupIndex4.indexName(), backupIndex5.indexName(), backupIndex6.indexName(), backupIndex7.indexName()}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)backupIndex1.indexName()));
    }

    @Test
    public void shouldFindManyBackupIndices_2() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusMinutes(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex6 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusWeeks(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex7 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusMonths(1L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5, backupIndex6, backupIndex7);
        StepResult result = step.execute(this.context);
        log.info("Find backup indices result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)7));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{backupIndex1.indexName(), backupIndex2.indexName(), backupIndex3.indexName(), backupIndex4.indexName(), backupIndex5.indexName(), backupIndex6.indexName(), backupIndex7.indexName()}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)backupIndex1.indexName()));
    }

    @Test
    public void shouldFindManyBackupIndices_3() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(4L));
        MigrationEnvironmentHelper.BackupIndex backupIndex6 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(5L));
        MigrationEnvironmentHelper.BackupIndex backupIndex7 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusSeconds(6L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5, backupIndex6, backupIndex7);
        StepResult result = step.execute(this.context);
        log.info("Find backup indices result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)7));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{backupIndex1.indexName(), backupIndex2.indexName(), backupIndex3.indexName(), backupIndex4.indexName(), backupIndex5.indexName(), backupIndex6.indexName(), backupIndex7.indexName()}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)backupIndex1.indexName()));
    }

    @Test
    public void shouldFindManyBackupIndices_4() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(4L));
        MigrationEnvironmentHelper.BackupIndex backupIndex6 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(5L));
        MigrationEnvironmentHelper.BackupIndex backupIndex7 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(6L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5, backupIndex6, backupIndex7);
        StepResult result = step.execute(this.context);
        log.info("Find backup indices result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)7));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{backupIndex1.indexName(), backupIndex2.indexName(), backupIndex3.indexName(), backupIndex4.indexName(), backupIndex5.indexName(), backupIndex6.indexName(), backupIndex7.indexName()}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)backupIndex1.indexName()));
    }

    @Test
    public void shouldFindManyBackupIndices_5() {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().plusMonths(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(4L));
        MigrationEnvironmentHelper.BackupIndex backupIndex6 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(5L));
        MigrationEnvironmentHelper.BackupIndex backupIndex7 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(6L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5, backupIndex6, backupIndex7);
        StepResult result = step.execute(this.context);
        log.info("Find backup indices result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)7));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{backupIndex1.indexName(), backupIndex2.indexName(), backupIndex3.indexName(), backupIndex4.indexName(), backupIndex5.indexName(), backupIndex6.indexName(), backupIndex7.indexName()}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)backupIndex1.indexName()));
    }

    @Test
    public void shouldFindLargeAmountOfBackupIndices() {
        MigrationEnvironmentHelper.BackupIndex[] backupIndices = (MigrationEnvironmentHelper.BackupIndex[])IntStream.range(0, 50).mapToObj(index -> new MigrationEnvironmentHelper.BackupIndex(NOW.minusHours(index).toLocalDateTime())).toArray(MigrationEnvironmentHelper.BackupIndex[]::new);
        this.environmentHelper.createBackupIndex(backupIndices);
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)backupIndices.length));
    }

    @Test
    public void shouldDetectBackupIndexInYellowStateAndReportErrorWhenYellowIndicesAreForbidden() {
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        this.environmentHelper.createIndexInYellowState(backupIndex.indexName());
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        CheckIndicesStateStep step = this.createCheckIndicesStateStep();
        TenantIndex tenantIndex = new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "Tenant name is irrelevant here");
        this.context.setTenantIndices(ImmutableList.of((Object)tenantIndex));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        StepResult result = step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        String expectedMessage = String.format("Index '%s' status is 'YELLOW'", backupIndex.indexName());
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)expectedMessage));
    }

    @Test
    public void shouldDetectBackupIndexInYellowStateAndNotReportErrorWhenYellowIndicesAreAllowed() {
        this.context = new DataMigrationContext(new MigrationConfig(true), this.clock);
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        this.environmentHelper.createIndexInYellowState(backupIndex.indexName());
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        CheckIndicesStateStep step = this.createCheckIndicesStateStep();
        TenantIndex tenantIndex = new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "Tenant name is irrelevant here");
        this.context.setTenantIndices(ImmutableList.of((Object)tenantIndex));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        StepResult result = step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldImposeWriteBlockOnDataIndices() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "not important")));
        this.context.setBackupIndices(ImmutableList.empty());
        WriteBlockStep step = new WriteBlockStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        StepResult result = step.execute(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldImposeWriteBlockOnDataAndBackupIndices() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        this.environmentHelper.createBackupIndex(backupIndex);
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndex.indexName()), (Matcher)Matchers.equalTo((Object)true));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "not important")));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        WriteBlockStep step = new WriteBlockStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        StepResult result = step.execute(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndex.indexName()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldImposeWriteBlockOnMultipleIndices() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        MigrationEnvironmentHelper.BackupIndex backupIndexOne = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndexTwo = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        this.environmentHelper.createBackupIndex(backupIndexOne, backupIndexTwo);
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexOne.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexTwo.indexName()), (Matcher)Matchers.equalTo((Object)true));
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndexOne.indexName(), (Object)backupIndexTwo.indexName()));
        WriteBlockStep step = new WriteBlockStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
        StepResult result = step.execute(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexOne.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexTwo.indexName()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReLockBackupIndex() {
        StepRepository repository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        this.environmentHelper.createBackupIndex(backupIndex);
        repository.writeBlockIndices(ImmutableList.of((Object)backupIndex.indexName()));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndex.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "not important")));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        WriteBlockStep step = new WriteBlockStep(repository);
        StepResult result = step.execute(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndex.indexName()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReleaseWriteBlockOnOneDataIndexWhenStepIsRollback() {
        StepRepository repository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        WriteBlockStep step = new WriteBlockStep(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX));
        StepResult result = step.rollback(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReleaseWriteBlockOnMultipleIndicesWhenStepIsRollback() {
        StepRepository repository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        WriteBlockStep step = new WriteBlockStep(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        MigrationEnvironmentHelper.BackupIndex backupIndexOne = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndexTwo = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        this.environmentHelper.createBackupIndex(backupIndexOne, backupIndexTwo);
        ImmutableList indicesToBlock = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)backupIndexOne, (Object[])new MigrationEnvironmentHelper.DeletableIndex[]{backupIndexTwo}).map(MigrationEnvironmentHelper.DeletableIndex::indexForDeletion);
        repository.writeBlockIndices(indicesToBlock);
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexOne.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexTwo.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndexOne.indexName(), (Object)backupIndexTwo.indexName()));
        StepResult result = step.rollback(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexOne.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexTwo.indexName()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReleaseWriteBlockOnOneDataIndex() {
        StepRepository repository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        UnblockDataIndicesStep step = new UnblockDataIndicesStep(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX));
        StepResult result = step.execute(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReleaseWriteBlockOnMultipleIndices() {
        StepRepository repository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        UnblockDataIndicesStep step = new UnblockDataIndicesStep(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        MigrationEnvironmentHelper.BackupIndex backupIndexOne = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndexTwo = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        this.environmentHelper.createBackupIndex(backupIndexOne, backupIndexTwo);
        ImmutableList indicesToBlock = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)backupIndexOne, (Object[])new MigrationEnvironmentHelper.DeletableIndex[]{backupIndexTwo}).map(MigrationEnvironmentHelper.DeletableIndex::indexForDeletion);
        repository.writeBlockIndices(indicesToBlock);
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexOne.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexTwo.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndexOne.indexName(), (Object)backupIndexTwo.indexName()));
        StepResult result = step.execute(this.context);
        log.debug("Write lock step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexOne.indexName()), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(backupIndexTwo.indexName()), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateTempIndexName() {
        Clock clock = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)TEMP_INDEX_NAME));
        clock = Clock.fixed(NOW.toInstant().plus(2L, ChronoUnit.HOURS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_03_01_00"));
        clock = Clock.fixed(NOW.toInstant().plus(5L, ChronoUnit.HOURS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_06_01_00"));
        clock = Clock.fixed(NOW.toInstant().plus(8L, ChronoUnit.DAYS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_09_01_01_00"));
        clock = Clock.fixed(NOW.toInstant().plus(30L, ChronoUnit.SECONDS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_30"));
        clock = Clock.fixed(NOW.toInstant().plus(57L, ChronoUnit.SECONDS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_57"));
        clock = Clock.fixed(NOW.toInstant().plus(40L, ChronoUnit.MINUTES), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_41_00"));
        clock = Clock.fixed(NOW.toInstant().plus(47L, ChronoUnit.MINUTES), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_48_00"));
        clock = Clock.fixed(NOW.plusYears(9L).toInstant(), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2009_01_01_01_01_00"));
        clock = Clock.fixed(NOW.plusYears(23L).plusMonths(8L).plusDays(24L).plusHours(11L).plusSeconds(15L).toInstant(), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getTempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2023_09_25_12_01_15"));
    }

    @Test
    public void shouldCreateTempIndexWithoutSourceMappings() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldCreateTempIndexWithoutMappingsWithGivenNumberOfShardsAndReplicas() {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        int primaryShards = 2;
        int replicas = 3;
        long fieldLimit = 104L;
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 2, 3, 104L, Collections.emptyMap());
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        Settings tempIndexSettings = this.environmentHelper.getIndexSettings(this.context.getTempIndexName());
        log.debug("Temp index settings '{}'", (Object)tempIndexSettings);
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsInt("index.number_of_replicas", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsLong(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), Long.valueOf(-1L)), (Matcher)Matchers.equalTo((Object)104L));
    }

    @Test
    public void shouldCreateTempIndexWithoutMappingsWithGivenNumberOfShardsAndReplicas_case2() {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        boolean primaryShards = true;
        int replicas = 2;
        long fieldLimit = 1024L;
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 2, 1024L, Collections.emptyMap());
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        Settings tempIndexSettings = this.environmentHelper.getIndexSettings(this.context.getTempIndexName());
        log.debug("Temp index settings '{}'", (Object)tempIndexSettings);
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsInt("index.number_of_replicas", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsLong(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), Long.valueOf(-1L)), (Matcher)Matchers.equalTo((Object)1024L));
    }

    @Test
    public void shouldCreateTempIndexWithoutMappingsWithGivenNumberOfShardsAndReplicas_case3() {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        boolean primaryShards = true;
        int replicas = 3;
        long fieldLimit = 1500L;
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 3, 1500L, Collections.emptyMap());
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        Settings tempIndexSettings = this.environmentHelper.getIndexSettings(this.context.getTempIndexName());
        log.debug("Temp index settings '{}'", (Object)tempIndexSettings);
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)1));
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsInt("index.number_of_replicas", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)tempIndexSettings.getAsLong(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), Long.valueOf(-1L)), (Matcher)Matchers.equalTo((Object)1500L));
    }

    @Test
    public void shouldCreateTempIndexWithExtendedMappings() {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 500L, (Map)DocNode.EMPTY);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create temp index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getTempIndexName());
        log.debug("Temp index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
    }

    @Test
    public void shouldCreateTempIndexWithMappings_simple() throws DocumentParseException {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        DocNode desiredMappings = DocNode.parse((Format)Format.JSON).from("{\n\t\"properties\": {\n\t\t\"description\": {\n\t\t\t\"type\": \"text\",\n\t\t\t\"fields\": {\n\t\t\t\t\"keyword_sub_field\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"ignore_above\": 215\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n");
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 500L, (Map)desiredMappings);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create temp index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getTempIndexName());
        log.debug("Temp index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
        actualMappings = MarkerNodeRemoval.withoutMigrationMarker(actualMappings);
        MatcherAssert.assertThat((Object)actualMappings.equals((Object)desiredMappings), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldCreateTempIndexWithMappings_medium() throws DocumentParseException {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        DocNode desiredMappings = DocNode.parse((Format)Format.JSON).from("{\n    \"properties\": {\n        \"stages\": {\n            \"properties\": {\n                \"message\": {\n                    \"type\": \"text\",\n                    \"fields\": {\n                        \"keyword\": {\n                            \"type\": \"keyword\",\n                            \"ignore_above\": 256\n                        }\n                    }\n                },\n                \"name\": {\n                    \"type\": \"keyword\"\n                },\n                \"start_time\": {\n                    \"type\": \"date\"\n                },\n                \"status\": {\n                    \"type\": \"keyword\"\n                },\n                \"step_number\": {\n                    \"type\": \"long\"\n                }\n            }\n        },\n        \"start_time\": {\n            \"type\": \"date\"\n        },\n        \"status\": {\n            \"type\": \"keyword\"\n        },\n        \"temp_index_name\": {\n            \"type\": \"keyword\"\n        },\n        \"backup_index_name\": {\n            \"type\": \"keyword\"\n        }\n    }\n}\n");
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 500L, (Map)desiredMappings);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create temp index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getTempIndexName());
        log.debug("Temp index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
        actualMappings = MarkerNodeRemoval.withoutMigrationMarker(actualMappings);
        MatcherAssert.assertThat((Object)actualMappings.equals((Object)desiredMappings), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldCreateTempIndexWithMappings_hard() throws DocumentParseException {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        DocNode desiredMappings = DocNode.parse((Format)Format.JSON).from("{\n\t\"dynamic\": \"true\",\n\t\"properties\": {\n\t\t\"action\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actionTypeIds\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"config\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"isMissingSecrets\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"secrets\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"action_task_param\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actionId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"apiKey\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"consumer\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"executionId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"params\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"relatedSavedObject\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"alerts\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actions\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"actionRef\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"actionTypeId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"frequency\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"notifyWhen\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"summary\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"throttle\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"group\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"params\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"alertTypeId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"apiKey\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"apiKeyOwner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"consumer\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"executionStatus\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"error\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"message\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"reason\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"lastDuration\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"lastExecutionDate\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"numberOfTriggeredActions\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"status\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"warning\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"message\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"reason\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"lastRun\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"alertsCount\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"active\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"ignored\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"new\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"recovered\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"outcome\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"outcomeMsg\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"outcomeOrder\": {\n\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"warning\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"legacyId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"mapped_params\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"risk_score\": {\n\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"severity\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"meta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"versionApiKeyLastmodified\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"monitoring\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"run\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"calculated_metrics\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"p50\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"p95\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"p99\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"success_ratio\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"history\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"duration\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"outcome\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"success\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"timestamp\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"last_run\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"metrics\": {\n\t\t\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\"duration\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"gap_duration_s\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_alerts_created\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_alerts_detected\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_indexing_duration_ms\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_search_duration_ms\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"timestamp\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"muteAll\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"mutedInstanceIds\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"normalizer\": \"lowercase\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"nextRun\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"notifyWhen\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"params\": {\n\t\t\t\t\t\"type\": \"flattened\",\n\t\t\t\t\t\"ignore_above\": 4096\n\t\t\t\t},\n\t\t\t\t\"running\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"schedule\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"scheduledTaskId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"snoozeSchedule\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"duration\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"rRule\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"byhour\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byminute\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bymonth\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bymonthday\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bysecond\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bysetpos\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byweekday\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byweekno\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byyearday\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"count\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"dtstart\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\t\t\"format\": \"strict_date_time\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"freq\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"tzid\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"until\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\t\t\"format\": \"strict_date_time\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"wkst\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"skipRecurrences\": {\n\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\"format\": \"strict_date_time\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"throttle\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updatedAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"api_key_pending_invalidation\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"apiKeyId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"apm-indices\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"apm-server-schema\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"schemaJson\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"apm-service-group\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"groupName\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"kuery\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"apm-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"app_search_telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"application_usage_daily\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"timestamp\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"application_usage_totals\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"canvas-element\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"@created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"@timestamp\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"content\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"help\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"image\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"canvas-workpad\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"@created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"@timestamp\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"canvas-workpad-template\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"help\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"template_key\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"assignees\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"closed_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"closed_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"connector\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"key\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"external_service\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"connector_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"external_id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"external_title\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"external_url\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"pushed_at\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"pushed_by\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"settings\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"syncAlerts\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"severity\": {\n\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"total_alerts\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"total_comments\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-comments\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"targets\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"endpointId\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"hostname\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"alertId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"comment\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"externalReferenceAttachmentTypeId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"externalReferenceId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"externalReferenceMetadata\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"externalReferenceStorage\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"index\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"persistableStateAttachmentState\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"persistableStateAttachmentTypeId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"pushed_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"pushed_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"rule\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-configure\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"closure_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"connector\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"key\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-connector-mappings\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"mappings\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"action_type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"source\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"target\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"cases-user-actions\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"action\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"payload\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"assignees\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"uid\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"comment\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"externalReferenceAttachmentTypeId\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"persistableStateAttachmentTypeId\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"connector\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"config\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"buildNum\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"config-global\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"buildNum\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"connector_token\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"connectorId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"expiresAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"token\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"tokenType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updatedAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"core-usage-stats\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"coreMigrationVersion\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"created_at\": {\n\t\t\t\"type\": \"date\"\n\t\t},\n\t\t\"csp-rule-template\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"metadata\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"benchmark\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"dashboard\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"controlGroupInput\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"chainingSystem\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"controlStyle\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"ignoreParentSettingsJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"panelsJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"hits\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"optionsJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"panelsJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"refreshInterval\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"display\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"pause\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"section\": {\n\t\t\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"timeFrom\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"timeRestore\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"timeTo\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"endpoint:user-artifact\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"body\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"compressionAlgorithm\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"decodedSha256\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"decodedSize\": {\n\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"encodedSha256\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"encodedSize\": {\n\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"encryptionAlgorithm\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"identifier\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"endpoint:user-artifact-manifest\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"artifacts\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"artifactId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"policyId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"schemaVersion\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"semanticVersion\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"enterprise_search_telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"epm-packages\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"es_index_patterns\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"experimental_data_stream_features\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"data_stream\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"features\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"synthetic_source\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"tsdb\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"install_source\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"install_started_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"install_status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"install_version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"installed_es\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"installed_kibana\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"installed_kibana_space_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"internal\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"keep_policies_up_to_date\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package_assets\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"verification_key_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"verification_status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"epm-packages-assets\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"asset_path\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"data_base64\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"data_utf8\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"install_source\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"media_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package_name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package_version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"event_loop_delays_daily\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"lastUpdatedAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"exception-list\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"_tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"comments\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"comment\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"entries\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"entries\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"list\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"expire_time\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"immutable\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"item_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"meta\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"os_types\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tie_breaker_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"exception-list-agnostic\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"_tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"comments\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"comment\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"entries\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"entries\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"list\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"expire_time\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"immutable\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"item_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"meta\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"os_types\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tie_breaker_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"file\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"FileKind\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"Meta\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t},\n\t\t\t\t\"Status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"Updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"extension\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"mime_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"size\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"user\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"file-upload-usage-collection-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"file_upload\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"index_creation_count\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fileShare\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"token\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"valid_until\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fleet-fleet-server-host\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"host_urls\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"proxy_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fleet-preconfiguration-deletion-record\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fleet-proxy\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"certificate\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"certificate_authorities\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"certificate_key\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"proxy_headers\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"url\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"graph-workspace\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"legacyIndexPatternRef\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"numLinks\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"numVertices\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"wsState\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"guided-onboarding-guide-state\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"guideId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"isActive\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"guided-onboarding-plugin-state\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"index-pattern\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"infrastructure-monitoring-log-view\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"infrastructure-ui-source\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"ingest-agent-policies\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"agent_features\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"data_output_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"download_source_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"fleet_server_host_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"inactivity_timeout\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_default_fleet_server\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_managed\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"monitoring_enabled\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"monitoring_output_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"namespace\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"revision\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"unenroll_timeout\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest-download-sources\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"host\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"source_id\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest-outputs\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"ca_sha256\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"ca_trusted_fingerprint\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"config\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t},\n\t\t\t\t\"config_yaml\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"hosts\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_default_monitoring\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"output_id\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"proxy_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"shipper\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\"\n\t\t\t\t},\n\t\t\t\t\"ssl\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest-package-policies\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"elasticsearch\": {\n\t\t\t\t\t\"enabled\": false,\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"privileges\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"cluster\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"inputs\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"enabled\": false,\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"compiled_input\": {\n\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"config\": {\n\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"policy_template\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"streams\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"compiled_stream\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"config\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"data_stream\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"dataset\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"elasticsearch\": {\n\t\t\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\"privileges\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"vars\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"vars\": {\n\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"is_managed\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"namespace\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"title\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"policy_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"revision\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"vars\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest_manager_settings\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"fleet_server_hosts\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"has_seen_add_data_notice\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"prerelease_integrations_enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"inventory-view\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"kql-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"optInCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"optOutCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"legacy-url-alias\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"disabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"resolveCounter\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"sourceId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"targetId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"targetNamespace\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"targetType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"lens\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"expression\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"state\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"visualizationType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"lens-ui-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"count\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"date\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"map\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"bounds\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"layerListJSON\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"mapStateJSON\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"uiStateJSON\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"maps-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"enabled\": false\n\t\t},\n\t\t\"metrics-explorer-view\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"migrationVersion\": {\n\t\t\t\"dynamic\": \"true\",\n\t\t\t\"properties\": {\n\t\t\t\t\"canvas-workpad-template\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"config\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"core-usage-stats\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"exception-list-agnostic\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"search-telemetry\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"space\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"spaces-usage-stats\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ml-job\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"datafeed_id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"job_id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ml-module\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"datafeeds\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"defaultIndexPattern\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"jobs\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"logo\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"query\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ml-trained-model\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"job\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"create_time\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"job_id\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"model_id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"monitoring-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"reportedClusterUuids\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"namespace\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"namespaces\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"originId\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"osquery-manager-usage-metric\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"count\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"errors\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"osquery-pack\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"queries\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"ecs_mapping\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"platform\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"shards\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"osquery-pack-asset\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"queries\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"ecs_mapping\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"platform\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"shards\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"osquery-saved-query\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"ecs_mapping\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"interval\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"platform\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"query\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"query\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"filters\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"query\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"language\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"timefilter\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"references\": {\n\t\t\t\"type\": \"nested\",\n\t\t\t\"properties\": {\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"rules-settings\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"flapping\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"lookBackWindow\": {\n\t\t\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"statusChangeThreshold\": {\n\t\t\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updatedAt\": {\n\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"sample-data-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"installCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"unInstallCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"search\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"breakdownField\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"columns\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"grid\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"hideAggregatedPreview\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"hideChart\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"hits\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"isTextBasedQuery\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"refreshInterval\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"pause\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"rowHeight\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"rowsPerPage\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"sort\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"timeRange\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"from\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"to\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"timeRestore\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"usesAdHocDataView\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"viewMode\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"search-session\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"appId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"expires\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"idMapping\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"initialState\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"isCanceled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"locatorId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"realmName\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"realmType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"restoreState\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"sessionId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"username\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"search-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"security-rule\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"rule_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"security-solution-signals-migration\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"destinationIndex\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"error\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"sourceIndex\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"taskId\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-detection-engine-rule-actions\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"actionRef\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"action_type_id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"group\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"params\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"alertThrottle\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"ruleAlertId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"ruleThrottle\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-ui-timeline\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"columns\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"aggregatable\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"category\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"columnHeaderType\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"description\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"example\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"indexes\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"placeholder\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"searchable\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"dataProviders\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"and\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"excluded\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"kqlQuery\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"queryMatch\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"displayField\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"displayValue\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"excluded\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"kqlQuery\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"queryMatch\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"displayField\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"displayValue\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"dateRange\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"end\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"start\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"eqlOptions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"eventCategoryField\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"size\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"tiebreakerField\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"timestampField\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"eventType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"excludedRowRendererIds\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"favorite\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"favoriteDate\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"fullName\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"keySearch\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"userName\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"filters\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"exists\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"match_all\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"meta\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"alias\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"controlledBy\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"disabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"formattedValue\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"index\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"key\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"negate\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"params\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"missing\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"range\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"script\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"indexNames\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"kqlMode\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"kqlQuery\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"filterQuery\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"kuery\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"expression\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"kind\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"serializedQuery\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"sort\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"columnId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"columnType\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"sortDirection\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"templateTimelineId\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"templateTimelineVersion\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"timelineType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-ui-timeline-note\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"eventId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"note\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-ui-timeline-pinned-event\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"eventId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"space\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"_reserved\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"disabledFeatures\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"imageUrl\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"initials\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 2048\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"spaces-usage-stats\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"synthetics-monitor\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"alert\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"status\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"custom_heartbeat_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"hash\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"hosts\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"journey_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"locations\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256,\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"label\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256,\n\t\t\t\t\t\t\t\"normalizer\": \"lowercase\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"origin\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"project_id\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"schedule\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"number\": {\n\t\t\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"urls\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"synthetics-param\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"synthetics-privates-locations\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"tag\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"allowChangingOptInStatus\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"lastReported\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"lastVersionChecked\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"reportFailureCount\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"reportFailureVersion\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"sendUsageFrom\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"userHasSeenNotice\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"type\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"ui-metric\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"count\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"updated_at\": {\n\t\t\t\"type\": \"date\"\n\t\t},\n\t\t\"upgrade-assistant-ml-upgrade-operation\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"jobId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"nodeId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"snapshotId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"upgrade-assistant-reindex-operation\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"errorMessage\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"indexName\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"lastCompletedStep\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"locked\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"newIndexName\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"reindexOptions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"openAndClose\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"queueSettings\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"queuedAt\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"startedAt\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"reindexTaskId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"reindexTaskPercComplete\": {\n\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t},\n\t\t\t\t\"runningReindexCount\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"upgrade-assistant-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"features\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"deprecation_logging\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\t\t\"null_value\": true\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"uptime-dynamic-settings\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"uptime-synthetics-api-key\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"apiKey\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"url\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"accessCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"accessDate\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createDate\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"locatorJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"slug\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"url\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 2048\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"usage-counters\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"domainId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"visualization\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"savedSearchRefName\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"uiStateJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"visState\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"workplace_search_telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t}\n\t}\n}\n");
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 1500L, (Map)desiredMappings);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)false));
        CreateTempIndexStep step = new CreateTempIndexStep(new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create temp index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getTempIndexName());
        log.debug("Temp index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
        actualMappings = MarkerNodeRemoval.withoutMigrationMarker(actualMappings);
        MatcherAssert.assertThat((Object)actualMappings.equals((Object)desiredMappings), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldTransferLargeNumberOfDocuments_FromSingleDataIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        int countOfDocuments = 1005;
        String[] spaceNames = (String[])IntStream.range(0, 1005).mapToObj(index -> "space_no_" + index).toArray(String[]::new);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), spaceNames);
        CopyDataToTempIndexStep step = MigrationStepsTest.createCopyDataToTempIndexStep(client);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)1005L));
    }

    @Test
    public void shouldTransferLargeNumberOfDocuments_FromFewDataIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        ImmutableList indices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)managementTenant, (Object[])new MigrationEnvironmentHelper.DoubleAliasIndex[0]);
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)indices);
        int countOfDocuments = 1004;
        indices.map(MigrationEnvironmentHelper.DoubleAliasIndex::indexName).forEach(indexName -> {
            String[] spaceNames = (String[])IntStream.range(0, 1004).mapToObj(index -> indexName + "space_no_" + index).toArray(String[]::new);
            catalog.insertSpace((String)indexName, spaceNames);
        });
        CopyDataToTempIndexStep step = MigrationStepsTest.createCopyDataToTempIndexStep(client);
        this.context.setTenantIndices(MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName((ImmutableList<MigrationEnvironmentHelper.DoubleAliasIndex>)indices));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(tempIndex), (Matcher)Matchers.equalTo((Object)(1004L * (long)indices.size())));
    }

    @Test
    public void shouldStoreSameDocumentsInTempIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        ImmutableList indices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)managementTenant, (Object[])new MigrationEnvironmentHelper.DoubleAliasIndex[0]);
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)indices);
        indices.map(MigrationEnvironmentHelper.DoubleAliasIndex::indexName).forEach(indexName -> catalog.insertSpace((String)indexName, (String)indexName));
        catalog.insertIndexPattern(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "iot-1");
        catalog.insertIndexPattern(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "iot-2");
        catalog.insertIndexPattern(managementTenant.indexName(), "iot-3");
        CopyDataToTempIndexStep step = MigrationStepsTest.createCopyDataToTempIndexStep(client);
        ImmutableList tenantIndices = ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT"), (Object)new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), null), (Object)new TenantIndex(managementTenant.indexName(), "management"), (Object[])new TenantIndex[0]);
        this.context.setTenantIndices(tenantIndices);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(TEMP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)6L));
        String id = "space:.kibana_8.7.0_001";
        String globalDocument = this.environmentHelper.getDocumentSource(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id).orElseThrow();
        id = "space:.kibana_3292183_kirk_8.7.0_001";
        String privateDocument = this.environmentHelper.getDocumentSource(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), id).orElseThrow();
        id = "space:.kibana_-1799980989_management_8.7.0_001";
        String managementDocument = this.environmentHelper.getDocumentSource(managementTenant.indexName(), id).orElseThrow();
        id = "space:.kibana_8.7.0_001";
        String migratedGlobal = this.environmentHelper.getDocumentSource(TEMP_INDEX_NAME, id).orElseThrow();
        id = "space:.kibana_3292183_kirk_8.7.0_001__sg_ten__3292183_kirk";
        String migratedPrivate = this.environmentHelper.getDocumentSource(TEMP_INDEX_NAME, id).orElseThrow();
        id = "space:.kibana_-1799980989_management_8.7.0_001__sg_ten__-1799980989_management";
        String migratedManagement = this.environmentHelper.getDocumentSource(TEMP_INDEX_NAME, id).orElseThrow();
        MatcherAssert.assertThat((Object)migratedGlobal, (Matcher)Matchers.equalTo((Object)globalDocument));
        MatcherAssert.assertThat((Object)migratedPrivate, (Matcher)Matchers.equalTo((Object)privateDocument));
        MatcherAssert.assertThat((Object)migratedManagement, (Matcher)Matchers.equalTo((Object)managementDocument));
        id = "index-pattern::iot-1";
        globalDocument = this.environmentHelper.getDocumentSource(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id).orElseThrow();
        id = "index-pattern::iot-2";
        privateDocument = this.environmentHelper.getDocumentSource(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), id).orElseThrow();
        id = "index-pattern::iot-3";
        managementDocument = this.environmentHelper.getDocumentSource(managementTenant.indexName(), id).orElseThrow();
        id = "index-pattern::iot-1";
        migratedGlobal = this.environmentHelper.getDocumentSource(TEMP_INDEX_NAME, id).orElseThrow();
        id = "index-pattern::iot-2__sg_ten__3292183_kirk";
        migratedPrivate = this.environmentHelper.getDocumentSource(TEMP_INDEX_NAME, id).orElseThrow();
        id = "index-pattern::iot-3__sg_ten__-1799980989_management";
        migratedManagement = this.environmentHelper.getDocumentSource(TEMP_INDEX_NAME, id).orElseThrow();
        MatcherAssert.assertThat((Object)migratedGlobal, (Matcher)Matchers.equalTo((Object)globalDocument));
        MatcherAssert.assertThat((Object)migratedPrivate, (Matcher)Matchers.equalTo((Object)privateDocument));
        MatcherAssert.assertThat((Object)migratedManagement, (Matcher)Matchers.equalTo((Object)managementDocument));
    }

    @Test
    public void shouldDetectThatIndexContainsAlreadyMigratedDocumentsAndReportError() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        String scopedId = RequestResponseTenantData.scopedId((String)"alreadyMigratedSpace", (String)"SGS_GLOBAL_TENANT");
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "alreadyMigratedSpace", scopedId);
        CopyDataToTempIndexStep step = MigrationStepsTest.createCopyDataToTempIndexStep(client);
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DOCUMENT_ALREADY_MIGRATED_ERROR));
    }

    @Test
    public void shouldAssignTenantScopeToSavedObjectId() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "global_tenant_space");
        catalog.insertSpace(managementTenant.indexName(), "management_tenant_space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk_private_tenant_space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX.indexName(), "lukasz_1_private_tenant_space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX.indexName(), "lukasz_2_private_tenant_space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX.indexName(), "lukasz_3_private_tenant_space");
        ImmutableList tenantIndices = ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT"), (Object)new TenantIndex(managementTenant.indexName(), "management"), (Object)new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), null), (Object[])new TenantIndex[]{new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX.indexName(), null), new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX.indexName(), null), new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX.indexName(), null)});
        this.context.setTenantIndices(tenantIndices);
        CopyDataToTempIndexStep step = MigrationStepsTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:global_tenant_space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management_tenant_space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:kirk_private_tenant_space__sg_ten__3292183_kirk");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:lukasz_1_private_tenant_space__sg_ten__-1091682490_lukasz");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:lukasz_2_private_tenant_space__sg_ten__739988528_ukasz");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:lukasz_3_private_tenant_space__sg_ten__-1091714203_luksz");
    }

    @Test
    public void shouldPreventIdColisions() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "colliding_space_id");
        catalog.insertSpace(managementTenant.indexName(), "colliding_space_id");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "colliding_space_id");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX.indexName(), "colliding_space_id");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX.indexName(), "colliding_space_id");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX.indexName(), "colliding_space_id");
        ImmutableList tenantIndices = ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT"), (Object)new TenantIndex(managementTenant.indexName(), "management"), (Object)new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), null), (Object[])new TenantIndex[]{new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX.indexName(), null), new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX.indexName(), null), new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX.indexName(), null)});
        this.context.setTenantIndices(tenantIndices);
        CopyDataToTempIndexStep step = MigrationStepsTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:colliding_space_id");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:colliding_space_id__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:colliding_space_id__sg_ten__3292183_kirk");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:colliding_space_id__sg_ten__-1091682490_lukasz");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:colliding_space_id__sg_ten__739988528_ukasz");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:colliding_space_id__sg_ten__-1091714203_luksz");
    }

    @Test
    public void shouldDeleteTempIndex() {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX, managementTenant);
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        client.admin().indices().create(new CreateIndexRequest(TEMP_INDEX_NAME)).actionGet();
        DeleteTempIndexStep step = new DeleteTempIndexStep(new StepRepository(client));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(TEMP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)true));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(TEMP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(managementTenant.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(backupIndex1.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(backupIndex2.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(backupIndex3.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(backupIndex4.indexName()), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(backupIndex5.indexName()), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotCreateBackupOfIndexWithoutMappingsAndReportError() {
        StepRepository repository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.EMPTY_MAPPINGS_ERROR));
    }

    @Test
    public void shouldCreateBackupOfSingleDocument() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(BACKUP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)true));
        this.environmentHelper.assertThatDocumentExists(BACKUP_INDEX_NAME, "space:default");
    }

    @Test
    public void shouldCreateBackupOfWriteBlockIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        MatcherAssert.assertThat((Object)this.environmentHelper.isDocumentInsertionPossible(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(BACKUP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)true));
        this.environmentHelper.assertThatDocumentExists(BACKUP_INDEX_NAME, "space:default");
    }

    @Test
    public void shouldNotCreateBackupWhenGlobalTenantIndexContainsMigrationMarkerInMappings() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(BACKUP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldGenerateBackupIndexNameBasedOnCurrentTime() {
        Clock clock = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)BACKUP_INDEX_NAME));
        clock = Clock.fixed(NOW.toInstant().plus(2L, ChronoUnit.HOURS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_03_01_00"));
        clock = Clock.fixed(NOW.toInstant().plus(5L, ChronoUnit.HOURS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_06_01_00"));
        clock = Clock.fixed(NOW.toInstant().plus(8L, ChronoUnit.DAYS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_09_01_01_00"));
        clock = Clock.fixed(NOW.toInstant().plus(30L, ChronoUnit.SECONDS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_30"));
        clock = Clock.fixed(NOW.toInstant().plus(57L, ChronoUnit.SECONDS), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_57"));
        clock = Clock.fixed(NOW.toInstant().plus(40L, ChronoUnit.MINUTES), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_41_00"));
        clock = Clock.fixed(NOW.toInstant().plus(47L, ChronoUnit.MINUTES), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_48_00"));
        clock = Clock.fixed(NOW.plusYears(9L).toInstant(), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2009_01_01_01_01_00"));
        clock = Clock.fixed(NOW.plusYears(23L).plusMonths(8L).plusDays(24L).plusHours(11L).plusSeconds(16L).toInstant(), ZoneOffset.UTC);
        this.context = new DataMigrationContext(new MigrationConfig(false), clock);
        MatcherAssert.assertThat((Object)this.context.getBackupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2023_09_25_12_01_16"));
    }

    @Test
    public void shouldBackupLargeNumberOfDocuments() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        int documentNumber = 12101;
        String[] spaceNames = (String[])IntStream.range(0, 12101).mapToObj(i -> "space_no_" + i).toArray(String[]::new);
        ImmutableList<String> spacesIds = catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), spaceNames);
        String[] patternNames = (String[])IntStream.range(0, 12101).mapToObj(i -> "index_pattern_no_" + i).toArray(String[]::new);
        ImmutableList<String> patternsIds = catalog.insertIndexPattern(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), patternNames);
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)24202L));
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        log.debug("Create backup result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(BACKUP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(BACKUP_INDEX_NAME), (Matcher)Matchers.equalTo((Object)24202L));
        MatcherAssert.assertThat(spacesIds, (Matcher)Matchers.hasSize((int)12101));
        MatcherAssert.assertThat(patternsIds, (Matcher)Matchers.hasSize((int)12101));
        Stream.concat(spacesIds.stream(), patternsIds.stream()).forEach(id -> this.environmentHelper.assertThatDocumentExists(BACKUP_INDEX_NAME, (String)id));
    }

    @Test
    public void shouldStoreExactCopyOfDocumentInBackupIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        int documentNumber = 51;
        String[] spaceNames = (String[])IntStream.range(0, 51).mapToObj(i -> "space_no_" + i).toArray(String[]::new);
        ImmutableList<String> spacesIds = catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), spaceNames);
        String[] patternNames = (String[])IntStream.range(0, 51).mapToObj(i -> "index_pattern_no_" + i).toArray(String[]::new);
        ImmutableList<String> patternsIds = catalog.insertIndexPattern(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), patternNames);
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)102L));
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        log.debug("Create backup result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        Stream.concat(spacesIds.stream(), patternsIds.stream()).forEach(id -> {
            String genuineDocument = this.environmentHelper.getDocumentSource(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), (String)id).orElseThrow();
            String documentBackup = this.environmentHelper.getDocumentSource(BACKUP_INDEX_NAME, (String)id).orElseThrow();
            MatcherAssert.assertThat((Object)documentBackup, (Matcher)Matchers.equalTo((Object)genuineDocument));
        });
    }

    @Test
    public void shouldCreateBackupIndexWithGivenNumberOfShardsAndReplicas() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository stepRepository = new StepRepository(client);
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        int primaryShards = 2;
        int replicas = 3;
        long fieldLimit = 104L;
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 2, 3, 104L, Collections.emptyMap());
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "backup-test-space");
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)false));
        stepRepository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(stepRepository, new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)true));
        Settings backupIndexSettings = this.environmentHelper.getIndexSettings(this.context.getBackupIndexName());
        log.debug("Backup index settings '{}'", (Object)backupIndexSettings);
        MatcherAssert.assertThat((Object)backupIndexSettings.getAsInt("index.number_of_shards", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)2));
        MatcherAssert.assertThat((Object)backupIndexSettings.getAsInt("index.number_of_replicas", Integer.valueOf(-1)), (Matcher)Matchers.equalTo((Object)3));
        MatcherAssert.assertThat((Object)backupIndexSettings.getAsLong(MapperService.INDEX_MAPPING_TOTAL_FIELDS_LIMIT_SETTING.getKey(), Long.valueOf(-1L)), (Matcher)Matchers.equalTo((Object)104L));
    }

    @Test
    public void shouldCreateBackupIndexWithMappings_simple() throws DocumentParseException {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository stepRepository = new StepRepository(client);
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        DocNode desiredMappings = DocNode.parse((Format)Format.JSON).from("{\n\t\"properties\": {\n\t\t\"description\": {\n\t\t\t\"type\": \"text\",\n\t\t\t\"fields\": {\n\t\t\t\t\"keyword_sub_field\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"ignore_above\": 215\n\t\t\t\t}\n\t\t\t}\n\t\t}\n\t}\n}\n");
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 1500L, (Map)desiredMappings);
        client.index(new IndexRequest(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()).source((Map)DocNode.EMPTY)).actionGet();
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)false));
        stepRepository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(stepRepository, new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create backup index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getBackupIndexName());
        log.debug("Backup index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)Matchers.equalTo((Object)desiredMappings));
    }

    @Test
    public void shouldCreateBackupIndexWithMappings_medium() throws DocumentParseException {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository stepRepository = new StepRepository(client);
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        DocNode desiredMappings = DocNode.parse((Format)Format.JSON).from("{\n    \"properties\": {\n        \"stages\": {\n            \"properties\": {\n                \"message\": {\n                    \"type\": \"text\",\n                    \"fields\": {\n                        \"keyword\": {\n                            \"type\": \"keyword\",\n                            \"ignore_above\": 256\n                        }\n                    }\n                },\n                \"name\": {\n                    \"type\": \"keyword\"\n                },\n                \"start_time\": {\n                    \"type\": \"date\"\n                },\n                \"status\": {\n                    \"type\": \"keyword\"\n                },\n                \"step_number\": {\n                    \"type\": \"long\"\n                }\n            }\n        },\n        \"start_time\": {\n            \"type\": \"date\"\n        },\n        \"status\": {\n            \"type\": \"keyword\"\n        },\n        \"temp_index_name\": {\n            \"type\": \"keyword\"\n        },\n        \"backup_index_name\": {\n            \"type\": \"keyword\"\n        }\n    }\n}\n");
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 1500L, (Map)desiredMappings);
        client.index(new IndexRequest(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()).source((Map)DocNode.EMPTY)).actionGet();
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)false));
        stepRepository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(stepRepository, new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create backup index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getBackupIndexName());
        log.debug("Backup index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)Matchers.equalTo((Object)desiredMappings));
    }

    @Test
    public void shouldCreateBackupIndexWithMappings_hard() throws DocumentParseException {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository stepRepository = new StepRepository(client);
        this.environmentHelper.addCreatedIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        DocNode desiredMappings = DocNode.parse((Format)Format.JSON).from("{\n\t\"dynamic\": \"true\",\n\t\"properties\": {\n\t\t\"action\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actionTypeIds\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"config\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"isMissingSecrets\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"secrets\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"action_task_param\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actionId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"apiKey\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"consumer\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"executionId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"params\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"relatedSavedObject\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"alerts\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actions\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"actionRef\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"actionTypeId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"frequency\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"notifyWhen\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"summary\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"throttle\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"group\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"params\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"alertTypeId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"apiKey\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"apiKeyOwner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"consumer\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"executionStatus\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"error\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"message\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"reason\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"lastDuration\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"lastExecutionDate\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"numberOfTriggeredActions\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"status\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"warning\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"message\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"reason\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"lastRun\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"alertsCount\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"active\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"ignored\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"new\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"recovered\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"outcome\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"outcomeMsg\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"outcomeOrder\": {\n\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"warning\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"legacyId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"mapped_params\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"risk_score\": {\n\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"severity\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"meta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"versionApiKeyLastmodified\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"monitoring\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"run\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"calculated_metrics\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"p50\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"p95\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"p99\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"success_ratio\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"history\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"duration\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"outcome\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"success\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"timestamp\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"last_run\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"metrics\": {\n\t\t\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\"duration\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"gap_duration_s\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_alerts_created\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_alerts_detected\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_indexing_duration_ms\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\t\t\"total_search_duration_ms\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"timestamp\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"muteAll\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"mutedInstanceIds\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"normalizer\": \"lowercase\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"nextRun\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"notifyWhen\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"params\": {\n\t\t\t\t\t\"type\": \"flattened\",\n\t\t\t\t\t\"ignore_above\": 4096\n\t\t\t\t},\n\t\t\t\t\"running\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"schedule\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"scheduledTaskId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"snoozeSchedule\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"duration\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"rRule\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"byhour\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byminute\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bymonth\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bymonthday\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bysecond\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"bysetpos\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byweekday\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byweekno\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"byyearday\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"count\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"dtstart\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\t\t\"format\": \"strict_date_time\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"freq\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"tzid\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"until\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\t\t\"format\": \"strict_date_time\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"wkst\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"skipRecurrences\": {\n\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\"format\": \"strict_date_time\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"throttle\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updatedAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"api_key_pending_invalidation\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"apiKeyId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"apm-indices\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"apm-server-schema\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"schemaJson\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"apm-service-group\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"groupName\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"kuery\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"apm-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"app_search_telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"application_usage_daily\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"timestamp\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"application_usage_totals\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"canvas-element\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"@created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"@timestamp\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"content\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"help\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"image\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"canvas-workpad\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"@created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"@timestamp\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"canvas-workpad-template\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"help\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"template_key\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"assignees\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"closed_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"closed_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"connector\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"key\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"external_service\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"connector_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"external_id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"external_title\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"external_url\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"pushed_at\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"pushed_by\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"settings\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"syncAlerts\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"severity\": {\n\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"short\"\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"total_alerts\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"total_comments\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-comments\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"targets\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"endpointId\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"hostname\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"alertId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"comment\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"externalReferenceAttachmentTypeId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"externalReferenceId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"externalReferenceMetadata\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"externalReferenceStorage\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"index\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"persistableStateAttachmentState\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"persistableStateAttachmentTypeId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"pushed_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"pushed_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"rule\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-configure\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"closure_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"connector\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"key\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-connector-mappings\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"mappings\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"action_type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"source\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"target\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"cases-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"cases-user-actions\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"action\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"email\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"full_name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"profile_uid\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"username\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"owner\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"payload\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"assignees\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"uid\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"comment\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"externalReferenceAttachmentTypeId\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"persistableStateAttachmentTypeId\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"connector\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"config\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"buildNum\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"config-global\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"buildNum\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"connector_token\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"connectorId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"expiresAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"token\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"tokenType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updatedAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"core-usage-stats\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"coreMigrationVersion\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"created_at\": {\n\t\t\t\"type\": \"date\"\n\t\t},\n\t\t\"csp-rule-template\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"metadata\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"benchmark\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"dashboard\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"controlGroupInput\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"chainingSystem\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"controlStyle\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"ignoreParentSettingsJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"panelsJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"hits\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"optionsJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"panelsJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"refreshInterval\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"display\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"pause\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"section\": {\n\t\t\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"timeFrom\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"timeRestore\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"timeTo\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"endpoint:user-artifact\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"body\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"compressionAlgorithm\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"decodedSha256\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"decodedSize\": {\n\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"encodedSha256\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"encodedSize\": {\n\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"encryptionAlgorithm\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"identifier\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"endpoint:user-artifact-manifest\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"artifacts\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"artifactId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"policyId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"schemaVersion\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"semanticVersion\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"enterprise_search_telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"epm-packages\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"es_index_patterns\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"experimental_data_stream_features\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"data_stream\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"features\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"synthetic_source\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"tsdb\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"install_source\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"install_started_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"install_status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"install_version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"installed_es\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"installed_kibana\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"installed_kibana_space_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"internal\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"keep_policies_up_to_date\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package_assets\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"verification_key_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"verification_status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"epm-packages-assets\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"asset_path\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"data_base64\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"data_utf8\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"install_source\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"media_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package_name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package_version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"event_loop_delays_daily\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"lastUpdatedAt\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"exception-list\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"_tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"comments\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"comment\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"entries\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"entries\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"list\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"expire_time\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"immutable\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"item_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"meta\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"os_types\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tie_breaker_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"exception-list-agnostic\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"_tags\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"comments\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"comment\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"created_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"entries\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"entries\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"list\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"expire_time\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"immutable\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"item_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"list_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"meta\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"os_types\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tie_breaker_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"file\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"FileKind\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"Meta\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t},\n\t\t\t\t\"Status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"Updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"extension\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"mime_type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"size\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"user\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"file-upload-usage-collection-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"file_upload\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"index_creation_count\": {\n\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fileShare\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"token\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"valid_until\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fleet-fleet-server-host\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"host_urls\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"proxy_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fleet-preconfiguration-deletion-record\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"fleet-proxy\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"certificate\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"certificate_authorities\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"certificate_key\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"proxy_headers\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"url\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"graph-workspace\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"legacyIndexPatternRef\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"numLinks\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"numVertices\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"wsState\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"guided-onboarding-guide-state\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"guideId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"isActive\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"guided-onboarding-plugin-state\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"index-pattern\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"infrastructure-monitoring-log-view\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"infrastructure-ui-source\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"ingest-agent-policies\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"agent_features\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"data_output_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"download_source_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"fleet_server_host_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"inactivity_timeout\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_default_fleet_server\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_managed\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"monitoring_enabled\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"monitoring_output_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"namespace\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"revision\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"unenroll_timeout\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest-download-sources\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"host\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"source_id\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest-outputs\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"ca_sha256\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"ca_trusted_fingerprint\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"config\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t},\n\t\t\t\t\"config_yaml\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"hosts\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"is_default\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_default_monitoring\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"is_preconfigured\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"output_id\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"proxy_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"shipper\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\"\n\t\t\t\t},\n\t\t\t\t\"ssl\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest-package-policies\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"elasticsearch\": {\n\t\t\t\t\t\"enabled\": false,\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"privileges\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"cluster\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"inputs\": {\n\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\"enabled\": false,\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"compiled_input\": {\n\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"config\": {\n\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"policy_template\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"streams\": {\n\t\t\t\t\t\t\t\"type\": \"nested\",\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"compiled_stream\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"config\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"data_stream\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"dataset\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"elasticsearch\": {\n\t\t\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\"privileges\": {\n\t\t\t\t\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"vars\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"vars\": {\n\t\t\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"is_managed\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"namespace\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"package\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"title\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"policy_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"revision\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"vars\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ingest_manager_settings\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"fleet_server_hosts\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"has_seen_add_data_notice\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"prerelease_integrations_enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"inventory-view\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"kql-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"optInCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"optOutCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"legacy-url-alias\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"disabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"resolveCounter\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"sourceId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"targetId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"targetNamespace\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"targetType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"lens\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"expression\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"state\": {\n\t\t\t\t\t\"type\": \"flattened\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"visualizationType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"lens-ui-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"count\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"date\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"map\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"bounds\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"dynamic\": \"false\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"layerListJSON\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"mapStateJSON\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"uiStateJSON\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"maps-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"enabled\": false\n\t\t},\n\t\t\"metrics-explorer-view\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"migrationVersion\": {\n\t\t\t\"dynamic\": \"true\",\n\t\t\t\"properties\": {\n\t\t\t\t\"canvas-workpad-template\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"config\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"core-usage-stats\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"exception-list-agnostic\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"search-telemetry\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"space\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"spaces-usage-stats\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ml-job\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"datafeed_id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"job_id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ml-module\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"datafeeds\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"defaultIndexPattern\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"jobs\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"logo\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"query\": {\n\t\t\t\t\t\"type\": \"object\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"ml-trained-model\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"job\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"create_time\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"job_id\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"model_id\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"monitoring-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"reportedClusterUuids\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"namespace\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"namespaces\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"originId\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"osquery-manager-usage-metric\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"count\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"errors\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"osquery-pack\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"queries\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"ecs_mapping\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"platform\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"shards\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"osquery-pack-asset\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"queries\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"ecs_mapping\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"interval\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"platform\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"version\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"shards\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"osquery-saved-query\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"created_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"created_by\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"ecs_mapping\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"interval\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"platform\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"query\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"updated_at\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updated_by\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"query\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"filters\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"query\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"language\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"timefilter\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"references\": {\n\t\t\t\"type\": \"nested\",\n\t\t\t\"properties\": {\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"rules-settings\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"flapping\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"createdAt\": {\n\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"lookBackWindow\": {\n\t\t\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"statusChangeThreshold\": {\n\t\t\t\t\t\t\t\"type\": \"long\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updatedAt\": {\n\t\t\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"sample-data-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"installCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"unInstallCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"search\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"breakdownField\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"columns\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"grid\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"hideAggregatedPreview\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"hideChart\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"hits\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"isTextBasedQuery\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"refreshInterval\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"pause\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"rowHeight\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"rowsPerPage\": {\n\t\t\t\t\t\"type\": \"integer\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"sort\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"timeRange\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"from\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"to\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\t\t\"doc_values\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"timeRestore\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"usesAdHocDataView\": {\n\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\"doc_values\": false,\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"viewMode\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"search-session\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"appId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"expires\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"idMapping\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"initialState\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"isCanceled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"locatorId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"realmName\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"realmType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"restoreState\": {\n\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\"enabled\": false\n\t\t\t\t},\n\t\t\t\t\"sessionId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"username\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"search-telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"security-rule\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"rule_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"security-solution-signals-migration\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"destinationIndex\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"error\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"sourceIndex\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"taskId\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-detection-engine-rule-actions\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"actions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"actionRef\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"action_type_id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"group\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"params\": {\n\t\t\t\t\t\t\t\"type\": \"object\",\n\t\t\t\t\t\t\t\"enabled\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"alertThrottle\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"ruleAlertId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"ruleThrottle\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-ui-timeline\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"columns\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"aggregatable\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"category\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"columnHeaderType\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"description\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"example\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"indexes\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"placeholder\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"searchable\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"dataProviders\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"and\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"excluded\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"kqlQuery\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"queryMatch\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"displayField\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"displayValue\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"excluded\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"kqlQuery\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"name\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"queryMatch\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"displayField\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"displayValue\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"operator\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"dateRange\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"end\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"start\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"eqlOptions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"eventCategoryField\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"size\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"tiebreakerField\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"timestampField\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"eventType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"excludedRowRendererIds\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"favorite\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"favoriteDate\": {\n\t\t\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"fullName\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"keySearch\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"userName\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"filters\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"exists\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"match_all\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"meta\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"alias\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"controlledBy\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"disabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"field\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"formattedValue\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"index\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"key\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"negate\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"params\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"type\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"value\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"missing\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"query\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"range\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"script\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"indexNames\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"kqlMode\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"kqlQuery\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"filterQuery\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"kuery\": {\n\t\t\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\t\t\"expression\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\t\t\"kind\": {\n\t\t\t\t\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"serializedQuery\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"sort\": {\n\t\t\t\t\t\"dynamic\": \"false\",\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"columnId\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"columnType\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"sortDirection\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"templateTimelineId\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"templateTimelineVersion\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"timelineType\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-ui-timeline-note\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"eventId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"note\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"siem-ui-timeline-pinned-event\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"created\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createdBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"eventId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"updated\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"updatedBy\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"space\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"_reserved\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"disabledFeatures\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"imageUrl\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"initials\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 2048\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"spaces-usage-stats\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"synthetics-monitor\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"alert\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"status\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"custom_heartbeat_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"hash\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"hosts\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"journey_id\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"locations\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"id\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256,\n\t\t\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"label\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256,\n\t\t\t\t\t\t\t\"normalizer\": \"lowercase\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"origin\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"project_id\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"schedule\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"number\": {\n\t\t\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"tags\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"text\": {\n\t\t\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"type\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"urls\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"synthetics-param\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"synthetics-privates-locations\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"tag\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"color\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"name\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"allowChangingOptInStatus\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"enabled\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t},\n\t\t\t\t\"lastReported\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"lastVersionChecked\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"reportFailureCount\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"reportFailureVersion\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"sendUsageFrom\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"userHasSeenNotice\": {\n\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"type\": {\n\t\t\t\"type\": \"keyword\"\n\t\t},\n\t\t\"ui-metric\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"count\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"updated_at\": {\n\t\t\t\"type\": \"date\"\n\t\t},\n\t\t\"upgrade-assistant-ml-upgrade-operation\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"jobId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"nodeId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"snapshotId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"upgrade-assistant-reindex-operation\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"errorMessage\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"indexName\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t},\n\t\t\t\t\"lastCompletedStep\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"locked\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"newIndexName\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"reindexOptions\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"openAndClose\": {\n\t\t\t\t\t\t\t\"type\": \"boolean\"\n\t\t\t\t\t\t},\n\t\t\t\t\t\t\"queueSettings\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"queuedAt\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t},\n\t\t\t\t\t\t\t\t\"startedAt\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"reindexTaskId\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 256\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"reindexTaskPercComplete\": {\n\t\t\t\t\t\"type\": \"float\"\n\t\t\t\t},\n\t\t\t\t\"runningReindexCount\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"status\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"upgrade-assistant-telemetry\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"features\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"deprecation_logging\": {\n\t\t\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\t\t\"enabled\": {\n\t\t\t\t\t\t\t\t\t\"type\": \"boolean\",\n\t\t\t\t\t\t\t\t\t\"null_value\": true\n\t\t\t\t\t\t\t\t}\n\t\t\t\t\t\t\t}\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"uptime-dynamic-settings\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t},\n\t\t\"uptime-synthetics-api-key\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"apiKey\": {\n\t\t\t\t\t\"type\": \"binary\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"url\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"accessCount\": {\n\t\t\t\t\t\"type\": \"long\"\n\t\t\t\t},\n\t\t\t\t\"accessDate\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"createDate\": {\n\t\t\t\t\t\"type\": \"date\"\n\t\t\t\t},\n\t\t\t\t\"locatorJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"slug\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"url\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"fields\": {\n\t\t\t\t\t\t\"keyword\": {\n\t\t\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\t\t\"ignore_above\": 2048\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"usage-counters\": {\n\t\t\t\"dynamic\": \"false\",\n\t\t\t\"properties\": {\n\t\t\t\t\"domainId\": {\n\t\t\t\t\t\"type\": \"keyword\"\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"visualization\": {\n\t\t\t\"properties\": {\n\t\t\t\t\"description\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"kibanaSavedObjectMeta\": {\n\t\t\t\t\t\"properties\": {\n\t\t\t\t\t\t\"searchSourceJSON\": {\n\t\t\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\t\t\"index\": false\n\t\t\t\t\t\t}\n\t\t\t\t\t}\n\t\t\t\t},\n\t\t\t\t\"savedSearchRefName\": {\n\t\t\t\t\t\"type\": \"keyword\",\n\t\t\t\t\t\"index\": false,\n\t\t\t\t\t\"doc_values\": false\n\t\t\t\t},\n\t\t\t\t\"title\": {\n\t\t\t\t\t\"type\": \"text\"\n\t\t\t\t},\n\t\t\t\t\"uiStateJSON\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t},\n\t\t\t\t\"version\": {\n\t\t\t\t\t\"type\": \"integer\"\n\t\t\t\t},\n\t\t\t\t\"visState\": {\n\t\t\t\t\t\"type\": \"text\",\n\t\t\t\t\t\"index\": false\n\t\t\t\t}\n\t\t\t}\n\t\t},\n\t\t\"workplace_search_telemetry\": {\n\t\t\t\"type\": \"object\",\n\t\t\t\"dynamic\": \"false\"\n\t\t}\n\t}\n}\n");
        stepRepository.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 1, 1, 1500L, (Map)desiredMappings);
        client.index(new IndexRequest(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()).source((Map)DocNode.EMPTY)).actionGet();
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)false));
        stepRepository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(stepRepository, new IndexSettingsManager(stepRepository));
        StepResult result = step.execute(this.context);
        log.debug("Create backup index step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.isIndexCreated(this.context.getBackupIndexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode actualMappings = this.environmentHelper.getIndexMappingsAsDocNode(this.context.getBackupIndexName());
        log.debug("Backup index mappings '{}'", (Object)actualMappings.toJsonString());
        MatcherAssert.assertThat((Object)actualMappings, (Matcher)Matchers.equalTo((Object)desiredMappings));
    }

    @Test
    public void shouldWriteBlockBackupIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        CreateBackupOfGlobalIndexStep step = new CreateBackupOfGlobalIndexStep(repository, settingsManager);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        String createdDocumentId = (String)catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default").get(0);
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        DeleteRequest deleteRequest = (DeleteRequest)new DeleteRequest(this.context.getBackupIndexName(), createdDocumentId).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
        ThrowableAssert.assertThatThrown(() -> client.delete(deleteRequest).actionGet(), (Matcher[])new Matcher[]{Matchers.instanceOf(ClusterBlockException.class)});
        this.environmentHelper.assertThatDocumentExists(this.context.getBackupIndexName(), createdDocumentId);
    }

    @Test
    public void shouldNotCheckPreviousBackupIfBackupWasCreatedInTheCurrentMigrationProcess() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        VerifyPreviousBackupStep step = new VerifyPreviousBackupStep(repository, settingsManager);
        this.context.setBackupCreated(Boolean.valueOf(true));
        StepResult result = step.execute(this.context);
        log.debug("Verify previous backup step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReportErrorWhenIndexWithPreviousBackupWasNotFound() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        VerifyPreviousBackupStep step = new VerifyPreviousBackupStep(repository, settingsManager);
        this.context.setBackupCreated(Boolean.valueOf(false));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_NOT_FOUND_ERROR));
    }

    @Test
    public void shouldReportErrorWhenIndexWithPreviousBackupWasFoundButNotExist() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        VerifyPreviousBackupStep step = new VerifyPreviousBackupStep(repository, settingsManager);
        this.context.setBackupCreated(Boolean.valueOf(false));
        this.context.setBackupIndices(ImmutableList.of((Object)"backup_index_which_does_not_exist"));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_DOES_NOT_EXIST_ERROR));
    }

    @Test
    public void shouldReportErrorWhenIndexWithPreviousBackupIsEmpty() {
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(6L).minusMinutes(5L).minusSeconds(4L));
        this.environmentHelper.createBackupIndex(backupIndex);
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        this.context.setBackupCreated(Boolean.valueOf(false));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        VerifyPreviousBackupStep step = new VerifyPreviousBackupStep(repository, settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Verify previous backup step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_IS_EMPTY_ERROR));
    }

    @Test
    public void shouldSuccessfullyVerifyBackupIndex() {
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(6L).minusMinutes(5L).minusSeconds(4L));
        this.environmentHelper.createBackupIndex(backupIndex);
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(backupIndex.indexName(), "default");
        this.context.setBackupCreated(Boolean.valueOf(false));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        VerifyPreviousBackupStep step = new VerifyPreviousBackupStep(repository, settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Verify previous backup step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReportErrorWhenBackupIndexContainsDataMigrationMarker() {
        MigrationEnvironmentHelper.BackupIndex backupIndex = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusHours(6L).minusMinutes(5L).minusSeconds(4L));
        this.environmentHelper.createBackupIndex(backupIndex);
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(backupIndex.indexName(), "default");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex.indexName());
        this.context.setBackupCreated(Boolean.valueOf(false));
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex.indexName()));
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        VerifyPreviousBackupStep step = new VerifyPreviousBackupStep(repository, settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Verify previous backup step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_CONTAINS_MIGRATED_DATA_ERROR));
    }

    @Test
    public void shouldProvideTotalCountOfDocumentInIndexForLargeNumberOfDocuments() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        StepRepository repository = new StepRepository(client);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        int documentNumber = 11000;
        String[] spaceNames = (String[])IntStream.range(0, 11000).mapToObj(i -> "space_no_" + i).toArray(String[]::new);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), spaceNames);
        long numberOfDocuments = repository.countDocuments(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        MatcherAssert.assertThat((Object)numberOfDocuments, (Matcher)Matchers.equalTo((Object)11000L));
    }

    @Test
    public void shouldAddMigrationMarkerToGlobalTenantIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        MatcherAssert.assertThat((Object)settingsManager.isMigrationMarkerPresent(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        AddMigrationMarkerToGlobalTenantIndexStep step = new AddMigrationMarkerToGlobalTenantIndexStep(settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)settingsManager.isMigrationMarkerPresent(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        GetMappingsResponse indexMappings = repository.findIndexMappings(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        Map mappings = ((MappingMetadata)indexMappings.getMappings().get(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName())).getSourceAsMap();
        log.debug("Extended index mappings with migration marker '{}'", (Object)mappings);
        DocNode mappingNode = DocNode.wrap((Object)mappings);
        MatcherAssert.assertThat((Object)mappingNode, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
    }

    @Test
    public void shouldAddMigrationMarkerOnlyToGlobalIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        ImmutableList doubleAliasIndices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)managementTenantIndex, (Object[])new MigrationEnvironmentHelper.DoubleAliasIndex[0]);
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)doubleAliasIndices);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        MatcherAssert.assertThat((Object)settingsManager.isMigrationMarkerPresent(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)false));
        ImmutableList tenantIndices = ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")).with((Object)new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), null)).with((Object)new TenantIndex(managementTenantIndex.indexName(), "management"));
        this.context.setTenantIndices(tenantIndices);
        AddMigrationMarkerToGlobalTenantIndexStep step = new AddMigrationMarkerToGlobalTenantIndexStep(settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)settingsManager.isMigrationMarkerPresent(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)true));
        DocNode mappingNode = this.environmentHelper.getIndexMappingsAsDocNode(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        MatcherAssert.assertThat((Object)mappingNode, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
        mappingNode = this.environmentHelper.getIndexMappingsAsDocNode(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName());
        MatcherAssert.assertThat((Object)mappingNode, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean")));
        mappingNode = this.environmentHelper.getIndexMappingsAsDocNode(managementTenantIndex.indexName());
        MatcherAssert.assertThat((Object)mappingNode, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean")));
    }

    @Test
    public void shouldNotAddMigrationMarkerToGlobalIndexWhenMarkerIsAlreadyPresent() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        AddMigrationMarkerToGlobalTenantIndexStep step = new AddMigrationMarkerToGlobalTenantIndexStep(settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)result.message(), (Matcher)Matchers.containsString((String)"marker already present"));
    }

    @Test
    public void shouldAddMigrationMarkerToBlockedIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        IndexSettingsManager settingsManager = new IndexSettingsManager(repository);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default");
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        AddMigrationMarkerToGlobalTenantIndexStep step = new AddMigrationMarkerToGlobalTenantIndexStep(settingsManager);
        StepResult result = step.execute(this.context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        DocNode mappingNode = this.environmentHelper.getIndexMappingsAsDocNode(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        MatcherAssert.assertThat((Object)mappingNode, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
    }

    @Test
    public void shouldBlockSingleDocumentDeletion() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        String id = (String)catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default").get(0);
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id);
        DeleteRequest deleteRequest = new DeleteRequest(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id);
        ThrowableAssert.assertThatThrown(() -> client.delete(deleteRequest).actionGet(), (Matcher[])new Matcher[]{Matchers.instanceOf(ClusterBlockException.class)});
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id);
    }

    @Test
    public void shouldBlockMultipleDocumentsDeletion() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        String id = (String)catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "one", "two", "three").get(0);
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id);
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> repository.deleteAllDocuments(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), id);
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DELETE_ALL_BULK_ERROR));
    }

    @Test
    public void shouldDeleteManyDocumentsFromGlobalTenantIndex() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        int numberOfDocuments = 25000;
        String[] names = (String[])IntStream.range(0, 25000).mapToObj(i -> "space_no_" + i).toArray(String[]::new);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), names);
        repository.writeBlockIndices(ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)25000L));
        DeleteGlobalIndexContentStep step = new DeleteGlobalIndexContentStep(repository);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        StepResult result = step.execute(this.context);
        log.debug("Delete global index content step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)0L));
    }

    @Test
    public void shouldDeleteOnlyDocumentsFromGlobalIndex() {
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenantIndex = this.environmentHelper.doubleAliasForTenant("management");
        ImmutableList doubleAliasIndices = ImmutableList.of((Object)MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)managementTenantIndex, (Object[])new MigrationEnvironmentHelper.DoubleAliasIndex[0]);
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)doubleAliasIndices);
        ImmutableList tenantIndices = ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")).with((Object)new TenantIndex(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), null)).with((Object)new TenantIndex(managementTenantIndex.indexName(), "management"));
        this.context.setTenantIndices(tenantIndices);
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusYears(1L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2);
        this.context.setBackupIndices(ImmutableList.of((Object)backupIndex1.indexName(), (Object)backupIndex2.indexName()));
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "global");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "private");
        catalog.insertSpace(managementTenantIndex.indexName(), "management");
        catalog.insertSpace(backupIndex1.indexName(), "backup_1");
        catalog.insertSpace(backupIndex2.indexName(), "backup_2");
        DeleteGlobalIndexContentStep step = new DeleteGlobalIndexContentStep(new StepRepository(client));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(managementTenantIndex.indexName()), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(backupIndex1.indexName()), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(backupIndex2.indexName()), (Matcher)Matchers.equalTo((Object)1L));
    }

    @Test
    public void shouldCopyAllFromTempIndexIntoGlobalTenantIndex() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        CopyDataToGlobalIndexStep step = new CopyDataToGlobalIndexStep(repository);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        repository.createIndex(this.context.getTempIndexName(), 1, 0, 1500L, Collections.emptyMap());
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        int numberOfDocuments = 12500;
        catalog.insertSpace(this.context.getTempIndexName(), 12500);
        StepResult result = step.execute(this.context);
        log.debug("Copy documents to global tenant index result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)12500L));
    }

    @Test
    public void shouldCopyExactDocumentToGlobalTenantIndex() {
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        StepRepository repository = new StepRepository(client);
        CopyDataToGlobalIndexStep step = new CopyDataToGlobalIndexStep(repository);
        this.context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "SGS_GLOBAL_TENANT")));
        repository.createIndex(this.context.getTempIndexName(), 1, 0, 1500L, Collections.emptyMap());
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        int numberOfDocuments = 3;
        ImmutableList<String> spacesIds = catalog.insertSpace(this.context.getTempIndexName(), 3);
        ImmutableList<String> patternIds = catalog.insertIndexPattern(this.context.getTempIndexName(), 3);
        StepResult result = step.execute(this.context);
        log.debug("Copy documents to global tenant index result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ImmutableList documentsToCompare = spacesIds.with(patternIds);
        MatcherAssert.assertThat((Object)documentsToCompare, (Matcher)Matchers.hasSize((int)6));
        for (String documentId : documentsToCompare) {
            String sourceDocument = this.environmentHelper.getDocumentSource(this.context.getTempIndexName(), documentId).orElseThrow();
            String documentCopy = this.environmentHelper.getDocumentSource(this.context.getGlobalTenantIndexName(), documentId).orElseThrow();
            MatcherAssert.assertThat((Object)documentCopy, (Matcher)Matchers.equalTo((Object)sourceDocument));
        }
    }

    private CheckIndicesStateStep createCheckIndicesStateStep() {
        return new CheckIndicesStateStep(new StepRepository(this.environmentHelper.getPrivilegedClient()));
    }

    private PopulateTenantsStep createPopulateTenantsStep() {
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        PrivilegedConfigClient privilegedConfigClient = this.environmentHelper.getPrivilegedClient();
        return new PopulateTenantsStep(configurationProvider, new StepRepository(privilegedConfigClient));
    }

    private static CopyDataToTempIndexStep createCopyDataToTempIndexStep(PrivilegedConfigClient client) {
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        StepRepository stepRepository = new StepRepository(client);
        IndexSettingsManager indexSettingsManager = new IndexSettingsManager(stepRepository);
        return new CopyDataToTempIndexStep(stepRepository, configurationProvider, indexSettingsManager);
    }
}

