/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.IndexNameDataFormatter;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.Constants;
import java.time.Clock;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexRequest;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsRequest;
import org.elasticsearch.action.admin.indices.mapping.get.GetMappingsResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsRequest;
import org.elasticsearch.action.admin.indices.settings.get.GetSettingsResponse;
import org.elasticsearch.action.admin.indices.template.get.GetIndexTemplatesResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.MappingMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.rules.ExternalResource;

public class MigrationEnvironmentHelper
extends ExternalResource {
    private static final Logger log = LogManager.getLogger(MigrationEnvironmentHelper.class);
    public static final String INDEX_TEMPLATE_NAME = "kibana_test_indices_template";
    public static final String TENANT_MANAGEMENT = "management";
    public static final String MULTITENANCY_INDEX_PREFIX = ".kibana";
    public static final DoubleAliasIndex GLOBAL_TENANT_INDEX = new DoubleAliasIndex(".kibana_8.7.0_001", ".kibana_8.7.0", ".kibana");
    public static final String CREATE_INDEX_ID = "CREATE_INDEX_ID";
    public static final DoubleAliasIndex PRIVATE_USER_KIRK_INDEX = new DoubleAliasIndex(".kibana_3292183_kirk_8.7.0_001", ".kibana_3292183_kirk_8.7.0", ".kibana_3292183_kirk");
    public static final DoubleAliasIndex PRIVATE_USER_LUKASZ_1_INDEX = new DoubleAliasIndex(".kibana_-1091682490_lukasz_8.7.0_001", ".kibana_-1091682490_lukasz_8.7.0", ".kibana_-1091682490_lukasz");
    public static final DoubleAliasIndex PRIVATE_USER_LUKASZ_2_INDEX = new DoubleAliasIndex(".kibana_739988528_ukasz_8.7.0_001", ".kibana_739988528_ukasz_8.7.0", ".kibana_739988528_ukasz");
    public static final DoubleAliasIndex PRIVATE_USER_LUKASZ_3_INDEX = new DoubleAliasIndex(".kibana_-1091714203_luksz_8.7.0_001", ".kibana_-1091714203_luksz_8.7.0", ".kibana_-1091714203_luksz");
    private final LocalCluster.Embedded cluster;
    private final Clock clock;
    private final List<DeletableIndex> createdIndices = new ArrayList<DeletableIndex>();
    private PrivilegedConfigClient privilegedConfigClient;

    public MigrationEnvironmentHelper(LocalCluster.Embedded cluster, Clock clock) {
        this.cluster = Objects.requireNonNull(cluster, "Local cluster is required");
        this.clock = Objects.requireNonNull(clock, "Clock is required");
    }

    protected void after() {
        this.deleteIndex((DeletableIndex[])this.createdIndices.toArray(DeletableIndex[]::new));
        this.createdIndices.clear();
        this.findAndDeleteBackupIndices();
        DataMigrationContext context = new DataMigrationContext(new MigrationConfig(false), this.clock);
        if (this.isIndexCreated(context.getTempIndexName())) {
            DeletableIndex[] deletableIndexArray = new DeletableIndex[1];
            deletableIndexArray[0] = () -> ((DataMigrationContext)context).getTempIndexName();
            this.deleteIndex(deletableIndexArray);
        }
        this.deleteIndexTemplateIfExists();
    }

    static String tenantNameToIndexName(String indexNamePrefix, String tenantName) {
        return indexNamePrefix + "_" + tenantName.hashCode() + "_" + tenantName.toLowerCase().replaceAll("[^a-z0-9]+", "");
    }

    public void addCreatedIndex(DeletableIndex indexName) {
        this.createdIndices.add(indexName);
    }

    private void deleteIndexTemplateIfExists() {
        Client client = this.cluster.getInternalNodeClient();
        GetIndexTemplatesResponse response = (GetIndexTemplatesResponse)client.admin().indices().prepareGetTemplates(Constants.DEFAULT_MASTER_TIMEOUT, new String[]{INDEX_TEMPLATE_NAME}).execute().actionGet();
        if (!response.getIndexTemplates().isEmpty()) {
            AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)client.admin().indices().prepareDeleteTemplate(INDEX_TEMPLATE_NAME).execute().actionGet();
            MatcherAssert.assertThat((Object)acknowledgedResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
        }
    }

    public boolean isIndexCreated(String ... indexOrAlias) {
        try {
            Client client = this.cluster.getInternalNodeClient();
            for (String index : indexOrAlias) {
                client.admin().indices().getIndex(new GetIndexRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{index})).actionGet();
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void deleteIndex(DeletableIndex ... deletableIndices) {
        if (deletableIndices.length == 0) {
            return;
        }
        String[] indicesForDeletion = (String[])Arrays.stream(deletableIndices).map(DeletableIndex::indexForDeletion).toArray(String[]::new);
        DeleteIndexRequest request = new DeleteIndexRequest(indicesForDeletion);
        Client client = this.cluster.getInternalNodeClient();
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)client.admin().indices().delete(request).actionGet();
        MatcherAssert.assertThat((Object)acknowledgedResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    public List<DoubleAliasIndex> getIndicesForConfiguredTenantsWithoutGlobal() {
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)this.cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        return configurationProvider.getTenantNames().stream().filter(name -> !"SGS_GLOBAL_TENANT".equals(name)).map(this::doubleAliasForTenant).toList();
    }

    public boolean isDocumentInsertionPossible(String indexName) {
        try {
            Client client = this.cluster.getInternalNodeClient();
            IndexRequest request = (IndexRequest)new IndexRequest(indexName).source((Map)ImmutableMap.of((Object)"new", (Object)"document")).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE);
            client.index(request).actionGet();
            return true;
        }
        catch (ClusterBlockException clusterBlockException) {
            return false;
        }
    }

    public Settings getIndexSettings(String index) {
        Client client = this.cluster.getInternalNodeClient();
        GetSettingsRequest request = new GetSettingsRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{index});
        return (Settings)((GetSettingsResponse)client.admin().indices().getSettings(request).actionGet()).getIndexToSettings().get(index);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long countDocumentInIndex(String indexName) {
        Client client = this.cluster.getInternalNodeClient();
        SearchRequest request = new SearchRequest(new String[]{indexName});
        request.source(SearchSourceBuilder.searchSource().size(0).trackTotalHits(true).query((QueryBuilder)QueryBuilders.matchAllQuery()));
        SearchResponse response = (SearchResponse)client.search(request).actionGet();
        try {
            MatcherAssert.assertThat((Object)response.getFailedShards(), (Matcher)Matchers.equalTo((Object)0));
            long l = response.getHits().getTotalHits().value();
            return l;
        }
        finally {
            response.decRef();
        }
    }

    public Optional<String> getDocumentSource(String indexName, String documentId) {
        Client client = this.cluster.getInternalNodeClient();
        GetResponse response = (GetResponse)client.get(new GetRequest(indexName, documentId)).actionGet();
        return Optional.ofNullable(response).filter(GetResponse::isExists).map(GetResponse::getSourceAsString);
    }

    public void createIndex(List<DoubleAliasIndex> indices) {
        this.createIndex((DoubleAliasIndex[])indices.toArray(DoubleAliasIndex[]::new));
    }

    public void createIndex(DoubleAliasIndex ... indices) {
        this.createIndex(MULTITENANCY_INDEX_PREFIX, 0, null, indices);
    }

    public DoubleAliasIndex doubleAliasForTenant(String tenantName) {
        return DoubleAliasIndex.forTenantWithPrefix(this.getConfiguredIndexPrefix(), tenantName);
    }

    public void createLegacyIndex(LegacyIndex ... indices) {
        String configuredIndexNamePrefix = this.getConfiguredIndexPrefix();
        BulkRequest bulkRequest = new BulkRequest();
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest(Constants.DEFAULT_MASTER_TIMEOUT, Constants.DEFAULT_ACK_TIMEOUT);
        PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest(INDEX_TEMPLATE_NAME).patterns(Collections.singletonList(configuredIndexNamePrefix + "*")).settings(Settings.builder().put("index.hidden", true));
        Client client = this.cluster.getInternalNodeClient();
        client.admin().indices().putTemplate(templateRequest).actionGet();
        for (LegacyIndex index : indices) {
            String currentIndexName = index.indexName();
            if (!currentIndexName.startsWith(configuredIndexNamePrefix)) {
                throw new IllegalStateException("All legacy indices names should start with " + configuredIndexNamePrefix);
            }
            bulkRequest.add(new IndexRequest(currentIndexName).source((Map)DocNode.EMPTY));
            this.createdIndices.add(index);
            indicesAliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index.indexName()).aliases(new String[]{index.longAlias()}));
        }
        BulkResponse response = (BulkResponse)client.bulk(bulkRequest.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        if (response.hasFailures()) {
            log.error("Cannot create legacy indices due to '{}'", (Object)response.buildFailureMessage());
        }
        MatcherAssert.assertThat((Object)response.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)client.admin().indices().aliases(indicesAliasesRequest).actionGet();
        if (!acknowledgedResponse.isAcknowledged()) {
            log.error("Cannot create aliases for legacy indices.");
        }
        MatcherAssert.assertThat((Object)acknowledgedResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    public void createIndex(String indexNamesPrefix, int numberOfReplicas, Settings additionalSettings, DoubleAliasIndex ... indices) {
        BulkRequest bulkRequestCreateIndices = new BulkRequest();
        BulkRequest bulkRequestClearIndices = new BulkRequest();
        IndicesAliasesRequest indicesAliasesRequest = new IndicesAliasesRequest(Constants.DEFAULT_MASTER_TIMEOUT, Constants.DEFAULT_ACK_TIMEOUT);
        Settings.Builder settings = Settings.builder().put("index.hidden", true).put("index.number_of_replicas", numberOfReplicas);
        if (additionalSettings != null) {
            settings.put(additionalSettings);
        }
        PutIndexTemplateRequest templateRequest = new PutIndexTemplateRequest(INDEX_TEMPLATE_NAME).patterns(Collections.singletonList(indexNamesPrefix + "*")).settings(settings);
        Client client = this.cluster.getInternalNodeClient();
        AcknowledgedResponse createTemplateResponse = (AcknowledgedResponse)client.admin().indices().putTemplate(templateRequest).actionGet();
        MatcherAssert.assertThat((Object)createTemplateResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
        for (DoubleAliasIndex index : indices) {
            String currentIndex = index.indexName();
            if (!currentIndex.startsWith(indexNamesPrefix)) {
                String message = String.join((CharSequence)"", "Incorrect name of index ", currentIndex, ". All created indices must have a common prefix '" + indexNamesPrefix, "'.");
                throw new IllegalStateException(message);
            }
            bulkRequestCreateIndices.add(new IndexRequest(currentIndex).id(CREATE_INDEX_ID).source((Map)DocNode.EMPTY));
            this.createdIndices.add(index);
            indicesAliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(index.indexName()).aliases(new String[]{index.longAlias(), index.shortAlias()}));
            bulkRequestClearIndices.add(new DeleteRequest(currentIndex, CREATE_INDEX_ID));
        }
        BulkResponse response = (BulkResponse)client.bulk(bulkRequestCreateIndices.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        if (response.hasFailures()) {
            log.error("Create index failure response {}", (Object)response.buildFailureMessage());
        }
        MatcherAssert.assertThat((Object)response.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
        IndicesAliasesResponse acknowledgedResponse = (IndicesAliasesResponse)client.admin().indices().aliases(indicesAliasesRequest).actionGet();
        MatcherAssert.assertThat((Object)acknowledgedResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
        response = (BulkResponse)client.bulk(bulkRequestClearIndices).actionGet();
        if (response.hasFailures()) {
            log.error("Cannot clear newly created indices {}", (Object)response.buildFailureMessage());
        }
        MatcherAssert.assertThat((Object)response.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
    }

    public String getConfiguredIndexPrefix() {
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)this.cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        return ((FeMultiTenancyConfig)configurationProvider.getConfig().orElseThrow()).getIndex();
    }

    public void createIndexInYellowState(String index) {
        Client client = this.cluster.getInternalNodeClient();
        CreateIndexRequest request = new CreateIndexRequest(index);
        Settings.Builder settings = Settings.builder().put("index.number_of_replicas", 100);
        request.settings(settings);
        CreateIndexResponse createIndexResponse = (CreateIndexResponse)client.admin().indices().create(request).actionGet();
        MatcherAssert.assertThat((Object)createIndexResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
        this.createdIndices.add(() -> index);
    }

    public void createBackupIndex(BackupIndex ... indices) {
        BulkRequest bulkRequestIndex = new BulkRequest();
        BulkRequest bulkRequestDelete = new BulkRequest();
        for (BackupIndex index : indices) {
            bulkRequestIndex.add(new IndexRequest(index.indexName()).id(CREATE_INDEX_ID).source((Map)DocNode.EMPTY));
            this.createdIndices.add(index);
            bulkRequestDelete.add(new DeleteRequest(index.indexName(), CREATE_INDEX_ID));
        }
        Client client = this.cluster.getInternalNodeClient();
        BulkResponse response = (BulkResponse)client.bulk(bulkRequestIndex.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        if (response.hasFailures()) {
            log.error("Create backup index failure response {}", (Object)response.buildFailureMessage());
        }
        MatcherAssert.assertThat((Object)response.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
        response = (BulkResponse)client.bulk(bulkRequestDelete.setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        if (response.hasFailures()) {
            log.error("Create backup index failure, cannot clean index, response {}", (Object)response.buildFailureMessage());
        }
        MatcherAssert.assertThat((Object)response.hasFailures(), (Matcher)Matchers.equalTo((Object)false));
    }

    public DocNode getIndexMappingsAsDocNode(String indexName) {
        Client client = this.cluster.getInternalNodeClient();
        GetMappingsResponse response = (GetMappingsResponse)client.admin().indices().getMappings(new GetMappingsRequest(Constants.DEFAULT_MASTER_TIMEOUT).indices(new String[]{indexName})).actionGet();
        Map source = Optional.of(response).map(GetMappingsResponse::getMappings).map(map -> (MappingMetadata)map.get(indexName)).map(MappingMetadata::getSourceAsMap).orElseGet(Collections::emptyMap);
        return DocNode.wrap((Object)source);
    }

    public void addDataMigrationMarkerToTheIndex(String indexName) {
        PrivilegedConfigClient client = this.getPrivilegedClient();
        StepRepository stepRepository = new StepRepository(client);
        GetMappingsResponse response = stepRepository.findIndexMappings(indexName);
        MappingMetadata mappingMetadata = (MappingMetadata)response.getMappings().get(indexName);
        MatcherAssert.assertThat((Object)mappingMetadata, (Matcher)Matchers.notNullValue());
        Map mappingSources = mappingMetadata.getSourceAsMap();
        MatcherAssert.assertThat((Object)mappingSources, (Matcher)Matchers.notNullValue());
        Map properties = (Map)mappingSources.get("properties");
        MatcherAssert.assertThat((String)"Index has not mapping defined, is index empty?", (Object)properties, (Matcher)Matchers.notNullValue());
        properties.put("sg_data_migrated_to_8_8_0", ImmutableMap.of((Object)"type", (Object)"boolean"));
        PutMappingRequest request = new PutMappingRequest(new String[]{indexName}).source(mappingSources);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)client.admin().indices().putMapping(request).actionGet();
        MatcherAssert.assertThat((Object)acknowledgedResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    public PrivilegedConfigClient getPrivilegedClient() {
        if (this.privilegedConfigClient != null) {
            return this.privilegedConfigClient;
        }
        Client client = this.cluster.getInternalNodeClient();
        this.privilegedConfigClient = PrivilegedConfigClient.adapt((Client)client);
        return this.privilegedConfigClient;
    }

    public static ImmutableList<TenantIndex> doubleAliasIndexToTenantDataWithoutTenantName(ImmutableList<DoubleAliasIndex> indices) {
        return indices.map(i -> new TenantIndex(i.indexName(), GLOBAL_TENANT_INDEX.indexName().equals(i.indexName()) ? "SGS_GLOBAL_TENANT" : "tenant name is not important here"));
    }

    public static ImmutableList<TenantIndex> doubleAliasIndexToTenantDataWithoutTenantName(DoubleAliasIndex ... indices) {
        return MigrationEnvironmentHelper.doubleAliasIndexToTenantDataWithoutTenantName((ImmutableList<DoubleAliasIndex>)ImmutableList.ofArray((Object[])indices));
    }

    public List<DoubleAliasIndex> generatePrivateTenantNames(String prefix, int number) {
        return IntStream.range(0, number).mapToObj(index -> "private tenant name - " + index).map(tenantName -> DoubleAliasIndex.forTenantWithPrefix(prefix, tenantName)).collect(Collectors.toList());
    }

    public void assertThatDocumentExists(String index, String documentId) {
        Client client = this.cluster.getInternalNodeClient();
        GetRequest request = new GetRequest(index, documentId);
        GetResponse response = (GetResponse)client.get(request).actionGet();
        String reason = "Document with id '" + documentId + "' does not exist in index '" + index + "'.";
        MatcherAssert.assertThat((String)reason, (Object)response.isExists(), (Matcher)Matchers.equalTo((Object)true));
    }

    public void assertThatDocumentDoesNotExist(String index, String documentId) {
        Client client = this.cluster.getInternalNodeClient();
        GetRequest request = new GetRequest(index, documentId);
        GetResponse response = (GetResponse)client.get(request).actionGet();
        String reason = "Document with id '" + documentId + "' does not exist in index '" + index + "'.";
        MatcherAssert.assertThat((String)reason, (Object)response.isExists(), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)true)));
    }

    public List<DoubleAliasIndex> findIndicesForTenantsDefinedInConfigurationWithoutGlobal() {
        ConfigurationRepository configRepository = (ConfigurationRepository)this.cluster.getInjectable(ConfigurationRepository.class);
        SgDynamicConfiguration configuration = configRepository.getConfiguration(CType.TENANTS);
        return configuration.getCEntries().keySet().stream().filter(tenantName -> !"SGS_GLOBAL_TENANT".equals(tenantName)).map(this::doubleAliasForTenant).toList();
    }

    public void findAndDeleteBackupIndices() {
        StepRepository stepRepository = new StepRepository(this.getPrivilegedClient());
        DeletableIndex[] backupIndices = (BackupIndex[])stepRepository.findIndexByNameOrAlias("backup_fe_migration_to_8_8_0_*").stream().flatMap(response -> Arrays.stream(response.indices())).map(indexName -> new BackupIndex((String)indexName)).toArray(BackupIndex[]::new);
        this.deleteIndex(backupIndices);
    }

    public Optional<GetIndexResponse> findHiddenIndexByName(String indexNameOrAlias) {
        Strings.requireNonEmpty((String)indexNameOrAlias, (String)"Index or alias name is required");
        try {
            GetIndexRequest request = new GetIndexRequest(Constants.DEFAULT_MASTER_TIMEOUT);
            request.indices(new String[]{indexNameOrAlias}).indicesOptions(IndicesOptions.strictExpandHidden());
            GetIndexResponse response = (GetIndexResponse)this.getPrivilegedClient().admin().indices().getIndex(request).actionGet();
            return Optional.ofNullable(response);
        }
        catch (IndexNotFoundException e) {
            return Optional.empty();
        }
    }

    public void deleteIndex(String indexName) {
        DeleteIndexRequest request = new DeleteIndexRequest(indexName);
        AcknowledgedResponse response = (AcknowledgedResponse)this.getPrivilegedClient().admin().indices().delete(request).actionGet();
        MatcherAssert.assertThat((Object)response.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    public static interface DeletableIndex {
        public String indexForDeletion();
    }

    public record DoubleAliasIndex(String indexName, String shortAlias, String longAlias) implements DeletableIndex
    {
        public static final String LAST_VERSION_BEFORE_MIGRATION = "8.7.0";
        public static final String LEGACY_VERSION = "7.17.12";

        public DoubleAliasIndex {
            Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
            Strings.requireNonEmpty((String)shortAlias, (String)"Short alias name is required");
            Strings.requireNonEmpty((String)longAlias, (String)"Long alias name is required");
        }

        public static DoubleAliasIndex forTenantWithPrefix(String indexNamePrefix, String tenantName, String version) {
            String baseAndShortAlias = MigrationEnvironmentHelper.tenantNameToIndexName(indexNamePrefix, tenantName);
            String fullIndexName = DoubleAliasIndex.createIndexName(baseAndShortAlias, version);
            String aliasWithVersionAndSeqNo = DoubleAliasIndex.createLongAlias(baseAndShortAlias, version);
            return new DoubleAliasIndex(fullIndexName, baseAndShortAlias, aliasWithVersionAndSeqNo);
        }

        public static DoubleAliasIndex forTenantWithPrefix(String indexNamePrefix, String tenantName) {
            return DoubleAliasIndex.forTenantWithPrefix(indexNamePrefix, tenantName, LAST_VERSION_BEFORE_MIGRATION);
        }

        private static String createLongAlias(String baseIndexName, String version) {
            return baseIndexName + "_" + version;
        }

        private static String createIndexName(String baseIndexName, String version) {
            return DoubleAliasIndex.createLongAlias(baseIndexName, version) + "_001";
        }

        public String getIndexNameInVersion(String version) {
            return DoubleAliasIndex.createIndexName(this.shortAlias, version);
        }

        public String getLongAliasInVersion(String version) {
            return DoubleAliasIndex.createLongAlias(this.shortAlias, version);
        }

        public LegacyIndex toLegacyIndex(String version) {
            return new LegacyIndex(this.getIndexNameInVersion(version), this.getLongAliasInVersion(version));
        }

        @Override
        public String indexForDeletion() {
            return this.indexName;
        }
    }

    public record LegacyIndex(String indexName, String longAlias) implements DeletableIndex
    {
        public LegacyIndex {
            Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
            Strings.requireNonEmpty((String)longAlias, (String)"Long alias is required");
        }

        @Override
        public String indexForDeletion() {
            return this.indexName;
        }
    }

    public record BackupIndex(String indexName) implements DeletableIndex
    {
        public BackupIndex(LocalDateTime backupIndexCreationTime) {
            this("backup_fe_migration_to_8_8_0_" + IndexNameDataFormatter.format((LocalDateTime)backupIndexCreationTime));
        }

        @Override
        public String indexForDeletion() {
            return this.indexName;
        }
    }
}

