/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.Unscoper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.internal.node.NodeClient;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.UpdateByQueryAction;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.InOrder;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.stubbing.Answer;

@RunWith(value=MockitoJUnitRunner.class)
public class TenantScopedActionListenerWrapperTest {
    @Mock
    private NodeClient client;
    @Mock
    private ThreadContext.StoredContext context;
    @Mock
    private Unscoper<BulkByScrollResponse> unscoper;

    @Test
    public void shouldCallDelegateOnFailure_whenExecutionFails() {
        RuntimeException actionException = new RuntimeException("Action failed");
        ActionListener originalListener = (ActionListener)Mockito.spy((Object)ActionListener.noop());
        TenantScopedActionListenerWrapper listenerWrapper = new TenantScopedActionListenerWrapper(originalListener, this.context, this.unscoper);
        ((NodeClient)Mockito.doAnswer((Answer)new CallListenerOnFailureAnswer(actionException)).when((Object)this.client)).execute((ActionType)ArgumentMatchers.any(), (ActionRequest)ArgumentMatchers.any(), (ActionListener)ArgumentMatchers.any(ActionListener.class));
        this.client.execute((ActionType)UpdateByQueryAction.INSTANCE, (ActionRequest)new UpdateByQueryRequest(), (ActionListener)listenerWrapper);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{originalListener, this.context});
        ((ThreadContext.StoredContext)inOrder.verify((Object)this.context)).restore();
        ((ActionListener)inOrder.verify((Object)originalListener)).onFailure((Exception)ArgumentMatchers.eq((Object)actionException));
    }

    private static class CallListenerOnFailureAnswer
    implements Answer<Void> {
        private final Exception ex;

        CallListenerOnFailureAnswer(Exception ex) {
            this.ex = ex;
        }

        public Void answer(InvocationOnMock invocation) {
            ActionListener actionListener = (ActionListener)invocation.getArgument(2);
            actionListener.onFailure(this.ex);
            return null;
        }
    }
}

