/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.mapper;

import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.enterprise.femt.request.mapper.DeleteMapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.IndexMapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.Unscoper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.UpdateMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.xcontent.XContentType;

public class BulkMapper
implements Unscoper<BulkResponse> {
    private static final Logger log = LogManager.getLogger(BulkMapper.class);

    public BulkRequest toScopedBulkRequest(BulkRequest request, String tenant) {
        log.debug("Rewriting bulk request - adding tenant scope");
        for (DocWriteRequest item : request.requests()) {
            String id = item.id();
            String newId = id == null ? (item instanceof IndexRequest ? RequestResponseTenantData.scopedId(UUIDs.base64UUID(), tenant) : null) : RequestResponseTenantData.scopeIdIfNeeded(id, tenant);
            if (item instanceof IndexRequest) {
                IndexRequest indexRequest = (IndexRequest)item;
                log.debug("Rewriting item - index request");
                indexRequest.id(newId);
                Map source = (Map)XContentHelper.convertToMap((BytesReference)indexRequest.source(), (boolean)true, (XContentType)indexRequest.getContentType()).v2();
                LinkedHashMap<String, Object> newSource = new LinkedHashMap<String, Object>(source);
                RequestResponseTenantData.appendSgTenantFieldTo(newSource, tenant);
                indexRequest.source(newSource, indexRequest.getContentType());
                continue;
            }
            if (item instanceof DeleteRequest) {
                log.debug("Rewriting item - delete request");
                ((DeleteRequest)item).id(newId);
                continue;
            }
            if (item instanceof UpdateRequest) {
                log.debug("Rewriting item - update request");
                ((UpdateRequest)item).id(newId);
                continue;
            }
            log.error("Rewriting item - unhandled item type {}", (Object)item.getClass().getName());
        }
        return request;
    }

    @Override
    public BulkResponse unscopeResponse(BulkResponse response) {
        log.debug("Rewriting bulk response - removing tenant scope");
        BulkItemResponse[] items = response.getItems();
        BulkItemResponse[] newItems = new BulkItemResponse[items.length];
        for (int i = 0; i < items.length; ++i) {
            DocWriteResponse docWriteResponse;
            BulkItemResponse item = items[i];
            if (item.getFailure() != null) {
                BulkItemResponse.Failure interceptedFailure = this.toUnscopedFailure(item.getFailure());
                newItems[i] = BulkItemResponse.failure((int)item.getItemId(), (DocWriteRequest.OpType)item.getOpType(), (BulkItemResponse.Failure)interceptedFailure);
                continue;
            }
            DocWriteResponse newDocWriteResponse = docWriteResponse = item.getResponse();
            if (docWriteResponse instanceof IndexResponse) {
                IndexResponse indexResponse = (IndexResponse)docWriteResponse;
                log.debug("Rewriting item - index response");
                newDocWriteResponse = new IndexMapper().unscopeResponse(indexResponse);
            } else if (docWriteResponse instanceof DeleteResponse) {
                DeleteResponse deleteResponse = (DeleteResponse)docWriteResponse;
                log.debug("Rewriting item - delete response");
                newDocWriteResponse = new DeleteMapper().unscopeResponse(deleteResponse);
            } else if (docWriteResponse instanceof UpdateResponse) {
                UpdateResponse updateResponse = (UpdateResponse)docWriteResponse;
                log.debug("Rewriting item - update response");
                newDocWriteResponse = new UpdateMapper().unscopeResponse(updateResponse);
            } else {
                log.error("Rewriting item - unhandled item type {}", (Object)item.getClass().getName());
            }
            newDocWriteResponse.setForcedRefresh(docWriteResponse.forcedRefresh());
            newItems[i] = BulkItemResponse.success((int)item.getItemId(), (DocWriteRequest.OpType)item.getOpType(), (DocWriteResponse)newDocWriteResponse);
        }
        return new BulkResponse(newItems, response.getTook().millis());
    }

    BulkItemResponse.Failure toUnscopedFailure(BulkItemResponse.Failure scoped) {
        log.debug("Rewriting item with failure");
        if (scoped.isAborted()) {
            return new BulkItemResponse.Failure(scoped.getIndex(), RequestResponseTenantData.unscopedId(scoped.getId()), scoped.getCause(), true);
        }
        if (scoped.getSeqNo() != -2L || scoped.getTerm() != 0L) {
            return new BulkItemResponse.Failure(scoped.getIndex(), RequestResponseTenantData.unscopedId(scoped.getId()), scoped.getCause(), scoped.getSeqNo(), scoped.getTerm());
        }
        return new BulkItemResponse.Failure(scoped.getIndex(), RequestResponseTenantData.unscopedId(scoped.getId()), scoped.getCause(), scoped.getStatus());
    }
}

