/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestStatus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class DashboardAccessByReadOnlyUserTest {
    private static final Logger log = LogManager.getLogger(DashboardAccessByReadOnlyUserTest.class);
    private static final String FRONTEND_INDEX = ".kibana";
    private static final TestSgConfig.User FRONTEND_SERVER_USER = new TestSgConfig.User("kibana_server");
    private static final TestSgConfig.Tenant HR_TENANT = new TestSgConfig.Tenant("hr_tenant");
    private static final TestSgConfig.User USER_READ_ONLY_TENANT = new TestSgConfig.User("user_read_only_tenant").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("hr_tenant_read_only").withTenantPermission(new String[]{"SGS_KIBANA_ALL_READ"}).on(new String[]{HR_TENANT.getName()})});
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().nodeSettings(new Object[]{"action.destructive_requires_name", false, "searchguard.unsupported.single_index_mt_enabled", true}).enterpriseModulesEnabled().roleMapping(new TestSgConfig.RoleMapping[]{new TestSgConfig.RoleMapping("SGS_KIBANA_USER").users(new String[]{USER_READ_ONLY_TENANT.getName()})}).users(new TestSgConfig.User[]{USER_READ_ONLY_TENANT}).frontendMultiTenancy(new TestSgConfig.FrontendMultiTenancy(true).index(".kibana").serverUser(FRONTEND_SERVER_USER.getName())).tenants(new TestSgConfig.Tenant[]{HR_TENANT}).embedded().build();

    @BeforeClass
    public static void createIndex() {
        Client client = cluster.getInternalNodeClient();
        DocNode indexMappings = DocNode.of((String)"_doc", (Object)DocNode.of((String)"properties", (Object)DocNode.of((String)"sg_tenant", (Object)DocNode.of((String)"type", (Object)"keyword"))));
        CreateIndexRequest request = new CreateIndexRequest(".kibana_8.9.0_001").settings(Settings.builder().put("index.hidden", true)).alias(new Alias(".kibana_8.9.0")).alias(new Alias(FRONTEND_INDEX)).mapping((Map)indexMappings);
        CreateIndexResponse response = (CreateIndexResponse)client.admin().indices().create(request).actionGet();
        MatcherAssert.assertThat((Object)response.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
        ImmutableMap source = ImmutableMap.of((Object)"sg_tenant", (Object)TenantManager.toInternalTenantName((String)HR_TENANT.getName()));
        DocWriteResponse createTenantResponse = (DocWriteResponse)client.index((IndexRequest)new IndexRequest(FRONTEND_INDEX).source((Map)source).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).actionGet();
        MatcherAssert.assertThat((Object)createTenantResponse.status(), (Matcher)Matchers.equalTo((Object)RestStatus.CREATED));
    }

    @Test
    public void shouldHavePermissionToLegacyUriAliasUpdate() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER_READ_ONLY_TENANT, new Header[]{new BasicHeader("sg_tenant", HR_TENANT.getName())});){
            String body = "{\"update\":{\"_id\":\"legacy-url-alias:default:dashboard:d90bca50-0910-11ef-ab4b-bf505c6701d0\",\"_index\":\".kibana_8.9.0\",\"_source\":true}}\n{\"script\":{\"source\":\"\\n            if (ctx._source[params.type].disabled != true) {\\n              if (ctx._source[params.type].resolveCounter == null) {\\n                ctx._source[params.type].resolveCounter = 1;\\n              }\\n              else {\\n                ctx._source[params.type].resolveCounter += 1;\\n              }\\n              ctx._source[params.type].lastResolved = params.time;\\n              ctx._source.updated_at = params.time;\\n            }\\n          \",\"lang\":\"painless\",\"params\":{\"type\":\"legacy-url-alias\",\"time\":\"2024-05-04T12:27:03.048Z\"}}}\n{\"update\":{\"_id\":\"legacy-url-alias:default:index-pattern:e4275435-dba8-4dbb-882f-509295543b89\",\"_index\":\".kibana_8.9.0\",\"_source\":true}}\n{\"script\":{\"source\":\"\\n            if (ctx._source[params.type].disabled != true) {\\n              if (ctx._source[params.type].resolveCounter == null) {\\n                ctx._source[params.type].resolveCounter = 1;\\n              }\\n              else {\\n                ctx._source[params.type].resolveCounter += 1;\\n              }\\n              ctx._source[params.type].lastResolved = params.time;\\n              ctx._source.updated_at = params.time;\\n            }\\n          \",\"lang\":\"painless\",\"params\":{\"type\":\"legacy-url-alias\",\"time\":\"2024-05-04T12:27:03.048Z\"}}}\n";
            GenericRestClient.HttpResponse response = client.postJson("/_bulk", body, new Header[0]);
            log.debug("Response status '{}', and body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode responseBody = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.errors", (Object)true));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.items[0].update.status", (Object)404));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.items[0].update.error.type", (Object)"document_missing_exception"));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.items[0].update._id", (Object)"legacy-url-alias:default:dashboard:d90bca50-0910-11ef-ab4b-bf505c6701d0"));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.items[1].update.status", (Object)404));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.items[1].update.error.type", (Object)"document_missing_exception"));
            MatcherAssert.assertThat((Object)responseBody, (Matcher)DocNodeMatchers.containsValue((String)"$.items[1].update._id", (Object)"legacy-url-alias:default:index-pattern:e4275435-dba8-4dbb-882f-509295543b89"));
        }
    }
}

