/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import jakarta.annotation.Nullable;
import org.elasticsearch.common.Strings;

public record TenantIndex(String indexName, @Nullable String tenantName) {
    public TenantIndex {
        Strings.requireNonEmpty((String)indexName, (String)"Tenant index name is required");
    }

    public boolean belongsToGlobalTenant() {
        return "SGS_GLOBAL_TENANT".equals(this.tenantName);
    }

    public boolean belongsToUserPrivateTenant() {
        return Strings.isNullOrEmpty((String)this.tenantName);
    }

    public String getVersion() {
        String removedPostfix = this.indexName.substring(0, this.indexName.length() - 4);
        return removedPostfix.substring(removedPostfix.lastIndexOf("_") + 1);
    }

    public boolean isInVersion(String version) {
        return this.getVersion().equals(version);
    }
}

