/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.BulkMapper;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class BulkRequestHandler
extends RequestHandler<BulkRequest> {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final BulkMapper bulkMapper;

    public BulkRequestHandler(Client nodeClient, ThreadContext threadContext) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.bulkMapper = new BulkMapper();
    }

    @Override
    public SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, String requestedTenant, BulkRequest request, ActionListener<?> listener) {
        this.log.debug("Handle bulk request");
        try (ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();){
            this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
            BulkRequest scoped = this.bulkMapper.toScopedBulkRequest(request, requestedTenant);
            TenantScopedActionListenerWrapper<BulkResponse> listenerWrapper = new TenantScopedActionListenerWrapper<BulkResponse>(listener, storedContext, this.bulkMapper);
            this.nodeClient.bulk(scoped, listenerWrapper);
            SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
            return result;
        }
    }
}

