/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.MarkerNodeRemoval;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Test;

public class MarkerNodeRemovalTest {
    @Test
    public void shouldRemoveOnlyMigrationMarker_1() throws DocumentParseException {
        DocNode properties = DocNode.of((String)"prop_one", (Object)1, (String)"prop_two", (Object)2, (String)"sg_data_migrated_to_8_8_0", (Object)DocNode.of((String)"type", (Object)"boolean"));
        DocNode node = DocNode.of((String)"root_one", (Object)1, (String)"root_two", (Object)2, (String)"properties", (Object)properties);
        DocNode processed = MarkerNodeRemoval.withoutMigrationMarker(node);
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.containsValue((String)"$.root_one", (Object)1));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.containsValue((String)"$.root_two", (Object)2));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$", (int)3));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.prop_one", (Object)1));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.prop_two", (Object)2));
        MatcherAssert.assertThat((Object)processed, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.properties", (String)"sg_data_migrated_to_8_8_0")));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.properties", (int)2));
    }

    @Test
    public void shouldRemoveOnlyMigrationMarker_2() throws DocumentParseException {
        DocNode root = DocNode.EMPTY;
        for (int i = 0; i < 100; ++i) {
            root = root.with("main_attribute_" + i, (Object)("value_" + i));
        }
        DocNode properties = DocNode.EMPTY;
        for (int i = 0; i < 100; ++i) {
            properties = properties.with("sub_attribute_" + i, (Object)("sub_value_" + i));
        }
        properties = properties.with("sg_data_migrated_to_8_8_0", (Object)"please remove me!");
        DocNode node = root.with("properties", (Object)properties);
        DocNode processed = MarkerNodeRemoval.withoutMigrationMarker(node);
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.containsValue((String)"main_attribute_5", (Object)"value_5"));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$", (int)101));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sub_attribute_44", (Object)"sub_value_44"));
        MatcherAssert.assertThat((Object)processed, (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.properties", (int)100));
        MatcherAssert.assertThat((Object)processed, (Matcher)Matchers.not((Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.properties", (String)"sg_data_migrated_to_8_8_0")));
    }
}

