/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.TenantScopedActionListenerWrapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.SearchMapper;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.util.concurrent.ThreadContext;

public class SearchRequestHandler
extends RequestHandler<SearchRequest> {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final SearchMapper searchMapper;

    public SearchRequestHandler(Client nodeClient, ThreadContext threadContext) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.searchMapper = new SearchMapper();
    }

    @Override
    public SyncAuthorizationFilter.Result handle(PrivilegesEvaluationContext context, String requestedTenant, SearchRequest request, ActionListener<?> listener) {
        this.log.debug("Handle search request");
        try (ThreadContext.StoredContext storedContext = this.threadContext.newStoredContext();){
            this.threadContext.putHeader("_sg_filter_level_femt_done", request.toString());
            SearchRequest scopedRequest = this.searchMapper.toScopedSearchRequest(request, requestedTenant);
            TenantScopedActionListenerWrapper<SearchResponse> listenerWrapper = new TenantScopedActionListenerWrapper<SearchResponse>(listener, storedContext, this.searchMapper, SearchResponse::decRef);
            this.nodeClient.search(scopedRequest, listenerWrapper);
            SyncAuthorizationFilter.Result result = SyncAuthorizationFilter.Result.INTERCEPTED;
            return result;
        }
    }
}

