/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.DeleteGlobalIndexContentStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.Arrays;
import java.util.Collection;
import org.elasticsearch.common.Strings;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

@RunWith(value=Parameterized.class)
public class DeleteGlobalIndexContentStepTest {
    private StepRepository stepRepository;
    private DataMigrationContext context;
    private BulkByScrollResponse deletionResponse;
    private DeleteGlobalIndexContentStep step;
    private final String indexName;
    private final long numberOfDocuments;

    public DeleteGlobalIndexContentStepTest(String indexName, long numberOfDocuments) {
        Strings.requireNonEmpty((String)indexName, (String)"Index name is required");
        this.indexName = indexName;
        this.numberOfDocuments = numberOfDocuments;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return Arrays.asList({"data_migration_temp_fe_1990_01_01_01_01_00", 1L}, {"openfind", 2L}, {"my_index", 3L}, {"please_do_not_delete_me", 7L}, {"log_index", 8L}, {".very_big_index", 13L}, {".one_hundred", 100L}, {".three_thousand", 3000L}, {"another_index_name", 1492L}, {"index_for_deletion", Long.MAX_VALUE});
    }

    @Before
    public void before() {
        this.stepRepository = (StepRepository)Mockito.mock(StepRepository.class);
        this.context = (DataMigrationContext)Mockito.mock(DataMigrationContext.class);
        this.deletionResponse = (BulkByScrollResponse)Mockito.mock(BulkByScrollResponse.class);
        this.step = new DeleteGlobalIndexContentStep(this.stepRepository);
    }

    @Test
    public void shouldDeleteOnlyGlobalTenantIndexContent() {
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)this.indexName);
        Mockito.when((Object)this.stepRepository.deleteAllDocuments(ArgumentMatchers.anyString())).thenReturn((Object)this.deletionResponse);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).deleteAllDocuments(this.indexName);
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).releaseWriteLock(ImmutableList.of((Object)this.indexName));
        ((StepRepository)Mockito.verify((Object)this.stepRepository)).countDocuments(this.indexName);
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.stepRepository});
        ((DataMigrationContext)Mockito.verify((Object)this.context)).getGlobalTenantIndexName();
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.context});
    }

    @Test
    public void shouldReportErrorWhenItIsNotPossibleToDeleteAllDocumentsFromTheIndex() {
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)this.indexName);
        Mockito.when((Object)this.stepRepository.deleteAllDocuments(ArgumentMatchers.anyString())).thenReturn((Object)this.deletionResponse);
        Mockito.when((Object)this.stepRepository.countDocuments(this.indexName)).thenReturn((Object)this.numberOfDocuments);
        StepResult result = this.step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.NOT_EMPTY_INDEX));
    }
}

