/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import java.util.Objects;

class CreateTempIndexStep
implements MigrationStep {
    private final IndexSettingsManager indexSettingsManager;

    public CreateTempIndexStep(IndexSettingsManager indexSettingsManager) {
        this.indexSettingsManager = Objects.requireNonNull(indexSettingsManager, "Index settings duplicator is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        String globalTenantIndexName = context.getGlobalTenantIndexName();
        String tempIndexName = context.getTempIndexName();
        IndexSettingsManager.BasicIndexSettings settings = this.indexSettingsManager.createIndexWithClonedSettings(globalTenantIndexName, tempIndexName, true);
        String message = "Temporary index '" + tempIndexName + "' created with " + settings.numberOfShards() + " shards, replicas " + settings.numberOfReplicas() + " and total mapping fields limit " + settings.mappingsTotalFieldsLimit();
        String details = "Temp index mappings " + settings.mappings();
        return new StepResult(StepExecutionStatus.OK, message, details);
    }

    @Override
    public String name() {
        return "create temp index";
    }
}

