/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.ConcurrentConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigUpdateException;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.EnableMultitenancyStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class EnableMultitenancyStepTest {
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(2020, 1, 1, 1, 1), ZoneOffset.UTC);
    private static final Clock CLOCK = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    private DataMigrationContext migrationContext;
    @Mock
    private FeMultiTenancyConfigurationProvider configurationProvider;
    @Mock
    private ConfigurationRepository repository;
    @Captor
    private ArgumentCaptor<SgDynamicConfiguration<FeMultiTenancyConfig>> configCaptor;
    private EnableMultitenancyStep step;

    @Before
    public void setUp() {
        this.migrationContext = new DataMigrationContext(new MigrationConfig(false), CLOCK);
        this.step = new EnableMultitenancyStep(this.configurationProvider, this.repository);
    }

    @Test
    public void shouldEnableMultitenancyWhenMtConfigDoesNotExist() throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        Mockito.when((Object)this.configurationProvider.getConfig()).thenReturn(Optional.empty());
        StepResult result = this.step.execute(this.migrationContext);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((ConfigurationRepository)Mockito.verify((Object)this.repository)).update((CType)ArgumentMatchers.eq((Object)FeMultiTenancyConfig.TYPE), (SgDynamicConfiguration)this.configCaptor.capture(), (String)ArgumentMatchers.isNull(), ArgumentMatchers.eq((boolean)false));
        SgDynamicConfiguration dynamicConfig = (SgDynamicConfiguration)this.configCaptor.getValue();
        FeMultiTenancyConfig capturedConfig = (FeMultiTenancyConfig)dynamicConfig.getCEntry("default");
        MatcherAssert.assertThat((Object)capturedConfig.isEnabled(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldEnableMultitenancyWhenMtIsDisabled() throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        Mockito.when((Object)this.configurationProvider.getConfig()).thenReturn(Optional.of(FeMultiTenancyConfig.DEFAULT.withEnabled(false)));
        StepResult result = this.step.execute(this.migrationContext);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((ConfigurationRepository)Mockito.verify((Object)this.repository)).update((CType)ArgumentMatchers.eq((Object)FeMultiTenancyConfig.TYPE), (SgDynamicConfiguration)this.configCaptor.capture(), (String)ArgumentMatchers.isNull(), ArgumentMatchers.eq((boolean)false));
        SgDynamicConfiguration dynamicConfig = (SgDynamicConfiguration)this.configCaptor.getValue();
        FeMultiTenancyConfig capturedConfig = (FeMultiTenancyConfig)dynamicConfig.getCEntry("default");
        MatcherAssert.assertThat((Object)capturedConfig.isEnabled(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldNotUpdateConfigurationWhenMultitenancyIsAlreadyEnabled() throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        Mockito.when((Object)this.configurationProvider.getConfig()).thenReturn(Optional.of(FeMultiTenancyConfig.DEFAULT.withEnabled(true)));
        StepResult result = this.step.execute(this.migrationContext);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        ((ConfigurationRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.never())).update((CType)ArgumentMatchers.eq((Object)FeMultiTenancyConfig.TYPE), (SgDynamicConfiguration)ArgumentMatchers.any(), (String)ArgumentMatchers.isNull(), ArgumentMatchers.eq((boolean)false));
    }

    @Test
    public void shouldConvertRepositoryExceptionToStepException() throws ConfigUpdateException, ConcurrentConfigUpdateException, ConfigValidationException {
        Mockito.when((Object)this.configurationProvider.getConfig()).thenReturn(Optional.of(FeMultiTenancyConfig.DEFAULT.withEnabled(false)));
        ((ConfigurationRepository)Mockito.doThrow(ConcurrentConfigUpdateException.class).when((Object)this.repository)).update((CType)ArgumentMatchers.eq((Object)FeMultiTenancyConfig.TYPE), (SgDynamicConfiguration)ArgumentMatchers.any(), (String)ArgumentMatchers.isNull(), ArgumentMatchers.eq((boolean)false));
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.migrationContext), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.CANNOT_ENABLE_MULTITENANCY));
    }
}

