/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.authz.TenantManager;
import com.google.common.base.Strings;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class RequestResponseTenantData {
    private static final Pattern INDEX_NAME_TENANT_PART = Pattern.compile("_(?<tenantName>-?\\d+_[^_]+)_.+");
    private static final String STORAGE_GLOBAL_TENANT_ID = TenantManager.toInternalTenantName((String)"SGS_GLOBAL_TENANT");
    public static final String SG_TENANT_FIELD = "sg_tenant";
    private static final String TENANT_SEPARATOR_IN_ID = "__sg_ten__";
    private static final String TENANT_NAME_GROUP = "tenantName";

    private RequestResponseTenantData() {
    }

    public static String getSgTenantField() {
        return SG_TENANT_FIELD;
    }

    public static String scopedId(String id, String tenant) {
        return RequestResponseTenantData.isStorageGlobal(tenant) ? id : id + TENANT_SEPARATOR_IN_ID + tenant;
    }

    private static boolean isStorageGlobal(String tenant) {
        return STORAGE_GLOBAL_TENANT_ID.equals(tenant);
    }

    public static String unscopedId(String id) {
        int i = id.indexOf(TENANT_SEPARATOR_IN_ID);
        if (i != -1) {
            return id.substring(0, i);
        }
        return id;
    }

    public static String scopeIdIfNeeded(String id, String tenant) {
        if (id.contains(TENANT_SEPARATOR_IN_ID)) {
            return RequestResponseTenantData.scopedId(RequestResponseTenantData.unscopedId(id), tenant);
        }
        return RequestResponseTenantData.scopedId(id, tenant);
    }

    public static boolean isScopedId(String id) {
        if (id == null) {
            return false;
        }
        return id.contains(TENANT_SEPARATOR_IN_ID) && !id.endsWith(TENANT_SEPARATOR_IN_ID);
    }

    public static String extractTenantFromId(String id) {
        if (RequestResponseTenantData.isScopedId(id)) {
            return id.substring(id.indexOf(TENANT_SEPARATOR_IN_ID) + TENANT_SEPARATOR_IN_ID.length());
        }
        return null;
    }

    public static boolean containsSgTenantField(Map<String, Object> map) {
        return map.containsKey(SG_TENANT_FIELD);
    }

    public static boolean containsSgTenantField(DocNode docNode) {
        return docNode.hasNonNull(SG_TENANT_FIELD);
    }

    public static void appendSgTenantFieldTo(Map<String, Object> map, String tenant) {
        if (!Strings.isNullOrEmpty((String)tenant) && !RequestResponseTenantData.isStorageGlobal(tenant)) {
            map.put(SG_TENANT_FIELD, tenant);
        }
    }

    public static BoolQueryBuilder sgTenantFieldQuery(String tenantStorageId) {
        BoolQueryBuilder queryBuilder = QueryBuilders.boolQuery();
        if (RequestResponseTenantData.isStorageGlobal(tenantStorageId)) {
            return queryBuilder.mustNot((QueryBuilder)QueryBuilders.existsQuery((String)SG_TENANT_FIELD));
        }
        return queryBuilder.minimumShouldMatch(1).should((QueryBuilder)QueryBuilders.termQuery((String)SG_TENANT_FIELD, (String)tenantStorageId));
    }

    public static Optional<String> scopedIdForPrivateTenantIndexName(String id, String indexName, String indexNamePrefix) {
        String indexNameWithoutPrefix = indexName.substring(indexNamePrefix.length());
        Matcher matcher = INDEX_NAME_TENANT_PART.matcher(indexNameWithoutPrefix);
        if (matcher.matches()) {
            String tenantNameExtractedFromIndexName = matcher.group(TENANT_NAME_GROUP);
            return Optional.of(RequestResponseTenantData.scopedId(id, tenantNameExtractedFromIndexName));
        }
        return Optional.empty();
    }
}

