/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.Objects;
import org.elasticsearch.index.reindex.BulkByScrollResponse;

class DeleteGlobalIndexContentStep
implements MigrationStep {
    private final StepRepository stepRepository;

    public DeleteGlobalIndexContentStep(StepRepository stepRepository) {
        this.stepRepository = Objects.requireNonNull(stepRepository, "Step repository is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        String globalTenantIndexName = context.getGlobalTenantIndexName();
        this.stepRepository.releaseWriteLock((ImmutableList<String>)ImmutableList.of((Object)globalTenantIndexName));
        BulkByScrollResponse response = this.stepRepository.deleteAllDocuments(globalTenantIndexName);
        StringBuilder details = new StringBuilder("Deleted total ").append(response.getTotal()).append(" documents, ").append("it took ").append(response.getTook()).append(", ").append("created documents ").append(response.getCreated()).append(", ").append("updated documents ").append(response.getUpdated()).append(", ").append("deleted documents ").append(response.getDeleted()).append(", ").append("version conflicts ").append(response.getVersionConflicts()).append(", ").append(" used ").append(response.getBatches()).append(" batches, ").append("batch retries ").append(response.getBulkRetries()).append(", ").append("search retries ").append(response.getSearchRetries()).append(".");
        long numberOfDocuments = this.stepRepository.countDocuments(globalTenantIndexName);
        if (numberOfDocuments != 0L) {
            String message = "Cannot remove all documents from index '" + globalTenantIndexName + "'";
            String errorDetails = "Index '" + globalTenantIndexName + "' contains " + numberOfDocuments + " documents";
            return new StepResult(StepExecutionStatus.NOT_EMPTY_INDEX, message, errorDetails);
        }
        return new StepResult(StepExecutionStatus.OK, "Content of index '" + globalTenantIndexName + "' deleted", details.toString());
    }

    @Override
    public String name() {
        return "Delete global index content";
    }
}

