/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.searchguard.authz.PrivilegesEvaluationContext;
import com.floragunn.searchguard.authz.PrivilegesEvaluationException;
import com.floragunn.searchguard.authz.PrivilegesEvaluationResult;
import com.floragunn.searchguard.authz.SyncAuthorizationFilter;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Action;
import com.floragunn.searchguard.authz.actions.ActionRequestIntrospector;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.actions.ResolvedIndices;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfig;
import com.floragunn.searchguard.enterprise.femt.KibanaActionsProvider;
import com.floragunn.searchguard.enterprise.femt.MultiTenancyAuthorizationFilter;
import com.floragunn.searchguard.enterprise.femt.RoleBasedTenantAuthorization;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandlerFactory;
import com.floragunn.searchguard.user.User;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.TransportDeleteIndexAction;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.TransportGetAction;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.common.logging.LogConfigurator;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class MultiTenancyAuthorizationFilterTest {
    private static final Logger log = LogManager.getLogger(MultiTenancyAuthorizationFilterTest.class);
    public static final String PRIVATE_TENANT_HEADER_VALUE = "__user__";
    public static final String INTERNAL_TEST_USER_1_PRIVATE_TENANT_NAME = "-66146748_testusername1";
    public static final String HR_TENANT_NAME = "hr_tenant_name";
    public static final String IT_TENANT_NAME = "it_tenant_name";
    public static final String FRONTEND_MAIN_INDEX = ".kibana_8.9.0_001";
    public static final String TEST_USER_NAME_1 = "test_user_name_1";
    public static final String TEST_USER_NAME_2 = "test_user_name_2";
    public static final String INTERNAL_HR_TENANT_NAME = "1140937035_hrtenantname";
    public static final String INTERNAL_IT_TENANT_NAME = "48572396_ittenantname";
    @Mock
    private FeMultiTenancyConfig config;
    @Mock
    private RoleBasedTenantAuthorization tenantAuthorization;
    @Mock
    private TenantManager tenantManager;
    @Mock
    private ThreadContext threadContext;
    @Mock
    private RequestHandlerFactory handlerFactory;
    @Mock
    private ActionListener<?> listener;
    @Mock
    private PrivilegesEvaluationContext context;
    @Mock
    private ActionRequestIntrospector.ActionRequestInfo actionRequestInfo;
    @Mock
    private User user;
    @Mock
    private ResolvedIndices resolvedIndices;
    @Mock
    private Action action;
    @Mock
    private RequestHandler<ActionRequest> actionHandler;
    private MultiTenancyAuthorizationFilter filter;

    @Before
    public void before() {
        LogConfigurator.configureESLogging();
        Mockito.when((Object)this.config.getIndex()).thenReturn((Object)".kibana");
        Mockito.when((Object)this.config.isEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.context.getUser()).thenReturn((Object)this.user);
        Mockito.when((Object)this.config.getServerUsername()).thenReturn((Object)"frontend_server_user");
        Mockito.when((Object)this.config.isPrivateTenantEnabled()).thenReturn((Object)false);
        this.filter = new MultiTenancyAuthorizationFilter(this.config, this.tenantAuthorization, this.tenantManager, new Actions(null), this.threadContext, null, this.handlerFactory);
    }

    @Test
    public void shouldAccessPrivateTenant_privateTenantEnabled() {
        Mockito.when((Object)this.config.isPrivateTenantEnabled()).thenReturn((Object)true);
        MultiTenancyAuthorizationFilter filter = new MultiTenancyAuthorizationFilter(this.config, this.tenantAuthorization, this.tenantManager, new Actions(null), this.threadContext, null, this.handlerFactory);
        Mockito.when((Object)this.context.getRequestInfo()).thenReturn((Object)this.actionRequestInfo);
        Mockito.when((Object)this.actionRequestInfo.getResolvedIndices()).thenReturn((Object)this.resolvedIndices);
        Mockito.when((Object)this.resolvedIndices.isLocalAll()).thenReturn((Object)false);
        GetRequest request = new GetRequest(FRONTEND_MAIN_INDEX, "space:default");
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.context.getAction()).thenReturn((Object)this.action);
        Mockito.when((Object)this.action.name()).thenReturn((Object)"indices:data/read/search");
        Mockito.when((Object)this.user.getName()).thenReturn((Object)TEST_USER_NAME_1);
        Mockito.when((Object)this.user.getRequestedTenant()).thenReturn((Object)PRIVATE_TENANT_HEADER_VALUE);
        Mockito.when((Object)this.tenantManager.isTenantHeaderValid(PRIVATE_TENANT_HEADER_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantManager.isUserTenantHeader(ArgumentMatchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.tenantManager.toInternalTenantName(this.context.getUser())).thenCallRealMethod();
        Mockito.when((Object)this.handlerFactory.requestHandlerFor((Object)request)).thenReturn(Optional.of(this.actionHandler));
        Mockito.when((Object)this.actionHandler.handle((PrivilegesEvaluationContext)ArgumentMatchers.same((Object)this.context), (String)ArgumentMatchers.eq((Object)INTERNAL_TEST_USER_1_PRIVATE_TENANT_NAME), (ActionRequest)ArgumentMatchers.same((Object)request), (ActionListener)ArgumentMatchers.same(this.listener))).thenReturn((Object)SyncAuthorizationFilter.Result.OK);
        SyncAuthorizationFilter.Result result = filter.apply(this.context, this.listener);
        log.info("Filter response {}", (Object)result);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)SyncAuthorizationFilter.Result.Status.OK));
        ((RequestHandler)Mockito.verify(this.actionHandler)).handle((PrivilegesEvaluationContext)ArgumentMatchers.same((Object)this.context), (String)ArgumentMatchers.eq((Object)INTERNAL_TEST_USER_1_PRIVATE_TENANT_NAME), (ActionRequest)ArgumentMatchers.same((Object)request), (ActionListener)ArgumentMatchers.same(this.listener));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void shouldNotAccessPrivateTenant() {
        Mockito.when((Object)this.context.getRequestInfo()).thenReturn((Object)this.actionRequestInfo);
        Mockito.when((Object)this.actionRequestInfo.getResolvedIndices()).thenReturn((Object)this.resolvedIndices);
        Mockito.when((Object)this.resolvedIndices.isLocalAll()).thenReturn((Object)false);
        GetRequest request = new GetRequest(FRONTEND_MAIN_INDEX, "space:default");
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.context.getAction()).thenReturn((Object)this.action);
        Mockito.when((Object)this.action.name()).thenReturn((Object)"indices:data/read/search");
        Mockito.when((Object)this.user.getName()).thenReturn((Object)TEST_USER_NAME_1);
        Mockito.when((Object)this.user.getRequestedTenant()).thenReturn((Object)PRIVATE_TENANT_HEADER_VALUE);
        Mockito.when((Object)this.tenantManager.isTenantHeaderValid(PRIVATE_TENANT_HEADER_VALUE)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantManager.isUserTenantHeader(ArgumentMatchers.anyString())).thenCallRealMethod();
        SyncAuthorizationFilter.Result result = this.filter.apply(this.context, this.listener);
        log.info("Filter response {}", (Object)result);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)SyncAuthorizationFilter.Result.Status.DENIED));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handlerFactory});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.tenantAuthorization});
    }

    @Test
    public void shouldBePermittedToPerformWriteOperationOnHrTenant() throws PrivilegesEvaluationException {
        Mockito.when((Object)this.context.getRequestInfo()).thenReturn((Object)this.actionRequestInfo);
        Mockito.when((Object)this.actionRequestInfo.getResolvedIndices()).thenReturn((Object)this.resolvedIndices);
        Mockito.when((Object)this.resolvedIndices.isLocalAll()).thenReturn((Object)false);
        IndexRequest request = (IndexRequest)new IndexRequest().index(FRONTEND_MAIN_INDEX);
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.context.getAction()).thenReturn((Object)this.action);
        Mockito.when((Object)this.action.name()).thenReturn((Object)"indices:data/write/index");
        Mockito.when((Object)this.user.getName()).thenReturn((Object)TEST_USER_NAME_2);
        Mockito.when((Object)this.user.getRequestedTenant()).thenReturn((Object)HR_TENANT_NAME);
        Mockito.when((Object)this.tenantManager.isTenantHeaderValid(HR_TENANT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantManager.isUserTenantHeader(ArgumentMatchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.tenantManager.toInternalTenantName(this.context.getUser())).thenCallRealMethod();
        Mockito.when((Object)this.handlerFactory.requestHandlerFor((Object)request)).thenReturn(Optional.of(this.actionHandler));
        Mockito.when((Object)this.actionHandler.handle((PrivilegesEvaluationContext)ArgumentMatchers.same((Object)this.context), (String)ArgumentMatchers.eq((Object)INTERNAL_HR_TENANT_NAME), (ActionRequest)ArgumentMatchers.same((Object)request), (ActionListener)ArgumentMatchers.same(this.listener))).thenReturn((Object)SyncAuthorizationFilter.Result.OK);
        Actions actions = new Actions(null);
        Action readAction = KibanaActionsProvider.getKibanaReadAction((Actions)actions);
        Action writeAction = KibanaActionsProvider.getKibanaWriteAction((Actions)actions);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, readAction, HR_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.OK);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, writeAction, HR_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.OK);
        SyncAuthorizationFilter.Result result = this.filter.apply(this.context, this.listener);
        log.info("Filter response {}", (Object)result);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)SyncAuthorizationFilter.Result.Status.OK));
        ((RequestHandler)Mockito.verify(this.actionHandler)).handle((PrivilegesEvaluationContext)ArgumentMatchers.same((Object)this.context), (String)ArgumentMatchers.eq((Object)INTERNAL_HR_TENANT_NAME), (ActionRequest)ArgumentMatchers.same((Object)request), (ActionListener)ArgumentMatchers.same(this.listener));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, readAction, HR_TENANT_NAME);
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, writeAction, HR_TENANT_NAME);
    }

    @Test
    public void shouldNotBePermittedToPerformWriteOperationOnHrTenant() throws PrivilegesEvaluationException {
        Mockito.when((Object)this.context.getRequestInfo()).thenReturn((Object)this.actionRequestInfo);
        Mockito.when((Object)this.actionRequestInfo.getResolvedIndices()).thenReturn((Object)this.resolvedIndices);
        Mockito.when((Object)this.resolvedIndices.isLocalAll()).thenReturn((Object)false);
        IndexRequest request = (IndexRequest)new IndexRequest().index(FRONTEND_MAIN_INDEX);
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.context.getAction()).thenReturn((Object)this.action);
        Mockito.when((Object)this.action.name()).thenReturn((Object)"indices:data/write/index");
        Mockito.when((Object)this.user.getName()).thenReturn((Object)TEST_USER_NAME_2);
        Mockito.when((Object)this.user.getRequestedTenant()).thenReturn((Object)HR_TENANT_NAME);
        Mockito.when((Object)this.tenantManager.isTenantHeaderValid(HR_TENANT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantManager.isUserTenantHeader(ArgumentMatchers.anyString())).thenCallRealMethod();
        Actions actions = new Actions(null);
        Action readAction = KibanaActionsProvider.getKibanaReadAction((Actions)actions);
        Action writeAction = KibanaActionsProvider.getKibanaWriteAction((Actions)actions);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, readAction, HR_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.OK);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, writeAction, HR_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.INSUFFICIENT);
        SyncAuthorizationFilter.Result result = this.filter.apply(this.context, this.listener);
        log.info("Filter response {}", (Object)result);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)SyncAuthorizationFilter.Result.Status.DENIED));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handlerFactory});
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, readAction, HR_TENANT_NAME);
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, writeAction, HR_TENANT_NAME);
    }

    @Test
    public void shouldBePermittedToPerformReadOnlyOperationOnItTenant() throws PrivilegesEvaluationException {
        Mockito.when((Object)this.context.getRequestInfo()).thenReturn((Object)this.actionRequestInfo);
        Mockito.when((Object)this.actionRequestInfo.getResolvedIndices()).thenReturn((Object)this.resolvedIndices);
        Mockito.when((Object)this.resolvedIndices.isLocalAll()).thenReturn((Object)false);
        GetRequest request = new GetRequest(FRONTEND_MAIN_INDEX, "document_id");
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.context.getAction()).thenReturn((Object)this.action);
        Mockito.when((Object)this.action.name()).thenReturn((Object)TransportGetAction.TYPE.name());
        Mockito.when((Object)this.user.getName()).thenReturn((Object)TEST_USER_NAME_2);
        Mockito.when((Object)this.user.getRequestedTenant()).thenReturn((Object)IT_TENANT_NAME);
        Mockito.when((Object)this.tenantManager.isTenantHeaderValid(IT_TENANT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantManager.isUserTenantHeader(ArgumentMatchers.anyString())).thenCallRealMethod();
        Mockito.when((Object)this.tenantManager.toInternalTenantName(this.context.getUser())).thenCallRealMethod();
        Mockito.when((Object)this.handlerFactory.requestHandlerFor((Object)request)).thenReturn(Optional.of(this.actionHandler));
        Mockito.when((Object)this.actionHandler.handle((PrivilegesEvaluationContext)ArgumentMatchers.same((Object)this.context), (String)ArgumentMatchers.eq((Object)INTERNAL_IT_TENANT_NAME), (ActionRequest)ArgumentMatchers.same((Object)request), (ActionListener)ArgumentMatchers.same(this.listener))).thenReturn((Object)SyncAuthorizationFilter.Result.OK);
        Actions actions = new Actions(null);
        Action readAction = KibanaActionsProvider.getKibanaReadAction((Actions)actions);
        Action writeAction = KibanaActionsProvider.getKibanaWriteAction((Actions)actions);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, readAction, IT_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.OK);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, writeAction, IT_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.INSUFFICIENT);
        SyncAuthorizationFilter.Result result = this.filter.apply(this.context, this.listener);
        log.info("Filter response {}", (Object)result);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)SyncAuthorizationFilter.Result.Status.OK));
        ((RequestHandler)Mockito.verify(this.actionHandler)).handle((PrivilegesEvaluationContext)ArgumentMatchers.same((Object)this.context), (String)ArgumentMatchers.eq((Object)INTERNAL_IT_TENANT_NAME), (ActionRequest)ArgumentMatchers.same((Object)request), (ActionListener)ArgumentMatchers.same(this.listener));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, readAction, IT_TENANT_NAME);
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, writeAction, IT_TENANT_NAME);
    }

    @Test
    public void shouldNotBePermittedToPerformDeleteIndexOperationOnItTenantForReadOnlyUser() throws PrivilegesEvaluationException {
        Mockito.when((Object)this.context.getRequestInfo()).thenReturn((Object)this.actionRequestInfo);
        Mockito.when((Object)this.actionRequestInfo.getResolvedIndices()).thenReturn((Object)this.resolvedIndices);
        Mockito.when((Object)this.resolvedIndices.isLocalAll()).thenReturn((Object)false);
        DeleteIndexRequest request = new DeleteIndexRequest(FRONTEND_MAIN_INDEX);
        Mockito.when((Object)this.context.getRequest()).thenReturn((Object)request);
        Mockito.when((Object)this.context.getAction()).thenReturn((Object)this.action);
        Mockito.when((Object)this.action.name()).thenReturn((Object)TransportDeleteIndexAction.TYPE.name());
        Mockito.when((Object)this.user.getName()).thenReturn((Object)TEST_USER_NAME_2);
        Mockito.when((Object)this.user.getRequestedTenant()).thenReturn((Object)IT_TENANT_NAME);
        Mockito.when((Object)this.tenantManager.isTenantHeaderValid(IT_TENANT_NAME)).thenReturn((Object)true);
        Mockito.when((Object)this.tenantManager.isUserTenantHeader(ArgumentMatchers.anyString())).thenCallRealMethod();
        Actions actions = new Actions(null);
        Action readAction = KibanaActionsProvider.getKibanaReadAction((Actions)actions);
        Action writeAction = KibanaActionsProvider.getKibanaWriteAction((Actions)actions);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, readAction, IT_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.OK);
        Mockito.when((Object)this.tenantAuthorization.hasTenantPermission(this.context, writeAction, IT_TENANT_NAME)).thenReturn((Object)PrivilegesEvaluationResult.INSUFFICIENT);
        SyncAuthorizationFilter.Result result = this.filter.apply(this.context, this.listener);
        log.info("Filter response {}", (Object)result);
        MatcherAssert.assertThat((Object)result.getStatus(), (Matcher)Matchers.equalTo((Object)SyncAuthorizationFilter.Result.Status.DENIED));
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
        Mockito.verifyNoInteractions((Object[])new Object[]{this.handlerFactory});
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, readAction, IT_TENANT_NAME);
        ((RoleBasedTenantAuthorization)Mockito.verify((Object)this.tenantAuthorization)).hasTenantPermission(this.context, writeAction, IT_TENANT_NAME);
    }
}

