/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.util.Objects;

class VerifyPreviousBackupStep
implements MigrationStep {
    private final StepRepository repository;
    private final IndexSettingsManager indexSettingsManager;

    public VerifyPreviousBackupStep(StepRepository repository, IndexSettingsManager settingsManager) {
        this.repository = Objects.requireNonNull(repository, "Step repository is required is required");
        this.indexSettingsManager = Objects.requireNonNull(settingsManager, "Index setting manager is required");
    }

    @Override
    public StepResult execute(DataMigrationContext context) throws StepException {
        if (!context.getBackupCreated().booleanValue()) {
            String backupIndexName = context.getNewestExistingBackupIndex().orElseThrow(() -> new StepException("Backup index not found", StepExecutionStatus.BACKUP_NOT_FOUND_ERROR, null));
            this.repository.findIndexByNameOrAlias(backupIndexName).orElseThrow(() -> new StepException("Backup index does not exist", StepExecutionStatus.BACKUP_DOES_NOT_EXIST_ERROR, "Index '" + backupIndexName + "' does not exist"));
            long numberOfDocuments = this.repository.countDocuments(backupIndexName);
            if (numberOfDocuments == 0L) {
                return new StepResult(StepExecutionStatus.BACKUP_IS_EMPTY_ERROR, "Backup index '" + backupIndexName + "' contains '" + numberOfDocuments + "' documents");
            }
            if (this.indexSettingsManager.isMigrationMarkerPresent(backupIndexName)) {
                String details = "Index name '" + backupIndexName + "'";
                return new StepResult(StepExecutionStatus.BACKUP_CONTAINS_MIGRATED_DATA_ERROR, "Backup index contain migrated data", details);
            }
            String details = "Index '" + backupIndexName + "' contains '" + numberOfDocuments + "' documents";
            return new StepResult(StepExecutionStatus.OK, "Backup index exists", details);
        }
        return new StepResult(StepExecutionStatus.OK, "A backup was created in the course of the current migration process");
    }

    @Override
    public String name() {
        return "Verify previous backup";
    }
}

