/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authc.AuthInfoService;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.tenants.AvailableTenantData;
import com.floragunn.searchguard.enterprise.femt.tenants.DefaultTenantNotFoundException;
import com.floragunn.searchguard.enterprise.femt.tenants.DefaultTenantSelector;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantAccessData;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantRepository;
import com.floragunn.searchguard.user.User;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;

public class AvailableTenantService {
    private final MultiTenancyConfigurationProvider configProvider;
    private final AuthorizationService authorizationService;
    private final ThreadPool threadPool;
    private final TenantRepository tenantRepository;
    private final DefaultTenantSelector defaultTenantSelector;
    private final AuthInfoService authInfoService;

    public AvailableTenantService(MultiTenancyConfigurationProvider configProvider, AuthorizationService authorizationService, ThreadPool threadPool, TenantRepository tenantRepository, AuthInfoService authInfoService) {
        this.configProvider = Objects.requireNonNull(configProvider, "Multi tenancy config provider is required");
        this.authorizationService = Objects.requireNonNull(authorizationService, "Authorization service is required");
        this.threadPool = Objects.requireNonNull(threadPool, "Thread pool is required");
        this.tenantRepository = Objects.requireNonNull(tenantRepository, "Tenant repository is required");
        this.defaultTenantSelector = new DefaultTenantSelector();
        this.authInfoService = Objects.requireNonNull(authInfoService, "Auth info service is required");
    }

    public Optional<AvailableTenantData> findTenantAvailableForCurrentUser() {
        ThreadContext threadContext = this.threadPool.getThreadContext();
        return Optional.ofNullable((User)threadContext.getTransient("_sg_user")).map(user -> {
            if (this.configProvider.isMultiTenancyEnabled()) {
                TransportAddress remoteAddress = (TransportAddress)threadContext.getTransient("_sg_remote_address");
                ImmutableSet internalRoles = this.authorizationService.getMappedRoles(user, remoteAddress);
                boolean adminUser = this.authInfoService.isAdmin(user);
                Map tenantsWriteAccessMap = this.configProvider.getTenantAccessMapper().mapTenantsAccess(user, adminUser, (Set)internalRoles);
                ImmutableSet<String> exists = this.tenantRepository.exists((String[])tenantsWriteAccessMap.keySet().toArray(String[]::new));
                HashMap<String, TenantAccessData> tenantsAccess = new HashMap<String, TenantAccessData>(tenantsWriteAccessMap.size());
                tenantsWriteAccessMap.entrySet().stream().filter(tenantWriteAccess -> (Boolean)tenantWriteAccess.getValue() != false || exists.contains(tenantWriteAccess.getKey())).forEach(tenantAccess -> {
                    TenantAccessData tenantAccessData = new TenantAccessData(true, (Boolean)tenantAccess.getValue(), exists.contains(tenantAccess.getKey()));
                    tenantsAccess.put((String)tenantAccess.getKey(), tenantAccessData);
                });
                Optional<String> tenantSelectedByDefault = this.defaultTenantSelector.findDefaultTenantForUser((User)user, (Map<String, TenantAccessData>)tenantsAccess, this.configProvider.getPreferredTenants());
                String defaultTenant = tenantSelectedByDefault.orElseThrow(() -> new DefaultTenantNotFoundException(user.getName()));
                return new AvailableTenantData(true, tenantsAccess, user.getName(), user.getRequestedTenant(), defaultTenant);
            }
            return new AvailableTenantData(false, (Map<String, TenantAccessData>)ImmutableMap.empty(), user.getName(), user.getRequestedTenant(), null);
        });
    }
}

