/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStateRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationStepsExecutor;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.ThrowExceptionStep;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class MigrationStepsExecutorTest {
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(2000, 1, 1, 1, 1), ZoneOffset.UTC);
    public static final String MESSAGE_1 = "I am done!";
    public static final String MESSAGE_2 = "The second step was executed";
    public static final String MESSAGE_3 = "The third step was executed";
    public static final String NAME_1 = "I am the first step";
    public static final String NAME_2 = "I am the second step";
    public static final String NAME_3 = "I am the third step";
    public static final String MESSAGE_FAILURE_1 = "Step execution failed!";
    public static final String MESSAGE_FAILURE_2 = "Oops, Sth went wrong during migration step execution!";
    public static final MigrationConfig STRICT_CONFIG = new MigrationConfig(false);
    public static final String ROLLBACK_MESSAGE_1 = "nothing to rollback - 1";
    @Captor
    private ArgumentCaptor<MigrationExecutionSummary> summaryCaptor;
    @Mock
    private MigrationStateRepository repository;
    private Clock clock;

    @Before
    public void before() {
        this.clock = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    }

    @Test(expected=IllegalStateException.class)
    public void shouldNotExecuteMigrationWithoutSteps() {
        new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.empty());
    }

    @Test(expected=IllegalStateException.class)
    public void shouldDetectNullMigrationStepAndReportException() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)stepOne, (Object)stepTwo, null, (Object[])new MigrationStep[0]));
    }

    @Test
    public void shouldExecuteAndPersistMigrationStep() {
        MigrationStep step = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)step));
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)summary.isSuccessful(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)summary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)summary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)summary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        ImmutableList stages = summary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        StepExecutionSummary stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary migrationSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)migrationSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)migrationSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)migrationSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)migrationSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = migrationSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
    }

    @Test
    public void shouldExecuteAndPersistMigrationMultipleStep() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)stepOne, (Object)stepTwo));
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)summary.isSuccessful(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)summary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)summary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)summary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        ImmutableList stages = summary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)2));
        StepExecutionSummary stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)2))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        List persistedSummaries = this.summaryCaptor.getAllValues();
        MatcherAssert.assertThat((Object)persistedSummaries, (Matcher)Matchers.hasSize((int)2));
        MigrationExecutionSummary stepSummary = (MigrationExecutionSummary)persistedSummaries.get(0);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepSummary = (MigrationExecutionSummary)persistedSummaries.get(1);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)2));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
    }

    @Test
    public void shouldBreakMigrationProcessInCaseOfExpectedFailure() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.INDICES_NOT_FOUND_ERROR, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)stepOne, (Object)stepTwo));
        MigrationExecutionSummary restSummary = executor.execute();
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        MatcherAssert.assertThat((Object)restSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)restSummary.isSuccessful(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)restSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)restSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)restSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        ImmutableList stages = restSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        StepExecutionSummary stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary migrationSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)migrationSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)migrationSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)migrationSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)migrationSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = migrationSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
    }

    @Test
    public void shouldBreakMigrationProcessInCaseOfUnexpectedFailure() {
        MigrationStep stepOne = this.stepMock(NAME_1);
        Mockito.when((Object)stepOne.execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenThrow(new Throwable[]{new RuntimeException(MESSAGE_FAILURE_1)});
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)stepOne, (Object)stepTwo));
        MigrationExecutionSummary restSummary = executor.execute();
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        MatcherAssert.assertThat((Object)restSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)restSummary.isSuccessful(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)restSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)restSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)restSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        ImmutableList stages = restSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        StepExecutionSummary stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)"Unexpected error: Step execution failed!"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary stepSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)"Unexpected error: Step execution failed!"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
    }

    @Test
    public void shouldMarkMigrationAsFailedInCaseOfExpectedErrorInTheLastStep() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.INDICES_NOT_FOUND_ERROR, MESSAGE_2);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)stepOne, (Object)stepTwo));
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.isSuccessful(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)summary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)summary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)summary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        ImmutableList stages = summary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)3));
        StepExecutionSummary stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        stepExecutionSummary = (StepExecutionSummary)stages.get(2);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)ROLLBACK_MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)3))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        List persistedSummaries = this.summaryCaptor.getAllValues();
        MatcherAssert.assertThat((Object)persistedSummaries, (Matcher)Matchers.hasSize((int)3));
        MigrationExecutionSummary stepSummary = (MigrationExecutionSummary)persistedSummaries.get(0);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepSummary = (MigrationExecutionSummary)persistedSummaries.get(1);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)2));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
        stepSummary = (MigrationExecutionSummary)persistedSummaries.get(2);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)3));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
        stepExecutionSummary = (StepExecutionSummary)stages.get(2);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)ROLLBACK_MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        ((MigrationStep)Mockito.verify((Object)stepOne)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
    }

    @Test
    public void shouldMarkMigrationAsFailedInCaseOfUnexpectedErrorInTheLastStep() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMock(NAME_2);
        Mockito.when((Object)stepTwo.execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenThrow(new Throwable[]{new RuntimeException(MESSAGE_FAILURE_1)});
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)stepOne, (Object)stepTwo));
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.isSuccessful(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)summary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)summary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)summary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        ImmutableList stages = summary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)3));
        StepExecutionSummary stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)"Unexpected error: Step execution failed!"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        stepExecutionSummary = (StepExecutionSummary)stages.get(2);
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)ROLLBACK_MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)3))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        List persistedSummaries = this.summaryCaptor.getAllValues();
        MatcherAssert.assertThat((Object)persistedSummaries, (Matcher)Matchers.hasSize((int)3));
        MigrationExecutionSummary stepSummary = (MigrationExecutionSummary)persistedSummaries.get(0);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)1));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepSummary = (MigrationExecutionSummary)persistedSummaries.get(1);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)2));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)"Unexpected error: Step execution failed!"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        stepSummary = (MigrationExecutionSummary)persistedSummaries.get(2);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)stepSummary.startTime(), (Matcher)Matchers.equalTo((Object)NOW.toLocalDateTime()));
        MatcherAssert.assertThat((Object)stepSummary.backupIndexName(), (Matcher)Matchers.equalTo((Object)"backup_fe_migration_to_8_8_0_2000_01_01_01_01_00"));
        MatcherAssert.assertThat((Object)stepSummary.tempIndexName(), (Matcher)Matchers.equalTo((Object)"data_migration_temp_fe_2000_01_01_01_01_00"));
        stages = stepSummary.stages();
        MatcherAssert.assertThat((Object)stages, (Matcher)Matchers.hasSize((int)3));
        stepExecutionSummary = (StepExecutionSummary)stages.get(0);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        stepExecutionSummary = (StepExecutionSummary)stages.get(1);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)"Unexpected error: Step execution failed!"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)1L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)NAME_2));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        stepExecutionSummary = (StepExecutionSummary)stages.get(2);
        MatcherAssert.assertThat((Object)stepExecutionSummary.message(), (Matcher)Matchers.equalTo((Object)ROLLBACK_MESSAGE_1));
        MatcherAssert.assertThat((Object)stepExecutionSummary.number(), (Matcher)Matchers.equalTo((Object)0L));
        MatcherAssert.assertThat((Object)stepExecutionSummary.name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        MatcherAssert.assertThat((Object)stepExecutionSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
    }

    @Test
    public void shouldExecuteManySteps() {
        List<MigrationStep> stepMocks = IntStream.range(0, 50).mapToObj(index -> this.stepMockWithResult("step_" + index, StepExecutionStatus.OK, "Step no. " + index)).collect(Collectors.toList());
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of(stepMocks));
        MigrationExecutionSummary migrationSummary = executor.execute();
        MatcherAssert.assertThat((Object)migrationSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        MatcherAssert.assertThat((Object)migrationSummary.stages(), (Matcher)Matchers.hasSize((int)stepMocks.size()));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)stepMocks.size()))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        stepMocks.forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
    }

    @Test
    public void shouldStopExecutionOfLargeAmountOfStepsAfterFirstExpectedFailure() {
        List stepMocks = IntStream.range(0, 49).mapToObj(index -> this.stepMockWithResult("step_" + index, StepExecutionStatus.OK, "Step no. " + index)).collect(Collectors.toList());
        int failureStepIndex = 40;
        stepMocks.add(40, this.stepMockWithResult("Failure step", StepExecutionStatus.INDICES_NOT_FOUND_ERROR, MESSAGE_FAILURE_2));
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of(stepMocks));
        MigrationExecutionSummary migrationSummary = executor.execute();
        MatcherAssert.assertThat((Object)migrationSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)migrationSummary.stages(), (Matcher)Matchers.hasSize((int)81));
        StepExecutionSummary failureStepSummary = (StepExecutionSummary)migrationSummary.stages().get(40);
        MatcherAssert.assertThat((Object)failureStepSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
        MatcherAssert.assertThat((Object)failureStepSummary.message(), (Matcher)Matchers.equalTo((Object)MESSAGE_FAILURE_2));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)81))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        stepMocks.stream().limit(41L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
        stepMocks.stream().limit(40L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
        stepMocks.stream().skip(41L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
    }

    @Test
    public void shouldStopExecutionOfLargeAmountOfStepsAfterFirstUnexpectedFailure() {
        List stepMocks = IntStream.range(0, 49).mapToObj(index -> this.stepMockWithResult("step_" + index, StepExecutionStatus.OK, "Step no. " + index)).collect(Collectors.toList());
        int failureStepIndex = 10;
        MigrationStep failureStep = this.stepMock("Failure step name");
        Mockito.when((Object)failureStep.execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenThrow(new Throwable[]{new IllegalStateException(MESSAGE_FAILURE_1)});
        stepMocks.add(10, failureStep);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of(stepMocks));
        MigrationExecutionSummary migrationSummary = executor.execute();
        MatcherAssert.assertThat((Object)migrationSummary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)migrationSummary.stages(), (Matcher)Matchers.hasSize((int)21));
        StepExecutionSummary failureStepSummary = (StepExecutionSummary)migrationSummary.stages().get(10);
        MatcherAssert.assertThat((Object)failureStepSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        MatcherAssert.assertThat((Object)failureStepSummary.message(), (Matcher)Matchers.containsString((String)MESSAGE_FAILURE_1));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)21))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
        stepMocks.stream().limit(11L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
        stepMocks.stream().limit(10L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
        stepMocks.stream().skip(11L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
        stepMocks.stream().skip(11L).forEach(stepMock -> ((MigrationStep)Mockito.verify((Object)stepMock, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class)));
    }

    @Test
    public void shouldReturnAnotherMigrationStartTime() {
        ZonedDateTime now = ZonedDateTime.of(LocalDateTime.of(2023, 5, 25, 12, 1), ZoneOffset.UTC);
        this.clock = Clock.fixed(now.toInstant(), ZoneOffset.UTC);
        MigrationStep step = this.stepMockWithResult("The only step to take", StepExecutionStatus.OK, "I am done");
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)step));
        MigrationExecutionSummary migrationSummary = executor.execute();
        MatcherAssert.assertThat((Object)migrationSummary.startTime(), (Matcher)Matchers.equalTo((Object)now.toLocalDateTime()));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)migrationSummary.stages().get(0)).startTime(), (Matcher)Matchers.equalTo((Object)now.toLocalDateTime()));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary persistedSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)persistedSummary.startTime(), (Matcher)Matchers.equalTo((Object)now.toLocalDateTime()));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)persistedSummary.stages().get(0)).startTime(), (Matcher)Matchers.equalTo((Object)now.toLocalDateTime()));
    }

    @Test
    public void shouldHandleStepExecutionException() {
        String message = "Sth went wrong so exception is needed";
        String details = "Descriptive message";
        ThrowExceptionStep step = new ThrowExceptionStep(message, StepExecutionStatus.INDICES_NOT_FOUND_ERROR, details);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)step));
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.stages(), (Matcher)Matchers.hasSize((int)1));
        StepExecutionSummary stepSummary = (StepExecutionSummary)summary.stages().get(0);
        MatcherAssert.assertThat((Object)stepSummary.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INDICES_NOT_FOUND_ERROR));
        MatcherAssert.assertThat((Object)stepSummary.message(), (Matcher)Matchers.equalTo((Object)message));
        MatcherAssert.assertThat((Object)stepSummary.details(), (Matcher)Matchers.equalTo((Object)details));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        MigrationExecutionSummary storedSummary = (MigrationExecutionSummary)this.summaryCaptor.getValue();
        MatcherAssert.assertThat((Object)storedSummary, (Matcher)Matchers.equalTo((Object)summary));
    }

    @Test
    public void shouldNotInvokeRollbackInCaseOfSuccessStepExecution() {
        MigrationStep step = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, ImmutableList.of((Object)step));
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        ((MigrationStep)Mockito.verify((Object)step)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)step, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
    }

    @Test
    public void shouldNotInvokeRollbackInCaseOfSuccessStepsExecution() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        MigrationStep stepThree = this.stepMockWithResult(NAME_3, StepExecutionStatus.OK, MESSAGE_3);
        ImmutableList steps = ImmutableList.of((Object)stepOne, (Object)stepTwo, (Object)stepThree, (Object[])new MigrationStep[0]);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, steps);
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.SUCCESS));
        ((MigrationStep)Mockito.verify((Object)stepOne, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)3))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
    }

    @Test
    public void shouldNotInvokeRollbackInCaseOfFirstStepExecutionFailure() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.CANNOT_UPDATE_STATUS_DOCUMENT_LOCK_ERROR, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        MigrationStep stepThree = this.stepMockWithResult(NAME_3, StepExecutionStatus.OK, MESSAGE_3);
        ImmutableList steps = ImmutableList.of((Object)stepOne, (Object)stepTwo, (Object)stepThree, (Object[])new MigrationStep[0]);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, steps);
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.stages(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(0)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.CANNOT_UPDATE_STATUS_DOCUMENT_LOCK_ERROR));
        ((MigrationStep)Mockito.verify((Object)stepOne, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree, (VerificationMode)Mockito.never())).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)1))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
    }

    @Test
    public void shouldInvokeMultipleRollbacksInCaseOfExecutionFailure() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        MigrationStep stepThree = this.stepMockWithResult(NAME_3, StepExecutionStatus.CANNOT_RESOLVE_INDEX_BY_ALIAS_ERROR, MESSAGE_3);
        ImmutableList steps = ImmutableList.of((Object)stepOne, (Object)stepTwo, (Object)stepThree, (Object[])new MigrationStep[0]);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, steps);
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.stages(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(0)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(1)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(2)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.CANNOT_RESOLVE_INDEX_BY_ALIAS_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(3)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(3)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the second step"));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(4)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(4)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        ((MigrationStep)Mockito.verify((Object)stepOne)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)5))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)ArgumentMatchers.any(MigrationExecutionSummary.class));
    }

    @Test
    public void shouldNotInterruptRollbacksInCaseOfErrors() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2, StepExecutionStatus.CANNOT_CREATE_STATUS_DOCUMENT_ERROR, ROLLBACK_MESSAGE_1);
        MigrationStep stepThree = this.stepMockWithResult(NAME_3, StepExecutionStatus.DATA_INDICES_LOCKED_ERROR, MESSAGE_3);
        ImmutableList steps = ImmutableList.of((Object)stepOne, (Object)stepTwo, (Object)stepThree, (Object[])new MigrationStep[0]);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, steps);
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.stages(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(0)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(1)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(2)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(3)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.CANNOT_CREATE_STATUS_DOCUMENT_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(3)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the second step"));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(4)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(4)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        ((MigrationStep)Mockito.verify((Object)stepOne)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)5))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        List persistedSummaries = this.summaryCaptor.getAllValues();
        MatcherAssert.assertThat((Object)persistedSummaries, (Matcher)Matchers.hasSize((int)5));
        MigrationExecutionSummary summaryAfterFirstStep = (MigrationExecutionSummary)persistedSummaries.get(0);
        MatcherAssert.assertThat((Object)summaryAfterFirstStep.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterFirstStep.stages().get(0)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MigrationExecutionSummary summaryAfterSecondStep = (MigrationExecutionSummary)persistedSummaries.get(1);
        MatcherAssert.assertThat((Object)summaryAfterSecondStep.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterSecondStep.stages().get(1)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MigrationExecutionSummary summaryAfterThirdStep = (MigrationExecutionSummary)persistedSummaries.get(2);
        MatcherAssert.assertThat((Object)summaryAfterThirdStep.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterThirdStep.stages().get(2)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MigrationExecutionSummary summaryAfterFirstFailedRollback = (MigrationExecutionSummary)persistedSummaries.get(3);
        MatcherAssert.assertThat((Object)summaryAfterFirstFailedRollback.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterFirstFailedRollback.stages().get(3)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.CANNOT_CREATE_STATUS_DOCUMENT_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterFirstFailedRollback.stages().get(3)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the second step"));
        MigrationExecutionSummary summaryAfterSecondRollback = (MigrationExecutionSummary)persistedSummaries.get(4);
        MatcherAssert.assertThat((Object)summaryAfterSecondRollback.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterSecondRollback.stages().get(4)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterSecondRollback.stages().get(4)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
    }

    @Test
    public void shouldNotInterruptRollbacksInCaseOfExceptions() {
        MigrationStep stepOne = this.stepMockWithResult(NAME_1, StepExecutionStatus.OK, MESSAGE_1);
        MigrationStep stepTwo = this.stepMockWithResult(NAME_2, StepExecutionStatus.OK, MESSAGE_2);
        Mockito.when((Object)stepTwo.rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenThrow(IllegalStateException.class);
        MigrationStep stepThree = this.stepMockWithResult(NAME_3, StepExecutionStatus.DATA_INDICES_LOCKED_ERROR, MESSAGE_3);
        ImmutableList steps = ImmutableList.of((Object)stepOne, (Object)stepTwo, (Object)stepThree, (Object[])new MigrationStep[0]);
        MigrationStepsExecutor executor = new MigrationStepsExecutor(STRICT_CONFIG, this.repository, this.clock, steps);
        MigrationExecutionSummary summary = executor.execute();
        MatcherAssert.assertThat((Object)summary.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)summary.stages(), (Matcher)Matchers.hasSize((int)5));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(0)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(1)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(2)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(3)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(3)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the second step"));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(4)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summary.stages().get(4)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
        ((MigrationStep)Mockito.verify((Object)stepOne)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepOne)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepTwo)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree, (VerificationMode)Mockito.never())).rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStep)Mockito.verify((Object)stepThree)).execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class));
        ((MigrationStateRepository)Mockito.verify((Object)this.repository, (VerificationMode)Mockito.times((int)5))).upsert((String)ArgumentMatchers.eq((Object)"migration_8_8_0"), (MigrationExecutionSummary)this.summaryCaptor.capture());
        List persistedSummaries = this.summaryCaptor.getAllValues();
        MatcherAssert.assertThat((Object)persistedSummaries, (Matcher)Matchers.hasSize((int)5));
        MigrationExecutionSummary summaryAfterFirstStep = (MigrationExecutionSummary)persistedSummaries.get(0);
        MatcherAssert.assertThat((Object)summaryAfterFirstStep.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterFirstStep.stages().get(0)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MigrationExecutionSummary summaryAfterSecondStep = (MigrationExecutionSummary)persistedSummaries.get(1);
        MatcherAssert.assertThat((Object)summaryAfterSecondStep.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.IN_PROGRESS));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterSecondStep.stages().get(1)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.OK));
        MigrationExecutionSummary summaryAfterThirdStep = (MigrationExecutionSummary)persistedSummaries.get(2);
        MatcherAssert.assertThat((Object)summaryAfterThirdStep.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterThirdStep.stages().get(2)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.DATA_INDICES_LOCKED_ERROR));
        MigrationExecutionSummary summaryAfterFirstFailedRollback = (MigrationExecutionSummary)persistedSummaries.get(3);
        MatcherAssert.assertThat((Object)summaryAfterFirstFailedRollback.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterFirstFailedRollback.stages().get(3)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNEXPECTED_ERROR));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterFirstFailedRollback.stages().get(3)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the second step"));
        MigrationExecutionSummary summaryAfterSecondRollback = (MigrationExecutionSummary)persistedSummaries.get(4);
        MatcherAssert.assertThat((Object)summaryAfterSecondRollback.status(), (Matcher)Matchers.equalTo((Object)ExecutionStatus.FAILURE));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterSecondRollback.stages().get(4)).status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.ROLLBACK));
        MatcherAssert.assertThat((Object)((StepExecutionSummary)summaryAfterSecondRollback.stages().get(4)).name(), (Matcher)Matchers.equalTo((Object)"rollback - I am the first step"));
    }

    private MigrationStep stepMock(String name) {
        MigrationStep step = (MigrationStep)Mockito.mock(MigrationStep.class);
        Mockito.when((Object)step.name()).thenReturn((Object)name);
        return step;
    }

    private MigrationStep stepMockWithResult(String name, StepExecutionStatus status, String message, StepExecutionStatus rollbackStatus, String rollbackMessage) {
        MigrationStep step = this.stepMock(name);
        Mockito.when((Object)step.execute((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenReturn((Object)new StepResult(status, message));
        Mockito.when((Object)step.rollback((DataMigrationContext)ArgumentMatchers.any(DataMigrationContext.class))).thenReturn((Object)new StepResult(rollbackStatus, rollbackMessage));
        return step;
    }

    private MigrationStep stepMockWithResult(String name, StepExecutionStatus status, String message) {
        return this.stepMockWithResult(name, status, message, StepExecutionStatus.ROLLBACK, ROLLBACK_MESSAGE_1);
    }
}

