/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Document;
import com.floragunn.codova.documents.Format;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.RequestResponseTenantData;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.EsClientProvider;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.Constants;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.After;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Test;

public class MultiTenancyRequestMappingTest {
    private static final Logger log = LogManager.getLogger(MultiTenancyRequestMappingTest.class);
    public static final String GLOBAL_TENANT_NAME = "SGS_GLOBAL_TENANT";
    private static final String DOC_ID = "123";
    private static final String KIBANA_INDEX = ".kibana";
    private static final String KIBANA_ALIAS = ".kibana".concat("_1.1.1");
    private static final String KIBANA_SERVER_USER = "kibana_server";
    private static final TestSgConfig.Tenant HR_TENANT = new TestSgConfig.Tenant("hr_tenant");
    private static final TestSgConfig.Tenant IT_TENANT = new TestSgConfig.Tenant("it_tenant");
    private static final TestSgConfig.User USER = new TestSgConfig.User("user").roles(new TestSgConfig.Role[]{new TestSgConfig.Role("tenant_access").withTenantPermission(new String[]{"*"}).on(new String[]{HR_TENANT.getName()}).clusterPermissions(new String[]{"*"}).indexPermissions(new String[]{"*"}).on(new String[]{".kibana*"}).aliasPermissions(new String[]{"*"}).on(new String[]{KIBANA_ALIAS})});
    private static final TestSgConfig.Role LIMITED_ROLE = new TestSgConfig.Role("limited_access_to_global_tenant").withTenantPermission(new String[]{"SGS_KIBANA_ALL_READ"}).on(new String[]{HR_TENANT.getName(), "SGS_GLOBAL_TENANT"}).indexPermissions(new String[]{"indices:data/read/search"}).on(new String[]{".kibana"}).clusterPermissions(new String[]{"SGS_CLUSTER_MONITOR"});
    private static final TestSgConfig.User LIMITED_USER = new TestSgConfig.User("limited_user").roles(new String[]{"SGS_KIBANA_USER_NO_GLOBAL_TENANT", LIMITED_ROLE.getName()});
    private final TenantManager tenantManager = new TenantManager((Set)ImmutableSet.of((Object)HR_TENANT.getName()), MultiTenancyConfigurationProvider.DEFAULT);
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().sslEnabled().nodeSettings(new Object[]{"action.destructive_requires_name", false}).nodeSettings(new Object[]{"searchguard.unsupported.single_index_mt_enabled", true}).enterpriseModulesEnabled().roles(new TestSgConfig.Role[]{LIMITED_ROLE}).users(new TestSgConfig.User[]{USER, LIMITED_USER}).frontendMultiTenancy(new TestSgConfig.FrontendMultiTenancy(true).index(".kibana").serverUser("kibana_server")).tenants(new TestSgConfig.Tenant[]{HR_TENANT, IT_TENANT}).embedded().build();

    @Before
    public void createTestIndex() {
        Client client = cluster.getInternalNodeClient();
        String mapping = "{\n  \"properties\": {\n    \"sg_tenant\": {\n      \"type\": \"keyword\"\n    }\n  }\n}\n";
        AcknowledgedResponse createIndexResponse = (AcknowledgedResponse)client.admin().indices().create(new CreateIndexRequest(KIBANA_INDEX).mapping(mapping).settings(Settings.builder().put("index.number_of_shards", 5))).actionGet();
        MatcherAssert.assertThat((Object)createIndexResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    @After
    public void deleteTestIndex() {
        this.deleteIndex(".kibana*");
    }

    @Test
    public void shouldCleanThreadContext() throws Exception {
        String internalTenantName = this.tenantManager.toInternalTenantName(User.forUser((String)USER.getName()).requestedTenant(IT_TENANT.getName()).build());
        this.addDocumentToIndex(this.createInternalScopedId("space_for_it_1", IT_TENANT.getName()), DocNode.of((String)"name", (Object)"IT tenant space 1", (String)"sg_tenant", (Object)internalTenantName));
        this.addDocumentToIndex(this.createInternalScopedId("space_for_it_2", IT_TENANT.getName()), DocNode.of((String)"name", (Object)"IT tenant space 2", (String)"sg_tenant", (Object)internalTenantName));
        this.addDocumentToIndex(this.createInternalScopedId("space_for_it_3", IT_TENANT.getName()), DocNode.of((String)"name", (Object)"IT tenant space 3", (String)"sg_tenant", (Object)internalTenantName));
        internalTenantName = this.tenantManager.toInternalTenantName(User.forUser((String)USER.getName()).requestedTenant(HR_TENANT.getName()).build());
        this.addDocumentToIndex(this.createInternalScopedId("space_for_human resources_1", HR_TENANT.getName()), DocNode.of((String)"name", (Object)"human resources tenant space 1", (String)"sg_tenant", (Object)internalTenantName));
        this.addDocumentToIndex(this.createInternalScopedId("space_for_human resources_2", HR_TENANT.getName()), DocNode.of((String)"name", (Object)"human resources tenant space 2", (String)"sg_tenant", (Object)internalTenantName));
        DocNode matchSpace = DocNode.of((String)"query", (Object)DocNode.of((String)"match", (Object)DocNode.of((String)"name", (Object)"space")));
        DocNode matchTenant = DocNode.of((String)"query", (Object)DocNode.of((String)"match", (Object)DocNode.of((String)"name", (Object)"tenant")));
        DocNode msearchHeader = DocNode.of((String)"index", (Object)KIBANA_INDEX);
        String query = Stream.of(msearchHeader, matchTenant, msearchHeader, matchSpace).map(DocNode::toJsonString).collect(Collectors.joining("\n")) + "\n";
        log.info("Msearch query : {}", (Object)query);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            BasicHeader sgTenantHeader = new BasicHeader("sg_tenant", HR_TENANT.getName());
            GenericRestClient.HttpResponse response = client.postJson("/_msearch?max_concurrent_searches=1", query, new Header[]{sgTenantHeader});
            log.info("Search without tenant response status '{}' body '{}'", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            DocNode body = response.getBodyAsDocNode();
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.responses[0].hits.total.value", (Object)2));
            MatcherAssert.assertThat((Object)body, (Matcher)DocNodeMatchers.containsValue((String)"$.responses[1].hits.total.value", (Object)2));
        }
    }

    private String createInternalScopedId(String documentId, String tenantId) {
        String internalTenantName = this.tenantManager.toInternalTenantName(User.forUser((String)USER.getName()).requestedTenant(tenantId).build());
        return RequestResponseTenantData.scopedId((String)documentId, (String)internalTenantName);
    }

    @Test
    public void getRequest_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withSourceParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?_source=false", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?_source=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?_source=true", new Header[0]);
            responseWithTenant = client.get("/.kibana/_doc/123?_source=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withSourceIncludesAndSourceExcludesParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?_source_includes=a*&_source_excludes=ab", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?_source_includes=a*&_source_excludes=ab", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?_source=a*", new Header[0]);
            responseWithTenant = client.get("/.kibana/_doc/123?_source=a*", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withStoredFieldsParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode indexMappings = DocNode.parse((Format)Format.JSON).from("{\n  \"properties\": {\n    \"aa\": {\n      \"type\": \"text\",\n      \"store\": true\n    },\n    \"ab\": {\n      \"type\": \"text\",\n      \"store\": true\n    },\n    \"bb\": {\n      \"type\": \"text\"\n    }\n  }\n}\n");
        this.updateIndexMappings(indexMappings);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?stored_fields=aa,ab", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?stored_fields=aa,ab", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?stored_fields=bb", new Header[0]);
            responseWithTenant = client.get("/.kibana/_doc/123?stored_fields=bb", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withRoutingParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        String routing = "test-routing";
        this.addDocumentToIndex(scopedId, routing, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?routing=" + routing, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?routing=" + routing, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            routing = routing.concat("-fake");
            responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?routing=" + routing, new Header[0]);
            responseWithTenant = client.get("/.kibana/_doc/123?routing=" + routing, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withPreferenceParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        String preference = "_local";
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?preference=" + preference, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?preference=" + preference, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withRealtimeParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String realtime = "true";
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?realtime=" + realtime, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?realtime=" + realtime, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            realtime = "false";
            responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?realtime=" + realtime, new Header[0]);
            responseWithTenant = client.get("/.kibana/_doc/123?realtime=" + realtime, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withRefreshParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String refresh = "true";
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?refresh=" + refresh, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?refresh=" + refresh, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            refresh = "false";
            responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?refresh=" + refresh, new Header[0]);
            responseWithTenant = client.get("/.kibana/_doc/123?refresh=" + refresh, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_withVersionParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocWriteResponse indexResponse = this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b"));
        long docVersion = indexResponse.getVersion();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId + "?version=" + docVersion + "&version_type=external_gte", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123?version=" + docVersion + "&version_type=external_gte", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void getRequest_docDoesNotExist() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_doc/" + scopedId, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_doc/123", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, DOC_ID), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void updateRequest_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123"), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withoutParams_usingScript() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)1);
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String script = "{\n  \"script\" : {\n    \"source\": \"ctx._source.a += params.add_to_a\",\n    \"lang\": \"painless\",\n    \"params\" : {\n      \"add_to_a\" : 4\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId), script, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123"), script, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withIfSeqNoAndIfPrimaryTermParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        DocWriteResponse indexResponse = this.addDocumentToIndex(scopedId, doc);
        long seqNo = indexResponse.getSeqNo();
        long primaryTerm = indexResponse.getPrimaryTerm();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId + "?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), (Map)updateReqBody, new Header[0]);
            GetResponse getResponse = this.getDocById(scopedId);
            seqNo = getResponse.getSeqNo();
            primaryTerm = getResponse.getPrimaryTerm();
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withRequireAliasParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        String aliasName = KIBANA_ALIAS;
        this.addAliasToIndex(aliasName);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String requireAlias = "true";
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + aliasName + "/_update/" + scopedId + "?require_alias=" + requireAlias), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + aliasName + "/_update/123?require_alias=" + requireAlias), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withRefreshParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String refresh = "true";
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId + "?refresh=" + refresh), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123?refresh=" + refresh), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            refresh = "false";
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId + "?refresh=" + refresh), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123?refresh=" + refresh), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withRoutingParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        String routing = "test-routing";
        this.addDocumentToIndex(scopedId, routing, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId + "?routing=" + routing), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123?routing=" + routing), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withSourceParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId + "?_source=ab,b*"), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123?_source=ab,b*"), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void updateRequest_withSourceIncludesAndSourceExcludesParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"b", (String)"bb", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            DocNode updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"new value"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/" + scopedId + "?_source_includes=ab&_source_excludes=bb"), (Map)updateReqBody, new Header[0]);
            updateReqBody = DocNode.of((String)"doc", (Object)doc.with("aa", (Object)"another new value"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update/123?_source_includes=ab&_source_excludes=bb"), (Map)updateReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void indexRequest_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            DocNode requestBody = doc.with("a", (Object)"new value");
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId), (Document)requestBody);
            requestBody = doc.with("a", (Object)"another new value");
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123"), (Document)requestBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/"), (Map)doc, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/"), (Map)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant).without(new String[]{"_id"}).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).without(new String[]{"_id"}).toJsonString()));
        }
    }

    @Test
    public void indexRequest_withoutParams_createEndpoint() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_create/unscoped_id"), (Document)doc);
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_create/scoped_id"), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant).without(new String[]{"_id"}).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).without(new String[]{"_id"}).toJsonString()));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_create/" + scopedId), (Map)doc, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_create/123"), (Map)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void indexRequest_withIfSeqNoAndIfPrimaryTermParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        DocWriteResponse indexResponse = this.addDocumentToIndex(scopedId, doc);
        long seqNo = indexResponse.getSeqNo();
        long primaryTerm = indexResponse.getPrimaryTerm();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), (Document)doc);
            GetResponse getResponse = this.getDocById(scopedId);
            seqNo = getResponse.getSeqNo();
            primaryTerm = getResponse.getPrimaryTerm();
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?if_seq_no=" + (seqNo *= 10L) + "&if_primary_term=" + (primaryTerm *= 10L)), (Map)doc, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), (Map)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void indexRequest_withRefreshParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?refresh=true"), (Document)doc);
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?refresh=true"), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?refresh=false"), (Map)doc, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?refresh=false"), (Map)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void indexRequest_withRoutingParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        String routing = "test-routing";
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, routing, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?routing=" + routing), (Document)doc);
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?routing=" + routing), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            routing = routing.concat("-missing-1");
            responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?routing=" + routing), (Document)doc);
            this.deleteDoc(scopedId, routing);
            responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?routing=" + routing), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)201));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void indexRequest_withVersionParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        DocWriteResponse indexResponse = this.addDocumentToIndex(scopedId, doc);
        long version = indexResponse.getVersion() + 1L;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?version=" + version + "&version_type=external"), (Document)doc);
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?version=" + ++version + "&version_type=external"), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            version = 1L;
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?version=" + version + "&version_type=external"), (Map)doc, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?version=" + version + "&version_type=external"), (Map)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void indexRequest_withRequireAliasParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        String aliasName = KIBANA_ALIAS;
        this.addAliasToIndex(aliasName);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/" + aliasName + "/_doc/" + scopedId + "?require_alias=true"), (Document)doc);
            GenericRestClient.HttpResponse responseWithTenant = client.putJson(this.appendWaitForAllActiveShardsParam("/" + aliasName + "/_doc/123?require_alias=true"), (Document)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?require_alias=true"), (Map)doc, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?require_alias=true"), (Map)doc, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void deleteRequest_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId), new Header[0]);
            this.addDocumentToIndex(scopedId, doc);
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123"), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void deleteRequest_withIfSeqNoAndIfPrimaryTermParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        DocWriteResponse indexResponse = this.addDocumentToIndex(scopedId, doc);
        long seqNo = indexResponse.getSeqNo();
        long primaryTerm = indexResponse.getPrimaryTerm();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), new Header[0]);
            indexResponse = this.addDocumentToIndex(scopedId, doc);
            seqNo = indexResponse.getSeqNo();
            primaryTerm = indexResponse.getPrimaryTerm();
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            indexResponse = this.addDocumentToIndex(scopedId, doc);
            seqNo = indexResponse.getSeqNo() * 10L;
            primaryTerm = indexResponse.getPrimaryTerm() * 10L;
            responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), new Header[0]);
            responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?if_seq_no=" + seqNo + "&if_primary_term=" + primaryTerm), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void deleteRequest_withRefreshParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?refresh=true"), new Header[0]);
            this.addDocumentToIndex(scopedId, doc);
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?refresh=true"), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            this.addDocumentToIndex(scopedId, doc);
            responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?refresh=false"), new Header[0]);
            this.addDocumentToIndex(scopedId, doc);
            responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?refresh=false"), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void deleteRequest_withRoutingParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        String routing = "test-routing";
        this.addDocumentToIndex(scopedId, routing, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?routing=" + routing), new Header[0]);
            this.addDocumentToIndex(scopedId, routing, doc);
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?routing=" + routing), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            this.addDocumentToIndex(scopedId, routing, doc);
            routing = routing.concat("-fake");
            responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?routing=" + routing), new Header[0]);
            responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?routing=" + routing), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void deleteRequest_withVersionParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b");
        DocWriteResponse indexResponse = this.addDocumentToIndex(scopedId, doc);
        long version = indexResponse.getVersion();
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?version_type=external_gte&version=" + version), new Header[0]);
            indexResponse = this.addDocumentToIndex(scopedId, doc);
            version = indexResponse.getVersion();
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?version_type=external_gte&version=" + version), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
            this.addDocumentToIndex(scopedId, doc);
            version = 1L;
            responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId + "?version_type=external_gte&version=" + version), new Header[0]);
            responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123?version_type=external_gte&version=" + version), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)409));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void deleteRequest_docDoesNotExist() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/" + scopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/.kibana/_doc/123"), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutAutoIncrementedFields(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutAutoIncrementedFields(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void deleteRequest_indexDoesNotExist() throws Exception {
        String missingIndex = KIBANA_ALIAS;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.delete(this.appendWaitForAllActiveShardsParam("/" + missingIndex + "/_doc/123"), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.delete(this.appendWaitForAllActiveShardsParam("/" + missingIndex + "/_doc/123"), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void clusterSearchShardsRequest_withoutParams() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search_shards", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search_shards", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)KIBANA_INDEX));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
        }
    }

    @Test
    public void clusterSearchShardsRequest_withAllowNoIndicesParam() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String indexPattern = ".kibana_1.1.1";
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/" + indexPattern + "/_search_shards?allow_no_indices=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/" + indexPattern + "/_search_shards?allow_no_indices=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)KIBANA_INDEX)));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
            responseWithoutTenant = client.get("/" + indexPattern + "/_search_shards?allow_no_indices=false", new Header[0]);
            responseWithTenant = client.get("/" + indexPattern + "/_search_shards?allow_no_indices=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
        }
    }

    @Test
    public void clusterSearchShardsRequest_withIgnoreUnavailableParam() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String indexPattern = ".kibana_1.1.1";
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/" + indexPattern + "/_search_shards?ignore_unavailable=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/" + indexPattern + "/_search_shards?ignore_unavailable=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.not((Matcher)Matchers.containsString((String)KIBANA_INDEX)));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
            responseWithoutTenant = client.get("/" + indexPattern + "/_search_shards?ignore_unavailable=false", new Header[0]);
            responseWithTenant = client.get("/" + indexPattern + "/_search_shards?ignore_unavailable=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
        }
    }

    @Test
    public void clusterSearchShardsRequest_withLocalParam() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search_shards?local=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search_shards?local=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)KIBANA_INDEX));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
            responseWithoutTenant = client.get("/.kibana/_search_shards?local=false", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search_shards?local=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)KIBANA_INDEX));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
        }
    }

    @Test
    public void clusterSearchShardsRequest_withPreferenceParam() throws Exception {
        String preference = "_local";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search_shards?preference=" + preference, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search_shards?preference=" + preference, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)KIBANA_INDEX));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
            preference = preference.concat("-fake");
            responseWithoutTenant = client.get("/.kibana/_search_shards?preference=" + preference, new Header[0]);
            responseWithTenant = client.get("/.kibana/_search_shards?preference=" + preference, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)400));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)500));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"security_exception"));
        }
    }

    @Test
    public void multiGetRequest_withoutParams() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_withPreferenceParam() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"second"));
        String preference = "_local";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?preference=" + preference, (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?preference=" + preference, (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            preference = preference.concat("-fake");
            responseWithoutTenant = client.postJson("/.kibana/_mget?preference=" + preference, (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?preference=" + preference, (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)"error"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"error"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_withRealtimeParam() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?realtime=true", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?realtime=true", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/.kibana/_mget?realtime=false", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?realtime=false", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_withRefreshParam() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?refresh=true", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?refresh=true", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/.kibana/_mget?refresh=false", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?refresh=false", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_withRoutingParam() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        String routing = "test-routing";
        this.addDocumentToIndex(firstScopedId, routing, DocNode.of((String)"a", (Object)"first"));
        this.addDocumentToIndex(secondScopedId, routing, DocNode.of((String)"a", (Object)"second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?routing=" + routing, (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?routing=" + routing, (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            routing = routing.concat("-fake");
            responseWithoutTenant = client.postJson("/.kibana/_mget?routing=" + routing, (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?routing=" + routing, (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)"\"found\":false"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_withStoredFieldsParam() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        DocNode indexMappings = DocNode.parse((Format)Format.JSON).from("{\n  \"properties\": {\n    \"aa\": {\n      \"type\": \"text\",\n      \"store\": true\n    },\n    \"ab\": {\n      \"type\": \"text\",\n      \"store\": true\n    },\n    \"bb\": {\n      \"type\": \"text\"\n    }\n  }\n}\n");
        this.updateIndexMappings(indexMappings);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"aa", (Object)"aa-first", (String)"ab", (Object)"ab-first", (String)"bb", (Object)"bb-first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"aa", (Object)"aa-second", (String)"ab", (Object)"ab-second", (String)"bb", (Object)"bb-second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?stored_fields=aa,ab", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?stored_fields=aa,ab", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/.kibana/_mget?stored_fields=bb", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?stored_fields=bb", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_withSourceParam() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?_source=false", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?_source=false", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/.kibana/_mget?_source=true", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?_source=true", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGequest_withSourceIncludesAndSourceExcludesParams() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"a-first", (String)"ab", (Object)"ab-first", (String)"c", (Object)"c-first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"a-second", (String)"ab", (Object)"ab-second", (String)"c", (Object)"c-second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget?_source_includes=a*&_source_excludes=ab", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget?_source_includes=a*&_source_excludes=ab", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/.kibana/_mget?_source=a*", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget?_source=a*", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_docsDoNotExist() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        String thirdId = "3";
        String thirdScopedId = this.scopedId(thirdId);
        String fourthId = "4";
        String fourthScopedId = this.scopedId(fourthId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"aa", (Object)"aa-first", (String)"ab", (Object)"ab-first", (String)"bb", (Object)"bb-first"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/.kibana/_mget", (Map)this.multiGetReqBody(firstScopedId, secondScopedId), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/.kibana/_mget", (Map)this.multiGetReqBody(firstId, secondId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/.kibana/_mget", (Map)this.multiGetReqBody(thirdScopedId, fourthScopedId), new Header[0]);
            responseWithTenant = client.postJson("/.kibana/_mget", (Map)this.multiGetReqBody(thirdId, fourthId), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, thirdId, fourthId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void multiGetRequest_indexDoesNotExist() throws Exception {
        String firstMissingIndex = KIBANA_ALIAS;
        String secondMissingIndex = KIBANA_INDEX.concat("_2.2.2");
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"aa", (Object)"aa-first"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"aa", (Object)"aa-second"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/_mget", (Map)this.multiGetReqBody(Tuple.tuple((Object)KIBANA_INDEX, Arrays.asList(firstScopedId, secondScopedId)), Tuple.tuple((Object)firstMissingIndex, Arrays.asList(firstScopedId, secondScopedId))), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/_mget", (Map)this.multiGetReqBody(Tuple.tuple((Object)KIBANA_INDEX, Arrays.asList(firstId, secondId)), Tuple.tuple((Object)firstMissingIndex, Arrays.asList(firstId, secondId))), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
            responseWithoutTenant = client.postJson("/_mget", (Map)this.multiGetReqBody(Tuple.tuple((Object)firstMissingIndex, Arrays.asList(firstScopedId, secondScopedId)), Tuple.tuple((Object)secondMissingIndex, Arrays.asList(firstScopedId, secondScopedId))), new Header[0]);
            responseWithTenant = client.postJson("/_mget", (Map)this.multiGetReqBody(Tuple.tuple((Object)firstMissingIndex, Arrays.asList(firstId, secondId)), Tuple.tuple((Object)secondMissingIndex, Arrays.asList(firstId, secondId))), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(responseWithoutTenant, firstId, secondId), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBody()));
        }
    }

    @Test
    public void searchRequest_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search/", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search/", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withPointInTimeQuery_success() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)LIMITED_USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.post("/.kibana/_pit?keep_alive=500ms", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            String pitId = response.getBodyAsDocNode().getAsString("id");
            MatcherAssert.assertThat((Object)pitId, (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
            DocNode searchRequestBody = DocNode.of((String)"pit", (Object)DocNode.of((String)"id", (Object)pitId, (String)"keep_alive", (Object)"250ms"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson("/_search/", (Map)searchRequestBody, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/_search/", (Map)searchRequestBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant).toJsonString()));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$", (String)"pit_id"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$", (String)"pit_id"));
        }
    }

    @Test
    public void searchRequest_withPointInTimeQuery_failure() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)LIMITED_USER, new Header[0]);){
            BasicHeader tenantHeader = new BasicHeader("sg_tenant", HR_TENANT.getName());
            GenericRestClient.HttpResponse response = client.post("/.kibana/_pit?keep_alive=500ms", new Header[]{tenantHeader});
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            String pitId = response.getBodyAsDocNode().getAsString("id");
            MatcherAssert.assertThat((Object)pitId, (Matcher)Matchers.not((Matcher)Matchers.emptyOrNullString()));
            DocNode searchRequestBody = DocNode.of((String)"pit", (Object)DocNode.of((String)"id", (Object)pitId, (String)"keep_alive", (Object)"250ms"));
            tenantHeader = new BasicHeader("sg_tenant", IT_TENANT.getName());
            GenericRestClient.HttpResponse responseWithTenant = client.postJson("/_search/", (Map)searchRequestBody, new Header[]{tenantHeader});
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void searchRequest_withAllowNoIndicesParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana,*_1.1.1/_search?allow_no_indices=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana,*_1.1.1/_search?allow_no_indices=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withDocValueFieldsParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode indexMappings = DocNode.parse((Format)Format.JSON).from("{\n  \"properties\": {\n    \"aa\": {\n      \"type\": \"keyword\"\n    },\n    \"ab\": {\n      \"type\": \"keyword\"\n    }\n  }\n}\n");
        this.updateIndexMappings(indexMappings);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"ab", (Object)"ab", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?docvalue_fields=a*", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?docvalue_fields=a*", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withExplainParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?explain=false", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?explain=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?explain=true", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?explain=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)"_explanation"));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"_explanation"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant).toJsonString())));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.removeAttributesFromSearchHits(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant), "_explanation"), DOC_ID), (Matcher)Matchers.equalTo((Object)this.removeAttributesFromSearchHits(this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithTenant), "_explanation").toJsonString()));
        }
    }

    @Test
    public void searchRequest_withIgnoreUnavailableParam() throws Exception {
        String indexName = KIBANA_ALIAS;
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/" + indexName + "/_search?ignore_unavailable=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/" + indexName + "/_search?ignore_unavailable=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withSeqNoPrimaryTermParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?seq_no_primary_term=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?seq_no_primary_term=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?seq_no_primary_term=false", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?seq_no_primary_term=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withSizeSortAndFromParams() throws Exception {
        IntStream.rangeClosed(1, 10).forEach(docNo -> {
            String id = String.valueOf(docNo);
            this.addDocumentToIndex(this.scopedId(id), DocNode.of((String)"field", (Object)docNo, (String)"sg_tenant", (Object)this.internalTenantName()));
        });
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            int size = 3;
            String sort = "field:desc";
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            size = 4;
            sort = "field:desc";
            int from = 5;
            responseWithoutTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort + "&from=" + from, new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort + "&from=" + from, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            size = 5;
            sort = "field:asc";
            responseWithoutTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort, new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            size = 20;
            sort = "field:desc";
            responseWithoutTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort, new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            size = 15;
            sort = "field:asc";
            from = 2;
            responseWithoutTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort + "&from=" + from, new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?size=" + size + "&sort=" + sort + "&from=" + from, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withSourceParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?_source=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?_source=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?_source=false", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?_source=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withSourceIncludesAndSourceExcludesParams() throws Exception {
        IntStream.rangeClosed(1, 10).forEach(docNo -> {
            String id = String.valueOf(docNo);
            this.addDocumentToIndex(this.scopedId(id), DocNode.of((String)"a", (Object)("a" + docNo), (String)"ab", (Object)("ab" + docNo), (String)"c", (Object)("c" + docNo), (String)"sg_tenant", (Object)this.internalTenantName()));
        });
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?_source_includes=a*,c&_source_excludes=ab", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?_source_includes=a*,c&_source_excludes=ab", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?_source=a*", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?_source=a*", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withStoredFieldsParam() throws Exception {
        DocNode indexMappings = DocNode.parse((Format)Format.JSON).from("{\n  \"properties\": {\n    \"aa\": {\n      \"type\": \"text\",\n      \"store\": true\n    },\n    \"ab\": {\n      \"type\": \"text\",\n      \"store\": true\n    },\n    \"bb\": {\n      \"type\": \"text\"\n    }\n  }\n}\n");
        this.updateIndexMappings(indexMappings);
        IntStream.rangeClosed(1, 10).forEach(docNo -> {
            String id = String.valueOf(docNo);
            this.addDocumentToIndex(this.scopedId(id), DocNode.of((String)"aa", (Object)("a" + docNo), (String)"ab", (Object)("ab" + docNo), (String)"bb", (Object)("bb" + docNo), (String)"sg_tenant", (Object)this.internalTenantName()));
        });
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?stored_fields=aa,ab", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?stored_fields=aa,ab", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?stored_fields=bb", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?stored_fields=bb", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withVersionParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"aa", (Object)"a", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?version=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?version=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?version=false", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?version=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withQParam() throws Exception {
        IntStream.rangeClosed(1, 10).forEach(docNo -> {
            String id = String.valueOf(docNo);
            this.addDocumentToIndex(this.scopedId(id), DocNode.of((String)"field", (Object)docNo, (String)"sg_tenant", (Object)this.internalTenantName()));
        });
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?q=" + URLEncoder.encode("field:[2 TO 5]", StandardCharsets.UTF_8), new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?q=" + URLEncoder.encode("field:[2 TO 5]", StandardCharsets.UTF_8), new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withRestTotalHitsAsIntParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?rest_total_hits_as_int=true", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?rest_total_hits_as_int=true", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
            responseWithoutTenant = client.get("/.kibana/_search?rest_total_hits_as_int=false", new Header[0]);
            responseWithTenant = client.get("/.kibana/_search?rest_total_hits_as_int=false", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withScrollParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?scroll=1d", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?scroll=1d", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void searchRequest_withSuggestFieldSuggestModeSuggestTextAndSuggestSizeParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"value1", (String)"b", (Object)"test", (String)"sg_tenant", (Object)this.internalTenantName()));
        this.addDocumentToIndex(this.scopedId("456"), DocNode.of((String)"a", (Object)"value2", (String)"b", (Object)"test", (String)"sg_tenant", (Object)this.internalTenantName()));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse responseWithoutTenant = client.get("/.kibana/_search?q=a:value*&suggest_field=a&suggest_mode=always&suggest_text=value&suggest_size=1", new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.get("/.kibana/_search?q=a:value*&suggest_field=a&suggest_mode=always&suggest_text=value&suggest_size=1", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString(), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForSearchRequests(responseWithoutTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_createAction_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkCreateReqBody(scopedId, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            this.deleteDoc(scopedId);
            bulkReqBody = this.bulkCreateReqBody(DOC_ID, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            bulkReqBody = this.bulkCreateReqBody(scopedId, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkCreateReqBody(DOC_ID, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString())));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)"document already exists"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"document already exists"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.removeAttributesFromBulkItems(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), "error"), DOC_ID), (Matcher)Matchers.equalTo((Object)this.removeAttributesFromBulkItems(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant), "error").toJsonString()));
        }
    }

    @Test
    public void bulkRequest_indexAction_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkIndexReqBody(scopedId, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            this.deleteDoc(scopedId);
            bulkReqBody = this.bulkIndexReqBody(DOC_ID, DocNode.of((String)"a", (Object)"a", (String)"b", (Object)"b"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            bulkReqBody = this.bulkIndexReqBody(scopedId, DocNode.of((String)"c", (Object)"c"));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkIndexReqBody(DOC_ID, DocNode.of((String)"d", (Object)"d"));
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_updateAction_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkUpdateReqBody(scopedId, DocNode.of((String)"b", (Object)"b"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, DocNode.of((String)"c", (Object)"c"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            this.deleteDoc(scopedId);
            bulkReqBody = this.bulkUpdateReqBody(scopedId, DocNode.of((String)"c", (Object)"c"));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, DocNode.of((String)"d", (Object)"d"));
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString())));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)"document missing"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"document missing"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.removeAttributesFromBulkItems(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), "error"), DOC_ID), (Matcher)Matchers.equalTo((Object)this.removeAttributesFromBulkItems(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant), "error").toJsonString()));
        }
    }

    @Test
    public void bulkRequest_deleteAction_withoutParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkDeleteReqBody(scopedId);
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a"));
            bulkReqBody = this.bulkDeleteReqBody(DOC_ID);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            bulkReqBody = this.bulkDeleteReqBody(scopedId);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkDeleteReqBody(DOC_ID);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_allActions_indexDoesNotExist() throws Exception {
        String index = KIBANA_ALIAS;
        String scopedId = this.scopedId(DOC_ID);
        DocNode docContent = DocNode.of((String)"a", (Object)"a");
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkCreateReqBody(scopedId, docContent);
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + index + "/_bulk/"), bulkReqBody, new Header[0]);
            this.deleteIndex(index);
            bulkReqBody = this.bulkCreateReqBody(DOC_ID, docContent);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + index + "/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            this.deleteIndex(index);
            bulkReqBody = this.bulkIndexReqBody(scopedId, docContent);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + index + "/_bulk/"), bulkReqBody, new Header[0]);
            this.deleteIndex(index);
            bulkReqBody = this.bulkIndexReqBody(DOC_ID, docContent);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + index + "/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            this.deleteIndex(index);
            bulkReqBody = this.bulkUpdateReqBody(scopedId, docContent);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + index + "/_bulk/"), bulkReqBody, new Header[0]);
            this.deleteIndex(index);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, docContent);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + index + "/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.not((Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString())));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBody(), (Matcher)Matchers.containsString((String)"document missing"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBody(), (Matcher)Matchers.containsString((String)"document missing"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.removeAttributesFromBulkItems(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), "error"), DOC_ID), (Matcher)Matchers.equalTo((Object)this.removeAttributesFromBulkItems(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant), "error").toJsonString()));
            bulkReqBody = this.bulkDeleteReqBody(scopedId);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkDeleteReqBody(DOC_ID);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_manyActionsInOneRequest() throws Exception {
        String firstId = "1";
        String firstScopedId = this.scopedId(firstId);
        String secondId = "2";
        String secondScopedId = this.scopedId(secondId);
        String thirdId = "3";
        String thirdScopedId = this.scopedId(thirdId);
        this.addDocumentToIndex(firstScopedId, DocNode.of((String)"a", (Object)"a"));
        this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"a"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkCreateReqBody = this.bulkCreateReqBody(thirdScopedId, DocNode.of((String)"a", (Object)"a"));
            String bulkIndexReqBody = this.bulkIndexReqBody(firstScopedId, DocNode.of((String)"b", (Object)"b"));
            String bulkUpdateReqBody = this.bulkUpdateReqBody(secondScopedId, DocNode.of((String)"b", (Object)"b"));
            String bulkDeleteReqBody = this.bulkDeleteReqBody(secondScopedId);
            String reqBodyWithManyActions = String.join((CharSequence)"", bulkCreateReqBody, bulkIndexReqBody, bulkUpdateReqBody, bulkDeleteReqBody);
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), reqBodyWithManyActions, new Header[0]);
            this.deleteDoc(thirdScopedId);
            this.addDocumentToIndex(secondScopedId, DocNode.of((String)"a", (Object)"a"));
            bulkCreateReqBody = this.bulkCreateReqBody(thirdId, DocNode.of((String)"a", (Object)"a"));
            bulkIndexReqBody = this.bulkIndexReqBody(firstId, DocNode.of((String)"b", (Object)"b"));
            bulkUpdateReqBody = this.bulkUpdateReqBody(secondId, DocNode.of((String)"b", (Object)"b"));
            bulkDeleteReqBody = this.bulkDeleteReqBody(secondId);
            reqBodyWithManyActions = String.join((CharSequence)"", bulkCreateReqBody, bulkIndexReqBody, bulkUpdateReqBody, bulkDeleteReqBody);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk/"), reqBodyWithManyActions, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"create"));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[1]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[1]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[2]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[2]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[3]", (String)"delete"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[3]", (String)"delete"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), firstId, secondId, thirdId), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_withRequireAliasParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"a", (Object)"a"));
        String aliasName = KIBANA_ALIAS;
        this.addAliasToIndex(aliasName);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkIndexReqBody(scopedId, DocNode.of((String)"a", (Object)"a"));
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + aliasName + "/_bulk?require_alias=true"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkIndexReqBody(DOC_ID, DocNode.of((String)"a", (Object)"a"));
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/" + aliasName + "/_bulk?require_alias=true"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            bulkReqBody = this.bulkIndexReqBody(scopedId, DocNode.of((String)"a", (Object)"a"));
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?require_alias=true"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkIndexReqBody(DOC_ID, DocNode.of((String)"a", (Object)"a"));
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?require_alias=true"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"index"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_withRoutingParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        String routing = "test-routing";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            this.addDocumentToIndex(scopedId, routing, DocNode.of((String)"a", (Object)"a"));
            String bulkReqBody = this.bulkDeleteReqBody(scopedId);
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?routing=" + routing), bulkReqBody, new Header[0]);
            this.addDocumentToIndex(scopedId, routing, DocNode.of((String)"a", (Object)"a"));
            bulkReqBody = this.bulkDeleteReqBody(DOC_ID);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?routing=" + routing), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            this.addDocumentToIndex(scopedId, routing, DocNode.of((String)"a", (Object)"a"));
            routing = routing.concat("-fake");
            bulkReqBody = this.bulkDeleteReqBody(scopedId);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?routing=" + routing), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkDeleteReqBody(DOC_ID);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?routing=" + routing), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"delete"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_withSourceParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode docContent = DocNode.of((String)"a", (Object)"a");
        this.addDocumentToIndex(scopedId, docContent);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkUpdateReqBody(scopedId, docContent);
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source=false"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, docContent);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source=false"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            bulkReqBody = this.bulkUpdateReqBody(scopedId, docContent);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source=true"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, docContent);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source=true"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void bulkRequest_withSourceIncludesAndSourceExcludesParams() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode docContent = DocNode.of((String)"a", (Object)"a", (String)"ab", (Object)"ab", (String)"b", (Object)"b");
        this.addDocumentToIndex(scopedId, docContent);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String bulkReqBody = this.bulkUpdateReqBody(scopedId, docContent);
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source_includes=a*&_source_excludes=ab"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, docContent);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source_includes=a*&_source_excludes=ab"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
            bulkReqBody = this.bulkUpdateReqBody(scopedId, docContent);
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source=a*"), bulkReqBody, new Header[0]);
            bulkReqBody = this.bulkUpdateReqBody(DOC_ID, docContent);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_bulk?_source=a*"), bulkReqBody, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)responseWithTenant.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"items[0]", (String)"update"));
            MatcherAssert.assertThat((Object)this.unscopeResponseBody(this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithoutTenant), DOC_ID), (Matcher)Matchers.equalTo((Object)this.responseBodyWithoutFieldsWhichMayDifferForBulkRequests(responseWithTenant).toJsonString()));
        }
    }

    @Test
    public void openPointInTimeRequest_success() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"point", (Object)"in", (String)"time", (Object)"test"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            GenericRestClient.HttpResponse response = client.post("/.kibana/_pit?keep_alive=500ms", new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$", (String)"id"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsOnlyFields((String)"$", (String[])new String[]{"id", "_shards"}));
        }
    }

    @Test
    public void openPointInTimeRequest_failure() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        this.addDocumentToIndex(scopedId, DocNode.of((String)"point", (Object)"in", (String)"time", (Object)"test"));
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)LIMITED_USER, new Header[0]);){
            BasicHeader tenantHeader = new BasicHeader("sg_tenant", IT_TENANT.getName());
            GenericRestClient.HttpResponse response = client.post("/.kibana/_pit?keep_alive=500ms", new Header[]{tenantHeader});
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void shouldNotDeleteFrontendIndexWithReadOnlyPermissions() throws Exception {
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)LIMITED_USER, new Header[]{new BasicHeader("sg_tenant", GLOBAL_TENANT_NAME)});){
            GenericRestClient.HttpResponse response = client.delete(KIBANA_INDEX, new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)403));
        }
    }

    @Test
    public void updateByQueryRequest_withRefreshParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)1, (String)"b", (Object)"value", (String)"sg_tenant", (Object)this.internalTenantName());
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String scriptAndQuery = "{\n  \"script\": {\n    \"source\": \"ctx._source.a += params.add_to_a\",\n    \"lang\": \"painless\",\n    \"params\": {\n      \"add_to_a\": 4\n    }\n  },\n  \"query\": {\n    \"term\": {\n      \"b\": \"value\"\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update_by_query?refresh=true"), scriptAndQuery, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update_by_query?refresh=true"), scriptAndQuery, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode().without(new String[]{"took"}), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBodyAsDocNode().without(new String[]{"took"})));
            scriptAndQuery = "{\n  \"script\": {\n    \"source\": \"ctx._source.a += params.add_to_a\",\n    \"lang\": \"painless\",\n    \"params\": {\n      \"add_to_a\": 4\n    }\n  },\n  \"query\": {\n    \"term\": {\n      \"b\": \"fake-value\"\n    }\n  }\n}\n";
            responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update_by_query?refresh=true"), scriptAndQuery, new Header[0]);
            responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update_by_query?refresh=true"), scriptAndQuery, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode().without(new String[]{"took"}), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBodyAsDocNode().without(new String[]{"took"})));
        }
    }

    @Test
    public void updateByQueryRequest_withAllowNoIndicesParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)1, (String)"b", (Object)"value", (String)"sg_tenant", (Object)this.internalTenantName());
        this.addDocumentToIndex(scopedId, doc);
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String scriptAndQuery = "{\n  \"script\": {\n    \"source\": \"ctx._source.a += params.add_to_a\",\n    \"lang\": \"painless\",\n    \"params\": {\n      \"add_to_a\": 4\n    }\n  },\n  \"query\": {\n    \"term\": {\n      \"b\": \"value\"\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana,*_1.1.1/_update_by_query?refresh=true&allow_no_indices=true"), scriptAndQuery, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana,*_1.1.1/_update_by_query?refresh=true&allow_no_indices=true"), scriptAndQuery, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode().without(new String[]{"took"}), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBodyAsDocNode().without(new String[]{"took"})));
        }
    }

    @Test
    public void updateByQueryRequest_withPreferenceParam() throws Exception {
        String scopedId = this.scopedId(DOC_ID);
        DocNode doc = DocNode.of((String)"a", (Object)1, (String)"b", (Object)"value", (String)"sg_tenant", (Object)this.internalTenantName());
        this.addDocumentToIndex(scopedId, doc);
        String preference = "_local";
        try (GenericRestClient client = cluster.getRestClient((EsClientProvider.UserCredentialsHolder)USER, new Header[0]);){
            String scriptAndQuery = "{\n  \"script\": {\n    \"source\": \"ctx._source.a += params.add_to_a\",\n    \"lang\": \"painless\",\n    \"params\": {\n      \"add_to_a\": 4\n    }\n  },\n  \"query\": {\n    \"term\": {\n      \"b\": \"value\"\n    }\n  }\n}\n";
            GenericRestClient.HttpResponse responseWithoutTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update_by_query?refresh=true&preference=" + preference), scriptAndQuery, new Header[0]);
            GenericRestClient.HttpResponse responseWithTenant = client.postJson(this.appendWaitForAllActiveShardsParam("/.kibana/_update_by_query?refresh=true&preference=" + preference), scriptAndQuery, new Header[]{this.tenantHeader()});
            MatcherAssert.assertThat((String)responseWithoutTenant.getBody(), (Object)responseWithoutTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((String)responseWithTenant.getBody(), (Object)responseWithTenant.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)responseWithoutTenant.getBodyAsDocNode().without(new String[]{"took"}), (Matcher)Matchers.equalTo((Object)responseWithTenant.getBodyAsDocNode().without(new String[]{"took"})));
        }
    }

    private DocNode responseBodyWithoutAutoIncrementedFields(GenericRestClient.HttpResponse response) throws Exception {
        ImmutableSet autoIncrementedFields = ImmutableSet.of((Object)"_version", (Object)"_seq_no");
        String regexPattern = String.format("\"(%s)\":\"?[\\w\\d]*\"?,", String.join((CharSequence)"|", (Iterable<? extends CharSequence>)autoIncrementedFields));
        String responseWithoutAutoIncrementedFields = response.getBody().replaceAll(regexPattern, "");
        return DocNode.parse((Format)Format.JSON).from(responseWithoutAutoIncrementedFields);
    }

    private DocNode responseBodyWithoutFieldsWhichMayDifferForSearchRequests(GenericRestClient.HttpResponse response) throws Exception {
        ImmutableSet excludedFields = ImmutableSet.of((Object)"took", (Object[])new String[]{"_score", "max_score"});
        String regexPattern = String.format("\"(%s)\":\"?[\\w\\d\\.]*\"?,", String.join((CharSequence)"|", (Iterable<? extends CharSequence>)excludedFields));
        String responseWithoutExcludedFields = response.getBody().replaceAll(regexPattern, "");
        return DocNode.parse((Format)Format.JSON).from(responseWithoutExcludedFields);
    }

    private DocNode responseBodyWithoutFieldsWhichMayDifferForBulkRequests(GenericRestClient.HttpResponse response) throws Exception {
        return this.responseBodyWithoutAutoIncrementedFields(response).without(new String[]{"took"});
    }

    private DocNode removeAttributesFromSearchHits(DocNode searchResponseBody, String ... attributes) {
        DocNode hits = searchResponseBody.getAsNode("hits");
        ImmutableList hitEntries = hits.getAsListOfNodes("hits");
        List<DocNode> hitEntriesWithoutAttributes = hitEntries.stream().map(entry -> {
            for (String attribute : attributes) {
                entry = entry.without(new String[]{attribute});
            }
            return entry;
        }).toList();
        hits = hits.with("hits", hitEntriesWithoutAttributes);
        return searchResponseBody.with("hits", (Object)hits);
    }

    private DocNode removeAttributesFromBulkItems(DocNode bulkResponseBody, String ... attributes) {
        ImmutableList items = bulkResponseBody.getAsListOfNodes("items");
        List<DocNode> itemsWithoutAttributes = items.stream().map(item -> {
            for (DocWriteRequest.OpType opType : DocWriteRequest.OpType.values()) {
                String opTypeName = opType.name().toLowerCase();
                DocNode itemDetails = item.getAsNode(opTypeName);
                if (itemDetails.isNull()) continue;
                for (String attribute : attributes) {
                    itemDetails = itemDetails.without(new String[]{attribute});
                }
                item = item.with(opTypeName, (Object)itemDetails);
            }
            return item;
        }).toList();
        return bulkResponseBody.with("items", itemsWithoutAttributes);
    }

    private String unscopeResponseBody(GenericRestClient.HttpResponse response, String ... ids) throws Exception {
        return this.unscopeResponseBody(response.getBodyAsDocNode(), ids);
    }

    private String unscopeResponseBody(DocNode response, String ... ids) {
        String responseJson = response.toJsonString();
        for (String id : ids) {
            responseJson = responseJson.replaceAll(this.scopedId(id), id);
        }
        return responseJson;
    }

    private String scopedId(String id) {
        return RequestResponseTenantData.scopedId((String)id, (String)this.internalTenantName());
    }

    private String internalTenantName() {
        return this.tenantManager.toInternalTenantName(User.forUser((String)USER.getName()).requestedTenant(HR_TENANT.getName()).build());
    }

    private Header tenantHeader() {
        return new BasicHeader("sg_tenant", HR_TENANT.getName());
    }

    private DocWriteResponse addDocumentToIndex(String id, String routing, DocNode doc) {
        Client client = cluster.getInternalNodeClient();
        DocWriteResponse indexResponse = (DocWriteResponse)client.index(((IndexRequest)new IndexRequest(KIBANA_INDEX).id(id).source((Map)doc).setRefreshPolicy(WriteRequest.RefreshPolicy.IMMEDIATE)).routing(routing)).actionGet();
        MatcherAssert.assertThat((Object)indexResponse.status().getStatus(), (Matcher)Matchers.equalTo((Object)201));
        return indexResponse;
    }

    private DocWriteResponse addDocumentToIndex(String id, DocNode doc) {
        return this.addDocumentToIndex(id, null, doc);
    }

    private GetResponse getDocById(String id) {
        Client client = cluster.getInternalNodeClient();
        GetResponse getResponse = (GetResponse)client.get(new GetRequest(KIBANA_INDEX).id(id)).actionGet();
        MatcherAssert.assertThat((Object)getResponse.isExists(), (Matcher)Matchers.equalTo((Object)true));
        return getResponse;
    }

    private void addAliasToIndex(String aliasName) {
        Client client = cluster.getInternalNodeClient();
        IndicesAliasesRequest.AliasActions addAlias = IndicesAliasesRequest.AliasActions.add().index(KIBANA_INDEX).alias(aliasName);
        AcknowledgedResponse acknowledgedResponse = (AcknowledgedResponse)client.admin().indices().aliases(new IndicesAliasesRequest(Constants.DEFAULT_MASTER_TIMEOUT, Constants.DEFAULT_ACK_TIMEOUT).addAliasAction(addAlias)).actionGet();
        MatcherAssert.assertThat((Object)acknowledgedResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void updateIndexMappings(DocNode mapping) {
        Client client = cluster.getInternalNodeClient();
        AcknowledgedResponse response = (AcknowledgedResponse)client.admin().indices().putMapping(new PutMappingRequest(new String[]{KIBANA_INDEX}).source((Map)mapping)).actionGet();
        MatcherAssert.assertThat((Object)response.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void deleteIndex(String indexNamePattern) {
        Client client = cluster.getInternalNodeClient();
        AcknowledgedResponse deleteIndexResponse = (AcknowledgedResponse)client.admin().indices().delete(new DeleteIndexRequest(indexNamePattern)).actionGet();
        MatcherAssert.assertThat((Object)deleteIndexResponse.isAcknowledged(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void deleteDoc(String id) {
        this.deleteDoc(id, null);
    }

    private void deleteDoc(String id, String routing) {
        Client client = cluster.getInternalNodeClient();
        DeleteResponse deleteResponse = (DeleteResponse)client.delete(new DeleteRequest(KIBANA_INDEX).id(id).routing(routing)).actionGet();
        MatcherAssert.assertThat((Object)deleteResponse.status().getStatus(), (Matcher)Matchers.equalTo((Object)200));
    }

    private DocNode multiGetReqBody(String ... docIds) {
        return DocNode.of((String)"ids", (Object)docIds);
    }

    private DocNode multiGetReqBody(Tuple<String, List<String>> ... indicesAndDocIds) {
        List docs = Stream.of(indicesAndDocIds).flatMap(indexAndDocIds -> ((List)indexAndDocIds.v2()).stream().map(docId -> DocNode.of((String)"_index", (Object)indexAndDocIds.v1(), (String)"_id", (Object)docId))).toList();
        return DocNode.of((String)"docs", docs);
    }

    private String bulkCreateReqBody(String docId, DocNode doc) {
        return this.bulkRequestBody("create", docId, doc);
    }

    private String bulkIndexReqBody(String docId, DocNode doc) {
        return this.bulkRequestBody("index", docId, doc);
    }

    private String bulkUpdateReqBody(String docId, DocNode doc) {
        return this.bulkRequestBody("update", docId, DocNode.of((String)"doc", (Object)doc));
    }

    private String bulkDeleteReqBody(String docId) {
        return this.bulkRequestBody("delete", docId, DocNode.EMPTY);
    }

    private String bulkRequestBody(String action, String docId, DocNode doc) {
        DocNode create = DocNode.of((String)action, (Object)DocNode.of((String)"_id", (Object)docId));
        return Stream.of(create, doc).filter(docNode -> !docNode.isEmpty()).map(DocNode::toJsonString).collect(Collectors.joining("\n", "", "\n"));
    }

    private String appendWaitForAllActiveShardsParam(String requestPath) {
        String waitForActiveShardsParam = "wait_for_active_shards";
        String waitForAllActiveShardsParam = "wait_for_active_shards".concat("=all");
        try {
            URI actualPath = new URI(requestPath);
            if (Strings.isNullOrEmpty((String)actualPath.getQuery())) {
                return String.format("%s%s%s", requestPath, "?", waitForAllActiveShardsParam);
            }
            if (actualPath.getQuery().contains("wait_for_active_shards")) {
                return requestPath;
            }
            return String.format("%s%s%s", requestPath, "&", waitForAllActiveShardsParam);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

