/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.tenants;

import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.enterprise.femt.tenants.TenantAccessData;
import com.floragunn.searchguard.user.User;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

class DefaultTenantSelector {
    private static final Set<String> GLOBAL_TENANT_ALIASES = ImmutableSet.of((Object)"global", (Object)"__global__");
    private static final Set<String> PRIVATE_TENANT_ALIASES = ImmutableSet.of((Object)"private", (Object)"__user__");
    private final Predicate<TenantAccessData> writeAccessOrReadAccessToExistingTenant = tenantAccessData -> tenantAccessData.writeAccess() || tenantAccessData.readAccess() && tenantAccessData.exists();

    DefaultTenantSelector() {
    }

    Optional<String> findDefaultTenantForUser(User user, Map<String, TenantAccessData> tenantsAvailableToUser, List<String> configuredPreferredTenants) {
        List<String> preferredTenantsInternalNames = this.toTenantsInternalNames(user, configuredPreferredTenants);
        Optional<String> preferredGlobalOrPrivateTenant = preferredTenantsInternalNames.stream().filter(tenant -> Optional.ofNullable((TenantAccessData)tenantsAvailableToUser.get(tenant)).map(this.writeAccessOrReadAccessToExistingTenant::test).orElse(false)).findFirst().or(() -> Optional.ofNullable((TenantAccessData)tenantsAvailableToUser.get("SGS_GLOBAL_TENANT")).map(this.writeAccessOrReadAccessToExistingTenant::test).flatMap(accessible -> accessible != false ? Optional.of("SGS_GLOBAL_TENANT") : Optional.empty())).or(() -> Optional.ofNullable((TenantAccessData)tenantsAvailableToUser.get(user.getName())).map(tenantAccessData -> "__user__"));
        return preferredGlobalOrPrivateTenant.or(() -> tenantsAvailableToUser.keySet().stream().sorted().filter(tenantName -> this.writeAccessOrReadAccessToExistingTenant.test((TenantAccessData)tenantsAvailableToUser.get(tenantName))).findFirst());
    }

    private List<String> toTenantsInternalNames(User user, List<String> configuredPreferredTenants) {
        return configuredPreferredTenants.stream().map(tenantName -> {
            if (GLOBAL_TENANT_ALIASES.contains(tenantName.toLowerCase())) {
                return "SGS_GLOBAL_TENANT";
            }
            if (PRIVATE_TENANT_ALIASES.contains(tenantName.toLowerCase())) {
                return user.getName();
            }
            return tenantName;
        }).collect(Collectors.toList());
    }
}

