/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyConfigurationProvider;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.FrontendObjectCatalog;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.AddMigrationMarkerToGlobalTenantIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CopyDataToTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateBackupOfGlobalIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CreateTempIndexStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.IndexSettingsManager;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.MigrationEnvironmentHelper;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateBackupIndicesStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateTenantsStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.http.Header;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Rule;
import org.junit.Test;
import org.mockito.Mockito;

public class CrossStepTest {
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(2020, 1, 1, 1, 1), ZoneOffset.UTC);
    private final Clock clock = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.unsupported.single_index_mt_enabled", true}).singleNode().sslEnabled().resources("multitenancy").enterpriseModulesEnabled().embedded().build();
    private DataMigrationContext context;
    @Rule
    public final MigrationEnvironmentHelper environmentHelper = new MigrationEnvironmentHelper(cluster, this.clock);

    @Before
    public void before() {
        this.context = new DataMigrationContext(new MigrationConfig(false), this.clock);
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_1() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        catalog.insertSpace(backupIndex2.indexName(), "backup-2-tenant-space");
        catalog.insertSpace(backupIndex3.indexName(), "backup-3-tenant-space");
        catalog.insertSpace(backupIndex4.indexName(), "backup-4-tenant-space");
        catalog.insertSpace(backupIndex5.indexName(), "backup-5-tenant-space");
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)5));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(tempIndex), (Matcher)Matchers.equalTo((Object)2L));
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:backup-1-tenant-space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(tempIndex, "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_2() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        catalog.insertSpace(backupIndex2.indexName(), "backup-2-tenant-space");
        catalog.insertSpace(backupIndex3.indexName(), "backup-3-tenant-space");
        catalog.insertSpace(backupIndex4.indexName(), "backup-4-tenant-space");
        catalog.insertSpace(backupIndex5.indexName(), "backup-5-tenant-space");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex1.indexName());
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)5));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(tempIndex), (Matcher)Matchers.equalTo((Object)2L));
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:backup-2-tenant-space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(tempIndex, "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_3() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        catalog.insertSpace(backupIndex2.indexName(), "backup-2-tenant-space");
        catalog.insertSpace(backupIndex3.indexName(), "backup-3-tenant-space");
        catalog.insertSpace(backupIndex4.indexName(), "backup-4-tenant-space");
        catalog.insertSpace(backupIndex5.indexName(), "backup-5-tenant-space");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex1.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex2.indexName());
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)5));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(tempIndex), (Matcher)Matchers.equalTo((Object)2L));
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:backup-3-tenant-space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(tempIndex, "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_4() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        catalog.insertSpace(backupIndex2.indexName(), "backup-2-tenant-space");
        catalog.insertSpace(backupIndex3.indexName(), "backup-3-tenant-space");
        catalog.insertSpace(backupIndex4.indexName(), "backup-4-tenant-space");
        catalog.insertSpace(backupIndex5.indexName(), "backup-5-tenant-space");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex1.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex2.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex3.indexName());
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)5));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(tempIndex), (Matcher)Matchers.equalTo((Object)2L));
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:backup-4-tenant-space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(tempIndex, "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_5() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        catalog.insertSpace(backupIndex2.indexName(), "backup-2-tenant-space");
        catalog.insertSpace(backupIndex3.indexName(), "backup-3-tenant-space");
        catalog.insertSpace(backupIndex4.indexName(), "backup-4-tenant-space");
        catalog.insertSpace(backupIndex5.indexName(), "backup-5-tenant-space");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex1.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex2.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex3.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex4.indexName());
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)5));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)2L));
        this.environmentHelper.assertThatDocumentExists(this.context.getTempIndexName(), "space:backup-5-tenant-space");
        this.environmentHelper.assertThatDocumentExists(this.context.getTempIndexName(), "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(this.context.getTempIndexName(), "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_6() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        MigrationEnvironmentHelper.BackupIndex backupIndex2 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(1L));
        MigrationEnvironmentHelper.BackupIndex backupIndex3 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(2L));
        MigrationEnvironmentHelper.BackupIndex backupIndex4 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(3L));
        MigrationEnvironmentHelper.BackupIndex backupIndex5 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime().minusDays(4L));
        this.environmentHelper.createBackupIndex(backupIndex1, backupIndex2, backupIndex3, backupIndex4, backupIndex5);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        catalog.insertSpace(backupIndex2.indexName(), "backup-2-tenant-space");
        catalog.insertSpace(backupIndex3.indexName(), "backup-3-tenant-space");
        catalog.insertSpace(backupIndex4.indexName(), "backup-4-tenant-space");
        catalog.insertSpace(backupIndex5.indexName(), "backup-5-tenant-space");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex1.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex2.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex3.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex4.indexName());
        this.environmentHelper.addDataMigrationMarkerToTheIndex(backupIndex5.indexName());
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)5));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_INDICES_CONTAIN_MIGRATION_MARKER));
    }

    @Test
    public void shouldMarkGlobalTenantIndexWithMigratedDataMarkerByStep() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        MigrationEnvironmentHelper.BackupIndex backupIndex1 = new MigrationEnvironmentHelper.BackupIndex(NOW.toLocalDateTime());
        this.environmentHelper.createBackupIndex(backupIndex1);
        catalog.insertSpace(backupIndex1.indexName(), "backup-1-tenant-space");
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)1));
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        IndexSettingsManager indexSettingsManager = new IndexSettingsManager(stepRepository);
        this.addMigrationMarkerToGlobalTenantIndexViaStep(indexSettingsManager);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(this.context.getTempIndexName()), (Matcher)Matchers.equalTo((Object)2L));
        String tempIndex = this.context.getTempIndexName();
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:backup-1-tenant-space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(tempIndex, "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldUseTheBackupIndexAsDataSource_7() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        StepRepository stepRepository = new StepRepository(client);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepException exception = (StepException)ThrowableAssert.assertThatThrown(() -> step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)exception.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.BACKUP_FROM_PREVIOUS_MIGRATION_NOT_AVAILABLE_ERROR));
    }

    @Test
    public void shouldUseTheBackupDataCreatedByStep() {
        PrivilegedConfigClient client = this.environmentHelper.getPrivilegedClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(client);
        MigrationEnvironmentHelper.DoubleAliasIndex managementTenant = this.environmentHelper.doubleAliasForTenant("management");
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX, managementTenant, MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX);
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "should-be-moved-to-backup-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        catalog.insertSpace(MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX.indexName(), "kirk-tenant-space");
        catalog.insertSpace(managementTenant.indexName(), "management-tenant-space");
        this.populateDataIndicesViaStep();
        MatcherAssert.assertThat((Object)this.context.getDataIndicesNames(), (Matcher)Matchers.hasSize((int)2));
        StepRepository stepRepository = new StepRepository(client);
        this.createBackupByStep(stepRepository);
        this.environmentHelper.assertThatDocumentExists(this.context.getBackupIndexName(), "space:should-be-moved-to-backup-space");
        this.environmentHelper.addDataMigrationMarkerToTheIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
        this.populateBackupIndicesViaStepExecution(stepRepository);
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)1));
        CopyDataToTempIndexStep step = CrossStepTest.createCopyDataToTempIndexStep(client);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        String tempIndex = this.context.getTempIndexName();
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(tempIndex), (Matcher)Matchers.equalTo((Object)2L));
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:should-be-moved-to-backup-space");
        this.environmentHelper.assertThatDocumentExists(tempIndex, "space:management-tenant-space__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentDoesNotExist(tempIndex, "space:kirk-tenant-space__sg_ten__3292183_kirk");
    }

    @Test
    public void shouldCloneIndexMappings() throws Exception {
        StepRepository stepRepository = new StepRepository(this.environmentHelper.getPrivilegedClient());
        IndexSettingsManager indexSettingsManager = new IndexSettingsManager(stepRepository);
        CreateTempIndexStep step = new CreateTempIndexStep(indexSettingsManager);
        GenericRestClient client = cluster.getAdminCertRestClient();
        String sourceIndexName = "source_index_with_mappings";
        String destinationIndexName = "destination_index";
        this.context = (DataMigrationContext)Mockito.mock(DataMigrationContext.class);
        Mockito.when((Object)this.context.getGlobalTenantIndexName()).thenReturn((Object)sourceIndexName);
        Mockito.when((Object)this.context.getTempIndexName()).thenReturn((Object)destinationIndexName);
        String path = "/" + sourceIndexName + "?timeout=60s";
        String createIndexBody = "{\n\t\"mappings\": {\n\t\t\"dynamic\": \"strict\",\n\t\t\"properties\": {\n\t\t\t\"my_test_property\": {\n\t\t\t\t\"type\": \"keyword\"\n\t\t\t}\n\t\t}\n\t}\n}\n";
        GenericRestClient.HttpResponse response = client.putJson(path, createIndexBody, new Header[0]);
        MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        DocNode clonedMappings = this.environmentHelper.getIndexMappingsAsDocNode(destinationIndexName);
        MatcherAssert.assertThat((Object)clonedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.dynamic", (Object)"strict"));
        MatcherAssert.assertThat((Object)clonedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.my_test_property.type", (Object)"keyword"));
        MatcherAssert.assertThat((Object)clonedMappings, (Matcher)DocNodeMatchers.containsValue((String)"$.properties.sg_data_migrated_to_8_8_0.type", (Object)"boolean"));
    }

    private void createBackupByStep(StepRepository stepRepository) {
        IndexSettingsManager indexSettingsManager = new IndexSettingsManager(stepRepository);
        CreateBackupOfGlobalIndexStep createBackupOfGlobalIndexStep = new CreateBackupOfGlobalIndexStep(stepRepository, indexSettingsManager);
        StepResult backupResult = createBackupOfGlobalIndexStep.execute(this.context);
        MatcherAssert.assertThat((Object)backupResult.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupCreated(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void populateDataIndicesViaStep() {
        PopulateTenantsStep step = this.createPopulateTenantsStep();
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    private void populateBackupIndicesViaStepExecution(StepRepository stepRepository) {
        PopulateBackupIndicesStep step = new PopulateBackupIndicesStep(stepRepository);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    private PopulateTenantsStep createPopulateTenantsStep() {
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        PrivilegedConfigClient privilegedConfigClient = this.environmentHelper.getPrivilegedClient();
        return new PopulateTenantsStep(configurationProvider, new StepRepository(privilegedConfigClient));
    }

    private void addMigrationMarkerToGlobalTenantIndexViaStep(IndexSettingsManager indexSettingsManager) {
        AddMigrationMarkerToGlobalTenantIndexStep step = new AddMigrationMarkerToGlobalTenantIndexStep(indexSettingsManager);
        StepResult result = step.execute(this.context);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    private static CopyDataToTempIndexStep createCopyDataToTempIndexStep(PrivilegedConfigClient client) {
        FeMultiTenancyConfigurationProvider configurationProvider = (FeMultiTenancyConfigurationProvider)cluster.getInjectable(FeMultiTenancyConfigurationProvider.class);
        StepRepository stepRepository = new StepRepository(client);
        IndexSettingsManager indexSettingsManager = new IndexSettingsManager(stepRepository);
        return new CopyDataToTempIndexStep(stepRepository, configurationProvider, indexSettingsManager);
    }
}

