/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.PopulateBackupIndicesStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepException;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import com.floragunn.searchsupport.junit.ThrowableAssert;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class PopulateBackupIndicesStepTest {
    private static final Logger log = LogManager.getLogger(PopulateBackupIndicesStepTest.class);
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(1990, 1, 1, 1, 1), ZoneOffset.UTC);
    private static final Clock CLOCK = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    public static final String BACKUP_INDEX_1 = "backup_fe_migration_to_8_8_0_1980_01_01_01_06_00";
    public static final String BACKUP_INDEX_2 = "backup_fe_migration_to_8_8_0_1990_01_01_01_02_00";
    public static final String BACKUP_INDEX_3 = "backup_fe_migration_to_8_8_0_1990_01_01_01_03_00";
    public static final String BACKUP_INDEX_4 = "backup_fe_migration_to_8_8_0_1990_01_01_01_04_00";
    public static final String BACKUP_INDEX_5 = "backup_fe_migration_to_8_8_0_2000_01_01_01_01_00";
    @Mock
    private StepRepository repository;
    @Mock
    private GetIndexResponse response;
    private DataMigrationContext context;
    private PopulateBackupIndicesStep step;

    @Before
    public void before() {
        this.step = new PopulateBackupIndicesStep(this.repository);
        this.context = new DataMigrationContext(new MigrationConfig(false), CLOCK);
    }

    @Test
    public void shouldSetEmptyBackupListInContext() {
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.empty());
        StepResult result = this.step.execute(this.context);
        log.info("Step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.notNullValue());
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.empty());
    }

    @Test
    public void shouldFindOneBackupIndex() {
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)new String[]{BACKUP_INDEX_1});
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepResult result = this.step.execute(this.context);
        log.info("Step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)1));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.containsInAnyOrder((Object[])new String[]{BACKUP_INDEX_1}));
    }

    @Test
    public void shouldFindManyBackupIndicesAndSortThemByDate() {
        String[] indices = new String[]{BACKUP_INDEX_3, BACKUP_INDEX_2, BACKUP_INDEX_4, BACKUP_INDEX_5, BACKUP_INDEX_1};
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)indices);
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepResult result = this.step.execute(this.context);
        log.info("Step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)indices.length));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{BACKUP_INDEX_5, BACKUP_INDEX_4, BACKUP_INDEX_3, BACKUP_INDEX_2, BACKUP_INDEX_1}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)BACKUP_INDEX_5));
    }

    @Test
    public void shouldSortAnotherBackupIndicesNames() {
        String[] indices = new String[]{BACKUP_INDEX_1, BACKUP_INDEX_2, BACKUP_INDEX_3, BACKUP_INDEX_5, BACKUP_INDEX_4};
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)indices);
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepResult result = this.step.execute(this.context);
        log.info("Step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.hasSize((int)indices.length));
        MatcherAssert.assertThat((Object)this.context.getBackupIndices(), (Matcher)Matchers.contains((Object[])new String[]{BACKUP_INDEX_5, BACKUP_INDEX_4, BACKUP_INDEX_3, BACKUP_INDEX_2, BACKUP_INDEX_1}));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)BACKUP_INDEX_5));
    }

    @Test
    public void shouldGetLatestBackupIndexName() {
        String[] indices = new String[]{BACKUP_INDEX_3, BACKUP_INDEX_4, BACKUP_INDEX_2};
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)indices);
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepResult result = this.step.execute(this.context);
        log.info("Step result '{}'.", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
        MatcherAssert.assertThat((Object)((String)this.context.getNewestExistingBackupIndex().orElseThrow()), (Matcher)Matchers.equalTo((Object)BACKUP_INDEX_4));
    }

    @Test
    public void shouldDetectIncorrectBackupIndexNamePrefix() {
        String[] indices = new String[]{BACKUP_INDEX_1, BACKUP_INDEX_2, BACKUP_INDEX_3, BACKUP_INDEX_5, BACKUP_INDEX_4, "not_backup_index"};
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)indices);
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INVALID_BACKUP_INDEX_NAME_ERROR));
    }

    @Test
    public void shouldDetectIncorrectBackupIndexNameDatePart() {
        String[] indices = new String[]{BACKUP_INDEX_1, BACKUP_INDEX_2, BACKUP_INDEX_3, "backup_fe_migration_to_8_8_0_1980_01_no_td_at_e0"};
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)indices);
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INVALID_DATE_IN_BACKUP_INDEX_NAME_ERROR));
    }

    @Test
    public void shouldDetectIncorrectBackupIndexNameWithNotExistingDate() {
        String[] indices = new String[]{BACKUP_INDEX_1, BACKUP_INDEX_2, BACKUP_INDEX_3, "backup_fe_migration_to_8_8_0_2000_02_35_01_01_00"};
        Mockito.when((Object)this.response.getIndices()).thenReturn((Object)indices);
        Mockito.when((Object)this.repository.findIndexByNameOrAlias(ArgumentMatchers.anyString())).thenReturn(Optional.of(this.response));
        StepException stepException = (StepException)ThrowableAssert.assertThatThrown(() -> this.step.execute(this.context), (Matcher[])new Matcher[]{Matchers.instanceOf(StepException.class)});
        MatcherAssert.assertThat((Object)stepException.getStatus(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.INVALID_DATE_IN_BACKUP_INDEX_NAME_ERROR));
    }
}

