/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.request.handler;

import com.floragunn.searchguard.enterprise.femt.request.handler.BulkRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.ClusterSearchShardsRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.DeleteRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.GetRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.IndexRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.MultiGetRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.RequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.SearchRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.UpdateByQueryRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.handler.UpdateRequestHandler;
import com.floragunn.searchguard.enterprise.femt.request.mapper.BulkMapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.GetMapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.MultiGetMapper;
import com.floragunn.searchguard.enterprise.femt.request.mapper.UpdateByQueryMapper;
import java.util.Objects;
import java.util.Optional;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.cluster.shards.ClusterSearchShardsRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.get.GetRequest;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.reindex.UpdateByQueryRequest;
import org.elasticsearch.indices.IndicesService;

public class RequestHandlerFactory {
    private final Client nodeClient;
    private final ThreadContext threadContext;
    private final ClusterService clusterService;
    private final IndicesService indicesService;

    public RequestHandlerFactory(Client nodeClient, ThreadContext threadContext, ClusterService clusterService, IndicesService indicesService) {
        this.nodeClient = Objects.requireNonNull(nodeClient, "nodeClient is required");
        this.threadContext = Objects.requireNonNull(threadContext, "threadContext is required");
        this.clusterService = Objects.requireNonNull(clusterService, "clusterService is required");
        this.indicesService = Objects.requireNonNull(indicesService, "indicesService is required");
    }

    public <T extends ActionRequest> Optional<RequestHandler<T>> requestHandlerFor(Object request) {
        RequestHandler handler = null;
        if (request instanceof IndexRequest) {
            handler = new IndexRequestHandler();
        } else if (request instanceof DeleteRequest) {
            handler = new DeleteRequestHandler();
        } else if (request instanceof SearchRequest) {
            handler = new SearchRequestHandler(this.nodeClient, this.threadContext);
        } else if (request instanceof GetRequest) {
            handler = new GetRequestHandler(this.nodeClient, this.threadContext, new GetMapper(this.clusterService, this.indicesService));
        } else if (request instanceof MultiGetRequest) {
            handler = new MultiGetRequestHandler(this.nodeClient, this.threadContext, new MultiGetMapper(new GetMapper(this.clusterService, this.indicesService)));
        } else if (request instanceof ClusterSearchShardsRequest) {
            handler = new ClusterSearchShardsRequestHandler(this.threadContext);
        } else if (request instanceof BulkRequest) {
            handler = new BulkRequestHandler(this.nodeClient, this.threadContext);
        } else if (request instanceof UpdateRequest) {
            handler = new UpdateRequestHandler(this.nodeClient, this.threadContext);
        } else if (request instanceof UpdateByQueryRequest) {
            handler = new UpdateByQueryRequestHandler(this.nodeClient, this.threadContext, new UpdateByQueryMapper(new BulkMapper()));
        }
        return Optional.ofNullable(handler);
    }
}

