/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableMap;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.authz.TenantManager;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.authz.config.ActionGroup;
import com.floragunn.searchguard.authz.config.MultiTenancyConfigurationProvider;
import com.floragunn.searchguard.configuration.CType;
import com.floragunn.searchguard.configuration.SgDynamicConfiguration;
import com.floragunn.searchguard.enterprise.femt.FeMultiTenancyTenantAccessMapper;
import com.floragunn.searchguard.enterprise.femt.KibanaActionsProvider;
import com.floragunn.searchguard.enterprise.femt.RoleBasedTenantAuthorization;
import com.floragunn.searchguard.enterprise.femt.TenantAuthorization;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.cstate.metrics.MetricsLevel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class FeMultiTenancyTenantAccessMapperTest {
    private static final ActionGroup.FlattenedIndex emptyActionGroups = new ActionGroup.FlattenedIndex(SgDynamicConfiguration.empty((CType)CType.ACTIONGROUPS));
    private static Actions actions = Actions.forTests();
    public static final boolean ADMIN_IS_USER = false;
    @Mock
    private MultiTenancyConfigurationProvider multiTenancyConfigurationProvider;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.multiTenancyConfigurationProvider.isMultiTenancyEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.multiTenancyConfigurationProvider.isGlobalTenantEnabled()).thenReturn((Object)true);
        Mockito.when((Object)this.multiTenancyConfigurationProvider.isPrivateTenantEnabled()).thenReturn((Object)true);
    }

    @Test
    public void wildcardTenantMapping() throws Exception {
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"all_access", (Object)DocNode.of((String)"tenant_permissions", List.of(ImmutableMap.of((Object)"tenant_patterns", List.of("*"), (Object)"allowed_actions", List.of("*"))))), (CType)CType.ROLES, null).get();
        ImmutableSet tenants = ImmutableSet.of((Object)"my_tenant", (Object)"test");
        TenantManager tenantManager = new TenantManager((Set)tenants, this.multiTenancyConfigurationProvider);
        RoleBasedTenantAuthorization tenantAuthorization = new RoleBasedTenantAuthorization(roles, emptyActionGroups, actions, tenantManager, MetricsLevel.NONE);
        FeMultiTenancyTenantAccessMapper mapper = new FeMultiTenancyTenantAccessMapper(tenantManager, (TenantAuthorization)tenantAuthorization, actions);
        User user = User.forUser((String)"user_name").searchGuardRoles(new String[]{"all_access"}).build();
        Map accessToTenants = mapper.mapTenantsAccess(user, false, (Set)ImmutableSet.of((Object)"all_access"));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.aMapWithSize((int)3));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)"my_tenant", (Object)true));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)"test", (Object)true));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)user.getName(), (Object)true));
    }

    @Test
    public void tenantMappingByName() throws Exception {
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"access_to_some_tenants", (Object)DocNode.of((String)"tenant_permissions", List.of(ImmutableMap.of((Object)"tenant_patterns", List.of("write_tenant"), (Object)"allowed_actions", List.of(KibanaActionsProvider.getKibanaWriteAction((Actions)actions).name())), ImmutableMap.of((Object)"tenant_patterns", List.of("read_tenant"), (Object)"allowed_actions", List.of(KibanaActionsProvider.getKibanaReadAction((Actions)actions).name()))))), (CType)CType.ROLES, null).get();
        ImmutableSet tenants = ImmutableSet.of((Object)"write_tenant", (Object[])new String[]{"read_tenant", "another_tenant"});
        TenantManager tenantManager = new TenantManager((Set)tenants, this.multiTenancyConfigurationProvider);
        RoleBasedTenantAuthorization tenantAuthorization = new RoleBasedTenantAuthorization(roles, emptyActionGroups, actions, tenantManager, MetricsLevel.NONE);
        FeMultiTenancyTenantAccessMapper mapper = new FeMultiTenancyTenantAccessMapper(tenantManager, (TenantAuthorization)tenantAuthorization, actions);
        User user = User.forUser((String)"user_name").searchGuardRoles(new String[]{"access_to_some_tenants"}).build();
        Map accessToTenants = mapper.mapTenantsAccess(user, false, (Set)ImmutableSet.of((Object)"access_to_some_tenants"));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.aMapWithSize((int)3));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)"write_tenant", (Object)true));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)"read_tenant", (Object)false));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)user.getName(), (Object)true));
    }

    @Test
    public void shouldNotReturnPrivateTenantWhenItsDisabled() throws Exception {
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"access_to_some_tenants", (Object)DocNode.of((String)"tenant_permissions", List.of(ImmutableMap.of((Object)"tenant_patterns", List.of("write_tenant"), (Object)"allowed_actions", List.of(KibanaActionsProvider.getKibanaWriteAction((Actions)actions).name())), ImmutableMap.of((Object)"tenant_patterns", List.of("read_tenant"), (Object)"allowed_actions", List.of(KibanaActionsProvider.getKibanaReadAction((Actions)actions).name()))))), (CType)CType.ROLES, null).get();
        ImmutableSet tenants = ImmutableSet.of((Object)"write_tenant", (Object[])new String[]{"read_tenant", "another_tenant"});
        Mockito.when((Object)this.multiTenancyConfigurationProvider.isPrivateTenantEnabled()).thenReturn((Object)false);
        TenantManager tenantManager = new TenantManager((Set)tenants, this.multiTenancyConfigurationProvider);
        RoleBasedTenantAuthorization tenantAuthorization = new RoleBasedTenantAuthorization(roles, emptyActionGroups, actions, tenantManager, MetricsLevel.NONE);
        FeMultiTenancyTenantAccessMapper mapper = new FeMultiTenancyTenantAccessMapper(tenantManager, (TenantAuthorization)tenantAuthorization, actions);
        User user = User.forUser((String)"user_name").searchGuardRoles(new String[]{"access_to_some_tenants"}).build();
        Map accessToTenants = mapper.mapTenantsAccess(user, false, (Set)ImmutableSet.of((Object)"access_to_some_tenants"));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.aMapWithSize((int)2));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)"write_tenant", (Object)true));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)"read_tenant", (Object)false));
    }

    @Test
    public void shouldNotReturnGlobalTenantWhenUserHasAccessButTenantIsDisabled() throws Exception {
        SgDynamicConfiguration roles = (SgDynamicConfiguration)SgDynamicConfiguration.fromMap((Map)DocNode.of((String)"access_to_global_tenant", (Object)DocNode.of((String)"tenant_permissions", List.of(ImmutableMap.of((Object)"tenant_patterns", List.of("SGS_GLOBAL_TENANT"), (Object)"allowed_actions", List.of(KibanaActionsProvider.getKibanaWriteAction((Actions)actions).name()))))), (CType)CType.ROLES, null).get();
        ImmutableSet tenants = ImmutableSet.of((Object)"SGS_GLOBAL_TENANT");
        Mockito.when((Object)this.multiTenancyConfigurationProvider.isGlobalTenantEnabled()).thenReturn((Object)false);
        TenantManager tenantManager = new TenantManager((Set)tenants, this.multiTenancyConfigurationProvider);
        RoleBasedTenantAuthorization tenantAuthorization = new RoleBasedTenantAuthorization(roles, emptyActionGroups, actions, tenantManager, MetricsLevel.NONE);
        FeMultiTenancyTenantAccessMapper mapper = new FeMultiTenancyTenantAccessMapper(tenantManager, (TenantAuthorization)tenantAuthorization, actions);
        User user = User.forUser((String)"user_name").searchGuardRoles(new String[]{"access_to_global_tenant"}).build();
        Map accessToTenants = mapper.mapTenantsAccess(user, false, (Set)ImmutableSet.of((Object)"access_to_global_tenant"));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.aMapWithSize((int)1));
        MatcherAssert.assertThat((Object)accessToTenants, (Matcher)Matchers.hasEntry((Object)user.getName(), (Object)true));
    }
}

