/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.ExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.FrontendObjectCatalog;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionSummary;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.persistence.IndexMigrationStateRepository;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.MigrationEnvironmentHelper;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchsupport.junit.matcher.DocNodeMatchers;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.http.Header;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.awaitility.Awaitility;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.client.internal.Client;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Rule;
import org.junit.Test;

public class MigrationApiTest {
    private static final Logger log = LogManager.getLogger(MigrationApiTest.class);
    private static final String MIGRATION_STATE_DOC_ID = "migration_8_8_0";
    private IndexMigrationStateRepository indexMigrationStateRepository;
    @ClassRule
    public static LocalCluster.Embedded cluster = new LocalCluster.Builder().nodeSettings(new Object[]{"searchguard.unsupported.single_index_mt_enabled", true}).sslEnabled().resources("multitenancy").enterpriseModulesEnabled().frontendMultiTenancy(new TestSgConfig.FrontendMultiTenancy(false)).embedded().build();
    @Rule
    public final MigrationEnvironmentHelper environmentHelper = new MigrationEnvironmentHelper(cluster, Clock.systemDefaultZone());

    @Before
    public void before() {
        Client client = cluster.getInternalNodeClient();
        IndexMigrationStateRepository repository = new IndexMigrationStateRepository(PrivilegedConfigClient.adapt((Client)client));
        this.indexMigrationStateRepository = new IndexMigrationStateRepository(PrivilegedConfigClient.adapt((Client)client));
        if (this.indexMigrationStateRepository.isIndexCreated()) {
            Awaitility.await((String)"Data migration isn't in progress").atMost(Duration.ofSeconds(10L)).pollInterval(Duration.ofMillis(25L)).until(() -> {
                Optional executionSummary = this.indexMigrationStateRepository.findById(MIGRATION_STATE_DOC_ID);
                return executionSummary.map(summary -> !summary.isMigrationInProgress(LocalDateTime.now())).orElse(true);
            });
            if (repository.isIndexCreated()) {
                this.environmentHelper.deleteIndex(".sg_data_migration_state");
                this.assertThatMigrationStateIndexExists(false);
            }
        }
    }

    @Test
    public void shouldStartMigrationProcess() throws Exception {
        this.createTenantsAndSavedObjects(this.mediumAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Start migration response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)85L));
            GetIndexResponse getIndexResponse = this.environmentHelper.findHiddenIndexByName("backup_fe_migration_to_8_8_0_*").orElseThrow();
            MatcherAssert.assertThat((Object)getIndexResponse.getIndices(), (Matcher)Matchers.arrayWithSize((int)1));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[14].name", (Object)"Enable multitenancy"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[14].status", (Object)"ok"));
        }
    }

    @Test
    public void shouldMigrateSmallAmountOfData() throws Exception {
        this.createTenantsAndSavedObjects(this.smallAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Start migration response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            GetIndexResponse getIndexResponse = this.environmentHelper.findHiddenIndexByName("backup_fe_migration_to_8_8_0_*").orElseThrow();
            MatcherAssert.assertThat((Object)getIndexResponse.getIndices(), (Matcher)Matchers.arrayWithSize((int)1));
        }
    }

    @Test
    public void shouldRerunMigrationProcessUsingBackupIndex() throws Exception {
        this.createTenantsAndSavedObjects(this.smallAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("First migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            Client nodeClient = cluster.getInternalNodeClient();
            FrontendObjectCatalog catalog = new FrontendObjectCatalog(PrivilegedConfigClient.adapt((Client)nodeClient));
            catalog.insertIndexPattern(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
            response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Second migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            GetIndexResponse getIndexResponse = this.environmentHelper.findHiddenIndexByName("backup_fe_migration_to_8_8_0_*").orElseThrow();
            MatcherAssert.assertThat((Object)getIndexResponse.getIndices(), (Matcher)Matchers.arrayWithSize((int)1));
        }
    }

    @Test
    public void shouldRerunMigrationThreeTimes() throws Exception {
        this.createTenantsAndSavedObjects(this.smallAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("First migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            Client nodeClient = cluster.getInternalNodeClient();
            FrontendObjectCatalog catalog = new FrontendObjectCatalog(PrivilegedConfigClient.adapt((Client)nodeClient));
            catalog.insertIndexPattern(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
            response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Second migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            nodeClient = cluster.getInternalNodeClient();
            catalog = new FrontendObjectCatalog(PrivilegedConfigClient.adapt((Client)nodeClient));
            catalog.insertIndexPattern(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), 100);
            response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Third migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            GetIndexResponse getIndexResponse = this.environmentHelper.findHiddenIndexByName("backup_fe_migration_to_8_8_0_*").orElseThrow();
            MatcherAssert.assertThat((Object)getIndexResponse.getIndices(), (Matcher)Matchers.arrayWithSize((int)1));
        }
    }

    @Test
    public void shouldRerunMigrationProcessAndCreateAdditionalBackupWhenGlobalTenantIndexContainsNotMigratedData() throws Exception {
        this.createTenantsAndSavedObjects(this.smallAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("First migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            Client nodeClient = cluster.getInternalNodeClient();
            FrontendObjectCatalog catalog = new FrontendObjectCatalog(PrivilegedConfigClient.adapt((Client)nodeClient));
            this.environmentHelper.deleteIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
            this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
            String spaceId = (String)catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "global_default").get(0);
            response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Second migration run response '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            this.assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex();
            GetIndexResponse getIndexResponse = this.environmentHelper.findHiddenIndexByName("backup_fe_migration_to_8_8_0_*").orElseThrow();
            if (log.isDebugEnabled()) {
                String indices = String.join((CharSequence)", ", getIndexResponse.getIndices());
                log.debug("Backup indices created when migration process is run twice '{}'", (Object)indices);
            }
            MatcherAssert.assertThat((Object)getIndexResponse.getIndices(), (Matcher)Matchers.arrayWithSize((int)2));
            String spaceSource = this.environmentHelper.getDocumentSource(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), spaceId).orElseThrow();
            for (String backupIndex : getIndexResponse.getIndices()) {
                this.environmentHelper.assertThatDocumentExists(backupIndex, spaceId);
                String backupSource = this.environmentHelper.getDocumentSource(backupIndex, spaceId).orElseThrow();
                MatcherAssert.assertThat((Object)backupSource, (Matcher)Matchers.equalTo((Object)spaceSource));
            }
        }
    }

    @Test
    @Ignore
    public void shouldMigrateLargeAmountOfData() throws Exception {
        this.createTenantsAndSavedObjects(this.largeAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Start migration response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)80000L));
        }
    }

    @Test
    @Ignore
    public void shouldMigrateHugeAmountOfData() throws Exception {
        this.createTenantsAndSavedObjects(this.hugeAmountOfData());
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            DocNode body = DocNode.EMPTY;
            GenericRestClient.HttpResponse response = client.postJson("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", (Map)body, new Header[0]);
            log.info("Start migration response status '{}' and body '{}'.", (Object)response.getStatusCode(), (Object)response.getBody());
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)800000L));
        }
    }

    @Test
    public void getMigrationState_shouldReturnNotFound_indexContainingMigrationStateDoesNotExist() throws Exception {
        this.assertThatMigrationStateIndexExists(false);
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
        }
    }

    @Test
    public void getMigrationState_shouldReturnNotFound_indexContainingMigrationStateIsEmpty() throws Exception {
        this.indexMigrationStateRepository.createIndex();
        this.assertThatMigrationStateIndexExists(true);
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)404));
        }
    }

    @Test
    public void getMigrationState_shouldReturnMigrationState_migrationStateDocExists() throws Exception {
        ZonedDateTime date = ZonedDateTime.of(2023, 10, 6, 10, 10, 10, 10, ZoneOffset.UTC);
        MigrationExecutionSummary migrationExecutionSummary = new MigrationExecutionSummary(LocalDateTime.from(date), ExecutionStatus.IN_PROGRESS, "temp-index", "backup-index", ImmutableList.of((Object)new StepExecutionSummary(1L, LocalDateTime.from(date.plusMinutes(2L)), "step-name", StepExecutionStatus.OK, "msg", "details")), null);
        this.saveMigrationState(migrationExecutionSummary);
        this.assertThatMigrationStateIndexExists(true);
        try (GenericRestClient client = cluster.getAdminCertRestClient();){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/config/fe_multi_tenancy/data_migration/8_8_0", new Header[0]);
            MatcherAssert.assertThat((Object)response.getStatusCode(), (Matcher)Matchers.equalTo((Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"status", (Object)200));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.data", (int)5));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.start_time", (Object)"2023-10-06T10:10:10.00000001Z"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.status", (Object)"in_progress"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.temp_index_name", (Object)"temp-index"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsFieldPointedByJsonPath((String)"$.data", (String)"stages"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.data.stages", (int)1));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.docNodeSizeEqualTo((String)"$.data.stages[0]", (int)6));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[0].start_time", (Object)"2023-10-06T10:12:10.00000001Z"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[0].name", (Object)"step-name"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[0].status", (Object)"ok"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[0].message", (Object)"msg"));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[0].number", (Object)1));
            MatcherAssert.assertThat((Object)response.getBodyAsDocNode(), (Matcher)DocNodeMatchers.containsValue((String)"$.data.stages[0].details", (Object)"details"));
        }
    }

    private void assertThatOnlySmallMigratedDatasetIsPresentInGlobalTenantIndex() {
        MatcherAssert.assertThat((Object)this.environmentHelper.countDocumentInIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName()), (Matcher)Matchers.equalTo((Object)28L));
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:global_default");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__191795427_performancereviews");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-738948632_performancereviews");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-634608247_abcdef22");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__580139487_admtenant");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1139640511_admin1");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-152937574_admintenant");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-523190050_businessintelligence");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1242674146_commandtenant");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1554582075_dept01");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1554582076_dept02");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1554582077_dept03");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1554582078_dept04");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1554582079_dept05");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1419750584_enterprisetenant");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-853258278_finance");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1992298040_financemanagement");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1592542611_humanresources");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1482524924_kibana712aliascreationtest");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-815674808_kibana712aliastest");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-2014056171_kltentro");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-2014056163_kltentrw");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1799980989_management");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__1593390681_performancedata");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1386441184_praxisro");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1386441176_praxisrw");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1754201467_testtenantro");
        this.environmentHelper.assertThatDocumentExists(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "space:configured_default__sg_ten__-1754201459_testtenantrw");
    }

    private List<MigrationEnvironmentHelper.DoubleAliasIndex> createTenantsAndSavedObjects(TenantDataProvider dataProvider) {
        List<MigrationEnvironmentHelper.DoubleAliasIndex> tenants = this.environmentHelper.findIndicesForTenantsDefinedInConfigurationWithoutGlobal();
        this.environmentHelper.createIndex(tenants);
        ArrayList<MigrationEnvironmentHelper.DoubleAliasIndex> createdIndices = new ArrayList<MigrationEnvironmentHelper.DoubleAliasIndex>(tenants);
        Client client = cluster.getInternalNodeClient();
        FrontendObjectCatalog catalog = new FrontendObjectCatalog(PrivilegedConfigClient.adapt((Client)client));
        for (MigrationEnvironmentHelper.DoubleAliasIndex index : tenants) {
            dataProvider.configuredTenant(catalog, index.indexName());
        }
        this.environmentHelper.createIndex(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        createdIndices.add(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX);
        dataProvider.globalTenant(catalog, MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName());
        ImmutableList privateUserTenants = ImmutableList.of((Object)MigrationEnvironmentHelper.PRIVATE_USER_KIRK_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_1_INDEX, (Object)MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_2_INDEX, (Object[])new MigrationEnvironmentHelper.DoubleAliasIndex[]{MigrationEnvironmentHelper.PRIVATE_USER_LUKASZ_3_INDEX});
        this.environmentHelper.createIndex((List<MigrationEnvironmentHelper.DoubleAliasIndex>)privateUserTenants);
        createdIndices.addAll((Collection<MigrationEnvironmentHelper.DoubleAliasIndex>)privateUserTenants);
        for (MigrationEnvironmentHelper.DoubleAliasIndex index : privateUserTenants) {
            dataProvider.privateUserTenant(catalog, index.indexName());
        }
        return createdIndices;
    }

    private TenantDataProvider mediumAmountOfData() {
        return new TenantDataProvider(){

            @Override
            public void globalTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "default", "custom", "detailed", "superglobal");
            }

            @Override
            public void configuredTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, "default", "custom", "detailed");
            }

            @Override
            public void privateUserTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, "default", "super_private");
            }
        };
    }

    private TenantDataProvider smallAmountOfData() {
        return new TenantDataProvider(){

            @Override
            public void globalTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(MigrationEnvironmentHelper.GLOBAL_TENANT_INDEX.indexName(), "global_default");
            }

            @Override
            public void configuredTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, "configured_default");
            }

            @Override
            public void privateUserTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, "user_private");
            }
        };
    }

    private TenantDataProvider largeAmountOfData() {
        return new TenantDataProvider(){

            @Override
            public void globalTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, 1000);
                catalog.insertIndexPattern(indexName, 1000);
                catalog.insertDashboard(indexName, 500);
            }

            @Override
            public void configuredTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, 1000);
                catalog.insertIndexPattern(indexName, 1000);
                catalog.insertDashboard(indexName, 500);
            }

            @Override
            public void privateUserTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, 1000);
                catalog.insertIndexPattern(indexName, 1000);
                catalog.insertDashboard(indexName, 500);
            }
        };
    }

    private TenantDataProvider hugeAmountOfData() {
        return new TenantDataProvider(){

            @Override
            public void globalTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, 10000);
                catalog.insertIndexPattern(indexName, 10000);
                catalog.insertDashboard(indexName, 5000);
            }

            @Override
            public void configuredTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, 10000);
                catalog.insertIndexPattern(indexName, 10000);
                catalog.insertDashboard(indexName, 5000);
            }

            @Override
            public void privateUserTenant(FrontendObjectCatalog catalog, String indexName) {
                catalog.insertSpace(indexName, 10000);
                catalog.insertIndexPattern(indexName, 10000);
                catalog.insertDashboard(indexName, 5000);
            }
        };
    }

    private void saveMigrationState(MigrationExecutionSummary migrationExecutionSummary) {
        this.indexMigrationStateRepository.create(MIGRATION_STATE_DOC_ID, migrationExecutionSummary);
    }

    private void assertThatMigrationStateIndexExists(boolean shouldExist) {
        Awaitility.await((String)"Index containing data migration state exists").atMost(Duration.ofSeconds(2L)).pollInterval(Duration.ofMillis(25L)).untilAsserted(() -> MatcherAssert.assertThat((Object)this.indexMigrationStateRepository.isIndexCreated(), (Matcher)Matchers.equalTo((Object)shouldExist)));
    }

    private static interface TenantDataProvider {
        public void globalTenant(FrontendObjectCatalog var1, String var2);

        public void configuredTenant(FrontendObjectCatalog var1, String var2);

        public void privateUserTenant(FrontendObjectCatalog var1, String var2);
    }
}

