/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps;

import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.DataMigrationContext;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.MigrationConfig;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepExecutionStatus;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.StepResult;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.TenantIndex;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.CheckIndicesStateStep;
import com.floragunn.searchguard.enterprise.femt.datamigration880.service.steps.StepRepository;
import java.time.Clock;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Answers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CheckIndicesStateStepTest {
    private static final Logger log = LogManager.getLogger(CheckIndicesStateStepTest.class);
    private static final ZonedDateTime NOW = ZonedDateTime.of(LocalDateTime.of(1990, 1, 1, 1, 1), ZoneOffset.UTC);
    private static final Clock CLOCK = Clock.fixed(NOW.toInstant(), ZoneOffset.UTC);
    public static final String TENANT_INDEX_1 = "tenant_index_1";
    public static final String TENANT_INDEX_2 = "tenant_index_2";
    public static final String TENANT_INDEX_3 = "tenant_index_3";
    public static final String TENANT_NAME_1 = "tenant name 1";
    public static final String TENANT_NAME_2 = "tenant name 2";
    public static final String TENANT_NAME_3 = "tenant name 3";
    public static final MigrationConfig STRICT_CONFIGURATION = new MigrationConfig(false);
    public static final MigrationConfig LENIENT_CONFIG = new MigrationConfig(true);
    public static final String BACKUP_INDEX_1 = "backup_index_0001";
    @Mock(answer=Answers.RETURNS_DEEP_STUBS)
    private StepRepository repository;
    private CheckIndicesStateStep step;

    @Before
    public void before() {
        this.step = new CheckIndicesStateStep(this.repository);
    }

    @Test
    public void shouldReportErrorWhenIndexStateIsUnavailable() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1)).thenReturn(null);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"Cannot retrieve index"));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_1));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
    }

    @Test
    public void shouldReturnSuccessResponseWhenIndexIsInGreenState() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.empty());
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1}).getIndex(TENANT_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldSearchForDataAndBackupIndexState() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.empty());
        context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_1));
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{BACKUP_INDEX_1}).getIndex(BACKUP_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReturnFailureResponseWhenBackupIndexIsInYellowState() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.empty());
        context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_1));
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{BACKUP_INDEX_1}).getIndex(BACKUP_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
    }

    @Test
    public void shouldReturnFailureResponseWhenBackupIndexIsInYellowStateAndDataIndexIsInGreenState() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_1));
        IndexStats indexStateTenantMock = (IndexStats)Mockito.mock(IndexStats.class);
        IndexStats indexStateBackupMock = (IndexStats)Mockito.mock(IndexStats.class);
        IndicesStatsResponse response = (IndicesStatsResponse)Mockito.mock(IndicesStatsResponse.class);
        Mockito.when((Object)this.repository.findIndexState((String[])Mockito.any(String[].class))).thenReturn((Object)response);
        Mockito.when((Object)response.getIndex(TENANT_INDEX_1)).thenReturn((Object)indexStateTenantMock);
        Mockito.when((Object)response.getIndex(BACKUP_INDEX_1)).thenReturn((Object)indexStateBackupMock);
        Mockito.when((Object)indexStateTenantMock.getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)indexStateBackupMock.getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"Index 'backup_index_0001' status is 'YELLOW' but GREEN status is required"));
    }

    @Test
    public void shouldReturnFailureResponseWhenBackupIndexIsInGreenStateAndDataIndexIsInYellowState() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.of((Object)BACKUP_INDEX_1));
        IndexStats indexStateTenantMock = (IndexStats)Mockito.mock(IndexStats.class);
        IndexStats indexStateBackupMock = (IndexStats)Mockito.mock(IndexStats.class);
        IndicesStatsResponse response = (IndicesStatsResponse)Mockito.mock(IndicesStatsResponse.class);
        Mockito.when((Object)this.repository.findIndexState((String[])Mockito.any(String[].class))).thenReturn((Object)response);
        Mockito.when((Object)response.getIndex(TENANT_INDEX_1)).thenReturn((Object)indexStateTenantMock);
        Mockito.when((Object)response.getIndex(BACKUP_INDEX_1)).thenReturn((Object)indexStateBackupMock);
        Mockito.when((Object)indexStateTenantMock.getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        Mockito.when((Object)indexStateBackupMock.getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)"Index 'tenant_index_1' status is 'YELLOW' but GREEN status is required"));
    }

    @Test
    public void shouldReturnFailureResponseWhenIndexIsInYellowStateInStrictConfiguration() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.empty());
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1}).getIndex(TENANT_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_1));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.YELLOW.name()));
    }

    @Test
    public void shouldReturnFailureResponseWhenIndexIsInRedStateInStrictConfiguration() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.empty());
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1}).getIndex(TENANT_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_1));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.RED.name()));
    }

    @Test
    public void shouldReturnFailureResponseWhenIndexIsInRedStateInLenientConfiguration() {
        DataMigrationContext context = new DataMigrationContext(LENIENT_CONFIG, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.empty());
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1}).getIndex(TENANT_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_1));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.RED.name()));
    }

    @Test
    public void shouldReturnSuccessResponseWhenIndexIsInYellowStateInLenientConfiguration() {
        DataMigrationContext context = new DataMigrationContext(LENIENT_CONFIG, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1)));
        context.setBackupIndices(ImmutableList.empty());
        IndexStats indexStateMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1}).getIndex(TENANT_INDEX_1);
        Mockito.when((Object)indexStateMock.getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReturnSuccessResponseWhenAllIndicesAreGreen() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReturnFailureResponseWhenLastIndexIsYellow() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_3));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.YELLOW.name()));
    }

    @Test
    public void shouldReturnFailureResponseWhenTwoIndicesAreYellow() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_2));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_3));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.YELLOW.name()));
    }

    @Test
    public void shouldReturnSuccessResponseWhenAllIndicesAreYellowInLenientMode() {
        DataMigrationContext context = new DataMigrationContext(LENIENT_CONFIG, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)true));
    }

    @Test
    public void shouldReturnFailureResponseWhenIndicesContainThreeColorsInLenientMode() {
        DataMigrationContext context = new DataMigrationContext(LENIENT_CONFIG, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_3));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.RED.name()));
    }

    @Test
    public void shouldReturnFailureResponseWhenIndicesContainThreeColorsInStrictMode() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.GREEN);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.YELLOW);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_2));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_3));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.RED.name()));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.YELLOW.name()));
    }

    @Test
    public void shouldReturnFailureResponseWhenAllIndicesAreRedInStrictMode() {
        DataMigrationContext context = new DataMigrationContext(STRICT_CONFIGURATION, CLOCK);
        context.setTenantIndices(ImmutableList.of((Object)new TenantIndex(TENANT_INDEX_1, TENANT_NAME_1), (Object)new TenantIndex(TENANT_INDEX_2, TENANT_NAME_2), (Object)new TenantIndex(TENANT_INDEX_3, TENANT_NAME_3), (Object[])new TenantIndex[0]));
        context.setBackupIndices(ImmutableList.empty());
        IndicesStatsResponse responseMock = this.repository.findIndexState(new String[]{TENANT_INDEX_1, TENANT_INDEX_2, TENANT_INDEX_3});
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_1).getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_2).getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        Mockito.when((Object)responseMock.getIndex(TENANT_INDEX_3).getHealth()).thenReturn((Object)ClusterHealthStatus.RED);
        StepResult result = this.step.execute(context);
        log.debug("Step result '{}'", (Object)result);
        MatcherAssert.assertThat((Object)result.isSuccess(), (Matcher)Matchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)result.status(), (Matcher)Matchers.equalTo((Object)StepExecutionStatus.UNHEALTHY_INDICES_ERROR));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_1));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_2));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)TENANT_INDEX_3));
        MatcherAssert.assertThat((Object)result.details(), (Matcher)Matchers.containsString((String)ClusterHealthStatus.RED.name()));
    }
}

