/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt;

import com.floragunn.codova.documents.BasicJsonPathDefaultConfiguration;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.errors.MissingAttribute;
import com.floragunn.codova.validation.errors.ValidationError;
import com.floragunn.dlic.util.Roles;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.authc.session.ApiAuthenticationFrontend;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.user.Attributes;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.security.WeakKeyException;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

public class HTTPJwtAuthenticator
implements LegacyHTTPAuthenticator,
ApiAuthenticationFrontend {
    private static final Logger log = LogManager.getLogger(HTTPJwtAuthenticator.class);
    private static final String BEARER = "bearer ";
    private final JwtParser jwtParser;
    private final String jwtHeaderName;
    private final String jwtUrlParameter;
    private final String rolesKey;
    private final String subjectKey;
    private final String jsonSubjectPath;
    private final String jsonRolesPath;
    private final String requireAudience;
    private final String requireIssuer;
    private Configuration jsonPathConfig;
    private Map<String, JsonPath> attributeMapping;
    private final Pattern subjectPattern;
    private final ComponentState componentState;
    private final Deserializer<Map<String, ?>> jsonDeserializer;
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "jwt";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPJwtAuthenticator::new);
        }
    };

    public HTTPJwtAuthenticator(Settings settings, Path configPath) {
        JwtParser _jwtParser;
        block10: {
            this.componentState = new ComponentState(0, "authentication_frontend", "jwt", HTTPJwtAuthenticator.class).initialized().requiresEnterpriseLicense();
            this.jsonDeserializer = new Deserializer<Map<String, ?>>(){

                public Map<String, ?> deserialize(byte[] bytes) throws DeserializationException {
                    try {
                        return DocReader.json().readObject(bytes);
                    }
                    catch (DocumentParseException | UnexpectedDocumentStructureException e) {
                        throw new DeserializationException(e.getMessage(), e);
                    }
                }
            };
            this.subjectPattern = HTTPJwtAuthenticator.getSubjectPattern(settings);
            _jwtParser = null;
            try {
                String signingKey = settings.get("signing_key");
                if (signingKey == null || signingKey.length() == 0) {
                    log.error("signingKey must not be null or empty. JWT authentication will not work");
                    break block10;
                }
                signingKey = signingKey.replace("-----BEGIN PUBLIC KEY-----\n", "");
                signingKey = signingKey.replace("-----END PUBLIC KEY-----", "");
                byte[] decoded = (byte[])Decoders.BASE64.decode((Object)signingKey);
                PublicKey key = null;
                try {
                    key = HTTPJwtAuthenticator.getPublicKey(decoded, "RSA");
                }
                catch (Exception e) {
                    log.debug("No public RSA key, try other algos ({})", (Object)e.toString());
                }
                try {
                    key = HTTPJwtAuthenticator.getPublicKey(decoded, "EC");
                }
                catch (Exception e) {
                    log.debug("No public ECDSA key, try other algos ({})", (Object)e.toString());
                }
                _jwtParser = key != null ? Jwts.parser().setSigningKey((Key)key).deserializeJsonWith(this.jsonDeserializer) : Jwts.parser().setSigningKey(decoded).deserializeJsonWith(this.jsonDeserializer);
            }
            catch (Throwable e) {
                log.error("Error creating JWT authenticator: " + e + ". JWT authentication will not work", e);
            }
        }
        this.jwtUrlParameter = settings.get("jwt_url_parameter");
        this.jwtHeaderName = settings.get("jwt_header", "Authorization");
        this.rolesKey = settings.get("roles_key");
        this.subjectKey = settings.get("subject_key");
        this.jsonRolesPath = settings.get("roles_path");
        this.jsonSubjectPath = settings.get("subject_path");
        this.requireAudience = settings.get("required_audience");
        this.requireIssuer = settings.get("required_issuer");
        if (this.requireAudience != null) {
            _jwtParser.requireAudience(this.requireAudience);
        }
        if (this.requireIssuer != null) {
            _jwtParser.requireIssuer(this.requireIssuer);
        }
        this.jwtParser = _jwtParser;
        this.attributeMapping = Attributes.getAttributeMapping((Settings)settings.getAsSettings("map_claims_to_user_attrs"));
        if (this.subjectKey != null && this.jsonSubjectPath != null || this.rolesKey != null && this.jsonRolesPath != null) {
            throw new IllegalStateException("Both, subject_key and subject_path or roles_key and roles_path have simultaneously provided. Please provide only one combination.");
        }
        this.jsonPathConfig = BasicJsonPathDefaultConfiguration.builder().options(new Option[]{Option.ALWAYS_RETURN_LIST}).build();
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) throws ElasticsearchSecurityException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(() -> this.extractCredentials0(request));
    }

    public AuthCredentials extractCredentials(Map<String, Object> request) throws ElasticsearchSecurityException, ConfigValidationException {
        String jwtString;
        String string = jwtString = request.containsKey("jwt") ? String.valueOf(request.get("jwt")) : null;
        if (jwtString == null) {
            throw new ConfigValidationException((ValidationError)new MissingAttribute("jwt"));
        }
        return this.extractCredentials(jwtString);
    }

    private AuthCredentials extractCredentials0(RestRequest request) {
        if (this.jwtParser == null) {
            log.error("Missing Signing Key. JWT authentication will not work");
            return null;
        }
        String jwtToken = request.header(this.jwtHeaderName);
        if ((jwtToken == null || jwtToken.isEmpty()) && this.jwtUrlParameter != null) {
            jwtToken = request.param(this.jwtUrlParameter);
        } else {
            request.param(this.jwtUrlParameter);
        }
        if (jwtToken == null || jwtToken.length() == 0) {
            if (log.isDebugEnabled()) {
                log.debug("No JWT token found in '{}' {} header", (Object)(this.jwtUrlParameter == null ? this.jwtHeaderName : this.jwtUrlParameter), (Object)(this.jwtUrlParameter == null ? "header" : "url parameter"));
            }
            return null;
        }
        int index = jwtToken.toLowerCase().indexOf(BEARER);
        if (index > -1) {
            jwtToken = jwtToken.substring(index + BEARER.length());
        } else if (log.isDebugEnabled()) {
            log.debug("No Bearer scheme found in header");
        }
        return this.extractCredentials(jwtToken);
    }

    private AuthCredentials extractCredentials(String jwtToken) {
        if (this.jwtParser == null) {
            log.error("Missing Signing Key. JWT authentication will not work");
            return null;
        }
        try {
            Claims claims;
            try {
                claims = AccessController.doPrivileged(() -> (Claims)this.jwtParser.parseClaimsJws(jwtToken).getBody());
            }
            catch (PrivilegedActionException e) {
                if (e.getCause() instanceof Exception) {
                    throw (Exception)e.getCause();
                }
                throw new RuntimeException(e.getCause());
            }
            String subject = this.extractSubject(claims);
            if (subject == null) {
                log.error("No subject found in JWT token");
                return null;
            }
            String[] roles = this.extractRoles(claims);
            return AuthCredentials.forUser((String)subject).authenticatorType(this.getType()).backendRoles(roles).attributesByJsonPath(this.attributeMapping, (Object)claims).prefixOldAttributes("attr.jwt.", (Map)claims).complete().build();
        }
        catch (WeakKeyException e) {
            log.error("Cannot authenticate user with JWT because of " + (Object)((Object)e), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            if (log.isDebugEnabled()) {
                log.debug("Invalid or expired JWT token.", (Throwable)e);
            }
            return null;
        }
    }

    public String getType() {
        return "jwt";
    }

    protected String extractSubject(Claims claims) {
        Object subjectObject;
        String subject = claims.getSubject();
        if (this.subjectKey != null) {
            subjectObject = claims.get(this.subjectKey, Object.class);
            if (subjectObject == null) {
                log.warn("Failed to get subject from JWT claims, check if subject_key '{}' is correct.", (Object)this.subjectKey);
                return null;
            }
            if (!(subjectObject instanceof String)) {
                log.warn("Expected type String for roles in the JWT for subject_key {}, but value was '{}' ({}). Will convert this value to String.", (Object)this.subjectKey, subjectObject, subjectObject.getClass());
            }
            subject = String.valueOf(subjectObject);
        } else if (this.jsonSubjectPath != null) {
            try {
                subjectObject = JsonPath.using((Configuration)BasicJsonPathDefaultConfiguration.defaultConfiguration()).parse((Object)claims).read(this.jsonSubjectPath, new Predicate[0]);
                if (subjectObject == null) {
                    log.error("The subject is null: " + this.jsonSubjectPath);
                    return null;
                }
                if (subjectObject instanceof Collection) {
                    Collection subjectCollection = (Collection)subjectObject;
                    if (subjectCollection.size() == 0) {
                        log.error("The subject is empty: " + this.jsonSubjectPath);
                        return null;
                    }
                    if (subjectCollection.size() > 1) {
                        log.error("More than one subject was found. Failing authentication: " + subjectObject + "; " + this.jsonSubjectPath);
                        return null;
                    }
                    subject = String.valueOf(subjectCollection.iterator().next());
                } else {
                    subject = String.valueOf(subjectObject);
                }
            }
            catch (PathNotFoundException e) {
                log.error("The provided JSON path {} could not be found ", (Object)this.jsonSubjectPath);
                return null;
            }
        }
        if (subject != null && this.subjectPattern != null) {
            Matcher matcher = this.subjectPattern.matcher(subject);
            if (!matcher.matches()) {
                log.warn("Subject " + subject + " does not match subject_pattern " + this.subjectPattern);
                return null;
            }
            if (matcher.groupCount() == 1) {
                subject = matcher.group(1);
            } else if (matcher.groupCount() > 1) {
                StringBuilder subjectBuilder = new StringBuilder();
                for (int i = 1; i <= matcher.groupCount(); ++i) {
                    if (matcher.group(i) == null) continue;
                    subjectBuilder.append(matcher.group(i));
                }
                subject = subjectBuilder.length() != 0 ? subjectBuilder.toString() : null;
            }
        }
        return subject;
    }

    protected String[] extractRoles(Claims claims) {
        if (this.rolesKey == null && this.jsonRolesPath == null) {
            return new String[0];
        }
        if (this.jsonRolesPath != null) {
            try {
                return Roles.split(JsonPath.using((Configuration)this.jsonPathConfig).parse((Object)claims).read(this.jsonRolesPath, new Predicate[0]));
            }
            catch (PathNotFoundException e) {
                log.error("The provided JSON path {} could not be found ", (Object)this.jsonRolesPath);
                return new String[0];
            }
        }
        Object rolesObject = claims.get(this.rolesKey, Object.class);
        if (rolesObject == null) {
            log.warn("Failed to get roles from JWT claims with roles_key '{}'. Check if this key is correct and available in the JWT payload.", (Object)this.rolesKey);
            return new String[0];
        }
        return Roles.split(rolesObject);
    }

    private static PublicKey getPublicKey(byte[] keyBytes, String algo) throws NoSuchAlgorithmException, InvalidKeySpecException {
        X509EncodedKeySpec spec = new X509EncodedKeySpec(keyBytes);
        KeyFactory kf = KeyFactory.getInstance(algo);
        return kf.generatePublic(spec);
    }

    private static Pattern getSubjectPattern(Settings settings) {
        String patternString = settings.get("subject_pattern");
        if (patternString == null) {
            return null;
        }
        try {
            return Pattern.compile(patternString);
        }
        catch (PatternSyntaxException e) {
            log.error("Invalid regular expression for subject_pattern: " + patternString, (Throwable)e);
            return null;
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }
}

