/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.saml;

import com.floragunn.dlic.auth.http.jwt.AbstractHTTPJwtAuthenticator;
import com.floragunn.dlic.auth.http.saml.AuthTokenProcessorHandler;
import com.floragunn.dlic.auth.http.saml.Saml2SettingsProvider;
import com.floragunn.dlic.auth.http.saml.SamlFilesystemMetadataResolver;
import com.floragunn.dlic.auth.http.saml.SamlHTTPMetadataResolver;
import com.floragunn.dlic.auth.http.saml.SamlNameIdFormat;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.TypedComponent;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.authc.legacy.LegacyHTTPAuthenticator;
import com.floragunn.searchguard.enterprise.auth.oidc.BadCredentialsException;
import com.floragunn.searchguard.enterprise.auth.oidc.KeyProvider;
import com.floragunn.searchguard.legacy.LegacyComponentFactory;
import com.floragunn.searchguard.support.PemKeyReader;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.PrivilegedCode;
import com.floragunn.searchsupport.cstate.ComponentState;
import com.google.common.base.Strings;
import com.onelogin.saml2.authn.AuthnRequest;
import com.onelogin.saml2.logout.LogoutRequest;
import com.onelogin.saml2.settings.Saml2Settings;
import com.onelogin.saml2.util.Util;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Path;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivateKey;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.component.DestructableComponent;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.opensaml.core.config.InitializationException;
import org.opensaml.core.config.InitializationService;
import org.opensaml.saml.config.impl.SAMLConfigurationInitializer;
import org.opensaml.saml.config.impl.XMLObjectProviderInitializer;
import org.opensaml.saml.metadata.resolver.MetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.AbstractReloadingMetadataResolver;

@Deprecated
public class HTTPSamlAuthenticator
implements LegacyHTTPAuthenticator,
AutoCloseable {
    protected static final Logger log = LogManager.getLogger(HTTPSamlAuthenticator.class);
    private static boolean openSamlInitialized = false;
    private String subjectKey;
    private String rolesKey;
    private String kibanaRootUrl;
    private String idpMetadataUrl;
    private String idpMetadataFile;
    private String spSignatureAlgorithm;
    private Boolean useForceAuthn;
    private PrivateKey spSignaturePrivateKey;
    private Saml2SettingsProvider saml2SettingsProvider;
    private MetadataResolver metadataResolver;
    private AuthTokenProcessorHandler authTokenProcessorHandler;
    private HTTPJwtAuthenticator httpJwtAuthenticator;
    private Settings jwtSettings;
    private boolean checkIssuer;
    private final ComponentState componentState = new ComponentState(0, "authentication_frontend", "saml", HTTPSamlAuthenticator.class).initialized().requiresEnterpriseLicense();
    public static TypedComponent.Info<LegacyHTTPAuthenticator> INFO = new TypedComponent.Info<LegacyHTTPAuthenticator>(){

        public Class<LegacyHTTPAuthenticator> getType() {
            return LegacyHTTPAuthenticator.class;
        }

        public String getName() {
            return "saml";
        }

        public TypedComponent.Factory<LegacyHTTPAuthenticator> getFactory() {
            return LegacyComponentFactory.adapt(HTTPSamlAuthenticator::new);
        }
    };

    public HTTPSamlAuthenticator(Settings settings, Path configPath) {
        try {
            HTTPSamlAuthenticator.ensureOpenSamlInitialization();
            this.rolesKey = settings.get("roles_key");
            this.subjectKey = settings.get("subject_key");
            this.kibanaRootUrl = settings.get("kibana_url");
            this.idpMetadataUrl = settings.get("idp.metadata_url");
            this.idpMetadataFile = settings.get("idp.metadata_file");
            this.spSignatureAlgorithm = settings.get("sp.signature_algorithm", "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
            this.spSignaturePrivateKey = this.getSpSignaturePrivateKey(settings, configPath);
            this.useForceAuthn = settings.getAsBoolean("sp.forceAuthn", null);
            this.checkIssuer = settings.getAsBoolean("check_issuer", Boolean.TRUE);
            if (this.rolesKey == null || this.rolesKey.length() == 0) {
                log.warn("roles_key is not configured, will only extract subject from SAML");
                this.rolesKey = null;
            }
            if (this.subjectKey == null || this.subjectKey.length() == 0) {
                this.subjectKey = null;
            }
            if (this.kibanaRootUrl == null) {
                throw new RuntimeException("kibana_url is unconfigured");
            }
            if (this.idpMetadataUrl == null && this.idpMetadataFile == null) {
                throw new RuntimeException("idp.metadata_url and idp.metadata_file are unconfigured");
            }
            this.metadataResolver = this.createMetadataResolver(settings, configPath);
            this.saml2SettingsProvider = new Saml2SettingsProvider(settings, this.metadataResolver);
            try {
                this.saml2SettingsProvider.getCached();
            }
            catch (Exception e) {
                log.debug("Exception while initializing Saml2SettingsProvider. Possibly, the IdP is unreachable right now. This is recoverable by a meta data refresh.", (Throwable)e);
            }
            this.jwtSettings = this.createJwtAuthenticatorSettings(settings);
            this.authTokenProcessorHandler = new AuthTokenProcessorHandler(settings, this.jwtSettings, this.saml2SettingsProvider);
            this.httpJwtAuthenticator = new HTTPJwtAuthenticator(this.jwtSettings, configPath);
        }
        catch (SettingsBasedSSLConfigurator.SSLConfigException | ComponentInitializationException | ResolverException e) {
            log.error("Error creating HTTPSamlAuthenticator: " + e + ". SAML authentication will not work", e);
            throw new RuntimeException(e);
        }
    }

    public AuthCredentials extractCredentials(RestRequest restRequest, ThreadContext threadContext) throws ElasticsearchSecurityException {
        if ("/_searchguard/api/authtoken".equals(restRequest.path())) {
            return null;
        }
        AuthCredentials authCredentials = this.httpJwtAuthenticator.extractCredentials(restRequest, threadContext);
        if ("/_searchguard/authinfo".equals(restRequest.path())) {
            this.initLogoutUrl(restRequest, threadContext, authCredentials);
        }
        return authCredentials;
    }

    public String getType() {
        return "saml";
    }

    public boolean reRequestAuthentication(RestChannel restChannel, AuthCredentials authCredentials) {
        try {
            RestRequest restRequest = restChannel.request();
            if ("/_searchguard/api/authtoken".equals(restRequest.path())) {
                String samlResponseBase64 = this.authTokenProcessorHandler.getSamlResponseBase64(restRequest);
                if (this.checkIssuer && !this.authTokenProcessorHandler.isResponseFromConfiguredEntity(samlResponseBase64)) {
                    return false;
                }
                if (this.authTokenProcessorHandler.handle(restRequest, restChannel)) {
                    return true;
                }
            }
            Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached();
            BytesRestResponse authenticateResponse = new BytesRestResponse(RestStatus.UNAUTHORIZED, "");
            authenticateResponse.addHeader("WWW-Authenticate", this.getWwwAuthenticateHeader(saml2Settings));
            restChannel.sendResponse((RestResponse)authenticateResponse);
            return true;
        }
        catch (Exception e) {
            log.error("Error in reRequestAuthentication()", (Throwable)e);
            return false;
        }
    }

    private String getWwwAuthenticateHeader(Saml2Settings saml2Settings) throws Exception {
        AuthnRequest authnRequest = this.buildAuthnRequest(saml2Settings);
        return "X-SG-IdP realm=\"Search Guard\" location=\"" + StringEscapeUtils.escapeJava((String)this.getSamlRequestRedirectBindingLocation(IdpEndpointType.SSO, saml2Settings, authnRequest.getEncodedAuthnRequest(Boolean.valueOf(true)))) + "\" requestId=\"" + StringEscapeUtils.escapeJava((String)authnRequest.getId()) + "\"";
    }

    private AuthnRequest buildAuthnRequest(Saml2Settings saml2Settings) {
        boolean forceAuthn = false;
        if (this.useForceAuthn != null) {
            forceAuthn = this.useForceAuthn;
        } else if (!this.isSingleLogoutAvailable(saml2Settings)) {
            forceAuthn = true;
        }
        return new AuthnRequest(saml2Settings, forceAuthn, false, true);
    }

    private PrivateKey getSpSignaturePrivateKey(Settings settings, Path configPath) {
        try {
            PrivateKey result = PemKeyReader.loadKeyFromStream((String)settings.get("sp.signature_private_key_password"), (InputStream)PemKeyReader.resolveStream((String)"sp.signature_private_key", (Settings)settings));
            if (result == null) {
                result = PemKeyReader.loadKeyFromFile((String)settings.get("sp.signature_private_key_password"), (String)PemKeyReader.resolve((String)"sp.signature_private_key_filepath", (Settings)settings, (Path)configPath, (boolean)false));
            }
            return result;
        }
        catch (Exception e) {
            throw new RuntimeException("Invalid value for sp.signature_private_key", e);
        }
    }

    private URL getIdpUrl(IdpEndpointType endpointType, Saml2Settings saml2Settings) {
        if (endpointType == IdpEndpointType.SSO) {
            return saml2Settings.getIdpSingleSignOnServiceUrl();
        }
        return saml2Settings.getIdpSingleLogoutServiceUrl();
    }

    private boolean isSingleLogoutAvailable(Saml2Settings saml2Settings) {
        return saml2Settings.getIdpSingleLogoutServiceUrl() != null;
    }

    @Override
    public void close() {
        if (this.metadataResolver instanceof DestructableComponent) {
            ((DestructableComponent)this.metadataResolver).destroy();
        }
    }

    static void ensureOpenSamlInitialization() {
        if (openSamlInitialized) {
            return;
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws InitializationException {
                    Thread thread = Thread.currentThread();
                    ClassLoader originalClassLoader = thread.getContextClassLoader();
                    try {
                        thread.setContextClassLoader(InitializationService.class.getClassLoader());
                        InitializationService.initialize();
                        new XMLObjectProviderInitializer().init();
                        new SAMLConfigurationInitializer().init();
                        new org.opensaml.xmlsec.config.impl.XMLObjectProviderInitializer().init();
                    }
                    finally {
                        thread.setContextClassLoader(originalClassLoader);
                    }
                    openSamlInitialized = true;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private AbstractReloadingMetadataResolver createMetadataResolver(Settings settings, Path configPath) throws ResolverException, SettingsBasedSSLConfigurator.SSLConfigException, ComponentInitializationException {
        AbstractReloadingMetadataResolver metadataResolver;
        try {
            metadataResolver = this.idpMetadataUrl != null ? (AbstractReloadingMetadataResolver)PrivilegedCode.execute(() -> new SamlHTTPMetadataResolver(settings, configPath), Exception.class) : (AbstractReloadingMetadataResolver)PrivilegedCode.execute(() -> new SamlFilesystemMetadataResolver(settings, configPath), Exception.class);
        }
        catch (Exception e) {
            if (e instanceof ResolverException) {
                throw (ResolverException)((Object)e);
            }
            if (e instanceof SettingsBasedSSLConfigurator.SSLConfigException) {
                throw (SettingsBasedSSLConfigurator.SSLConfigException)e;
            }
            if (e instanceof ComponentInitializationException) {
                throw (ComponentInitializationException)((Object)e);
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws ComponentInitializationException {
                    metadataResolver.initialize();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof ComponentInitializationException) {
                throw (ComponentInitializationException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
        return metadataResolver;
    }

    private Settings createJwtAuthenticatorSettings(Settings settings) {
        Settings.Builder settingsBuilder = Settings.builder();
        Settings jwtSettings = settings.getAsSettings("jwt");
        settingsBuilder.put(jwtSettings);
        if (jwtSettings.get("roles_key") == null && settings.get("roles_key") != null) {
            settingsBuilder.put("roles_key", "roles");
        }
        if (jwtSettings.get("subject_key") == null) {
            settingsBuilder.put("subject_key", "sub");
        }
        return settingsBuilder.build();
    }

    String buildLogoutUrl(AuthCredentials authCredentials) {
        try {
            if (authCredentials == null) {
                return null;
            }
            Saml2Settings saml2Settings = this.saml2SettingsProvider.getCached();
            if (!this.isSingleLogoutAvailable(saml2Settings)) {
                return null;
            }
            String nameIdClaim = this.subjectKey == null ? "sub" : "saml_ni";
            String nameId = (String)authCredentials.getAttributes().get("attr.jwt." + nameIdClaim);
            String nameIdFormat = SamlNameIdFormat.getByShortName((String)authCredentials.getAttributes().get("attr.jwt.saml_nif")).getUri();
            String sessionIndex = (String)authCredentials.getAttributes().get("attr.jwt.saml_si");
            LogoutRequest logoutRequest = new LogoutRequest(saml2Settings, null, nameId, sessionIndex, nameIdFormat);
            return this.getSamlRequestRedirectBindingLocation(IdpEndpointType.SLO, saml2Settings, logoutRequest.getEncodedLogoutRequest(Boolean.valueOf(true)));
        }
        catch (Exception e) {
            log.error("Error while creating logout URL. Logout will be not available", (Throwable)e);
            return null;
        }
    }

    private void initLogoutUrl(RestRequest restRequest, ThreadContext threadContext, AuthCredentials authCredentials) {
        threadContext.putTransient("_sg_sso_logout_url", (Object)this.buildLogoutUrl(authCredentials));
    }

    private String getSamlRequestRedirectBindingLocation(IdpEndpointType idpEndpointType, Saml2Settings saml2Settings, String samlRequest) throws Exception {
        URL idpUrl = this.getIdpUrl(idpEndpointType, saml2Settings);
        if (Strings.isNullOrEmpty((String)idpUrl.getQuery())) {
            return this.getIdpUrl(idpEndpointType, saml2Settings) + "?" + this.getSamlRequestQueryString(samlRequest);
        }
        return this.getIdpUrl(idpEndpointType, saml2Settings) + "&" + this.getSamlRequestQueryString(samlRequest);
    }

    private String getSamlRequestQueryString(String samlRequest) throws Exception {
        if (this.spSignaturePrivateKey == null) {
            return "SAMLRequest=" + Util.urlEncoder((String)samlRequest);
        }
        String queryString = "SAMLRequest=" + Util.urlEncoder((String)samlRequest) + "&SigAlg=" + Util.urlEncoder((String)this.spSignatureAlgorithm);
        String signature = this.getSamlRequestQueryStringSignature(queryString);
        queryString = queryString + "&Signature=" + Util.urlEncoder((String)signature);
        return queryString;
    }

    private String getSamlRequestQueryStringSignature(String samlRequestQueryString) throws Exception {
        try {
            return Util.base64encoder((byte[])Util.sign((String)samlRequestQueryString, (PrivateKey)this.spSignaturePrivateKey, (String)this.spSignatureAlgorithm));
        }
        catch (Exception e) {
            throw new Exception("Error while signing SAML request", e);
        }
    }

    public ComponentState getComponentState() {
        return this.componentState;
    }

    private static enum IdpEndpointType {
        SSO,
        SLO;

    }

    class HTTPJwtAuthenticator
    extends AbstractHTTPJwtAuthenticator {
        private final ComponentState componentState;

        public HTTPJwtAuthenticator(Settings settings, Path configPath) {
            super(settings, configPath);
            this.componentState = new ComponentState(0, "authentication_frontend", "saml_jwt", HTTPJwtAuthenticator.class).initialized().requiresEnterpriseLicense();
        }

        public String getType() {
            return "saml[jwt]";
        }

        @Override
        protected KeyProvider initKeyProvider(Settings settings, Path configPath) throws Exception {
            return new KeyProvider(){

                public JsonWebKey getKeyAfterRefresh(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                    return HTTPSamlAuthenticator.this.authTokenProcessorHandler.getSigningKey();
                }

                public JsonWebKey getKey(String kid) throws AuthenticatorUnavailableException, BadCredentialsException {
                    return HTTPSamlAuthenticator.this.authTokenProcessorHandler.getSigningKey();
                }
            };
        }

        public ComponentState getComponentState() {
            return this.componentState;
        }
    }
}

