/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap.util;

import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.List;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.ldaptive.ConnectionConfig;
import org.ldaptive.ConnectionFactory;
import org.ldaptive.DefaultConnectionFactory;
import org.ldaptive.DerefAliases;
import org.ldaptive.FilterTemplate;
import org.ldaptive.LdapEntry;
import org.ldaptive.LdapException;
import org.ldaptive.ReturnAttributes;
import org.ldaptive.SearchOperation;
import org.ldaptive.SearchRequest;
import org.ldaptive.SearchResponse;
import org.ldaptive.SearchScope;
import org.ldaptive.handler.SearchResultHandler;
import org.ldaptive.referral.FollowSearchReferralHandler;

public class LdapHelper {
    protected static final Logger log = LogManager.getLogger(LdapHelper.class);
    private static FilterTemplate ALL = new FilterTemplate("(objectClass=*)");

    public static List<LdapEntry> search(ConnectionConfig connectionConfig, String baseDn, FilterTemplate filter, SearchScope searchScope) throws LdapException {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("baseDn {}", (Object)baseDn);
            }
            return AccessController.doPrivileged(() -> {
                SearchOperation search = new SearchOperation((ConnectionFactory)new DefaultConnectionFactory(connectionConfig));
                search.setSearchResultHandlers(new SearchResultHandler[]{new FollowSearchReferralHandler()});
                SearchResponse r = search.execute((SearchRequest)SearchRequest.builder().dn(baseDn).aliases(DerefAliases.ALWAYS).filter(filter).scope(searchScope).returnAttributes(ReturnAttributes.ALL.value()).build());
                return new ArrayList(r.getEntries());
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getException() instanceof LdapException) {
                throw (LdapException)e.getException();
            }
            if (e.getException() instanceof RuntimeException) {
                throw (RuntimeException)e.getException();
            }
            throw new RuntimeException(e);
        }
    }

    public static LdapEntry lookup(ConnectionConfig connectionConfig, LdapName roleDn) throws LdapException {
        return LdapHelper.lookup(connectionConfig, roleDn.toString());
    }

    public static LdapEntry lookup(ConnectionConfig connectionConfig, String unescapedDn) throws LdapException {
        List<LdapEntry> entries = LdapHelper.search(connectionConfig, unescapedDn, ALL, SearchScope.OBJECT);
        if (entries.size() == 1) {
            return entries.get(0);
        }
        return null;
    }
}

