/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.codova.config.net.ProxyConfig;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.KeySetRetriever;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.MockIpdServer;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.OidcProviderConfig;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.OpenIdProviderClient;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.TestJwk;
import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.google.common.collect.ImmutableMap;
import com.google.common.hash.Hashing;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.entity.ContentType;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpCoreContext;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.apache.http.util.EntityUtils;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Ignore;
import org.junit.Test;

public class OpenIdProviderClientTest {
    protected static MockIpdServer mockIdpServer;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @ClassRule
    public static WireMockRule wireMockProxy;

    @BeforeClass
    public static void setUp() throws Exception {
        mockIdpServer = MockIpdServer.start(TestJwk.Jwks.ALL);
    }

    @AfterClass
    public static void tearDown() {
        if (mockIdpServer != null) {
            try {
                mockIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Ignore(value="TODO why is this ignored?")
    @Test
    public void proxyTest() throws Exception {
        try (MockIpdServer proxyOnlyMockIdpServer = MockIpdServer.start(TestJwk.Jwks.ALL).acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());){
            proxyOnlyMockIdpServer.setRequireValidCodes(false);
            OpenIdProviderClient openIdProviderClientWithoutProxySettings = new OpenIdProviderClient(proxyOnlyMockIdpServer.getDiscoverUri(), null, null, true);
            try {
                openIdProviderClientWithoutProxySettings.getOidcConfiguration();
                Assert.fail();
            }
            catch (AuthenticatorUnavailableException e) {
                Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("HTTP/1.1 451"));
            }
            ImmutableMap proxySettings = ImmutableMap.of((Object)"proxy.host", (Object)"127.0.0.8", (Object)"proxy.port", (Object)wireMockProxy.port(), (Object)"proxy.scheme", (Object)"http");
            OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(proxyOnlyMockIdpServer.getDiscoverUri(), null, ProxyConfig.parse((Map)proxySettings, (String)"proxy"), true);
            OidcProviderConfig oidcProviderConfig = openIdProviderClient.getOidcConfiguration();
            Assert.assertTrue((String)String.valueOf(oidcProviderConfig.getParsedJson()), (boolean)oidcProviderConfig.getParsedJson().containsKey("token_endpoint"));
            String tokenEndpointRequest = "grant_type=authorization_code&code=wusch";
            HttpResponse response = openIdProviderClient.callTokenEndpoint(tokenEndpointRequest.getBytes(), ContentType.create((String)"application/x-www-form-urlencoded"));
            Assert.assertEquals((String)response.toString(), (long)200L, (long)response.getStatusLine().getStatusCode());
            String entity = EntityUtils.toString((HttpEntity)response.getEntity());
            Assert.assertTrue((String)entity, (boolean)entity.contains("access_token"));
        }
    }

    @Test
    public void cacheTest() throws AuthenticatorUnavailableException {
        OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(mockIdpServer.getDiscoverUri(), null, null, true);
        KeySetRetriever keySetRetriever = new KeySetRetriever(openIdProviderClient);
        keySetRetriever.get();
        Assert.assertEquals((long)1L, (long)openIdProviderClient.getOidcCacheMisses());
        Assert.assertEquals((long)0L, (long)openIdProviderClient.getOidcCacheHits());
        keySetRetriever.get();
        Assert.assertEquals((long)1L, (long)openIdProviderClient.getOidcCacheMisses());
        Assert.assertEquals((long)1L, (long)openIdProviderClient.getOidcCacheHits());
    }

    @Test
    public void clientCertTest() throws Exception {
        try (MockIpdServer sslMockIdpServer = new MockIpdServer(TestJwk.Jwks.ALL, SocketUtils.findAvailableTcpPort(), true){

            @Override
            protected void handleDiscoverRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.SSLTestHttpServerConnection connection = (MockIpdServer.SSLTestHttpServerConnection)((HttpCoreContext)context).getConnection();
                X509Certificate peerCert = (X509Certificate)connection.getPeerCertificates()[0];
                try {
                    String sha256Fingerprint = Hashing.sha256().hashBytes(peerCert.getEncoded()).toString();
                    Assert.assertEquals((Object)"04b2b8baea7a0a893f0223d95b72081e9a1e154a0f9b1b4e75998085972b1b68", (Object)sha256Fingerprint);
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException(e);
                }
                super.handleDiscoverRequest(request, response, context);
            }
        };){
            SSLContextBuilder sslContextBuilder = SSLContexts.custom();
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"jwt/truststore.jks").toFile());
            trustStore.load(trustStream, "changeit".toCharArray());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"jwt/spock-keystore.jks").toFile());
            keyStore.load(keyStream, "changeit".toCharArray());
            sslContextBuilder.loadTrustMaterial(trustStore, null);
            sslContextBuilder.loadKeyMaterial(keyStore, "changeit".toCharArray(), new PrivateKeyStrategy(){

                public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                    return "spock";
                }
            });
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = new SettingsBasedSSLConfigurator.SSLConfig(sslContextBuilder.build(), new String[]{"TLSv1.2", "TLSv1.1"}, null, null, false, false, false, trustStore, null, keyStore, null, null, false);
            OpenIdProviderClient openIdProviderClient = new OpenIdProviderClient(mockIdpServer.getDiscoverUri(), sslConfig, null, true);
            KeySetRetriever keySetRetriever = new KeySetRetriever(openIdProviderClient);
            keySetRetriever.get();
        }
    }

    static {
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        wireMockProxy = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").trustAllProxyTargets(true).enableBrowserProxying(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
    }
}

