/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap.srv;

import com.unboundid.ldap.listener.LDAPListenerClientConnection;
import com.unboundid.ldap.listener.LDAPListenerRequestHandler;
import com.unboundid.ldap.protocol.AbandonRequestProtocolOp;
import com.unboundid.ldap.protocol.AddRequestProtocolOp;
import com.unboundid.ldap.protocol.AddResponseProtocolOp;
import com.unboundid.ldap.protocol.BindRequestProtocolOp;
import com.unboundid.ldap.protocol.BindResponseProtocolOp;
import com.unboundid.ldap.protocol.CompareRequestProtocolOp;
import com.unboundid.ldap.protocol.CompareResponseProtocolOp;
import com.unboundid.ldap.protocol.DeleteRequestProtocolOp;
import com.unboundid.ldap.protocol.DeleteResponseProtocolOp;
import com.unboundid.ldap.protocol.ExtendedRequestProtocolOp;
import com.unboundid.ldap.protocol.ExtendedResponseProtocolOp;
import com.unboundid.ldap.protocol.LDAPMessage;
import com.unboundid.ldap.protocol.ModifyDNRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyDNResponseProtocolOp;
import com.unboundid.ldap.protocol.ModifyRequestProtocolOp;
import com.unboundid.ldap.protocol.ModifyResponseProtocolOp;
import com.unboundid.ldap.protocol.ProtocolOp;
import com.unboundid.ldap.protocol.SearchRequestProtocolOp;
import com.unboundid.ldap.protocol.SearchResultDoneProtocolOp;
import com.unboundid.ldap.protocol.UnbindRequestProtocolOp;
import com.unboundid.ldap.sdk.Control;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.ResultCode;
import java.util.List;
import javax.net.ssl.SSLSocket;

class PlaintextRequestRejectingRequestHandler
extends LDAPListenerRequestHandler {
    private final LDAPListenerRequestHandler delegate;
    private final LDAPListenerClientConnection connection;

    PlaintextRequestRejectingRequestHandler(LDAPListenerRequestHandler delegate, LDAPListenerClientConnection connection) {
        this.delegate = delegate;
        this.connection = connection;
    }

    public void closeInstance() {
        this.delegate.closeInstance();
    }

    public void processAbandonRequest(int messageID, AbandonRequestProtocolOp request, List<Control> controls) {
        this.delegate.processAbandonRequest(messageID, request, controls);
    }

    public LDAPMessage processAddRequest(int messageID, AddRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new AddResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processAddRequest(messageID, request, controls);
    }

    public LDAPMessage processBindRequest(int messageID, BindRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new BindResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processBindRequest(messageID, request, controls);
    }

    public LDAPMessage processCompareRequest(int messageID, CompareRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new CompareResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processCompareRequest(messageID, request, controls);
    }

    public LDAPMessage processDeleteRequest(int messageID, DeleteRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new DeleteResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processDeleteRequest(messageID, request, controls);
    }

    public LDAPMessage processExtendedRequest(int messageID, ExtendedRequestProtocolOp request, List<Control> controls) {
        if (request.getOID().equals("1.3.6.1.4.1.1466.20037")) {
            return this.delegate.processExtendedRequest(messageID, request, controls);
        }
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new ExtendedResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processExtendedRequest(messageID, request, controls);
    }

    public LDAPMessage processModifyRequest(int messageID, ModifyRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new ModifyResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processModifyRequest(messageID, request, controls);
    }

    public LDAPMessage processModifyDNRequest(int messageID, ModifyDNRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new ModifyDNResponseProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processModifyDNRequest(messageID, request, controls);
    }

    public LDAPMessage processSearchRequest(int messageID, SearchRequestProtocolOp request, List<Control> controls) {
        if (!this.isTlsConnection()) {
            return new LDAPMessage(messageID, (ProtocolOp)new SearchResultDoneProtocolOp(new LDAPResult(messageID, ResultCode.UNWILLING_TO_PERFORM)), new Control[0]);
        }
        return this.delegate.processSearchRequest(messageID, request, controls);
    }

    public void processUnbindRequest(int messageID, UnbindRequestProtocolOp request, List<Control> controls) {
        this.delegate.processUnbindRequest(messageID, request, controls);
    }

    public LDAPListenerRequestHandler newInstance(LDAPListenerClientConnection connection) throws LDAPException {
        return new PlaintextRequestRejectingRequestHandler(this.delegate.newInstance(connection), connection);
    }

    private boolean isTlsConnection() {
        return this.connection.getSocket() instanceof SSLSocket;
    }
}

