/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.http.HttpBody;
import org.elasticsearch.http.HttpRequest;
import org.elasticsearch.http.HttpResponse;
import org.elasticsearch.rest.ChunkedRestResponseBodyPart;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentParserConfiguration;

public class FakeRestRequest
extends RestRequest {
    private final ReleasableBytesReference content;
    private final RestRequest.Method method;

    public FakeRestRequest() {
        this(new HashMap<String, String>(), new HashMap<String, String>(), null, RestRequest.Method.GET, "/");
    }

    public FakeRestRequest(Map<String, String> headers, Map<String, String> params) {
        this(headers, params, null, RestRequest.Method.GET, "/");
    }

    private FakeRestRequest(final Map<String, String> headers, Map<String, String> params, final ReleasableBytesReference content, RestRequest.Method method, String path) {
        super(XContentParserConfiguration.EMPTY, params, path, FakeRestRequest.convert(headers), new HttpRequest(){

            public RestRequest.Method method() {
                return RestRequest.Method.GET;
            }

            public String uri() {
                return "";
            }

            public Map<String, List<String>> getHeaders() {
                return FakeRestRequest.convert(headers);
            }

            public HttpBody body() {
                return HttpBody.fromBytesReference((BytesReference)content);
            }

            public List<String> strictCookies() {
                return Collections.emptyList();
            }

            public HttpRequest.HttpVersion protocolVersion() {
                return HttpRequest.HttpVersion.HTTP_1_1;
            }

            public HttpRequest removeHeader(String header) {
                return this;
            }

            public HttpResponse createResponse(RestStatus status, BytesReference content2) {
                return null;
            }

            public HttpResponse createResponse(RestStatus status, ChunkedRestResponseBodyPart content2) {
                return null;
            }

            public Exception getInboundException() {
                return null;
            }

            public void release() {
            }
        }, null);
        this.content = content;
        this.method = method;
    }

    public RestRequest.Method method() {
        return this.method;
    }

    public String uri() {
        return this.rawPath();
    }

    public boolean hasContent() {
        return this.content != null;
    }

    public ReleasableBytesReference content() {
        return this.content;
    }

    private static Map<String, List<String>> convert(Map<String, String> headers) {
        HashMap<String, List<String>> ret = new HashMap<String, List<String>>();
        for (String h : headers.keySet()) {
            ret.put(h, Collections.singletonList(headers.get(h)));
        }
        return ret;
    }

    public static class Builder {
        private Map<String, String> headers = new HashMap<String, String>();
        private Map<String, String> params = new HashMap<String, String>();
        private ReleasableBytesReference content;
        private String path = "/";
        private RestRequest.Method method = RestRequest.Method.GET;

        public Builder withHeaders(Map<String, String> headers) {
            this.headers = headers;
            return this;
        }

        public Builder withParams(Map<String, String> params) {
            this.params = params;
            return this;
        }

        public Builder withContent(BytesReference content) {
            this.content = content == null ? null : ReleasableBytesReference.wrap((BytesReference)content);
            return this;
        }

        public Builder withPath(String path) {
            this.path = path;
            return this;
        }

        public Builder withMethod(RestRequest.Method method) {
            this.method = method;
            return this;
        }

        public FakeRestRequest build() {
            return new FakeRestRequest(this.headers, this.params, this.content, this.method, this.path);
        }
    }
}

