/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.dlic.auth.http.jwt.keybyoidc.BadCredentialsException;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.KeyProvider;
import com.floragunn.searchguard.authc.AuthenticatorUnavailableException;
import com.google.common.base.Strings;
import org.apache.cxf.rs.security.jose.jwa.SignatureAlgorithm;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureVerifier;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtException;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.rs.security.jose.jwt.JwtUtils;

public class JwtVerifier {
    private final KeyProvider keyProvider;

    public JwtVerifier(KeyProvider keyProvider) {
        this.keyProvider = keyProvider;
    }

    public JwtToken getVerifiedJwtToken(String encodedJwt) throws BadCredentialsException, AuthenticatorUnavailableException {
        try {
            JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(encodedJwt);
            JwtToken jwt = jwtConsumer.getJwtToken();
            JsonWebKey key = this.keyProvider.getKey(jwt.getJwsHeaders().getKeyId());
            JwsSignatureVerifier signatureVerifier = this.getInitializedSignatureVerifier(key, jwt);
            boolean signatureValid = jwtConsumer.verifySignatureWith(signatureVerifier);
            if (!signatureValid && Strings.isNullOrEmpty((String)jwt.getJwsHeaders().getKeyId())) {
                key = this.keyProvider.getKeyAfterRefresh(null);
                signatureVerifier = this.getInitializedSignatureVerifier(key, jwt);
                signatureValid = jwtConsumer.verifySignatureWith(signatureVerifier);
            }
            if (!signatureValid) {
                throw new BadCredentialsException("Invalid JWT signature");
            }
            this.validateClaims(jwt);
            return jwt;
        }
        catch (JwtException e) {
            throw new BadCredentialsException(e.getMessage(), e);
        }
    }

    private void validateSignatureAlgorithm(JsonWebKey key, JwtToken jwt) throws BadCredentialsException {
        SignatureAlgorithm tokenAlgorithm;
        if (Strings.isNullOrEmpty((String)key.getAlgorithm())) {
            return;
        }
        SignatureAlgorithm keyAlgorithm = SignatureAlgorithm.getAlgorithm((String)key.getAlgorithm());
        if (!keyAlgorithm.equals((Object)(tokenAlgorithm = SignatureAlgorithm.getAlgorithm((String)jwt.getJwsHeaders().getAlgorithm())))) {
            throw new BadCredentialsException("Algorithm of JWT does not match algorithm of JWK (" + String.valueOf(keyAlgorithm) + " != " + String.valueOf(tokenAlgorithm) + ")");
        }
    }

    private JwsSignatureVerifier getInitializedSignatureVerifier(JsonWebKey key, JwtToken jwt) throws BadCredentialsException, JwtException {
        this.validateSignatureAlgorithm(key, jwt);
        JwsSignatureVerifier result = JwsUtils.getSignatureVerifier((JsonWebKey)key, (SignatureAlgorithm)jwt.getJwsHeaders().getSignatureAlgorithm());
        if (result == null) {
            throw new BadCredentialsException("Cannot verify JWT");
        }
        return result;
    }

    private void validateClaims(JwtToken jwt) throws BadCredentialsException, JwtException {
        JwtClaims claims = jwt.getClaims();
        if (claims != null) {
            JwtUtils.validateJwtExpiry((JwtClaims)claims, (int)0, (boolean)false);
            JwtUtils.validateJwtNotBefore((JwtClaims)claims, (int)0, (boolean)false);
        }
    }
}

