/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.floragunn.dlic.auth.ldap.util.Utils;
import com.floragunn.dlic.auth.ldap2.LDAPConnectionManager;
import com.floragunn.dlic.auth.ldap2.ParametrizedFilter;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchScope;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public final class LDAPUserSearcher {
    protected static final Logger log = LogManager.getLogger(LDAPUserSearcher.class);
    private static final int ZERO_PLACEHOLDER = 0;
    private static final String DEFAULT_USERBASE = "";
    private static final String DEFAULT_USERSEARCH_PATTERN = "(sAMAccountName={0})";
    private final Settings settings;
    private final List<Map.Entry<String, Settings>> userBaseSettings;
    private final LDAPConnectionManager lcm;

    LDAPUserSearcher(LDAPConnectionManager lcm, Settings settings) {
        this.lcm = lcm;
        this.settings = settings;
        this.userBaseSettings = LDAPUserSearcher.getUserBaseSettings(settings);
    }

    static List<Map.Entry<String, Settings>> getUserBaseSettings(Settings settings) {
        HashMap<String, Settings> userBaseSettingsMap = new HashMap<String, Settings>(settings.getGroups("users"));
        if (!userBaseSettingsMap.isEmpty()) {
            if (settings.hasValue("userbase")) {
                throw new RuntimeException("Both old-style and new-style configuration defined for LDAP authentication backend: " + String.valueOf(settings));
            }
            return Utils.getOrderedBaseSettings(userBaseSettingsMap);
        }
        Settings.Builder settingsBuilder = Settings.builder();
        settingsBuilder.put("base", settings.get("userbase", DEFAULT_USERBASE));
        settingsBuilder.put("search", settings.get("usersearch", DEFAULT_USERSEARCH_PATTERN));
        return Collections.singletonList(Pair.of((Object)"_legacyConfig", (Object)settingsBuilder.build()));
    }

    SearchResultEntry exists(LDAPConnection con, String user) throws LDAPException {
        if (this.settings.getAsBoolean("fakelogin_enabled", Boolean.valueOf(false)).booleanValue() || this.settings.getAsBoolean("search_all_bases", Boolean.valueOf(false)).booleanValue() || this.settings.hasValue("userbase")) {
            return this.existsSearchingAllBases(con, user);
        }
        return this.existsSearchingUntilFirstHit(con, user);
    }

    private SearchResultEntry existsSearchingUntilFirstHit(LDAPConnection con, String user) throws LDAPException {
        String username = user;
        for (Map.Entry<String, Settings> entry : this.userBaseSettings) {
            Settings baseSettings = entry.getValue();
            ParametrizedFilter pf = new ParametrizedFilter(baseSettings.get("search", DEFAULT_USERSEARCH_PATTERN));
            pf.setParameter(0, username);
            List<SearchResultEntry> result = this.lcm.search(con, baseSettings.get("base", DEFAULT_USERBASE), SearchScope.SUB, pf);
            if (log.isDebugEnabled()) {
                log.debug("Results for LDAP search for " + user + " in base " + entry.getKey() + ":\n" + String.valueOf(result));
            }
            if (result == null || result.size() < 1) continue;
            return result.get(0);
        }
        return null;
    }

    private SearchResultEntry existsSearchingAllBases(LDAPConnection con, String user) throws LDAPException {
        String username = user;
        HashSet<SearchResultEntry> result = new HashSet<SearchResultEntry>();
        for (Map.Entry<String, Settings> entry : this.userBaseSettings) {
            Settings baseSettings = entry.getValue();
            ParametrizedFilter pf = new ParametrizedFilter(baseSettings.get("search", DEFAULT_USERSEARCH_PATTERN));
            pf.setParameter(0, username);
            List<SearchResultEntry> foundEntries = this.lcm.search(con, baseSettings.get("base", DEFAULT_USERBASE), SearchScope.SUB, pf);
            if (log.isDebugEnabled()) {
                log.debug("Results for LDAP search for " + user + " in base " + entry.getKey() + ":\n" + String.valueOf(result));
            }
            if (foundEntries == null) continue;
            result.addAll(foundEntries);
        }
        if (result.isEmpty()) {
            log.debug("No user " + username + " found");
            return null;
        }
        if (result.size() > 1) {
            log.debug("More than one user for '" + username + "' found");
            return null;
        }
        return (SearchResultEntry)result.iterator().next();
    }
}

