/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.dlic.auth.http.jwt.keybyoidc.TestJwk;
import com.google.common.collect.ImmutableSet;
import java.util.Arrays;
import java.util.Set;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jws.JwsHeaders;
import org.apache.cxf.rs.security.jose.jws.JwsSignatureProvider;
import org.apache.cxf.rs.security.jose.jws.JwsUtils;
import org.apache.cxf.rs.security.jose.jwt.JoseJwtProducer;
import org.apache.cxf.rs.security.jose.jwt.JwtClaims;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.logging.log4j.util.Strings;

public class TestJwts {
    public static final String ROLES_CLAIM = "roles";
    public static final Set<String> TEST_ROLES = ImmutableSet.of((Object)"role1", (Object)"role2");
    public static final String TEST_ROLES_STRING = Strings.join(TEST_ROLES, (char)',');
    public static final String TEST_AUDIENCE = "TestAudience";
    public static final String MCCOY_SUBJECT = "Leonard McCoy";
    static final JwtToken MC_COY = TestJwts.create("Leonard McCoy", "TestAudience", "roles", TEST_ROLES_STRING);
    static final JwtToken MC_COY_EXPIRED = TestJwts.create("Leonard McCoy", "TestAudience", "roles", TEST_ROLES_STRING, "exp", 10);
    static final JwtToken MC_LIST_CLAIM = TestJwts.create("McList", "TestAudience", "roles", TEST_ROLES_STRING, "n", Arrays.asList("mcl"));
    static final JwtToken MC_LIST_2_CLAIM = TestJwts.create("McList", "TestAudience", "roles", TEST_ROLES_STRING, "n", Arrays.asList("mcl", "mcl2"));
    public static final String MC_COY_SIGNED_OCT_1 = TestJwts.createSigned(MC_COY, TestJwk.OCT_1);
    public static final String MC_COY_SIGNED_RSA_1 = TestJwts.createSigned(MC_COY, TestJwk.RSA_1);
    public static final String MC_COY_SIGNED_RSA_X = TestJwts.createSigned(MC_COY, TestJwk.RSA_X);
    public static final String MC_COY_EXPIRED_SIGNED_OCT_1 = TestJwts.createSigned(MC_COY_EXPIRED, TestJwk.OCT_1);
    static final String MC_LIST_CLAIM_SIGNED_OCT_1 = TestJwts.createSigned(MC_LIST_CLAIM, TestJwk.OCT_1);
    static final String MC_LIST_2_CLAIM_SIGNED_OCT_1 = TestJwts.createSigned(MC_LIST_2_CLAIM, TestJwk.OCT_1);

    public static JwtToken create(String subject, String audience, Object ... moreClaims) {
        JwtClaims claims = new JwtClaims();
        claims.setSubject(subject);
        claims.setAudience(audience);
        if (moreClaims != null) {
            for (int i = 0; i < moreClaims.length; i += 2) {
                claims.setClaim(String.valueOf(moreClaims[i]), moreClaims[i + 1]);
            }
        }
        JwtToken result = new JwtToken(claims);
        return result;
    }

    public static String createSigned(JwtToken baseJwt, JsonWebKey jwk) {
        return TestJwts.createSigned(baseJwt, jwk, JwsUtils.getSignatureProvider((JsonWebKey)jwk));
    }

    public static String createSigned(JwtToken baseJwt, JsonWebKey jwk, JwsSignatureProvider signatureProvider) {
        JwsHeaders jwsHeaders = new JwsHeaders();
        JwtToken signedToken = new JwtToken(jwsHeaders, baseJwt.getClaims());
        jwsHeaders.setKeyId(jwk.getKeyId());
        return new JoseJwtProducer().processJwt(signedToken, null, signatureProvider);
    }

    static String createSignedWithoutKeyId(JwtToken baseJwt, JsonWebKey jwk) {
        JwsHeaders jwsHeaders = new JwsHeaders();
        JwtToken signedToken = new JwtToken(jwsHeaders, baseJwt.getClaims());
        return new JoseJwtProducer().processJwt(signedToken, null, JwsUtils.getSignatureProvider((JsonWebKey)jwk));
    }

    public static class PeculiarEscaping {
        public static final String MC_COY_SIGNED_RSA_1 = "eyJraWQiOiJraWRcLzEiLCJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJMZW9uYXJkIE1jQ295IiwiYXVkIjoiVGVzdEF1ZGllbmNlIiwicm9sZXMiOiJyb2xlMSxyb2xlMiJ9.C0ntlhZtalpOYzgrzq_I4c6NxeQEmUk9Id5fVI6SXLIyscBrpS8nQ3bZrtX3qDiCYZDbp5n1OJMp3nhC7Ro2qdWjFe3FRSewKyZSowzVdQSlPetEsyLh3KdEs2ZPx3vry_y8SeCcJw_tiUOysceTMKzseL3DzF2PmoRRARLbQVI6zQvanRC8-WREraA2gTXpv_R-haOy7sf00VQhjGPMTCjqxXTfO6gzCz5-02tpGOOooQ8BcPy_At0nKjmuZgw_jODTL4TYs_T48M9tHxuY02qF3zv6iLonFz1mrb7Ff-65OUo4QVfqiOMxCOAe1JFP9o1tbtgaoiaWVznezjRK6A";
    }

    static class NoKid {
        static final String MC_COY_SIGNED_RSA_1 = TestJwts.createSignedWithoutKeyId(MC_COY, TestJwk.RSA_1);
        static final String MC_COY_SIGNED_RSA_2 = TestJwts.createSignedWithoutKeyId(MC_COY, TestJwk.RSA_2);
        static final String MC_COY_SIGNED_RSA_X = TestJwts.createSignedWithoutKeyId(MC_COY, TestJwk.RSA_X);

        NoKid() {
        }
    }
}

