/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.floragunn.dlic.auth.ldap.srv.LdapServer;
import com.floragunn.searchguard.legacy.test.DynamicSgConfig;
import com.floragunn.searchguard.legacy.test.RestHelper;
import com.floragunn.searchguard.legacy.test.SingleClusterTest;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.elasticsearch.common.settings.Settings;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;

public class LdapBackendIntegTest2
extends SingleClusterTest {
    private static LdapServer tlsLdapServer = LdapServer.createTls("base.ldif");

    @AfterClass
    public static void tearDownLdap() throws Exception {
        if (tlsLdapServer != null) {
            tlsLdapServer.stop();
        }
    }

    protected String getResourceFolder() {
        return "ldap";
    }

    @Test
    public void testIntegLdapAuthenticationSSL() throws Exception {
        String sgConfigAsYamlString = FileHelper.loadFile((String)"ldap/sg_config_ldap2.yml");
        sgConfigAsYamlString = sgConfigAsYamlString.replace("${ldapsPort}", String.valueOf(tlsLdapServer.getPort()));
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfigAsYamlString(sgConfigAsYamlString), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)200L, (long)rh.executeGetRequest("", new Header[]{LdapBackendIntegTest2.encodeBasicHeader((String)"jacksonm", (String)"secret")}).getStatusCode());
    }

    @Test
    public void testIntegLdapAuthenticationSSLFail() throws Exception {
        String sgConfigAsYamlString = FileHelper.loadFile((String)"ldap/sg_config_ldap2.yml");
        sgConfigAsYamlString = sgConfigAsYamlString.replace("${ldapsPort}", String.valueOf(tlsLdapServer.getPort()));
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfigAsYamlString(sgConfigAsYamlString), Settings.EMPTY);
        RestHelper rh = this.nonSslRestHelper();
        Assert.assertEquals((long)401L, (long)rh.executeGetRequest("", new Header[]{LdapBackendIntegTest2.encodeBasicHeader((String)"wrong", (String)"wrong")}).getStatusCode());
    }

    @Test
    public void testAttributesWithImpersonation() throws Exception {
        String sgConfigAsYamlString = FileHelper.loadFile((String)"ldap/sg_config_ldap2.yml");
        sgConfigAsYamlString = sgConfigAsYamlString.replace("${ldapsPort}", String.valueOf(tlsLdapServer.getPort()));
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.cn=Captain Spock,ou=people,o=TEST", new String[]{"*"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfigAsYamlString(sgConfigAsYamlString), settings);
        RestHelper rh = this.nonSslRestHelper();
        RestHelper.HttpResponse res = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "jacksonm"), LdapBackendIntegTest2.encodeBasicHeader((String)"spock", (String)"spocksecret")});
        Assert.assertEquals((long)200L, (long)res.getStatusCode());
        Assert.assertTrue((boolean)res.getBody().contains("ldap.dn"));
        Assert.assertTrue((boolean)res.getBody().contains("attr.ldap.entryDN"));
        Assert.assertTrue((boolean)res.getBody().contains("attr.ldap.subschemaSubentry"));
    }

    @Test
    public void testSkipUser() throws Exception {
        String sgConfigAsYamlString = FileHelper.loadFile((String)"ldap/sg_config_skip_users.yml");
        sgConfigAsYamlString = sgConfigAsYamlString.replace("${ldapsPort}", String.valueOf(tlsLdapServer.getPort()));
        Settings settings = Settings.builder().putList("searchguard.authcz.rest_impersonation_user.cn=Captain Spock,ou=people,o=TEST", new String[]{"*"}).build();
        this.setup(Settings.EMPTY, new DynamicSgConfig().setSgConfigAsYamlString(sgConfigAsYamlString), settings);
        RestHelper rh = this.nonSslRestHelper();
        int actual = rh.executeGetRequest("_searchguard/authinfo", new Header[]{new BasicHeader("sg_impersonate_as", "jacksonm"), LdapBackendIntegTest2.encodeBasicHeader((String)"spock", (String)"spocksecret")}).getStatusCode();
        Assert.assertEquals((long)401L, (long)actual);
    }
}

