/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.codova.documents.DocWriter;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.CxfTestTools;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.TestJwts;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import com.google.common.collect.ImmutableMap;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKeys;
import org.apache.http.Header;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.client.utils.URLEncodedUtils;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.junit.Assert;

public class MockIpdServer
implements Closeable {
    private static final Logger log = LogManager.getLogger(MockIpdServer.class);
    static final String CTX_DISCOVER = "/discover";
    static final String CTX_KEYS = "/api/oauth/keys";
    static final String CTX_TOKEN = "/token";
    private final HttpServer httpServer;
    private final int port;
    private final String uri;
    private final boolean ssl;
    private final JsonWebKeys jwks;
    private boolean requireValidCodes = true;
    private Map<String, String> validCodes = new ConcurrentHashMap<String, String>();
    private Map<String, String> validCodesToRedirectUri = new ConcurrentHashMap<String, String>();
    private Header requiredHttpHeader;

    public static MockIpdServer start(JsonWebKeys jwks) throws IOException {
        int i = 0;
        while (true) {
            try {
                return new MockIpdServer(jwks);
            }
            catch (BindException e) {
                if (i >= 10) {
                    throw e;
                }
                ++i;
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
            }
        }
    }

    MockIpdServer(JsonWebKeys jwks) throws IOException {
        this(jwks, SocketUtils.findAvailableTcpPort(), false);
    }

    MockIpdServer(JsonWebKeys jwks, int port, boolean ssl) throws IOException {
        this.port = port;
        this.uri = (ssl ? "https" : "http") + "://localhost:" + port;
        this.ssl = ssl;
        this.jwks = jwks;
        ServerBootstrap serverBootstrap = ServerBootstrap.bootstrap().setListenerPort(port).registerHandler(CTX_DISCOVER, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleDiscoverRequest(request, response, context);
            }
        }).registerHandler(CTX_KEYS, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleKeysRequest(request, response, context);
            }
        }).registerHandler(CTX_TOKEN, new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                MockIpdServer.this.handleTokenRequest(request, response, context);
            }
        });
        if (ssl) {
            serverBootstrap = serverBootstrap.setSslContext(this.createSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

                public void initialize(SSLServerSocket socket) throws SSLException {
                    socket.setNeedClientAuth(true);
                }
            }).setConnectionFactory((HttpConnectionFactory)new HttpConnectionFactory<DefaultBHttpServerConnection>(){
                private ConnectionConfig cconfig = ConnectionConfig.DEFAULT;

                public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
                    SSLTestHttpServerConnection conn = new SSLTestHttpServerConnection(this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), ConnSupport.createDecoder((ConnectionConfig)this.cconfig), ConnSupport.createEncoder((ConnectionConfig)this.cconfig), this.cconfig.getMessageConstraints(), null, null, null, null);
                    conn.bind(socket);
                    return conn;
                }
            });
        }
        this.httpServer = serverBootstrap.create();
        this.httpServer.start();
    }

    public MockIpdServer acceptOnlyRequestsWithHeader(Header header) {
        this.requiredHttpHeader = header;
        return this;
    }

    @Override
    public void close() throws IOException {
        this.httpServer.stop();
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public String getUri() {
        return this.uri;
    }

    public URI getDiscoverUri() {
        return URI.create(this.uri + CTX_DISCOVER);
    }

    public int getPort() {
        return this.port;
    }

    protected void handleDiscoverRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.checkClientAddress(request, response, context)) {
            return;
        }
        response.setStatusCode(200);
        response.setHeader("Cache-Control", "public, max-age=31536000");
        response.setEntity((HttpEntity)new StringEntity("{\"jwks_uri\": \"" + this.uri + "/api/oauth/keys\",\n\"issuer\": \"" + this.uri + "\", \"unknownPropertyToBeIgnored\": 42, \"token_endpoint\": \"" + this.uri + "/token\", \"authorization_endpoint\": \"" + this.uri + "/auth\"}"));
    }

    protected void handleKeysRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if (!this.checkClientAddress(request, response, context)) {
            return;
        }
        response.setStatusCode(200);
        response.setEntity((HttpEntity)new StringEntity(CxfTestTools.toJson((JsonMapObject)this.jwks)));
    }

    protected void handleTokenRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        String idToken;
        if (!this.checkClientAddress(request, response, context)) {
            return;
        }
        if (!"POST".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Not a POST request"));
            return;
        }
        if (request.getFirstHeader("Content-Type") == null) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Content-Type header is missing"));
            return;
        }
        if (!request.getFirstHeader("Content-Type").getValue().toLowerCase().startsWith("application/x-www-form-urlencoded")) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Content-Type is not application/x-www-form-urlencoded"));
            return;
        }
        if (!(request instanceof HttpEntityEnclosingRequest)) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Missing entity"));
            return;
        }
        HttpEntity entity = ((HttpEntityEnclosingRequest)request).getEntity();
        String entityBody = EntityUtils.toString((HttpEntity)entity);
        Map<String, String> entityParams = this.getFormUrlEncodedValues(entityBody);
        log.info("Got entity params: " + String.valueOf(entityParams) + "; " + entityBody);
        if (!entityParams.containsKey("grant_type")) {
            response.setStatusCode(400);
            response.setEntity((HttpEntity)new StringEntity("Missing grant_type"));
            return;
        }
        String code = entityParams.get("code");
        if (this.requireValidCodes) {
            String currentRedirectUri;
            idToken = this.validCodes.remove(code);
            if (idToken == null) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Invalid code " + code));
                return;
            }
            String oldRedirectUri = this.validCodesToRedirectUri.remove(code);
            if (!oldRedirectUri.equals(currentRedirectUri = entityParams.get("redirect_uri"))) {
                response.setStatusCode(400);
                response.setEntity((HttpEntity)new StringEntity("Invalid redirect_uri " + currentRedirectUri + "; expected: " + oldRedirectUri));
                return;
            }
        } else {
            idToken = TestJwts.MC_COY_SIGNED_OCT_1;
        }
        response.setStatusCode(200);
        ImmutableMap responseBody = ImmutableMap.of((Object)"access_token", (Object)"totototototo", (Object)"token_type", (Object)"bearer", (Object)"expires_in", (Object)3600, (Object)"scope", (Object)"profile app:read app:write", (Object)"id_token", (Object)idToken);
        response.setEntity((HttpEntity)new StringEntity(DocWriter.json().writeAsString((Object)responseBody), ContentType.APPLICATION_JSON));
    }

    private SSLContext createSSLContext() {
        if (!this.ssl) {
            return null;
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"jwt/truststore.jks").toFile());
            trustStore.load(trustStream, "changeit".toCharArray());
            tmf.init(trustStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"jwt/node-0-keystore.jks").toFile());
            keyStore.load(keyStream, "changeit".toCharArray());
            kmf.init(keyStore, "changeit".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean checkClientAddress(HttpRequest request, HttpResponse response, HttpContext context) throws UnsupportedEncodingException {
        if (this.requiredHttpHeader != null) {
            List<Header> requestHeaders = Arrays.asList(request.getHeaders(this.requiredHttpHeader.getName()));
            if (requestHeaders.stream().anyMatch(header -> this.requiredHttpHeader.getValue().equals(header.getValue()))) {
                return true;
            }
            response.setStatusCode(451);
            response.setEntity((HttpEntity)new StringEntity("We are only accepting requests with the '" + this.requiredHttpHeader.getName() + "' header set to '" + this.requiredHttpHeader.getValue() + "'"));
            return false;
        }
        return true;
    }

    public String handleSsoGetRequestURI(String ssoLocation, String userJwt) throws URISyntaxException, UnsupportedEncodingException {
        Map<String, String> ssoParams = this.getUriParams(ssoLocation);
        String scope = ssoParams.get("scope");
        Assert.assertNotNull((String)ssoLocation, (Object)scope);
        Assert.assertTrue((String)ssoLocation, (boolean)scope.contains("openid"));
        String state = ssoParams.get("state");
        Assert.assertNotNull((String)ssoLocation, (Object)state);
        String redirectUri = ssoParams.get("redirect_uri");
        Assert.assertNotNull((String)ssoLocation, (Object)redirectUri);
        String code = RandomStringUtils.randomAlphanumeric((int)8);
        this.validCodes.put(code, userJwt);
        this.validCodesToRedirectUri.put(code, redirectUri);
        URIBuilder uriBuilder = new URIBuilder(redirectUri);
        uriBuilder.addParameter("code", code);
        uriBuilder.addParameter("state", state);
        return uriBuilder.build().toASCIIString();
    }

    private Map<String, String> getUriParams(String uriString) {
        URI uri = URI.create(uriString);
        return this.getFormUrlEncodedValues(uri.getRawQuery());
    }

    private Map<String, String> getFormUrlEncodedValues(String formUrlencoded) {
        List nameValuePairs = URLEncodedUtils.parse((String)formUrlencoded, (Charset)Charset.forName("utf-8"));
        HashMap<String, String> result = new HashMap<String, String>(nameValuePairs.size());
        for (NameValuePair nameValuePair : nameValuePairs) {
            result.put(nameValuePair.getName(), nameValuePair.getValue());
        }
        return result;
    }

    public boolean isRequireValidCodes() {
        return this.requireValidCodes;
    }

    public void setRequireValidCodes(boolean requireValidCodes) {
        this.requireValidCodes = requireValidCodes;
    }

    static class SSLTestHttpServerConnection
    extends DefaultBHttpServerConnection {
        public SSLTestHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
            super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
        }

        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            return ((SSLSocket)this.getSocket()).getSession().getPeerCertificates();
        }
    }
}

