/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.saml;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.documents.Format;
import com.floragunn.dlic.auth.http.saml.HTTPSamlAuthenticator;
import com.floragunn.dlic.auth.http.saml.MockSamlIdpServer;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.util.FakeRestRequest;
import com.google.common.collect.ImmutableMap;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.KeyManagerFactory;
import org.apache.cxf.rs.security.jose.jws.JwsJwtCompactConsumer;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.internal.LoggerFactoryImpl;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logging.internal.spi.LoggerFactory;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

@Deprecated
public class HTTPSamlAuthenticatorTest {
    protected static MockSamlIdpServer mockSamlIdpServer;
    private static final Pattern WWW_AUTHENTICATE_PATTERN;
    private static final String SPOCK_KEY = "-----BEGIN ENCRYPTED PRIVATE KEY-----\nMIIE6TAbBgkqhkiG9w0BBQMwDgQI0JMa7PyPedwCAggABIIEyLdPL2RXj8jjKqFT\np+7vywwyxyUQOQvvIIU6H+lKZPd/y6pxzYtGd1suT2aermrrlh4b/ZXXfj/EcKcw\nGgcXB60Kr7UHIv7Xr498S4EKa9R7UG0NtWtsA3FVR5ndwXI+CiRSShhkskmpseVH\ndNWAoUsKQFbZRLnoINMKIw1/lpQBUwAUcYVB7LxLeKSTVHn/h9kvq0tad1kbE5OY\nGnOLEVW311++XQ3Ep/13tGEZCrxef+QsnmXuYxXBq4RvbyGZOvyM2FC7va8KzJxl\nP38SPEL1TzqokQB/eLDBMBOCqkhTbP/8lNuoEVm44T6//ijBp6VdBB+YRIFh3NrS\n1fPuDVgHr1jrRGICe8lzWy/bSa+4FlxYjn5qpEzZQtbC6C+iRzlwtlCiDdKl8zJ1\nYF80OW9Gr3Kvph2LJukBiODcyWUAsAf5vJH3vfPV4T9kWTNMu2NCy3Ch8u9d906k\nzojB/tRRdZ/XCftkU05gYU/5ruU1YA49U60s0KWXvSLmecFo2SjkcEoPDI+Y80Uw\nOB/5kdh1M1uu/qjoJTPWBbZ28L6e0fiMsr7eWSG7PQFwnN6VzY6Oesm8AS8LMe3V\nDr4Syec8vVfGg/EDsjNC1yeZTzlO66NQYGkpnHwK1kgX/XXe7fjDfztPyM9crBXj\nYcYpNULAkMj9QUVDQqQ7L8TjoAFQiSdvNa+kkDhaxnAXoxfqeacTtkpKcHADsAQL\nazfoyflnpuZ1dIn0noRFsVuguKDp4k990bhXu9RkQ1H5IzIoYqJwypacVdt3m74o\njpZvBY6z0EtBNkze6WA0Vj0BSWpy/IzndDwroG4Xf+54hn0R/Tp5K5UNttOaJN8c\n9U/NTiGJTJg1O4x6xbPD7C5bBdoJ/MH5yJuk/dUc7pVkisLpuH9sAPETjYCdFIjX\nMSRJCtq2ouT0ZRW1yBIrKIadgHLExhjZjTSQCBXJMbO7r2DjPHMZU23GTiPtC8ua\nL2BmC+AW7RQ2Fyo3hJDT2TM4XlMMlTtGuFxkWwmjV+FiwfjbiR3cp0+99/X6OFu5\nysgZLuTMQsmWNJ8ZARZqBnkGnN92Aw4D5GLCFv3QXO+fqJnOP1PbkPwpjq59Yytf\nU4XqyTwRYSXRzwPFFb7RcgL9HbmjpRBEnvqEjKYeXxkBnhs+WOWN/PuJzGgP5uAk\njAjQbtgLEPd4WpGcwEhkX6S1DBi8NrGapuehCjXsN1axify8Kx4eRuTiPdINlgsq\nd2MsPIuDgU2+0QXrXjRLwABcMGuKcmmfZjC+zZomj+yr4+Togs3vhSj9yGK3HHMh\nNgOlPBTibruXXa4AI07c28j3sEry+CMZrUGyYg6o1HLBpBfOmp7V5HJcvkMFWCVy\nDPFm5LZu0jZMDj9a+oGkv4hfp1xSXSUjhjiGz47xFJb6PH9pOUIkhTEdFCgEXbaR\nfXcR+kakLOotL4X1cT9cpxdimN3CCTBpr03gCv2NCVYMYhHKHK+CQVngJrY+PzMH\nq6fw81bUNcixZyeXFfLFN6GK75k51UV7YS/X2H8YkqGeIVNaFjrcqUoVAN8jQOeb\nXXIa8gT/MdNT0+W3NHKcbE31pDhOI92COZWlhOyp1cLhyo1ytayjxPTl/2RM/Vtj\nT9IKkp7810LOKhrCDQ==\n-----END ENCRYPTED PRIVATE KEY-----";
    private static X509Certificate spSigningCertificate;

    @BeforeClass
    public static void setUp() throws Exception {
        mockSamlIdpServer = new MockSamlIdpServer();
        mockSamlIdpServer.start();
        HTTPSamlAuthenticatorTest.initSpSigningKeys();
    }

    @AfterClass
    public static void tearDown() {
        if (mockSamlIdpServer != null) {
            try {
                mockSamlIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void basicTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
        com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
        String authorization = (String)response.get("authorization");
        Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
        JwtToken jwt = jwtConsumer.getJwtToken();
        Assert.assertEquals((Object)"horst", (Object)jwt.getClaim("sub"));
    }

    @Test
    public void unsolicitedSsoTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setEndpointQueryString(null);
        mockSamlIdpServer.setDefaultAssertionConsumerService("http://wherever/searchguard/saml/acs/idpinitiated");
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        try (HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);){
            String encodedSamlResponse = mockSamlIdpServer.createUnsolicitedSamlResponse();
            RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, null, "/searchguard/saml/acs/idpinitiated");
            TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
            samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
            String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
            com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
            String authorization = (String)response.get("authorization");
            Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
            JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
            JwtToken jwt = jwtConsumer.getJwtToken();
            Assert.assertEquals((Object)"horst", (Object)jwt.getClaim("sub"));
        }
    }

    @Test
    public void badUnsolicitedSsoTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setEndpointQueryString(null);
        mockSamlIdpServer.setDefaultAssertionConsumerService("http://wherever/searchguard/saml/acs/idpinitiated");
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        try (HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);){
            String encodedSamlResponse = mockSamlIdpServer.createUnsolicitedSamlResponse();
            AuthenticateHeaders authenticateHeaders = new AuthenticateHeaders("http://wherever/searchguard/saml/acs/", "wrong_request_id");
            RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders, "/searchguard/saml/acs/idpinitiated");
            TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
            samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
            Assert.assertEquals((Object)RestStatus.UNAUTHORIZED, (Object)tokenRestChannel.response.status());
        }
    }

    @Test
    public void wrongCertTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/spock-keystore.jks", "spock");
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        Assert.assertEquals((long)401L, (long)tokenRestChannel.response.status().getStatus());
    }

    @Test
    public void noSignatureTest() throws Exception {
        mockSamlIdpServer.setSignResponses(false);
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        Assert.assertEquals((long)401L, (long)tokenRestChannel.response.status().getStatus());
    }

    @Test
    public void rolesTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setAuthenticateUserRoles(Arrays.asList("a", "b"));
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
        com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
        String authorization = (String)response.get("authorization");
        Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
        JwtToken jwt = jwtConsumer.getJwtToken();
        Assert.assertEquals((Object)"horst", (Object)jwt.getClaim("sub"));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])((List)jwt.getClaim("roles")).toArray(new String[0]));
    }

    @Test
    public void idpEndpointWithQueryStringTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setEndpointQueryString("extra=query");
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
        com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
        String authorization = (String)response.get("authorization");
        Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
        JwtToken jwt = jwtConsumer.getJwtToken();
        Assert.assertEquals((Object)"horst", (Object)jwt.getClaim("sub"));
    }

    @Test
    public void commaSeparatedRolesTest() throws Exception {
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUserRoles(Arrays.asList("a,b"));
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("roles_seperator", ",").put("path.home", ".").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
        com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
        String authorization = (String)response.get("authorization");
        Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
        JwtToken jwt = jwtConsumer.getJwtToken();
        Assert.assertEquals((Object)"horst", (Object)jwt.getClaim("sub"));
        Assert.assertArrayEquals((Object[])new String[]{"a", "b"}, (Object[])((List)jwt.getClaim("roles")).toArray(new String[0]));
    }

    @Test
    public void basicLogoutTestEncryptedKey() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("horst");
        mockSamlIdpServer.setSpSignatureCertificate(spSigningCertificate);
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("sp.signature_private_key", SPOCK_KEY).put("sp.signature_private_key_password", "changeit").put("path.home", ".").build();
        try (HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);){
            AuthCredentials authCredentials = AuthCredentials.forUser((String)"horst").oldAttribute("attr.jwt.sub", "horst").oldAttribute("attr.jwt.saml_nif", "urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified").oldAttribute("attr.jwt.saml_si", "si123").build();
            String logoutUrl = samlAuthenticator.buildLogoutUrl(authCredentials);
            mockSamlIdpServer.handleSloGetRequestURI(logoutUrl);
        }
    }

    @Test
    public void initialConnectionFailureTest() throws Exception {
        try (MockSamlIdpServer mockSamlIdpServer = new MockSamlIdpServer();){
            Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("idp.min_refresh_delay", 100).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").build();
            HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
            FakeRestRequest restRequest = new FakeRestRequest((Map<String, String>)ImmutableMap.of(), new HashMap<String, String>());
            TestRestChannel restChannel = new TestRestChannel(restRequest);
            samlAuthenticator.reRequestAuthentication((RestChannel)restChannel, null);
            Assert.assertNull((Object)restChannel.response);
            mockSamlIdpServer.start();
            mockSamlIdpServer.setSignResponses(true);
            mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
            mockSamlIdpServer.setAuthenticateUser("horst");
            mockSamlIdpServer.setEndpointQueryString(null);
            Thread.sleep(500L);
            AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
            String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
            RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
            TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
            samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
            String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
            com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
            String authorization = (String)response.get("authorization");
            Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
            JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
            JwtToken jwt = jwtConsumer.getJwtToken();
            Assert.assertEquals((Object)"horst", (Object)jwt.getClaim("sub"));
        }
    }

    @Test
    public void subjectPatternTest() throws Exception {
        mockSamlIdpServer.setSignResponses(true);
        mockSamlIdpServer.loadSigningKeys("saml-legacy/kirk-keystore.jks", "kirk");
        mockSamlIdpServer.setAuthenticateUser("leonard@example.com");
        mockSamlIdpServer.setEndpointQueryString(null);
        Settings settings = Settings.builder().put("idp.metadata_url", mockSamlIdpServer.getMetadataUri()).put("kibana_url", "http://wherever").put("idp.entity_id", mockSamlIdpServer.getIdpEntityId()).put("exchange_key", "abc").put("roles_key", "roles").put("path.home", ".").put("subject_pattern", "^(.+)@(?:.+)$").build();
        HTTPSamlAuthenticator samlAuthenticator = new HTTPSamlAuthenticator(settings, null);
        AuthenticateHeaders authenticateHeaders = this.getAutenticateHeaders(samlAuthenticator);
        String encodedSamlResponse = mockSamlIdpServer.handleSsoGetRequestURI(authenticateHeaders.location);
        RestRequest tokenRestRequest = this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders);
        TestRestChannel tokenRestChannel = new TestRestChannel(tokenRestRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)tokenRestChannel, null);
        String responseJson = new String(BytesReference.toBytes((BytesReference)tokenRestChannel.response.content()));
        com.floragunn.fluent.collections.ImmutableMap response = DocNode.parse((Format)Format.JSON).from(responseJson).toMap();
        String authorization = (String)response.get("authorization");
        Assert.assertNotNull((String)("Expected authorization attribute in JSON: " + responseJson), (Object)authorization);
        JwsJwtCompactConsumer jwtConsumer = new JwsJwtCompactConsumer(authorization.replaceAll("\\s*bearer\\s*", ""));
        JwtToken jwt = jwtConsumer.getJwtToken();
        Assert.assertEquals((Object)"leonard", (Object)jwt.getClaim("sub"));
    }

    private AuthenticateHeaders getAutenticateHeaders(HTTPSamlAuthenticator samlAuthenticator) {
        FakeRestRequest restRequest = new FakeRestRequest((Map<String, String>)ImmutableMap.of(), new HashMap<String, String>());
        TestRestChannel restChannel = new TestRestChannel(restRequest);
        samlAuthenticator.reRequestAuthentication((RestChannel)restChannel, null);
        List wwwAuthenticateHeaders = (List)restChannel.response.getHeaders().get("WWW-Authenticate");
        Assert.assertNotNull((Object)wwwAuthenticateHeaders);
        Assert.assertEquals((String)("More than one WWW-Authenticate header: " + String.valueOf(wwwAuthenticateHeaders)), (long)1L, (long)wwwAuthenticateHeaders.size());
        String wwwAuthenticateHeader = (String)wwwAuthenticateHeaders.get(0);
        Matcher wwwAuthenticateHeaderMatcher = WWW_AUTHENTICATE_PATTERN.matcher(wwwAuthenticateHeader);
        if (!wwwAuthenticateHeaderMatcher.matches()) {
            Assert.fail((String)("Invalid WWW-Authenticate header: " + wwwAuthenticateHeader));
        }
        Assert.assertEquals((Object)"X-SG-IdP", (Object)wwwAuthenticateHeaderMatcher.group(1));
        Assert.assertEquals((Object)"location", (Object)wwwAuthenticateHeaderMatcher.group(4));
        Assert.assertEquals((Object)"requestId", (Object)wwwAuthenticateHeaderMatcher.group(6));
        String location = wwwAuthenticateHeaderMatcher.group(5);
        String requestId = wwwAuthenticateHeaderMatcher.group(7);
        return new AuthenticateHeaders(location, requestId);
    }

    private RestRequest buildTokenExchangeRestRequest(String encodedSamlResponse, AuthenticateHeaders authenticateHeaders) {
        return this.buildTokenExchangeRestRequest(encodedSamlResponse, authenticateHeaders, "/searchguard/saml/acs");
    }

    private RestRequest buildTokenExchangeRestRequest(String encodedSamlResponse, AuthenticateHeaders authenticateHeaders, String acsEndpoint) {
        String authtokenPostJson = authenticateHeaders != null ? "{\"SAMLResponse\": \"" + encodedSamlResponse + "\", \"RequestId\": \"" + authenticateHeaders.requestId + "\"}" : "{\"SAMLResponse\": \"" + encodedSamlResponse + "\", \"RequestId\": null, \"acsEndpoint\": \"" + acsEndpoint + "\" }";
        return new FakeRestRequest.Builder().withPath("/_searchguard/api/authtoken").withMethod(RestRequest.Method.POST).withContent((BytesReference)new BytesArray(authtokenPostJson)).withHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/json")).build();
    }

    private static void initSpSigningKeys() {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"saml-legacy/spock-keystore.jks").toFile());
            keyStore.load(keyStream, "changeit".toCharArray());
            kmf.init(keyStore, "changeit".toCharArray());
            spSigningCertificate = (X509Certificate)keyStore.getCertificate("spock");
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        LoggerFactory.setInstance((LoggerFactory)new LoggerFactoryImpl());
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
        WWW_AUTHENTICATE_PATTERN = Pattern.compile("([^\\s]+)\\s*([^\\s=]+)=\"([^\"]+)\"\\s*([^\\s=]+)=\"([^\"]+)\"\\s*([^\\s=]+)=\"([^\"]+)\"\\s*");
    }

    static class AuthenticateHeaders {
        final String location;
        final String requestId;

        AuthenticateHeaders(String location, String requestId) {
            this.location = location;
            this.requestId = requestId;
        }
    }

    static class TestRestChannel
    implements RestChannel {
        final RestRequest restRequest;
        RestResponse response;

        TestRestChannel(RestRequest restRequest) {
            this.restRequest = restRequest;
        }

        public XContentBuilder newBuilder() throws IOException {
            return null;
        }

        public XContentBuilder newErrorBuilder() throws IOException {
            return null;
        }

        public XContentBuilder newBuilder(XContentType xContentType, boolean useFiltering) throws IOException {
            return null;
        }

        public BytesStreamOutput bytesOutput() {
            return null;
        }

        public void releaseOutputBuffer() {
        }

        public RestRequest request() {
            return this.restRequest;
        }

        public boolean detailedErrorsEnabled() {
            return false;
        }

        public void sendResponse(RestResponse response) {
            this.response = response;
        }

        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering) throws IOException {
            return null;
        }

        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering, OutputStream out) throws IOException {
            return null;
        }
    }
}

