/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap.srv;

import com.floragunn.dlic.auth.ldap.srv.PlainTextLdapServer;
import com.floragunn.dlic.auth.ldap.srv.RestrictedInMemoryDirectoryServer;
import com.floragunn.dlic.auth.ldap.srv.StartTlsLdapServer;
import com.floragunn.dlic.auth.ldap.srv.TlsLdapServer;
import com.google.common.io.CharStreams;
import com.unboundid.ldap.listener.InMemoryDirectoryServerConfig;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.DN;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.schema.Schema;
import com.unboundid.ldif.LDIFReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.BindException;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class LdapServer {
    private static final Logger LOG = LoggerFactory.getLogger(LdapServer.class);
    private static final int LOCK_TIMEOUT = 60;
    private static final TimeUnit TIME_UNIT = TimeUnit.SECONDS;
    private static final String LOCK_TIMEOUT_MSG = "Unable to obtain lock due to timeout after 60 " + TIME_UNIT.toString();
    private static final String SERVER_NOT_STARTED = "The LDAP server is not started.";
    private static final String SERVER_ALREADY_STARTED = "The LDAP server is already started.";
    private RestrictedInMemoryDirectoryServer server;
    private final AtomicBoolean isStarted = new AtomicBoolean(Boolean.FALSE);
    private final ReentrantLock serverStateLock = new ReentrantLock();
    private int port = -1;

    public static LdapServer createTls(String ... ldifFiles) {
        for (int tries = 0; tries < 10; ++tries) {
            try {
                TlsLdapServer server = new TlsLdapServer();
                server.start(ldifFiles);
                return server;
            }
            catch (Exception e) {
                System.out.println("Unable to start ldap server, try again ... " + String.valueOf(e));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }
        System.out.println("Unable to start ldap server, return null");
        return null;
    }

    public static LdapServer createStartTls(String ... ldifFiles) {
        for (int tries = 0; tries < 10; ++tries) {
            try {
                StartTlsLdapServer server = new StartTlsLdapServer();
                server.start(ldifFiles);
                return server;
            }
            catch (Exception e) {
                System.out.println("Unable to start ldap server, try again ... " + String.valueOf(e));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }
        System.out.println("Unable to start ldap server, return null");
        return null;
    }

    public static LdapServer createPlainText(String ... ldifFiles) {
        for (int tries = 0; tries < 10; ++tries) {
            try {
                PlainTextLdapServer server = new PlainTextLdapServer();
                server.start(ldifFiles);
                return server;
            }
            catch (Exception e) {
                System.out.println("Unable to start ldap server, try again ... " + String.valueOf(e));
                try {
                    Thread.sleep(500L);
                    continue;
                }
                catch (InterruptedException ex) {
                    return null;
                }
            }
        }
        System.out.println("Unable to start ldap server, return null");
        return null;
    }

    public boolean isStarted() {
        return this.isStarted.get();
    }

    public int getPort() {
        return this.port;
    }

    public String hostAndPort() {
        return "localhost:" + this.port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int start(String ... ldifFiles) throws Exception {
        boolean hasLock = false;
        try {
            hasLock = this.serverStateLock.tryLock(60L, TIME_UNIT);
            if (hasLock) {
                int retVal = this.doStart(ldifFiles);
                this.isStarted.set(Boolean.TRUE);
                int n = retVal;
                return n;
            }
            try {
                throw new IllegalStateException(LOCK_TIMEOUT_MSG);
            }
            catch (InterruptedException ioe) {
                LOG.error(ioe.getMessage(), (Throwable)ioe);
            }
        }
        finally {
            if (hasLock) {
                this.serverStateLock.unlock();
            }
        }
        return -1;
    }

    private int doStart(String ... ldifFiles) throws Exception {
        if (this.isStarted.get()) {
            throw new IllegalStateException(SERVER_ALREADY_STARTED);
        }
        return this.configureAndStartServer(ldifFiles);
    }

    abstract InMemoryListenerConfig getInMemoryListenerConfig() throws LDAPException;

    private final String loadFile(String file) throws IOException {
        String ldif;
        try (InputStreamReader reader = new InputStreamReader(this.getClass().getResourceAsStream("/ldap/" + file), StandardCharsets.UTF_8);){
            ldif = CharStreams.toString((Readable)reader);
        }
        ldif = ldif.replace("${hostname}", "localhost");
        ldif = ldif.replace("${port}", String.valueOf(this.port));
        return ldif;
    }

    private synchronized int configureAndStartServer(String ... ldifFiles) throws Exception {
        InMemoryListenerConfig listenerConfig = this.getInMemoryListenerConfig();
        this.port = listenerConfig.getListenPort();
        Schema schema = Schema.getDefaultStandardSchema();
        String rootObjectDN = "o=TEST";
        InMemoryDirectoryServerConfig config = new InMemoryDirectoryServerConfig(new DN[]{new DN("o=TEST")});
        config.setSchema(schema);
        config.setListenerConfigs(Collections.singletonList(listenerConfig));
        config.setEnforceAttributeSyntaxCompliance(false);
        config.setEnforceSingleStructuralObjectClass(false);
        this.server = new RestrictedInMemoryDirectoryServer(config);
        try {
            this.server.clear();
            this.server.startListening();
            return this.loadLdifFiles(ldifFiles);
        }
        catch (LDAPException ldape) {
            if (ldape.getMessage().contains("java.net.BindException")) {
                throw new BindException(ldape.getMessage());
            }
            throw ldape;
        }
    }

    public void stop() {
        block8: {
            boolean hasLock = false;
            try {
                hasLock = this.serverStateLock.tryLock(60L, TIME_UNIT);
                if (hasLock) {
                    if (!this.isStarted.get()) {
                        throw new IllegalStateException(SERVER_NOT_STARTED);
                    }
                    LOG.info("Shutting down in-Memory Ldap Server.");
                    this.server.shutDown(true);
                    break block8;
                }
                throw new IllegalStateException(LOCK_TIMEOUT_MSG);
            }
            catch (InterruptedException ioe) {
                LOG.debug(ExceptionUtils.getStackTrace((Throwable)ioe));
            }
            finally {
                if (hasLock) {
                    this.serverStateLock.unlock();
                }
            }
        }
    }

    private int loadLdifFiles(String ... ldifFiles) throws Exception {
        int ldifLoadCount = 0;
        for (String ldif : ldifFiles) {
            ++ldifLoadCount;
            try (LDIFReader r = new LDIFReader(new BufferedReader(new StringReader(this.loadFile(ldif))));){
                Entry entry = null;
                while ((entry = r.readEntry()) != null) {
                    this.server.add(entry);
                    ++ldifLoadCount;
                }
            }
            catch (Exception e) {
                LOG.error(e.toString(), (Throwable)e);
                throw e;
            }
        }
        return ldifLoadCount;
    }
}

