/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap.srv;

import com.floragunn.dlic.auth.ldap.srv.LdapServer;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import com.unboundid.ldap.listener.InMemoryListenerConfig;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.util.ssl.KeyStoreKeyManager;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;

class StartTlsLdapServer
extends LdapServer {
    StartTlsLdapServer() {
    }

    @Override
    InMemoryListenerConfig getInMemoryListenerConfig() throws LDAPException {
        return InMemoryListenerConfig.createLDAPConfig((String)"ldap", null, (int)SocketUtils.findAvailableTcpPort(), (SSLSocketFactory)this.createSSLSocketFactory());
    }

    private SSLSocketFactory createSSLSocketFactory() {
        try {
            String serverKeyStorePath = FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/node-0-keystore.jks").toFile().getAbsolutePath();
            SSLUtil serverSSLUtil = new SSLUtil((KeyManager)new KeyStoreKeyManager(serverKeyStorePath, "changeit".toCharArray()), (TrustManager)new TrustStoreTrustManager(serverKeyStorePath));
            return serverSSLUtil.createSSLSocketFactory();
        }
        catch (Exception e) {
            throw new RuntimeException("Error while creating SSLSocketFactory");
        }
    }
}

