/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.ldap2;

import com.floragunn.dlic.auth.ldap.LdapUser;
import com.floragunn.dlic.auth.ldap.srv.LdapServer;
import com.floragunn.dlic.auth.ldap2.LDAPAuthenticationBackend2;
import com.floragunn.dlic.auth.ldap2.LDAPAuthorizationBackend2;
import com.floragunn.dlic.auth.ldap2.LDAPConnectionManager;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.SearchResultEntry;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.TreeSet;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class LdapBackendTestNewStyleConfig2 {
    private static LdapServer tlsLdapServer;
    private static LdapServer startTlsLdapServer;
    private static LdapServer plainTextLdapServer;
    @Parameterized.Parameter
    public boolean healthCheckEnabled;

    @Parameterized.Parameters
    public static Object[] parameters() {
        return new Object[]{Boolean.FALSE, Boolean.TRUE};
    }

    protected Settings.Builder createBaseSettings() {
        if (this.healthCheckEnabled) {
            return Settings.builder().put("pool.health_check.enabled", true).put("pool.health_check.interval_millis", 5L).put("pool.health_check.validation.max_response_time", 300L).put("pool.health_check.validation.on_create", true).put("pool.health_check.validation.on_release", true).put("pool.health_check.validation.on_exception", true).put("pool.health_check.pruning.enabled", true);
        }
        return Settings.builder();
    }

    @Test
    public void testLdapAuthentication() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testLdapAuthenticationFakeLogin() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("fakelogin_enabled", true).build();
        new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"unknown").password("unknown").build());
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testLdapInjection() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        String injectString = "*jack*";
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)injectString).password("secret").build());
    }

    @Test
    public void testLdapAuthenticationBindDn() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("bind_dn", "cn=Captain Spock,ou=people,o=TEST").put("password", "spocksecret").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationWrongBindDn() throws Exception {
        try {
            Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("bind_dn", "cn=Captain Spock,ou=people,o=TEST").put("password", "wrong").build();
            new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertTrue((String)ExceptionUtils.getStackTrace((Throwable)e), (boolean)ExceptionUtils.getStackTrace((Throwable)e).contains("password was incorrect"));
        }
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testLdapAuthenticationBindFail() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("wrong").build());
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testLdapAuthenticationNoUser() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"UNKNOWN").password("UNKNOWN").build());
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testLdapAuthenticationFail() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("xxxxx").build());
    }

    @Test
    public void testLdapAuthenticationSSL() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/truststore.jks")).put("verify_hostnames", false).put("path.home", ".").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationSSLPEMFile() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("pemtrustedcas_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/root-ca.pem").toFile().getName()).put("verify_hostnames", false).put("path.home", ".").put("path.conf", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/root-ca.pem").getParent()).build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, Paths.get("src/test/resources/ldap", new String[0])).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationSSLPEMText() throws Exception {
        Settings settingsFromFile = Settings.builder().loadFromPath(Paths.get(FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/test1.yml").toFile().getAbsolutePath(), new String[0])).build();
        Settings settings = Settings.builder().put(settingsFromFile).putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationSSLSSLv3() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/truststore.jks")).put("verify_hostnames", false).putList("enabled_ssl_protocols", new String[]{"SSLv3"}).put("path.home", ".").build();
        try {
            new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
            Assert.fail((String)"Expected Exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)e.getMessage().contains("protocol is disabled or cipher suites are inappropriate"));
        }
    }

    @Test
    public void testLdapAuthenticationSSLUnknownCipher() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/truststore.jks")).put("verify_hostnames", false).putList("enabled_ssl_ciphers", new String[]{"AAA"}).put("path.home", ".").build();
        try {
            new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
            Assert.fail((String)"Expected Exception");
        }
        catch (Exception e) {
            Assert.assertTrue((String)ExceptionUtils.getStackTrace((Throwable)e), (boolean)WildcardMatcher.match((String)"*unsupported*ciphersuite*aaa*", (String)ExceptionUtils.getStackTrace((Throwable)e).toLowerCase()));
        }
    }

    @Test
    public void testLdapAuthenticationSpecialCipherProtocol() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/truststore.jks")).put("verify_hostnames", false).putList("enabled_ssl_protocols", new String[]{"TLSv1.2"}).putList("enabled_ssl_ciphers", new String[]{"TLS_DHE_RSA_WITH_AES_128_CBC_SHA256"}).put("path.home", ".").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationSSLNoKeystore() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + tlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/truststore.jks")).put("verify_hostnames", false).put("path.home", ".").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationSSLFailPlain() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).build();
        try {
            new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
            Assert.fail((String)"Expected exception");
        }
        catch (Exception e) {
            Assert.assertEquals(IllegalStateException.class, e.getCause().getCause().getClass());
        }
    }

    @Test
    public void testLdapExists() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        LDAPAuthenticationBackend2 lbe = new LDAPAuthenticationBackend2(settings, null);
        Assert.assertTrue((boolean)lbe.exists(new User("jacksonm")));
        Assert.assertFalse((boolean)lbe.exists(new User("doesnotexist")));
    }

    @Test
    public void testLdapAuthorization() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("roles.g1.search", "(uniqueMember={0})").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"ceo", new ArrayList(new TreeSet(user.getRoles())).get(0));
        Assert.assertEquals((Object)user.getName(), (Object)user.getUserEntry().getDN());
    }

    @Test
    public void testLdapAuthenticationReferral() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        try (LDAPConnectionManager conMngt = new LDAPConnectionManager(settings, null);
             LDAPConnection con = conMngt.getConnection();){
            SearchResultEntry ref1 = conMngt.lookup(con, "cn=Ref1,ou=people,o=TEST");
            Assert.assertEquals((Object)"cn=refsolved,ou=people,o=TEST", (Object)ref1.getDN());
        }
    }

    @Test
    public void testLdapEscape() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("roles.g1.search", "(uniqueMember={0})").put("userrolename", "description").put("resolve_nested_roles", true).build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"ssign").password("ssignsecret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Special\\, Sign,ou=people,o=TEST", (Object)user.getName());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertEquals((Object)"cn=Special\\, Sign,ou=people,o=TEST", (Object)user.getName());
        Assert.assertEquals((long)4L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ceo"));
    }

    @Test
    public void testLdapAuthorizationRoleSearchUsername() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(cn={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("roles.g1.search", "(uniqueMember=cn={1},ou=people,o=TEST)").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"Michael Jackson").password("secret").build());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"Michael Jackson", (Object)user.getOriginalUsername());
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getUserEntry().getDN());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"ceo", new ArrayList(new TreeSet(user.getRoles())).get(0));
        Assert.assertEquals((Object)user.getName(), (Object)user.getUserEntry().getDN());
    }

    @Test
    public void testLdapAuthorizationOnly() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("roles.g1.search", "(uniqueMember={0})").build();
        User user = new User("jacksonm");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"jacksonm", (Object)user.getName());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"ceo", new ArrayList(new TreeSet(user.getRoles())).get(0));
    }

    @Test
    public void testLdapAuthorizationNested() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)4L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"nested1", new ArrayList(new TreeSet(user.getRoles())).get(1));
    }

    @Test
    public void testLdapAuthorizationNestedFilter() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").putList("nested_role_filter", new String[]{"cn=nested2,ou=groups,o=TEST"}).build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"ceo", new ArrayList(new TreeSet(user.getRoles())).get(0));
        Assert.assertEquals((Object)"nested2", new ArrayList(new TreeSet(user.getRoles())).get(1));
    }

    @Test
    public void testLdapAuthorizationDnNested() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "dn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)4L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"cn=nested1,ou=groups,o=TEST", new ArrayList(new TreeSet(user.getRoles())).get(1));
    }

    @Test
    public void testLdapAuthorizationDn() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "dn").put("username_attribute", "UID").put("resolve_nested_roles", false).put("roles.g1.search", "(uniqueMember={0})").build();
        User user = new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret".getBytes()).build());
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"jacksonm", (Object)user.getName());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"cn=ceo,ou=groups,o=TEST", new ArrayList(new TreeSet(user.getRoles())).get(0));
    }

    @Test
    public void testLdapAuthenticationUserNameAttribute() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.base", "ou=people,o=TEST").put("users.u1.search", "(uid={0})").put("username_attribute", "uid").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"jacksonm", (Object)user.getName());
    }

    @Test
    public void testLdapAuthenticationStartTLS() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + startTlsLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("enable_ssl", true).put("enable_start_tls", true).put("searchguard.ssl.transport.truststore_filepath", FileHelper.getAbsoluteFilePathFromClassPath((String)"ldap/truststore.jks")).put("verify_hostnames", false).put("path.home", ".").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testLdapAuthorizationSkipUsers() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("roles.g1.search", "(uniqueMember={0})").putList("skip_users", new String[]{"cn=Michael Jackson,ou*people,o=TEST"}).build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
        Assert.assertEquals((long)0L, (long)user.getRoles().size());
        Assert.assertEquals((Object)user.getName(), (Object)user.getUserEntry().getDN());
    }

    @Test
    public void testLdapAuthorizationNestedAttr() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").put("userrolename", "description").put("rolesearch_enabled", true).build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)8L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"nested3", new ArrayList(new TreeSet(user.getRoles())).get(4));
        Assert.assertEquals((Object)"rolemo4", new ArrayList(new TreeSet(user.getRoles())).get(7));
    }

    @Test
    public void testLdapAuthorizationNestedAttrFilter() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").put("userrolename", "description").put("rolesearch_enabled", true).putList("nested_role_filter", new String[]{"cn=rolemo4*"}).build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)6L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"role2", new ArrayList(new TreeSet(user.getRoles())).get(4));
        Assert.assertEquals((Object)"nested1", new ArrayList(new TreeSet(user.getRoles())).get(2));
    }

    @Test
    public void testLdapAuthorizationNestedAttrFilterAll() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").put("userrolename", "description").put("rolesearch_enabled", true).putList("nested_role_filter", new String[]{"*"}).build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)4L, (long)user.getRoles().size());
    }

    @Test
    public void testLdapAuthorizationNestedAttrFilterAllEqualsNestedFalse() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", false).put("roles.g1.search", "(uniqueMember={0})").put("userrolename", "description").put("rolesearch_enabled", true).build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)4L, (long)user.getRoles().size());
    }

    @Test
    public void testLdapAuthorizationNestedAttrNoRoleSearch() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "unused").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(((unused").put("userrolename", "description").put("rolesearch_enabled", false).build();
        User user = new User("spock");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"spock", (Object)user.getName());
        Assert.assertEquals((long)3L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"nested3", new ArrayList(new TreeSet(user.getRoles())).get(1));
        Assert.assertEquals((Object)"rolemo4", new ArrayList(new TreeSet(user.getRoles())).get(2));
    }

    @Test
    public void testCustomAttributes() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
        Assert.assertEquals((String)user.getCustomAttributesMap().toString(), (long)16L, (long)user.getCustomAttributesMap().size());
        Assert.assertFalse((String)user.getCustomAttributesMap().toString(), (boolean)user.getCustomAttributesMap().keySet().contains("attr.ldap.userpassword"));
        settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("custom_attr_maxval_len", 0).build();
        user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertEquals((String)user.getCustomAttributesMap().toString(), (long)2L, (long)user.getCustomAttributesMap().size());
        settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").putList("custom_attr_whitelist", new String[]{"*objectclass*", "entryParentId"}).build();
        user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertEquals((String)user.getCustomAttributesMap().toString(), (long)2L, (long)user.getCustomAttributesMap().size());
    }

    @Test
    public void testLdapAuthorizationNonDNRoles() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("roles.g1.base", "ou=groups,o=TEST").put("rolename", "cn").put("resolve_nested_roles", true).put("roles.g1.search", "(uniqueMember={0})").put("userrolename", "description, ou").put("rolesearch_enabled", true).build();
        User user = new User("nondnroles");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"nondnroles", (Object)user.getName());
        Assert.assertEquals((long)5L, (long)user.getRoles().size());
        Assert.assertTrue((String)"Roles do not contain non-LDAP role 'kibanauser'", (boolean)user.getRoles().contains("kibanauser"));
        Assert.assertTrue((String)"Roles do not contain non-LDAP role 'humanresources'", (boolean)user.getRoles().contains("humanresources"));
        Assert.assertTrue((String)"Roles do not contain LDAP role 'dummyempty'", (boolean)user.getRoles().contains("dummyempty"));
        Assert.assertTrue((String)"Roles do not contain non-LDAP role 'role2'", (boolean)user.getRoles().contains("role2"));
        Assert.assertTrue((String)"Roles do not contain non-LDAP role 'anotherrole' from second role name", (boolean)user.getRoles().contains("anotherrole"));
    }

    @Test
    public void testChainedLdapAuthentication1() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("users.u2.search", "(uid={0})").put("users.u2.base", "ou=people2,o=TEST").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
    }

    @Test
    public void testChainedLdapAuthentication2() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("users.u2.search", "(uid={0})").put("users.u2.base", "ou=people2,o=TEST").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"presleye").password("secret").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Elvis Presley,ou=people2,o=TEST", (Object)user.getName());
    }

    @Test(expected=ElasticsearchSecurityException.class)
    public void testChainedLdapAuthenticationDuplicate() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("search_all_bases", true).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("users.u2.search", "(uid={0})").put("users.u2.base", "ou=people2,o=TEST").build();
        new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
    }

    @Test
    public void testChainedLdapAuthorization() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"127.0.0.1:4", "localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people,o=TEST").put("rolename", "cn").put("roles.g1.base", "ou=groups,o=TEST").put("roles.g1.search", "(uniqueMember={0})").put("roles.g2.base", "ou=groups2,o=TEST").put("roles.g2.search", "(uniqueMember={0})").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Michael Jackson,ou=people,o=TEST", (Object)user.getName());
        Assert.assertEquals((long)3L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains("ceo"));
        Assert.assertTrue((boolean)user.getRoles().contains("king"));
        Assert.assertTrue((boolean)user.getRoles().contains("role2"));
        Assert.assertEquals((Object)user.getName(), (Object)user.getUserEntry().getDN());
    }

    @Test
    public void testCrossChainedLdapAuthorization() throws Exception {
        Settings settings = this.createBaseSettings().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("users.u1.search", "(uid={0})").put("users.u1.base", "ou=people2,o=TEST").put("rolename", "cn").put("roles.g1.base", "ou=groups,o=TEST").put("roles.g1.search", "(uniqueMember={0})").put("roles.g2.base", "ou=groups2,o=TEST").put("roles.g2.search", "(uniqueMember={0})").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"mercuryf").password("secret").build());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"cn=Freddy Mercury,ou=people2,o=TEST", (Object)user.getName());
        Assert.assertEquals((long)1L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().contains("crossnested2"));
    }

    @Test
    public void testLdapAuthorizationNonDNEntry() throws Exception {
        Settings settings = Settings.builder().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("usersearch", "(uid={0})").put("userbase", "ou=people,o=TEST").put("rolebase", "ou=groups,o=TEST").put("rolename", "description").put("rolesearch", "(uniqueMember={0})").build();
        User user = new User("jacksonm");
        new LDAPAuthorizationBackend2(settings, null).fillRoles(user, null);
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"jacksonm", (Object)user.getName());
        Assert.assertEquals((long)2L, (long)user.getRoles().size());
        Assert.assertEquals((Object)"ceo-ceo", new ArrayList(new TreeSet(user.getRoles())).get(0));
    }

    @Test
    public void testLdapSpecial186() throws Exception {
        Settings settings = Settings.builder().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("usersearch", "(uid={0})").put("userbase", "ou=people,o=TEST").put("rolebase", "ou=groups,o=TEST").put("rolename", "description").put("rolesearch", "(uniqueMember={0})").put("resolve_nested_roles", true).build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"spec186").password("spec186").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"CN=AA BB/CC (DD) my\\, company end\\=with\\=whitespace\\ ,ou=people,o=TEST", (Object)user.getName());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertEquals((long)3L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLEx(186n) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186nn) consists of\\, special="));
        new LDAPAuthorizationBackend2(settings, null).fillRoles(new User("spec186"), null);
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLEx(186n) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186nn) consists of\\, special="));
        new LDAPAuthorizationBackend2(settings, null).fillRoles(new User("CN=AA BB/CC (DD) my\\, company end\\=with\\=whitespace\\ ,ou=people,o=TEST"), null);
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLEx(186n) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186nn) consists of\\, special="));
        new LDAPAuthorizationBackend2(settings, null).fillRoles(new User("CN=AA BB\\/CC (DD) my\\, company end\\=with\\=whitespace\\ ,ou=people,o=TEST"), null);
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLEx(186n) consists of\\, special="));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("ROLE/(186nn) consists of\\, special="));
    }

    @Test
    public void testLdapSpecial186_2() throws Exception {
        Settings settings = Settings.builder().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("usersearch", "(uid={0})").put("userbase", "ou=people,o=TEST").put("rolebase", "ou=groups,o=TEST").put("rolename", "dn").put("rolesearch", "(uniqueMember={0})").put("resolve_nested_roles", true).build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"spec186").password("spec186").build());
        Assert.assertNotNull((Object)user);
        Assert.assertEquals((Object)"CN=AA BB/CC (DD) my\\, company end\\=with\\=whitespace\\ ,ou=people,o=TEST", (Object)user.getName());
        new LDAPAuthorizationBackend2(settings, null).fillRoles((User)user, null);
        Assert.assertEquals((long)3L, (long)user.getRoles().size());
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186n) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186nn) consists of\\, special\\=chars\\ "));
        new LDAPAuthorizationBackend2(settings, null).fillRoles(new User("spec186"), null);
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186n) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186nn) consists of\\, special\\=chars\\ "));
        new LDAPAuthorizationBackend2(settings, null).fillRoles(new User("CN=AA BB/CC (DD) my\\, company end\\=with\\=whitespace\\ ,ou=people,o=TEST"), null);
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186n) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186nn) consists of\\, special\\=chars\\ "));
        new LDAPAuthorizationBackend2(settings, null).fillRoles(new User("CN=AA BB\\/CC (DD) my\\, company end\\=with\\=whitespace\\ ,ou=people,o=TEST"), null);
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186n) consists of\\, special\\=chars\\ "));
        Assert.assertTrue((boolean)user.getRoles().toString().contains("cn=ROLE/(186nn) consists of\\, special\\=chars\\ "));
    }

    @Test
    public void testOperationalAttributes() throws Exception {
        Settings settings = Settings.builder().putList("hosts", new String[]{"localhost:" + plainTextLdapServer.getPort()}).put("usersearch", "(uid={0})").build();
        LdapUser user = (LdapUser)new LDAPAuthenticationBackend2(settings, null).authenticate(AuthCredentials.forUser((String)"jacksonm").password("secret").build());
        Assert.assertNotNull((Object)user);
        Attribute operationAttribute = user.getUserEntry().getUbEntry().getAttribute("entryUUID");
        Assert.assertNotNull((Object)operationAttribute);
        Assert.assertNotNull((Object)operationAttribute.getValue());
        Assert.assertTrue((operationAttribute.getValue().length() > 10 ? 1 : 0) != 0);
        Assert.assertTrue((operationAttribute.getValue().split("-").length == 5 ? 1 : 0) != 0);
    }

    @AfterClass
    public static void tearDown() throws Exception {
        if (tlsLdapServer != null) {
            tlsLdapServer.stop();
        }
        if (startTlsLdapServer != null) {
            startTlsLdapServer.stop();
        }
        if (plainTextLdapServer != null) {
            plainTextLdapServer.stop();
        }
    }

    static {
        System.setProperty("sg.display_lic_none", "true");
        tlsLdapServer = LdapServer.createTls("base.ldif", "base2.ldif");
        startTlsLdapServer = LdapServer.createStartTls("base.ldif", "base2.ldif");
        plainTextLdapServer = LdapServer.createPlainText("base.ldif", "base2.ldif");
    }
}

