/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.util;

import com.floragunn.dlic.util.SettingsBasedSSLConfigurator;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.SocketUtils;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Map;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.ssl.PrivateKeyDetails;
import org.apache.http.ssl.PrivateKeyStrategy;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.ssl.SSLContexts;
import org.elasticsearch.common.settings.Settings;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class SettingsBasedSSLConfiguratorTest {
    @Rule
    public ExpectedException thrown = ExpectedException.none();

    @Test
    public void testPemTrust() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/pem/truststore.jks", "sslConfigurator/pem/node1-keystore.jks", "secret", false);){
            Path rootCaPemPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/pem/root-ca.pem");
            Assert.assertTrue((boolean)rootCaPemPath.toFile().exists());
            Settings settings = Settings.builder().put("prefix.pemtrustedcas_filepath", rootCaPemPath.getFileName().toString()).put("prefix.enable_ssl", "true").put("path.home", rootCaPemPath.getParent().toString()).build();
            Path configPath = rootCaPemPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    @Test
    public void testPemWrongTrust() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/pem/truststore.jks", "sslConfigurator/pem/node1-keystore.jks", "secret", false);){
            Path rootCaPemPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/pem/other-root-ca.pem");
            Settings settings = Settings.builder().put("prefix.pemtrustedcas_filepath", rootCaPemPath.getFileName().toString()).put("prefix.enable_ssl", "true").put("path.home", rootCaPemPath.getParent().toString()).build();
            Path configPath = rootCaPemPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                this.thrown.expect(SSLHandshakeException.class);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));){
                    Assert.fail((String)"Connection should have failed due to wrong trust");
                }
            }
        }
    }

    @Test
    public void testPemClientAuth() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/pem/truststore.jks", "sslConfigurator/pem/node1-keystore.jks", "secret", true);){
            Path rootCaPemPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/pem/root-ca.pem");
            Settings settings = Settings.builder().put("prefix.pemtrustedcas_filepath", rootCaPemPath.getFileName().toString()).put("prefix.enable_ssl", "true").put("path.home", rootCaPemPath.getParent().toString()).put("prefix.enable_ssl_client_auth", "true").put("prefix.pemcert_filepath", "kirk.pem").put("prefix.pemkey_filepath", "kirk.key").put("prefix.pemkey_password", "secret").build();
            Path configPath = rootCaPemPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    @Test
    public void testPemClientAuthFailure() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/pem/truststore.jks", "sslConfigurator/pem/node1-keystore.jks", "secret", true);){
            Path rootCaPemPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/pem/root-ca.pem");
            Settings settings = Settings.builder().put("prefix.pemtrustedcas_filepath", rootCaPemPath.getFileName().toString()).put("prefix.enable_ssl", "true").put("path.home", rootCaPemPath.getParent().toString()).put("prefix.enable_ssl_client_auth", "true").put("prefix.pemcert_filepath", "wrong-kirk.pem").put("prefix.pemkey_filepath", "wrong-kirk.key").put("prefix.pemkey_password", "G0CVtComen4a").build();
            Path configPath = rootCaPemPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                this.thrown.expect((Matcher)CoreMatchers.either((Matcher)CoreMatchers.instanceOf(SocketException.class)).or(CoreMatchers.instanceOf(SSLHandshakeException.class)).or(CoreMatchers.instanceOf(SSLException.class)));
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));){
                    Assert.fail((String)"Connection should have failed due to wrong client cert");
                }
            }
        }
    }

    @Test
    public void testPemHostnameVerificationFailure() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/pem/truststore.jks", "sslConfigurator/pem/node-wrong-hostname-keystore.jks", "secret", false);){
            Path rootCaPemPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/pem/root-ca.pem");
            Settings settings = Settings.builder().put("prefix.pemtrustedcas_filepath", rootCaPemPath.getFileName().toString()).put("prefix.enable_ssl", "true").put("prefix.verify_hostnames", "true").put("path.home", rootCaPemPath.getParent().toString()).build();
            Path configPath = rootCaPemPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                this.thrown.expect(SSLPeerUnverifiedException.class);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));){
                    Assert.fail((String)"Connection should have failed due to wrong hostname");
                }
            }
        }
    }

    @Test
    public void testPemHostnameVerificationOff() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/pem/truststore.jks", "sslConfigurator/pem/node-wrong-hostname-keystore.jks", "secret", false);){
            Path rootCaPemPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/pem/root-ca.pem");
            Settings settings = Settings.builder().put("prefix.pemtrustedcas_filepath", rootCaPemPath.getFileName().toString()).put("prefix.enable_ssl", "true").put("prefix.verify_hostnames", "false").put("path.home", rootCaPemPath.getParent().toString()).build();
            Path configPath = rootCaPemPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    @Test
    public void testJksTrust() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/jks/truststore.jks", "sslConfigurator/jks/node1-keystore.jks", "secret", false);){
            Path rootCaJksPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/jks/truststore.jks");
            Settings settings = Settings.builder().put("searchguard.ssl.transport.truststore_filepath", rootCaJksPath.getFileName().toString()).put("searchguard.ssl.transport.truststore_password", "secret").put("prefix.enable_ssl", "true").put("path.home", rootCaJksPath.getParent().toString()).build();
            Path configPath = rootCaJksPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    @Test
    public void testJksWrongTrust() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/jks/truststore.jks", "sslConfigurator/jks/node1-keystore.jks", "secret", false);){
            Path rootCaJksPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/jks/other-root-ca.jks");
            Settings settings = Settings.builder().put("searchguard.ssl.transport.truststore_filepath", rootCaJksPath.getFileName().toString()).put("searchguard.ssl.transport.truststore_password", "secret").put("prefix.enable_ssl", "true").put("path.home", rootCaJksPath.getParent().toString()).build();
            Path configPath = rootCaJksPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                this.thrown.expect(SSLHandshakeException.class);
                try (CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));){
                    Assert.fail((String)"Connection should have failed due to wrong trust");
                }
            }
        }
    }

    @Test
    public void testTrustAll() throws Exception {
        try (TestServer testServer = new TestServer("sslConfigurator/jks/truststore.jks", "sslConfigurator/jks/node1-keystore.jks", "secret", false);){
            Path rootCaJksPath = FileHelper.getAbsoluteFilePathFromClassPath((String)"sslConfigurator/jks/other-root-ca.jks");
            Settings settings = Settings.builder().put("prefix.enable_ssl", "true").put("prefix.trust_all", "true").put("path.home", rootCaJksPath.getParent().toString()).build();
            Path configPath = rootCaJksPath.getParent();
            SettingsBasedSSLConfigurator sbsc = new SettingsBasedSSLConfigurator(settings, configPath, "prefix");
            SettingsBasedSSLConfigurator.SSLConfig sslConfig = sbsc.buildSSLConfig();
            try (CloseableHttpClient httpClient = HttpClients.custom().setSSLSocketFactory((LayeredConnectionSocketFactory)sslConfig.toSSLConnectionSocketFactory()).build();){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)new HttpGet(testServer.getUri()));
                if (response != null) {
                    response.close();
                }
            }
        }
    }

    static class TestServer
    implements Closeable {
        private HttpServer httpServer;
        private int port;

        TestServer(String trustStore, String keyStore, String password, boolean clientAuth) throws IOException {
            this.createHttpServer(trustStore, keyStore, password, clientAuth);
        }

        String getUri() {
            return "https://localhost:" + this.port + "/test";
        }

        private void createHttpServer(String trustStore, String keyStore, String password, final boolean clientAuth) throws IOException {
            this.port = SocketUtils.findAvailableTcpPort();
            ServerBootstrap serverBootstrap = ServerBootstrap.bootstrap().setListenerPort(this.port).registerHandler("test", new HttpRequestHandler(){

                public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                }
            });
            serverBootstrap = serverBootstrap.setSslContext(this.createSSLContext(trustStore, keyStore, password)).setSslSetupHandler(new SSLServerSetupHandler(){

                public void initialize(SSLServerSocket socket) throws SSLException {
                    if (clientAuth) {
                        socket.setNeedClientAuth(true);
                    }
                }
            }).setConnectionFactory((HttpConnectionFactory)new HttpConnectionFactory<DefaultBHttpServerConnection>(){
                private ConnectionConfig cconfig = ConnectionConfig.DEFAULT;

                public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
                    SSLTestHttpServerConnection conn = new SSLTestHttpServerConnection(this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), ConnSupport.createDecoder((ConnectionConfig)this.cconfig), ConnSupport.createEncoder((ConnectionConfig)this.cconfig), this.cconfig.getMessageConstraints(), null, null, null, null);
                    conn.bind(socket);
                    return conn;
                }
            });
            this.httpServer = serverBootstrap.create();
            this.httpServer.start();
        }

        @Override
        public void close() throws IOException {
            if (this.httpServer != null) {
                this.httpServer.shutdown(0L, null);
            }
        }

        private SSLContext createSSLContext(String trustStorePath, String keyStorePath, String password) {
            try {
                TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                KeyStore trustStore = KeyStore.getInstance("JKS");
                FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)trustStorePath).toFile());
                trustStore.load(trustStream, password.toCharArray());
                tmf.init(trustStore);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
                KeyStore keyStore = KeyStore.getInstance("JKS");
                Path path = FileHelper.getAbsoluteFilePathFromClassPath((String)keyStorePath);
                if (path == null) {
                    throw new RuntimeException("Could not find " + keyStorePath);
                }
                FileInputStream keyStream = new FileInputStream(path.toFile());
                keyStore.load(keyStream, password.toCharArray());
                kmf.init(keyStore, password.toCharArray());
                SSLContextBuilder sslContextBuilder = SSLContexts.custom();
                sslContextBuilder.loadTrustMaterial(trustStore, null);
                sslContextBuilder.loadKeyMaterial(keyStore, password.toCharArray(), new PrivateKeyStrategy(){

                    public String chooseAlias(Map<String, PrivateKeyDetails> aliases, Socket socket) {
                        return "node1";
                    }
                });
                return sslContextBuilder.build();
            }
            catch (IOException | GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
        }

        static class SSLTestHttpServerConnection
        extends DefaultBHttpServerConnection {
            public SSLTestHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
                super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
            }

            public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
                return ((SSLSocket)this.getSocket()).getSession().getPeerCertificates();
            }
        }
    }
}

