/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.dlic.auth.http.jwt.keybyoidc;

import com.floragunn.codova.documents.DocReader;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.HTTPJwtKeyByOpenIdConnectAuthenticator;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.MockIpdServer;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.TestJwk;
import com.floragunn.dlic.auth.http.jwt.keybyoidc.TestJwts;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.util.FakeRestRequest;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.rs.security.jose.jwk.JsonWebKey;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.internal.LoggerFactoryImpl;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.logging.internal.spi.LoggerFactory;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentType;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

@Deprecated
public class HTTPJwtKeyByOpenIdConnectAuthenticatorTest {
    protected static MockIpdServer mockIdpServer;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @ClassRule
    public static WireMockRule wireMockProxy;

    @BeforeClass
    public static void setUp() throws Exception {
        mockIdpServer = MockIpdServer.start(TestJwk.Jwks.ALL);
    }

    @AfterClass
    public static void tearDown() {
        if (mockIdpServer != null) {
            try {
                mockIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void basicTest() {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals((Object)"TestAudience", creds.getAttributes().get("attr.jwt.aud"));
        Assert.assertEquals((long)0L, (long)creds.getBackendRoles().size());
        Assert.assertEquals((long)3L, (long)creds.getAttributes().size());
    }

    @Test
    public void proxyTest() throws Exception {
        try (MockIpdServer proxyOnlyMockIdpServer = MockIpdServer.start(TestJwk.Jwks.ALL).acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader());){
            proxyOnlyMockIdpServer.setRequireValidCodes(false);
            Settings settings = Settings.builder().put("openid_connect_url", proxyOnlyMockIdpServer.getDiscoverUri().toString()).put("proxy.host", "127.0.0.8").put("proxy.port", wireMockProxy.port()).put("proxy.scheme", "http").build();
            HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
            AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
            Assert.assertNotNull((Object)creds);
            Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
            Assert.assertEquals((Object)"TestAudience", creds.getAttributes().get("attr.jwt.aud"));
            Assert.assertEquals((long)0L, (long)creds.getBackendRoles().size());
            Assert.assertEquals((long)3L, (long)creds.getAttributes().size());
            FakeRestRequest restRequest = new FakeRestRequest();
            TestRestChannel restChannel = new TestRestChannel(restRequest);
            jwtAuth.handleMetaRequest((RestRequest)restRequest, (RestChannel)restChannel, "/_searchguard/test/openid", "config", null);
            String response = restChannel.response.content().utf8ToString();
            Map parsedResponse = DocReader.json().readObject(response);
            Assert.assertTrue((String)response, (boolean)parsedResponse.containsKey("token_endpoint_proxy"));
            restRequest = new FakeRestRequest.Builder().withMethod(RestRequest.Method.POST).withContent((BytesReference)new BytesArray("grant_type=authorization_code&code=wusch")).withHeaders((Map<String, String>)ImmutableMap.of((Object)"Content-Type", (Object)"application/x-www-form-urlencoded")).build();
            restChannel = new TestRestChannel(restRequest);
            jwtAuth.handleMetaRequest((RestRequest)restRequest, (RestChannel)restChannel, "/_searchguard/test/openid", "token", null);
            response = restChannel.response.content().utf8ToString();
            parsedResponse = DocReader.json().readObject(response);
            Assert.assertTrue((String)response, (boolean)parsedResponse.containsKey("id_token"));
        }
    }

    @Test
    public void bearerTest() {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)("Bearer " + TestJwts.MC_COY_SIGNED_OCT_1)), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals((Object)"TestAudience", creds.getAttributes().get("attr.jwt.aud"));
        Assert.assertEquals((long)0L, (long)creds.getBackendRoles().size());
        Assert.assertEquals((long)3L, (long)creds.getAttributes().size());
    }

    @Test
    public void testRoles() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_key", "roles").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals(TestJwts.TEST_ROLES, (Object)creds.getBackendRoles());
    }

    @Test
    public void testRolesJsonPath() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_path", "$.roles").put("subject_path", "$.sub").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals(TestJwts.TEST_ROLES, (Object)creds.getBackendRoles());
    }

    @Test
    public void testRolesCollectionJsonPath() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_path", "$.roles").put("subject_path", "$.sub").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)com.floragunn.searchguard.enterprise.auth.oidc.TestJwts.createSigned((JwtToken)com.floragunn.searchguard.enterprise.auth.oidc.TestJwts.create((String)"Leonard McCoy", (String)"TestAudience", (Object[])new Object[]{"roles", Arrays.asList("role 1", "role 2", "role 3, role 4")}), (JsonWebKey)TestJwk.OCT_1)), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertThat((Object)creds.getBackendRoles(), (Matcher)CoreMatchers.hasItems((Object[])new String[]{"role 1", "role 2", "role 3", "role 4"}));
    }

    @Test
    public void testInvalidSubjectJsonPath() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_path", "$.roles").put("subject_path", "$.subasd").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNull((Object)creds);
    }

    @Test
    public void testInvalidRolesJsonPath() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_path", "$.asdroles").put("subject_path", "$.sub").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals(Collections.emptySet(), (Object)creds.getBackendRoles());
    }

    @Test
    public void testExp() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_EXPIRED_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNull((Object)creds);
    }

    @Test
    public void testRS256() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_RSA_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals((Object)"TestAudience", creds.getAttributes().get("attr.jwt.aud"));
        Assert.assertEquals((long)0L, (long)creds.getBackendRoles().size());
        Assert.assertEquals((long)3L, (long)creds.getAttributes().size());
    }

    @Test
    public void testBadSignature() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_RSA_X), new HashMap<String, String>()), null);
        Assert.assertNull((Object)creds);
    }

    @Test
    public void testPeculiarJsonEscaping() {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)"eyJraWQiOiJraWRcLzEiLCJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJMZW9uYXJkIE1jQ295IiwiYXVkIjoiVGVzdEF1ZGllbmNlIiwicm9sZXMiOiJyb2xlMSxyb2xlMiJ9.C0ntlhZtalpOYzgrzq_I4c6NxeQEmUk9Id5fVI6SXLIyscBrpS8nQ3bZrtX3qDiCYZDbp5n1OJMp3nhC7Ro2qdWjFe3FRSewKyZSowzVdQSlPetEsyLh3KdEs2ZPx3vry_y8SeCcJw_tiUOysceTMKzseL3DzF2PmoRRARLbQVI6zQvanRC8-WREraA2gTXpv_R-haOy7sf00VQhjGPMTCjqxXTfO6gzCz5-02tpGOOooQ8BcPy_At0nKjmuZgw_jODTL4TYs_T48M9tHxuY02qF3zv6iLonFz1mrb7Ff-65OUo4QVfqiOMxCOAe1JFP9o1tbtgaoiaWVznezjRK6A"), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)creds.getUsername());
        Assert.assertEquals((Object)"TestAudience", creds.getAttributes().get("attr.jwt.aud"));
        Assert.assertEquals((long)0L, (long)creds.getBackendRoles().size());
        Assert.assertEquals((long)3L, (long)creds.getAttributes().size());
    }

    @Test
    public void testSubjectPattern() {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("subject_pattern", "^(.)(?:.*)$").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_COY_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"Leonard McCoy".substring(0, 1), (Object)creds.getUsername());
        Assert.assertEquals((Object)"TestAudience", creds.getAttributes().get("attr.jwt.aud"));
        Assert.assertEquals((long)0L, (long)creds.getBackendRoles().size());
        Assert.assertEquals((long)3L, (long)creds.getAttributes().size());
    }

    @Test
    public void testSubjectJsonPathWithList() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_path", "$.roles").put("subject_path", "$.n").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_LIST_CLAIM_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNotNull((Object)creds);
        Assert.assertEquals((Object)"mcl", (Object)creds.getUsername());
        Assert.assertEquals(TestJwts.TEST_ROLES, (Object)creds.getBackendRoles());
    }

    @Test
    public void testSubjectJsonPathWithListSize2() throws Exception {
        Settings settings = Settings.builder().put("openid_connect_url", mockIdpServer.getDiscoverUri().toString()).put("roles_path", "$.roles").put("subject_path", "$.n").build();
        HTTPJwtKeyByOpenIdConnectAuthenticator jwtAuth = new HTTPJwtKeyByOpenIdConnectAuthenticator(settings, null);
        AuthCredentials creds = jwtAuth.extractCredentials((RestRequest)new FakeRestRequest((Map<String, String>)ImmutableMap.of((Object)"Authorization", (Object)TestJwts.MC_LIST_2_CLAIM_SIGNED_OCT_1), new HashMap<String, String>()), null);
        Assert.assertNull((Object)creds);
    }

    static {
        LoggerFactory.setInstance((LoggerFactory)new LoggerFactoryImpl());
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        wireMockProxy = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").enableBrowserProxying(true).proxyPassThrough(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
    }

    static class TestRestChannel
    implements RestChannel {
        final RestRequest restRequest;
        RestResponse response;

        TestRestChannel(RestRequest restRequest) {
            this.restRequest = restRequest;
        }

        public XContentBuilder newBuilder() throws IOException {
            return null;
        }

        public XContentBuilder newErrorBuilder() throws IOException {
            return null;
        }

        public XContentBuilder newBuilder(XContentType xContentType, boolean useFiltering) throws IOException {
            return null;
        }

        public BytesStreamOutput bytesOutput() {
            return null;
        }

        public void releaseOutputBuffer() {
        }

        public RestRequest request() {
            return this.restRequest;
        }

        public boolean detailedErrorsEnabled() {
            return false;
        }

        public void sendResponse(RestResponse response) {
            this.response = response;
        }

        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering) throws IOException {
            return null;
        }

        public XContentBuilder newBuilder(XContentType xContentType, XContentType responseContentType, boolean useFiltering, OutputStream out) throws IOException {
            return null;
        }
    }
}

