/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.oidc;

import com.floragunn.codova.config.net.TLSConfig;
import com.floragunn.codova.documents.DocNode;
import com.floragunn.codova.validation.ConfigValidationException;
import com.floragunn.codova.validation.VariableResolvers;
import com.floragunn.searchguard.authc.CredentialsException;
import com.floragunn.searchguard.authc.session.ActivatedFrontendConfig;
import com.floragunn.searchguard.authc.session.GetActivatedFrontendConfigAction;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.enterprise.auth.oidc.MockIpdServer;
import com.floragunn.searchguard.enterprise.auth.oidc.OidcAuthenticator;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwk;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwts;
import com.floragunn.searchguard.test.helper.certificate.TestCertificates;
import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchsupport.proxy.wiremock.WireMockRequestHeaderAddingFilter;
import com.github.tomakehurst.wiremock.core.Options;
import com.github.tomakehurst.wiremock.core.WireMockConfiguration;
import com.github.tomakehurst.wiremock.extension.Extension;
import com.github.tomakehurst.wiremock.junit.WireMockRule;
import com.google.common.collect.ImmutableMap;
import java.io.FileNotFoundException;
import java.net.URLEncoder;
import java.util.Map;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class OidcAuthenticatorTest {
    protected static MockIpdServer mockIdpServer;
    protected static MockIpdServer pkceMockIdpServer;
    private static TestCertificates testCertificates;
    private static final WireMockRequestHeaderAddingFilter REQUEST_HEADER_ADDING_FILTER;
    @ClassRule
    public static WireMockRule wireMockProxy;
    private static ConfigurationRepository.Context testContext;
    private static Map<String, Object> basicAuthenticatorSettings;
    private static String FRONTEND_BASE_URL;
    private static final TLSConfig IDP_TLS_CONFIG;

    @BeforeClass
    public static void setUp() throws Exception {
        mockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).start();
        basicAuthenticatorSettings = ImmutableMap.of((Object)"idp.openid_configuration_url", (Object)mockIdpServer.getDiscoverUri().toString(), (Object)"client_id", (Object)"Der Klient", (Object)"client_secret", (Object)"Das Geheimnis", (Object)"pkce", (Object)false);
        pkceMockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).requirePkce(true).start();
    }

    @AfterClass
    public static void tearDown() {
        if (mockIdpServer != null) {
            try {
                mockIdpServer.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Test
    public void basicTest() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1);
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
    }

    @Test
    public void userInfoTest() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator((Map)ImmutableMap.of((Object)"idp.openid_configuration_url", (Object)mockIdpServer.getDiscoverUri().toString(), (Object)"client_id", (Object)"Der Klient", (Object)"client_secret", (Object)"Das Geheimnis", (Object)"pkce", (Object)false, (Object)"get_user_info", (Object)true), testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1, (Map<String, Object>)ImmutableMap.of((Object)"sub", (Object)"Leonard McCoy", (Object)"user_info_attr", (Object)1234));
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
        Assert.assertEquals((String)authCredentials.getAttributesForUserMapping().toString(), (Object)1234, ((Map)authCredentials.getAttributesForUserMapping().get((Object)"oidc_user_info")).get("user_info_attr"));
    }

    @Test
    public void pkceTest() throws Exception {
        ImmutableMap authenticatorSettings = ImmutableMap.of((Object)"idp.openid_configuration_url", (Object)pkceMockIdpServer.getDiscoverUri().toString(), (Object)"client_id", (Object)"Der Klient");
        OidcAuthenticator authenticator = new OidcAuthenticator((Map)authenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = pkceMockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1);
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
    }

    @Test
    public void pkceMissingTest() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = pkceMockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1);
        Assert.assertNull((Object)ssoResponse);
    }

    @Test
    public void nextUrlTest() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        String redirectTarget = "/goto/0f8bc3727ebe162dc2ceeae137e607a1?sg_tenant=management";
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, redirectTarget, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1);
        Assert.assertTrue((String)ssoResponse, (boolean)ssoResponse.matches(".*state=[A-Za-z0-9\\-_]+%7C" + URLEncoder.encode(redirectTarget, "utf-8")));
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
        Assert.assertEquals((Object)redirectTarget, (Object)authCredentials.getRedirectUri());
    }

    @Test
    public void proxyTest() throws Exception {
        try (MockIpdServer proxyOnlyMockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader()).start();){
            DocNode config = DocNode.of((String)"idp.openid_configuration_url", (Object)proxyOnlyMockIdpServer.getDiscoverUri().toString(), (String)"idp.proxy.host", (Object)"127.0.0.8", (String)"idp.proxy.port", (Object)wireMockProxy.port(), (String)"idp.proxy.scheme", (Object)"http", (String)"client_id", (Object)"x", (Object[])new Object[]{"client_secret", "x"});
            OidcAuthenticator authenticator = new OidcAuthenticator((Map)config, testContext);
            ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
            authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
            Assert.assertNotNull((Object)authMethod);
            Assert.assertNotNull((String)authMethod.toString(), (Object)authMethod.getSsoLocation());
            String ssoResponse = proxyOnlyMockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1);
            ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
            AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
            Assert.assertNotNull((Object)authCredentials);
            Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
        }
    }

    @Test
    public void proxyWithTlsConfigTest() throws Exception {
        try (MockIpdServer proxyOnlyMockIdpServer = MockIpdServer.forKeySet(TestJwk.Jwks.ALL).acceptOnlyRequestsWithHeader(REQUEST_HEADER_ADDING_FILTER.getHeader()).useCustomTlsConfig(IDP_TLS_CONFIG).start();){
            DocNode config = DocNode.of((String)"idp.openid_configuration_url", (Object)proxyOnlyMockIdpServer.getDiscoverUri().toString(), (String)"idp.proxy.host", (Object)"127.0.0.8", (String)"idp.proxy.port", (Object)wireMockProxy.port(), (String)"idp.proxy.scheme", (Object)"http", (String)"client_id", (Object)"x", (Object[])new Object[]{"client_secret", "x", "idp.tls.trusted_cas", "#{file:" + testCertificates.getCaCertificate().getCertificateFile().getAbsolutePath() + "}", "idp.tls.verify_hostnames", false});
            OidcAuthenticator authenticator = new OidcAuthenticator((Map)config, testContext);
            ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
            authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
            Assert.assertNotNull((Object)authMethod);
            Assert.assertNotNull((String)authMethod.toString(), (Object)authMethod.getSsoLocation());
            String ssoResponse = proxyOnlyMockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_OCT_1);
            ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
            AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
            Assert.assertNotNull((Object)authCredentials);
            Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
        }
    }

    @Test
    public void testExp() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_EXPIRED_SIGNED_OCT_1);
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        try {
            AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
            Assert.fail((String)("Expected exception, got: " + authCredentials));
        }
        catch (CredentialsException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("The token has expired"));
        }
    }

    @Test
    public void testRS256() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_RSA_1);
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
        Assert.assertNotNull((Object)authCredentials);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
    }

    @Test
    public void testBadSignature() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), TestJwts.MC_COY_SIGNED_RSA_X);
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        try {
            AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
            Assert.fail((String)("Expected exception, got: " + authCredentials));
        }
        catch (CredentialsException e) {
            Assert.assertTrue((String)e.getMessage(), (boolean)e.getMessage().contains("Invalid JWT signature"));
        }
    }

    @Test
    public void testPeculiarJsonEscaping() throws Exception {
        OidcAuthenticator authenticator = new OidcAuthenticator(basicAuthenticatorSettings, testContext);
        ActivatedFrontendConfig.AuthMethod authMethod = new ActivatedFrontendConfig.AuthMethod("oidc", "OIDC", null);
        authMethod = authenticator.activateFrontendConfig(authMethod, new GetActivatedFrontendConfigAction.Request(null, null, FRONTEND_BASE_URL));
        String ssoResponse = mockIdpServer.handleSsoGetRequestURI(authMethod.getSsoLocation(), "eyJraWQiOiJraWRcLzEiLCJhbGciOiJSUzI1NiJ9.eyJzdWIiOiJMZW9uYXJkIE1jQ295IiwiYXVkIjoiVGVzdEF1ZGllbmNlIiwicm9sZXMiOiJyb2xlMSxyb2xlMiJ9.C0ntlhZtalpOYzgrzq_I4c6NxeQEmUk9Id5fVI6SXLIyscBrpS8nQ3bZrtX3qDiCYZDbp5n1OJMp3nhC7Ro2qdWjFe3FRSewKyZSowzVdQSlPetEsyLh3KdEs2ZPx3vry_y8SeCcJw_tiUOysceTMKzseL3DzF2PmoRRARLbQVI6zQvanRC8-WREraA2gTXpv_R-haOy7sf00VQhjGPMTCjqxXTfO6gzCz5-02tpGOOooQ8BcPy_At0nKjmuZgw_jODTL4TYs_T48M9tHxuY02qF3zv6iLonFz1mrb7Ff-65OUo4QVfqiOMxCOAe1JFP9o1tbtgaoiaWVznezjRK6A");
        ImmutableMap request = ImmutableMap.of((Object)"sso_result", (Object)ssoResponse, (Object)"sso_context", (Object)authMethod.getSsoContext(), (Object)"frontend_base_url", (Object)FRONTEND_BASE_URL);
        AuthCredentials authCredentials = authenticator.extractCredentials((Map)request);
        Assert.assertNotNull((Object)authCredentials);
        Assert.assertEquals((Object)"Leonard McCoy", (Object)authCredentials.getUsername());
    }

    static {
        testCertificates = TestCertificates.builder().ca("CN=root.ca.example.com,OU=SearchGuard,O=SearchGuard", 2, "password").addClients(new String[]{"CN=client.ca.example.com,OU=SearchGuard,O=SearchGuard"}).build();
        REQUEST_HEADER_ADDING_FILTER = new WireMockRequestHeaderAddingFilter("Proxy", "wire-mock");
        wireMockProxy = new WireMockRule((Options)WireMockConfiguration.options().bindAddress("127.0.0.8").caKeystorePath(testCertificates.getCaCertificate().getJksFile().getAbsolutePath()).trustAllProxyTargets(true).enableBrowserProxying(true).dynamicPort().extensions(new Extension[]{REQUEST_HEADER_ADDING_FILTER}));
        testContext = new ConfigurationRepository.Context(VariableResolvers.ALL, null, null, null, null);
        FRONTEND_BASE_URL = "http://whereever";
        try {
            IDP_TLS_CONFIG = new TLSConfig.Builder().trust(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/root-ca.pem").toFile()).clientCert(FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/idp.pem").toFile(), FileHelper.getAbsoluteFilePathFromClassPath((String)"oidc/idp/idp.key").toFile(), "secret").build();
        }
        catch (ConfigValidationException | FileNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

