/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.saml;

import com.floragunn.searchguard.test.helper.cluster.FileHelper;
import com.floragunn.searchguard.test.helper.network.PortAllocator;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.BindException;
import java.net.Socket;
import java.net.URISyntaxException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLServerSocket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.TrustManagerFactory;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import net.shibboleth.utilities.java.support.codec.Base64Support;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.apache.http.Header;
import org.apache.http.HttpConnectionFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.ConnSupport;
import org.apache.http.impl.DefaultBHttpServerConnection;
import org.apache.http.impl.bootstrap.HttpServer;
import org.apache.http.impl.bootstrap.SSLServerSetupHandler;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectBuilderFactory;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Marshaller;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.schema.XSAny;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.common.messaging.context.SAMLProtocolContext;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPRedirectDeflateDecoder;
import org.opensaml.saml.saml2.binding.security.impl.SAML2HTTPRedirectDeflateSignatureSecurityHandler;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AttributeValue;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnRequest;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.LogoutRequest;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusCode;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.StaticCredentialResolver;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.xmlsec.SignatureValidationParameters;
import org.opensaml.xmlsec.context.SecurityParametersContext;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoGenerator;
import org.opensaml.xmlsec.keyinfo.impl.StaticKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.X509KeyInfoGeneratorFactory;
import org.opensaml.xmlsec.signature.Signature;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureTrustEngine;
import org.opensaml.xmlsec.signature.support.Signer;
import org.opensaml.xmlsec.signature.support.impl.ExplicitKeySignatureTrustEngine;
import org.w3c.dom.Document;

class MockSamlIdpServer
implements Closeable {
    static final String ENTITY_ID = "http://test.entity";
    static final String CTX_METADATA = "/metadata";
    static final String CTX_SAML_SSO = "/saml/sso";
    static final String CTX_SAML_SLO = "/saml/slo";
    private HttpServer httpServer;
    private int port;
    private String uri;
    private final boolean ssl;
    private boolean wantAuthnRequestsSigned;
    private String idpEntityId;
    private X509Certificate signingCertificate;
    private Credential signingCredential;
    private String authenticateUser;
    private List<String> authenticateUserRoles;
    private int baseId = 1;
    private boolean signResponses = true;
    private X509Certificate spSignatureCertificate;
    private String endpointQueryString;
    private String defaultAssertionConsumerService;
    private int retry = 0;

    MockSamlIdpServer() throws IOException {
        this(false, ENTITY_ID, null);
    }

    MockSamlIdpServer(boolean ssl, String idpEntityId, String endpointQueryString) throws IOException {
        this.ssl = ssl;
        this.idpEntityId = idpEntityId;
        this.endpointQueryString = endpointQueryString;
        this.port = PortAllocator.TCP.allocateSingle(MockSamlIdpServer.class.getName(), 2345);
        this.uri = (ssl ? "https" : "http") + "://localhost:" + this.port;
    }

    public MockSamlIdpServer start() throws IOException {
        try {
            this.loadSigningKeys("saml/kirk-keystore.jks", "kirk");
            ServerBootstrap serverBootstrap = ServerBootstrap.bootstrap().setListenerPort(this.port).registerHandler(CTX_METADATA, new HttpRequestHandler(){

                public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                    MockSamlIdpServer.this.handleMetadataRequest(request, response, context);
                }
            }).registerHandler(CTX_SAML_SSO, new HttpRequestHandler(){

                public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                    MockSamlIdpServer.this.handleSsoRequest(request, response, context);
                }
            }).registerHandler(CTX_SAML_SLO, new HttpRequestHandler(){

                public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                    MockSamlIdpServer.this.handleSloRequest(request, response, context);
                }
            });
            if (this.ssl) {
                serverBootstrap = serverBootstrap.setSslContext(this.createSSLContext()).setSslSetupHandler(new SSLServerSetupHandler(){

                    public void initialize(SSLServerSocket socket) throws SSLException {
                        socket.setNeedClientAuth(true);
                    }
                }).setConnectionFactory((HttpConnectionFactory)new HttpConnectionFactory<DefaultBHttpServerConnection>(){
                    private ConnectionConfig cconfig = ConnectionConfig.DEFAULT;

                    public DefaultBHttpServerConnection createConnection(Socket socket) throws IOException {
                        SSLTestHttpServerConnection conn = new SSLTestHttpServerConnection(this.cconfig.getBufferSize(), this.cconfig.getFragmentSizeHint(), ConnSupport.createDecoder((ConnectionConfig)this.cconfig), ConnSupport.createEncoder((ConnectionConfig)this.cconfig), this.cconfig.getMessageConstraints(), null, null, null, null);
                        conn.bind(socket);
                        return conn;
                    }
                });
            }
            this.httpServer = serverBootstrap.create();
            this.httpServer.start();
            return this;
        }
        catch (BindException e) {
            ++this.retry;
            this.port = PortAllocator.TCP.allocateSingle(MockSamlIdpServer.class.getName(), 2345);
            this.uri = (this.ssl ? "https" : "http") + "://localhost:" + this.port;
            if (this.retry > 5) {
                throw e;
            }
            return this.start();
        }
    }

    public void shutdown() {
        if (this.httpServer != null) {
            this.httpServer.shutdown(5L, TimeUnit.SECONDS);
            this.httpServer = null;
        }
    }

    @Override
    public void close() throws IOException {
        this.shutdown();
    }

    public HttpServer getHttpServer() {
        return this.httpServer;
    }

    public String getUri() {
        if (this.endpointQueryString != null) {
            return this.uri + "?" + this.endpointQueryString;
        }
        return this.uri;
    }

    public String getMetadataUri() {
        if (this.endpointQueryString != null) {
            return this.uri + "/metadata?" + this.endpointQueryString;
        }
        return this.uri + CTX_METADATA;
    }

    public String getSamlSsoUri() {
        if (this.endpointQueryString != null) {
            return this.uri + "/saml/sso?" + this.endpointQueryString;
        }
        return this.uri + CTX_SAML_SSO;
    }

    public String getSamlSloUri() {
        if (this.endpointQueryString != null) {
            return this.uri + "/saml/slo?" + this.endpointQueryString;
        }
        return this.uri + CTX_SAML_SLO;
    }

    public int getPort() {
        return this.port;
    }

    protected void handleMetadataRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        response.setStatusCode(200);
        response.setHeader("Cache-Control", "public, max-age=31536000");
        response.setHeader("Content-Type", "application/xml");
        response.setEntity((HttpEntity)new StringEntity(this.createMetadata()));
    }

    protected void handleSsoRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if ("GET".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            this.handleSsoGetRequestBase(request);
        } else {
            response.setStatusCode(405);
        }
    }

    protected void handleSloRequest(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
        if ("GET".equalsIgnoreCase(request.getRequestLine().getMethod())) {
            this.handleSloGetRequestBase(request);
        } else {
            response.setStatusCode(405);
        }
    }

    public String handleSsoGetRequestURI(String samlRequestURI) {
        return this.handleSsoGetRequestBase((HttpRequest)new BasicHttpRequest("GET", samlRequestURI));
    }

    public String handleSsoGetRequestBase(HttpRequest request) {
        try {
            FakeHttpServletRequest httpServletRequest = new FakeHttpServletRequest(request);
            HTTPRedirectDeflateDecoder decoder = new HTTPRedirectDeflateDecoder();
            decoder.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
            decoder.setHttpServletRequest((HttpServletRequest)httpServletRequest);
            decoder.initialize();
            decoder.decode();
            MessageContext messageContext = decoder.getMessageContext();
            if (!(messageContext.getMessage() instanceof AuthnRequest)) {
                throw new RuntimeException("Expected AuthnRequest; received: " + messageContext.getMessage());
            }
            AuthnRequest authnRequest = (AuthnRequest)messageContext.getMessage();
            return this.createSamlAuthResponse(authnRequest);
        }
        catch (URISyntaxException | ComponentInitializationException | MessageDecodingException e) {
            throw new RuntimeException(e);
        }
    }

    public String createUnsolicitedSamlResponse() {
        return this.createSamlAuthResponse(null);
    }

    public void handleSloGetRequestURI(String samlRequestURI) {
        this.handleSloGetRequestBase((HttpRequest)new BasicHttpRequest("GET", samlRequestURI));
    }

    public void handleSloGetRequestBase(HttpRequest request) {
        try {
            FakeHttpServletRequest httpServletRequest = new FakeHttpServletRequest(request);
            HTTPRedirectDeflateDecoder decoder = new HTTPRedirectDeflateDecoder();
            decoder.setParserPool(XMLObjectProviderRegistrySupport.getParserPool());
            decoder.setHttpServletRequest((HttpServletRequest)httpServletRequest);
            decoder.initialize();
            decoder.decode();
            MessageContext messageContext = decoder.getMessageContext();
            if (!(messageContext.getMessage() instanceof LogoutRequest)) {
                throw new RuntimeException("Expected LogoutRequest; received: " + messageContext.getMessage());
            }
            LogoutRequest logoutRequest = (LogoutRequest)messageContext.getMessage();
            SAML2HTTPRedirectDeflateSignatureSecurityHandler signatureSecurityHandler = new SAML2HTTPRedirectDeflateSignatureSecurityHandler();
            SignatureValidationParameters validationParams = new SignatureValidationParameters();
            SecurityParametersContext securityParametersContext = (SecurityParametersContext)messageContext.getSubcontext(SecurityParametersContext.class, true);
            SAMLPeerEntityContext peerEntityContext = (SAMLPeerEntityContext)messageContext.getSubcontext(SAMLPeerEntityContext.class, true);
            peerEntityContext.setEntityId(this.idpEntityId);
            peerEntityContext.setRole(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
            SAMLProtocolContext protocolContext = (SAMLProtocolContext)messageContext.getSubcontext(SAMLProtocolContext.class, true);
            protocolContext.setProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            validationParams.setSignatureTrustEngine(this.buildSignatureTrustEngine(this.spSignatureCertificate));
            securityParametersContext.setSignatureValidationParameters(validationParams);
            signatureSecurityHandler.setHttpServletRequestSupplier(() -> httpServletRequest);
            signatureSecurityHandler.initialize();
            signatureSecurityHandler.invoke(messageContext);
            if (!this.authenticateUser.equals(logoutRequest.getNameID().getValue())) {
                throw new RuntimeException("Unexpected NameID in LogoutRequest: " + logoutRequest);
            }
        }
        catch (URISyntaxException | ComponentInitializationException | MessageDecodingException | MessageHandlerException e) {
            throw new RuntimeException(e);
        }
    }

    private String createSamlAuthResponse(AuthnRequest authnRequest) {
        try {
            Response response = MockSamlIdpServer.createSamlElement(Response.class);
            response.setID(this.nextId());
            if (authnRequest != null) {
                response.setInResponseTo(authnRequest.getID());
            }
            response.setVersion(SAMLVersion.VERSION_20);
            response.setStatus(this.createStatus("urn:oasis:names:tc:SAML:2.0:status:Success"));
            response.setIssueInstant(Instant.now());
            Assertion assertion = MockSamlIdpServer.createSamlElement(Assertion.class);
            response.getAssertions().add(assertion);
            assertion.setID(this.nextId());
            assertion.setIssueInstant(Instant.now());
            assertion.setIssuer(this.createIssuer());
            AuthnStatement authnStatement = MockSamlIdpServer.createSamlElement(AuthnStatement.class);
            assertion.getAuthnStatements().add(authnStatement);
            authnStatement.setAuthnInstant(Instant.now());
            authnStatement.setSessionIndex(this.nextId());
            authnStatement.setAuthnContext(this.createAuthnCotext());
            Subject subject = MockSamlIdpServer.createSamlElement(Subject.class);
            assertion.setSubject(subject);
            subject.setNameID(this.createNameID("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified", this.authenticateUser));
            if (authnRequest != null) {
                subject.getSubjectConfirmations().add(this.createSubjectConfirmation("urn:oasis:names:tc:SAML:2.0:cm:bearer", Instant.now().plusSeconds(60L), authnRequest.getID(), authnRequest.getAssertionConsumerServiceURL()));
            } else {
                subject.getSubjectConfirmations().add(this.createSubjectConfirmation("urn:oasis:names:tc:SAML:2.0:cm:bearer", Instant.now().plusSeconds(60L), null, this.defaultAssertionConsumerService));
            }
            Conditions conditions = MockSamlIdpServer.createSamlElement(Conditions.class);
            assertion.setConditions(conditions);
            conditions.setNotBefore(Instant.now());
            conditions.setNotOnOrAfter(Instant.now().plus(1L, ChronoUnit.MINUTES));
            if (this.authenticateUserRoles != null) {
                AttributeStatement attributeStatement = MockSamlIdpServer.createSamlElement(AttributeStatement.class);
                assertion.getAttributeStatements().add(attributeStatement);
                Attribute attribute = MockSamlIdpServer.createSamlElement(Attribute.class);
                attributeStatement.getAttributes().add(attribute);
                attribute.setName("roles");
                attribute.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
                for (String role : this.authenticateUserRoles) {
                    attribute.getAttributeValues().add(this.createXSAny(AttributeValue.DEFAULT_ELEMENT_NAME, role));
                }
            }
            if (this.signResponses) {
                Signature signature = MockSamlIdpServer.createSamlElement(Signature.class);
                assertion.setSignature(signature);
                signature.setSigningCredential(this.signingCredential);
                signature.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
                signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
                XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller((XMLObject)assertion).marshall((XMLObject)assertion);
                Signer.signObject((Signature)signature);
            }
            String marshalledXml = this.marshallSamlXml((XMLObject)response);
            return Base64Support.encode((byte[])marshalledXml.getBytes("UTF-8"), (boolean)false);
        }
        catch (UnsupportedEncodingException | EncodingException | MarshallingException | SignatureException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T createSamlElement(Class<T> clazz) {
        try {
            XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
            QName defaultElementName = (QName)clazz.getDeclaredField("DEFAULT_ELEMENT_NAME").get(null);
            return (T)builderFactory.getBuilder(defaultElementName).buildObject(defaultElementName);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchFieldException | java.lang.SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public XSAny createXSAny(QName elementName, String textContent) {
        XMLObjectBuilderFactory builderFactory = XMLObjectProviderRegistrySupport.getBuilderFactory();
        XSAny result = (XSAny)builderFactory.getBuilder(XSAny.TYPE_NAME).buildObject(elementName);
        result.setTextContent(textContent);
        return result;
    }

    private NameIDFormat createNameIDFormat(String format) {
        NameIDFormat nameIdFormat = MockSamlIdpServer.createSamlElement(NameIDFormat.class);
        nameIdFormat.setFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified");
        return nameIdFormat;
    }

    private Status createStatus(String statusCodeValue) {
        Status status = MockSamlIdpServer.createSamlElement(Status.class);
        StatusCode statusCode = MockSamlIdpServer.createSamlElement(StatusCode.class);
        statusCode.setValue(statusCodeValue);
        status.setStatusCode(statusCode);
        return status;
    }

    private NameID createNameID(String format, String value) {
        NameID nameID = MockSamlIdpServer.createSamlElement(NameID.class);
        nameID.setFormat(format);
        nameID.setValue(value);
        return nameID;
    }

    private SubjectConfirmation createSubjectConfirmation(String method, Instant notOnOrAfter, String inResponseTo, String recipient) {
        SubjectConfirmation result = MockSamlIdpServer.createSamlElement(SubjectConfirmation.class);
        result.setMethod(method);
        SubjectConfirmationData subjectConfirmationData = MockSamlIdpServer.createSamlElement(SubjectConfirmationData.class);
        result.setSubjectConfirmationData(subjectConfirmationData);
        subjectConfirmationData.setInResponseTo(inResponseTo);
        subjectConfirmationData.setNotOnOrAfter(notOnOrAfter);
        subjectConfirmationData.setRecipient(recipient);
        return result;
    }

    private Issuer createIssuer() {
        Issuer issuer = MockSamlIdpServer.createSamlElement(Issuer.class);
        issuer.setValue(this.idpEntityId);
        return issuer;
    }

    private AuthnContext createAuthnCotext() {
        AuthnContext authnContext = MockSamlIdpServer.createSamlElement(AuthnContext.class);
        AuthnContextClassRef authnContextClassRef = MockSamlIdpServer.createSamlElement(AuthnContextClassRef.class);
        authnContextClassRef.setAuthnContextClassRef("urn:oasis:names:tc:SAML:2.0:ac:classes:unspecified");
        authnContext.setAuthnContextClassRef(authnContextClassRef);
        return authnContext;
    }

    public String createMetadata() {
        try {
            EntityDescriptor idpEntityDescriptor = MockSamlIdpServer.createSamlElement(EntityDescriptor.class);
            idpEntityDescriptor.setEntityID(this.idpEntityId);
            IDPSSODescriptor idpSsoDescriptor = MockSamlIdpServer.createSamlElement(IDPSSODescriptor.class);
            idpEntityDescriptor.getRoleDescriptors().add(idpSsoDescriptor);
            idpSsoDescriptor.setWantAuthnRequestsSigned(Boolean.valueOf(this.wantAuthnRequestsSigned));
            idpSsoDescriptor.addSupportedProtocol("urn:oasis:names:tc:SAML:2.0:protocol");
            SingleLogoutService redirectSingleLogoutService = MockSamlIdpServer.createSamlElement(SingleLogoutService.class);
            idpSsoDescriptor.getSingleLogoutServices().add(redirectSingleLogoutService);
            redirectSingleLogoutService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            redirectSingleLogoutService.setLocation(this.getSamlSloUri());
            idpSsoDescriptor.getNameIDFormats().add(this.createNameIDFormat("urn:oasis:names:tc:SAML:1.1:nameid-format:unspecified"));
            SingleSignOnService redirectSingleSignOnService = MockSamlIdpServer.createSamlElement(SingleSignOnService.class);
            idpSsoDescriptor.getSingleSignOnServices().add(redirectSingleSignOnService);
            redirectSingleSignOnService.setBinding("urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect");
            redirectSingleSignOnService.setLocation(this.getSamlSsoUri());
            X509KeyInfoGeneratorFactory keyInfoGeneratorFactory = new X509KeyInfoGeneratorFactory();
            keyInfoGeneratorFactory.setEmitEntityCertificate(true);
            KeyInfoGenerator keyInfoGenerator = keyInfoGeneratorFactory.newInstance();
            KeyDescriptor signingKeyDescriptor = MockSamlIdpServer.createSamlElement(KeyDescriptor.class);
            idpSsoDescriptor.getKeyDescriptors().add(signingKeyDescriptor);
            signingKeyDescriptor.setUse(UsageType.SIGNING);
            signingKeyDescriptor.setKeyInfo(keyInfoGenerator.generate((Credential)new BasicX509Credential(this.signingCertificate)));
            return this.marshallSamlXml((XMLObject)idpEntityDescriptor);
        }
        catch (SecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private String marshallSamlXml(XMLObject xmlObject) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Marshaller out = XMLObjectProviderRegistrySupport.getMarshallerFactory().getMarshaller(xmlObject);
            out.marshall(xmlObject, document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            DOMSource source = new DOMSource(document);
            StringWriter stringWriter = new StringWriter();
            transformer.transform(source, new StreamResult(stringWriter));
            return stringWriter.toString();
        }
        catch (ParserConfigurationException | TransformerException | TransformerFactoryConfigurationError | MarshallingException e) {
            throw new RuntimeException(e);
        }
    }

    private SignatureTrustEngine buildSignatureTrustEngine(X509Certificate certificate) {
        StaticCredentialResolver credentialResolver = new StaticCredentialResolver((Credential)new BasicX509Credential(certificate));
        StaticKeyInfoCredentialResolver keyInfoCredentialResolver = new StaticKeyInfoCredentialResolver((Credential)new BasicX509Credential(certificate));
        return new ExplicitKeySignatureTrustEngine((CredentialResolver)credentialResolver, (KeyInfoCredentialResolver)keyInfoCredentialResolver);
    }

    void loadSigningKeys(String path, String alias) {
        try {
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)path).toFile());
            keyStore.load(keyStream, "changeit".toCharArray());
            kmf.init(keyStore, "changeit".toCharArray());
            this.signingCertificate = (X509Certificate)keyStore.getCertificate(alias);
            this.signingCredential = new BasicX509Credential(this.signingCertificate, (PrivateKey)keyStore.getKey(alias, "changeit".toCharArray()));
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | UnrecoverableKeyException | CertificateException e) {
            throw new RuntimeException(e);
        }
    }

    private SSLContext createSSLContext() {
        if (!this.ssl) {
            return null;
        }
        try {
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            KeyStore trustStore = KeyStore.getInstance("JKS");
            FileInputStream trustStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"jwt/truststore.jks").toFile());
            trustStore.load(trustStream, "changeit".toCharArray());
            tmf.init(trustStore);
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream keyStream = new FileInputStream(FileHelper.getAbsoluteFilePathFromClassPath((String)"jwt/node-0-keystore.jks").toFile());
            keyStore.load(keyStream, "changeit".toCharArray());
            kmf.init(keyStore, "changeit".toCharArray());
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(kmf.getKeyManagers(), tmf.getTrustManagers(), null);
            return sslContext;
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private String nextId() {
        return "MOCKSAML_" + this.baseId++;
    }

    public String getIdpEntityId() {
        return this.idpEntityId;
    }

    public String getAuthenticateUser() {
        return this.authenticateUser;
    }

    public void setAuthenticateUser(String authenticateUser) {
        this.authenticateUser = authenticateUser;
    }

    public List<String> getAuthenticateUserRoles() {
        return this.authenticateUserRoles;
    }

    public void setAuthenticateUserRoles(List<String> authenticateUserRoles) {
        this.authenticateUserRoles = authenticateUserRoles;
    }

    public boolean isSignResponses() {
        return this.signResponses;
    }

    public void setSignResponses(boolean signResponses) {
        this.signResponses = signResponses;
    }

    public X509Certificate getSpSignatureCertificate() {
        return this.spSignatureCertificate;
    }

    public void setSpSignatureCertificate(X509Certificate spSignatureCertificate) {
        this.spSignatureCertificate = spSignatureCertificate;
    }

    public String getEndpointQueryString() {
        return this.endpointQueryString;
    }

    public void setEndpointQueryString(String endpointQueryString) {
        this.endpointQueryString = endpointQueryString;
    }

    public String getDefaultAssertionConsumerService() {
        return this.defaultAssertionConsumerService;
    }

    public void setDefaultAssertionConsumerService(String defaultAssertionConsumerService) {
        this.defaultAssertionConsumerService = defaultAssertionConsumerService;
    }

    static class FakeHttpServletRequest
    implements HttpServletRequest {
        private final HttpRequest delegate;
        private final Map<String, String> queryParams;
        private final URIBuilder uriBuilder;

        FakeHttpServletRequest(HttpRequest delegate) throws URISyntaxException {
            this.delegate = delegate;
            String uri = delegate.getRequestLine().getUri();
            this.uriBuilder = new URIBuilder(uri);
            this.queryParams = this.uriBuilder.getQueryParams().stream().collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
        }

        public Object getAttribute(String arg0) {
            return null;
        }

        public Enumeration getAttributeNames() {
            return Collections.emptyEnumeration();
        }

        public String getCharacterEncoding() {
            if (this.delegate instanceof HttpEntityEnclosingRequest) {
                return ((HttpEntityEnclosingRequest)this.delegate).getEntity().getContentEncoding().getValue();
            }
            return null;
        }

        public int getContentLength() {
            if (this.delegate instanceof HttpEntityEnclosingRequest) {
                return (int)((HttpEntityEnclosingRequest)this.delegate).getEntity().getContentLength();
            }
            return 0;
        }

        public String getContentType() {
            if (this.delegate instanceof HttpEntityEnclosingRequest) {
                return ((HttpEntityEnclosingRequest)this.delegate).getEntity().getContentType().getValue();
            }
            return null;
        }

        public ServletInputStream getInputStream() throws IOException {
            if (this.delegate instanceof HttpEntityEnclosingRequest) {
                final InputStream in = ((HttpEntityEnclosingRequest)this.delegate).getEntity().getContent();
                return new ServletInputStream(){

                    public int read() throws IOException {
                        return in.read();
                    }

                    public int available() throws IOException {
                        return in.available();
                    }

                    public void close() throws IOException {
                        in.close();
                    }
                };
            }
            return null;
        }

        public String getLocalAddr() {
            return null;
        }

        public String getLocalName() {
            return null;
        }

        public int getLocalPort() {
            return 0;
        }

        public Locale getLocale() {
            return null;
        }

        public Enumeration getLocales() {
            return null;
        }

        public String getParameter(String name) {
            return this.queryParams.get(name);
        }

        public Map getParameterMap() {
            return Collections.unmodifiableMap(this.queryParams);
        }

        public Enumeration getParameterNames() {
            return Collections.enumeration(this.queryParams.keySet());
        }

        public String[] getParameterValues(String name) {
            String value = this.queryParams.get(name);
            if (value != null) {
                return new String[]{value};
            }
            return null;
        }

        public String getProtocol() {
            return null;
        }

        public BufferedReader getReader() throws IOException {
            if (this.delegate instanceof HttpEntityEnclosingRequest) {
                InputStream in = ((HttpEntityEnclosingRequest)this.delegate).getEntity().getContent();
                return new BufferedReader(new InputStreamReader(in));
            }
            return null;
        }

        public String getRealPath(String arg0) {
            return null;
        }

        public String getRemoteAddr() {
            return null;
        }

        public String getRemoteHost() {
            return null;
        }

        public int getRemotePort() {
            return 0;
        }

        public RequestDispatcher getRequestDispatcher(String arg0) {
            return null;
        }

        public String getScheme() {
            return null;
        }

        public String getServerName() {
            return null;
        }

        public int getServerPort() {
            return 0;
        }

        public boolean isSecure() {
            return false;
        }

        public void removeAttribute(String arg0) {
        }

        public void setAttribute(String arg0, Object arg1) {
        }

        public void setCharacterEncoding(String arg0) throws UnsupportedEncodingException {
        }

        public String getAuthType() {
            return null;
        }

        public String getContextPath() {
            return null;
        }

        public Cookie[] getCookies() {
            return null;
        }

        public long getDateHeader(String arg0) {
            return 0L;
        }

        public String getHeader(String name) {
            Header header = this.delegate.getFirstHeader(name);
            if (header != null) {
                return header.getValue();
            }
            return null;
        }

        public Enumeration getHeaderNames() {
            return Collections.enumeration(Arrays.asList(this.delegate.getAllHeaders()).stream().map(NameValuePair::getName).collect(Collectors.toSet()));
        }

        public Enumeration getHeaders(String name) {
            Header[] headers = this.delegate.getHeaders(name);
            if (headers != null) {
                return Collections.enumeration(Arrays.asList(headers).stream().map(NameValuePair::getName).collect(Collectors.toSet()));
            }
            return null;
        }

        public int getIntHeader(String name) {
            Header header = this.delegate.getFirstHeader(name);
            if (header != null) {
                return Integer.parseInt(header.getValue());
            }
            return 0;
        }

        public String getMethod() {
            return this.delegate.getRequestLine().getMethod();
        }

        public String getPathInfo() {
            return null;
        }

        public String getPathTranslated() {
            return this.uriBuilder.getPath();
        }

        public String getQueryString() {
            return this.delegate.getRequestLine().getUri().replaceAll("^.*\\?", "");
        }

        public String getRemoteUser() {
            return null;
        }

        public String getRequestURI() {
            return this.delegate.getRequestLine().getUri();
        }

        public StringBuffer getRequestURL() {
            return new StringBuffer(this.delegate.getRequestLine().getUri());
        }

        public String getRequestedSessionId() {
            return null;
        }

        public String getServletPath() {
            return null;
        }

        public HttpSession getSession() {
            return null;
        }

        public HttpSession getSession(boolean arg0) {
            return null;
        }

        public Principal getUserPrincipal() {
            return null;
        }

        public boolean isRequestedSessionIdFromCookie() {
            return false;
        }

        public boolean isRequestedSessionIdFromURL() {
            return false;
        }

        public boolean isRequestedSessionIdFromUrl() {
            return false;
        }

        public boolean isRequestedSessionIdValid() {
            return false;
        }

        public boolean isUserInRole(String arg0) {
            return false;
        }
    }

    static class SSLTestHttpServerConnection
    extends DefaultBHttpServerConnection {
        public SSLTestHttpServerConnection(int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageParserFactory<HttpRequest> requestParserFactory, HttpMessageWriterFactory<HttpResponse> responseWriterFactory) {
            super(buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestParserFactory, responseWriterFactory);
        }

        public Certificate[] getPeerCertificates() throws SSLPeerUnverifiedException {
            return ((SSLSocket)this.getSocket()).getSession().getPeerCertificates();
        }
    }
}

