/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.enterprise.auth.jwt.Jose;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwk;
import com.floragunn.searchguard.enterprise.auth.oidc.TestJwts;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.http.Header;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class RestAuthenticationIntegrationTests {
    static TestSgConfig.Authc AUTHC = new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("jwt").frontend(DocNode.of((String)"signing.jwks", (Object)Jose.toBasicObject((JsonMapObject)TestJwk.OCT_1_2_3))).skipIps(new String[]{"127.0.0.4"}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().rolesFrom("jwt.n").attrsFrom("a_n", "jwt.n").attrsFrom("a_m", "jwt.m")), new TestSgConfig.Authc.Domain("jwt").frontend(DocNode.of((String)"signing.jwks", (Object)Jose.toBasicObject((JsonMapObject)TestJwk.OCT_1_2_3))).acceptIps(new String[]{"127.0.0.4"}).userMapping(new TestSgConfig.Authc.Domain.UserMapping().rolesFromCommaSeparatedString("jwt.roles")), new TestSgConfig.Authc.Domain("basic/internal_users_db").frontend(DocNode.of((String)"challenge", (Object)false))});
    @ClassRule
    public static LocalCluster cluster = new LocalCluster.Builder().singleNode().sslEnabled().authc(AUTHC).enterpriseModulesEnabled().build();

    @Test
    public void jwt() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "bearer " + TestJwts.MC_LIST_2_CLAIM_SIGNED_OCT_1)});){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)"McList", (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), Arrays.asList("mcl", "mcl2"), (Object)response.getBodyAsDocNode().get("backend_roles"));
            Assert.assertTrue((String)response.getBody(), (boolean)((Collection)response.getBodyAsDocNode().get("attribute_names")).contains("a_m"));
        }
    }

    @Test
    public void jwt_commaSeparatedRoles() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[]{new BasicHeader("Authorization", "bearer " + TestJwts.MC_COY_SIGNED_OCT_1)});){
            client.setLocalAddress(InetAddress.getByAddress(new byte[]{127, 0, 0, 4}));
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)TestJwts.MC_COY.getClaims().getSubject(), (Object)response.getBodyAsDocNode().get("user_name"));
            Assert.assertEquals((String)response.getBody(), TestJwts.TEST_ROLES, (Object)ImmutableSet.of((Collection)((Collection)response.getBodyAsDocNode().get("backend_roles"))));
        }
    }

    @Test
    public void challenges() throws Exception {
        try (GenericRestClient client = cluster.getRestClient(new Header[0]);){
            GenericRestClient.HttpResponse response = client.get("/_searchguard/authinfo", new Header[0]);
            List wwwAuthenticateValues = response.getHeaders().stream().filter(h -> h.getName().equals("WWW-Authenticate")).map(h -> h.getValue()).collect(Collectors.toList());
            Assert.assertEquals((String)response.getBody(), (long)401L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getHeaders().toString(), (Object)ImmutableList.of((Object)"Bearer realm=\"Search Guard\""), wwwAuthenticateValues);
        }
    }
}

