/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.enterprise.auth.session;

import com.floragunn.codova.documents.DocNode;
import com.floragunn.fluent.collections.ImmutableList;
import com.floragunn.fluent.collections.ImmutableSet;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.TestSgConfig;
import com.floragunn.searchguard.test.helper.cluster.BearerAuthorization;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.junit.Assert;
import org.junit.ClassRule;
import org.junit.Test;

public class ExternalSearchGuardSessionAuthenticationBackendTest {
    static final TestSgConfig.User SESSION_TEST_USER = new TestSgConfig.User("session_test_user").roles(new String[]{"sg_all_access", "SGS_KIBANA_USER"});
    static final String HS512_KEY = "rJr-CU8cedCQxHetNz5jgNWVPrfDmgUMjiNcXmvxODZozLkNCbgDQRneS6kNXlnOLFC8IKx5mACOmcd4bsDD2w";
    static final DocNode HS512_JWK = DocNode.of((String)"kty", (Object)"oct", (String)"kid", (Object)"kid_a", (String)"k", (Object)"rJr-CU8cedCQxHetNz5jgNWVPrfDmgUMjiNcXmvxODZozLkNCbgDQRneS6kNXlnOLFC8IKx5mACOmcd4bsDD2w", (String)"alg", (Object)"HS512");
    static final String SESSION_JWT_AUDIENCE = "test_session_audience";
    @ClassRule
    public static LocalCluster sessionProvidingCluster = new LocalCluster.Builder().sgConfig(new TestSgConfig().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("basic/internal_users_db")})).frontendAuthc("default", new TestSgConfig.FrontendAuthc[]{new TestSgConfig.FrontendAuthc().authDomain(new TestSgConfig.FrontendAuthDomain("basic").label("Basic Login"))}).sessions(new TestSgConfig.Sessions().jwtSigningKeyHs512("rJr-CU8cedCQxHetNz5jgNWVPrfDmgUMjiNcXmvxODZozLkNCbgDQRneS6kNXlnOLFC8IKx5mACOmcd4bsDD2w").jwtAudience("test_session_audience")).user(SESSION_TEST_USER)).singleNode().sslEnabled().enterpriseModulesEnabled().build();
    @ClassRule
    public static LocalCluster sessionConsumingCluster = new LocalCluster.Builder().sgConfig(new TestSgConfig().authc(new TestSgConfig.Authc(new TestSgConfig.Authc.Domain[]{new TestSgConfig.Authc.Domain("jwt/external_session").frontend(DocNode.of((String)"signing.jwks.keys", Arrays.asList(HS512_JWK), (String)"required_audience", (Object)"test_session_audience")).backend(DocNode.of((String)"hosts", (Object)ImmutableList.of((Object)"#{var:session_hosts}", (Object)"https://invalidhost.example.com:9200", (Object)"https://invalidhost2.example.com:9200", (Object[])new String[0]), (String)"tls.trust_all", (Object)true, (String)"tls.verify_hostnames", (Object)false))})).var("session_hosts", () -> sessionProvidingCluster.getHttpAddressAsURI().toString())).singleNode().sslEnabled().enterpriseModulesEnabled().build();

    @Test
    public void basicTest() throws Exception {
        String token;
        GenericRestClient.HttpResponse response;
        try (GenericRestClient restClient = sessionProvidingCluster.getRestClient(new Header[0]);){
            response = restClient.postJson("/_searchguard/auth/session", (Map)DocNode.of((String)"mode", (Object)"basic", (String)"user", (Object)SESSION_TEST_USER.getName(), (String)"password", (Object)SESSION_TEST_USER.getPassword()), new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)201L, (long)response.getStatusCode());
            token = response.getBodyAsDocNode().getAsString("token");
            Assert.assertNotNull((String)response.getBody(), (Object)token);
        }
        restClient = sessionConsumingCluster.getRestClient(new Header[]{new BearerAuthorization(token)});
        try {
            response = restClient.get("/_searchguard/authinfo", new Header[0]);
            Assert.assertEquals((String)response.getBody(), (long)200L, (long)response.getStatusCode());
            Assert.assertEquals((String)response.getBody(), (Object)SESSION_TEST_USER.getName(), (Object)response.getBodyAsDocNode().getAsString("user_name"));
            Assert.assertEquals((String)response.getBody(), (Object)SESSION_TEST_USER.getRoleNames(), (Object)ImmutableSet.of((Collection)response.getBodyAsDocNode().getAsListOfStrings("sg_roles")));
        }
        finally {
            if (restClient != null) {
                restClient.close();
            }
        }
    }
}

