/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.authtoken;

import com.floragunn.codova.config.net.CacheConfig;
import com.floragunn.codova.documents.DocReader;
import com.floragunn.codova.documents.DocumentParseException;
import com.floragunn.codova.documents.UnexpectedDocumentStructureException;
import com.floragunn.searchguard.authtoken.AuthToken;
import com.floragunn.searchguard.authtoken.AuthTokenModule;
import com.floragunn.searchguard.authtoken.AuthTokenService;
import com.floragunn.searchguard.authtoken.AuthTokenServiceConfig;
import com.floragunn.searchguard.authtoken.NoSuchAuthTokenException;
import com.floragunn.searchguard.authtoken.RequestedPrivileges;
import com.floragunn.searchguard.authtoken.TestJwk;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenRequest;
import com.floragunn.searchguard.authtoken.api.CreateAuthTokenResponse;
import com.floragunn.searchguard.authz.AuthorizationService;
import com.floragunn.searchguard.authz.PrivilegesEvaluator;
import com.floragunn.searchguard.authz.actions.Actions;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.ProtectedConfigIndexService;
import com.floragunn.searchguard.configuration.StaticSgConfig;
import com.floragunn.searchguard.sgconf.history.ConfigHistoryService;
import com.floragunn.searchguard.support.PrivilegedConfigClient;
import com.floragunn.searchguard.test.GenericRestClient;
import com.floragunn.searchguard.test.helper.cluster.LocalCluster;
import com.floragunn.searchguard.user.User;
import com.floragunn.searchsupport.StaticSettings;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.io.Decoders;
import io.jsonwebtoken.io.DeserializationException;
import io.jsonwebtoken.io.Deserializer;
import io.jsonwebtoken.security.Keys;
import java.io.IOException;
import java.io.Reader;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.http.Header;
import org.elasticsearch.client.internal.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;

public class AuthTokenServiceTest {
    private static ConfigurationRepository configurationRepository;
    private static PrivilegesEvaluator privilegesEvaluator;
    private static AuthorizationService authorizationService;
    private static ProtectedConfigIndexService protectedConfigIndexService;
    private static ThreadPool threadPool;
    private static PrivilegedConfigClient privilegedConfigClient;
    private static StaticSgConfig staticSgConfig;
    private static ClusterService clusterService;
    private static Deserializer<Map<String, ?>> jsonDeserializer;
    @ClassRule
    public static LocalCluster.Embedded cluster;

    @BeforeClass
    public static void setupDependencies() {
        configurationRepository = (ConfigurationRepository)cluster.getInjectable(ConfigurationRepository.class);
        authorizationService = (AuthorizationService)cluster.getInjectable(AuthorizationService.class);
        privilegesEvaluator = (PrivilegesEvaluator)cluster.getInjectable(PrivilegesEvaluator.class);
        protectedConfigIndexService = (ProtectedConfigIndexService)cluster.getInjectable(ProtectedConfigIndexService.class);
        clusterService = (ClusterService)cluster.getInjectable(ClusterService.class);
        threadPool = (ThreadPool)cluster.getInjectable(ThreadPool.class);
        staticSgConfig = (StaticSgConfig)cluster.getInjectable(StaticSgConfig.class);
        privilegedConfigClient = PrivilegedConfigClient.adapt((Client)cluster.node().client());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void basicTest() throws Exception {
        User testUser = User.forUser((String)"test_user").backendRoles(new String[]{"r1", "r2", "r3"}).build();
        AuthTokenServiceConfig config = new AuthTokenServiceConfig();
        Actions actions = new Actions(null);
        config.setEnabled(true);
        config.setJwtSigningKey(TestJwk.OCT_1);
        config.setJwtAud("_test_aud");
        config.setMaxTokensPerUser(100);
        config.setCacheConfig(CacheConfig.DEFAULT);
        ConfigHistoryService configHistoryService = new ConfigHistoryService(configurationRepository, staticSgConfig, privilegedConfigClient, protectedConfigIndexService, actions, StaticSettings.EMPTY, privilegesEvaluator);
        AuthTokenService authTokenService = new AuthTokenService(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService, StaticSettings.EMPTY, threadPool, clusterService, protectedConfigIndexService, actions, config);
        try {
            authTokenService.setSendTokenUpdates(false);
            authTokenService.waitForInitComplete(10000L);
            RequestedPrivileges requestedPrivileges = RequestedPrivileges.parseYaml((String)"cluster_permissions:\n- cluster:test\nroles:\n- r1\n- r0\ndata_stream_permissions:\n- data_stream_patterns: ['ds_1']\n  allowed_actions: ['action:x']");
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(requestedPrivileges);
            CreateAuthTokenResponse response = authTokenService.createJwt(testUser, request);
            JwtParser jwtParser = Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64URL.decode((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg")))).json(jsonDeserializer).build();
            Claims claims = (Claims)jwtParser.parseSignedClaims((CharSequence)response.getJwt()).getPayload();
            Map claimsRequested = (Map)claims.get("requested", Map.class);
            Assert.assertEquals((Object)testUser.getName(), (Object)claims.getSubject());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), claimsRequested.get("cluster_permissions"));
            Assert.assertEquals((long)1L, (long)((List)claimsRequested.get("data_stream_permissions")).size());
            Assert.assertEquals(Collections.singletonList("ds_1"), ((Map)((List)claimsRequested.get("data_stream_permissions")).get(0)).get("data_stream_patterns"));
            Assert.assertEquals(Collections.singletonList("action:x"), ((Map)((List)claimsRequested.get("data_stream_permissions")).get(0)).get("allowed_actions"));
            Assert.assertEquals(Collections.singletonList("r1"), ((Map)claims.get((Object)"base")).get("r_be"));
            Assert.assertEquals((long)1L, (long)claims.getAudience().size());
            Assert.assertTrue((boolean)claims.getAudience().contains(config.getJwtAud()));
            AuthToken authToken = authTokenService.getByClaims((Map)claims);
            Assert.assertEquals((Object)testUser.getName(), (Object)authToken.getUserName());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), (Object)authToken.getRequestedPrivileges().getClusterPermissions());
            Assert.assertEquals(Collections.singletonList("r1"), (Object)authToken.getBase().getBackendRoles());
        }
        finally {
            authTokenService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reloadFromCacheTest() throws Exception {
        User testUser = User.forUser((String)"test_user").backendRoles(new String[]{"r1", "r2", "r3"}).build();
        Actions actions = new Actions(null);
        AuthTokenServiceConfig config = new AuthTokenServiceConfig();
        config.setEnabled(true);
        config.setJwtSigningKey(TestJwk.OCT_1);
        config.setJwtAud("_test_aud");
        config.setMaxTokensPerUser(100);
        config.setCacheConfig(CacheConfig.DEFAULT);
        ConfigHistoryService configHistoryService = new ConfigHistoryService(configurationRepository, staticSgConfig, privilegedConfigClient, protectedConfigIndexService, actions, StaticSettings.EMPTY, privilegesEvaluator);
        AuthTokenService authTokenService = new AuthTokenService(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService, StaticSettings.EMPTY, threadPool, clusterService, protectedConfigIndexService, actions, config);
        try {
            authTokenService.setSendTokenUpdates(false);
            authTokenService.waitForInitComplete(10000L);
            RequestedPrivileges requestedPrivileges = RequestedPrivileges.parseYaml((String)"cluster_permissions:\n- cluster:test\nroles:\n- r1\n- r0");
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(requestedPrivileges);
            CreateAuthTokenResponse response = authTokenService.createJwt(testUser, request);
            JwtParser jwtParser = Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64URL.decode((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg")))).json(jsonDeserializer).build();
            Claims claims = (Claims)jwtParser.parseSignedClaims((CharSequence)response.getJwt()).getPayload();
            Assert.assertEquals((Object)testUser.getName(), (Object)claims.getSubject());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), ((Map)claims.get((Object)"requested")).get("cluster_permissions"));
            Assert.assertEquals(Collections.singletonList("r1"), ((Map)claims.get((Object)"base")).get("r_be"));
            Assert.assertEquals((long)1L, (long)claims.getAudience().size());
            Assert.assertTrue((boolean)claims.getAudience().contains(config.getJwtAud()));
            AuthToken authToken = authTokenService.getByClaims((Map)claims);
            Assert.assertEquals((Object)testUser.getName(), (Object)authToken.getUserName());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), (Object)authToken.getRequestedPrivileges().getClusterPermissions());
            Assert.assertEquals(Collections.singletonList("r1"), (Object)authToken.getBase().getBackendRoles());
        }
        finally {
            authTokenService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void reloadFromIndexTest() throws Exception {
        User testUser = User.forUser((String)"test_user").backendRoles(new String[]{"r1", "r2", "r3"}).build();
        AuthTokenServiceConfig config = new AuthTokenServiceConfig();
        Actions actions = new Actions(null);
        config.setEnabled(true);
        config.setJwtSigningKey(TestJwk.OCT_1);
        config.setJwtAud("_test_aud");
        config.setMaxTokensPerUser(100);
        config.setCacheConfig(CacheConfig.DEFAULT);
        ConfigHistoryService configHistoryService = new ConfigHistoryService(configurationRepository, staticSgConfig, privilegedConfigClient, protectedConfigIndexService, actions, StaticSettings.EMPTY, privilegesEvaluator);
        AuthTokenService authTokenService = new AuthTokenService(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService, StaticSettings.EMPTY, threadPool, clusterService, protectedConfigIndexService, actions, config);
        try {
            authTokenService.setSendTokenUpdates(false);
            authTokenService.waitForInitComplete(20000L);
            RequestedPrivileges requestedPrivileges = RequestedPrivileges.parseYaml((String)"cluster_permissions:\n- cluster:test\nroles:\n- r1\n- r0");
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(requestedPrivileges);
            CreateAuthTokenResponse response = authTokenService.createJwt(testUser, request);
            JwtParser jwtParser = Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64URL.decode((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg")))).json(jsonDeserializer).build();
            Claims claims = (Claims)jwtParser.parseSignedClaims((CharSequence)response.getJwt()).getPayload();
            Assert.assertEquals((Object)testUser.getName(), (Object)claims.getSubject());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), ((Map)claims.get((Object)"requested")).get("cluster_permissions"));
            Assert.assertEquals(Collections.singletonList("r1"), ((Map)claims.get((Object)"base")).get("r_be"));
            Assert.assertEquals((long)1L, (long)claims.getAudience().size());
            Assert.assertTrue((boolean)claims.getAudience().contains(config.getJwtAud()));
            AuthToken authToken = authTokenService.getByClaims((Map)claims);
            Assert.assertEquals((Object)testUser.getName(), (Object)authToken.getUserName());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), (Object)authToken.getRequestedPrivileges().getClusterPermissions());
            Assert.assertEquals(Collections.singletonList("r1"), (Object)authToken.getBase().getBackendRoles());
            authTokenService.shutdown();
            ConfigHistoryService configHistoryService2 = new ConfigHistoryService(configurationRepository, staticSgConfig, privilegedConfigClient, protectedConfigIndexService, actions, StaticSettings.EMPTY, privilegesEvaluator);
            AuthTokenService authTokenService2 = new AuthTokenService(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService2, StaticSettings.EMPTY, threadPool, clusterService, protectedConfigIndexService, actions, config);
            authTokenService2.setSendTokenUpdates(false);
            authTokenService2.waitForInitComplete(20000L);
            AuthToken authToken2 = authTokenService2.getByClaims((Map)claims);
            Assert.assertEquals((Object)authToken.getUserName(), (Object)authToken2.getUserName());
            Assert.assertEquals((Object)authToken.getRequestedPrivileges().getClusterPermissions(), (Object)authToken2.getRequestedPrivileges().getClusterPermissions());
            Assert.assertEquals((Object)authToken.getBase().getBackendRoles(), (Object)authToken2.getBase().getBackendRoles());
        }
        finally {
            authTokenService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void expiryTest() throws Exception {
        User testUser = User.forUser((String)"test_user").backendRoles(new String[]{"r1", "r2", "r3"}).build();
        AuthTokenServiceConfig config = new AuthTokenServiceConfig();
        Actions actions = new Actions(null);
        config.setEnabled(true);
        config.setJwtSigningKey(TestJwk.OCT_1);
        config.setJwtAud("_test_aud");
        config.setMaxTokensPerUser(100);
        config.setCacheConfig(CacheConfig.DEFAULT);
        Settings authTokenServiceSettings = Settings.builder().put(AuthTokenService.CLEANUP_INTERVAL.name(), TimeValue.timeValueSeconds((long)1L)).build();
        ConfigHistoryService configHistoryService = new ConfigHistoryService(configurationRepository, staticSgConfig, privilegedConfigClient, protectedConfigIndexService, actions, StaticSettings.EMPTY, privilegesEvaluator);
        AuthTokenService authTokenService = new AuthTokenService(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService, new StaticSettings(authTokenServiceSettings, null), threadPool, clusterService, protectedConfigIndexService, actions, config);
        try {
            authTokenService.setSendTokenUpdates(false);
            authTokenService.waitForInitComplete(10000L);
            RequestedPrivileges requestedPrivileges = RequestedPrivileges.parseYaml((String)"cluster_permissions:\n- cluster:test\nroles:\n- r1\n- r0");
            CreateAuthTokenRequest request = new CreateAuthTokenRequest(requestedPrivileges);
            request.setExpiresAfter(Duration.ofSeconds(5L));
            CreateAuthTokenResponse response = authTokenService.createJwt(testUser, request);
            JwtParser jwtParser = Jwts.parser().verifyWith(Keys.hmacShaKeyFor((byte[])((byte[])Decoders.BASE64URL.decode((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg")))).json(jsonDeserializer).build();
            Claims claims = (Claims)jwtParser.parseSignedClaims((CharSequence)response.getJwt()).getPayload();
            String id = claims.get((Object)"jti").toString();
            Assert.assertEquals((Object)testUser.getName(), (Object)claims.getSubject());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), ((Map)claims.get((Object)"requested")).get("cluster_permissions"));
            Assert.assertEquals(Collections.singletonList("r1"), ((Map)claims.get((Object)"base")).get("r_be"));
            Assert.assertEquals((long)1L, (long)claims.getAudience().size());
            Assert.assertTrue((boolean)claims.getAudience().contains(config.getJwtAud()));
            Assert.assertTrue((String)(response.getAuthToken().getCreationTime().plusSeconds(11L) + " <= " + claims.getExpiration().getTime() + "\n" + claims.toString()), (response.getAuthToken().getCreationTime().plusSeconds(11L).toEpochMilli() > claims.getExpiration().getTime() ? 1 : 0) != 0);
            AuthToken authToken = authTokenService.getByIdFromIndex(id);
            Assert.assertEquals((Object)testUser.getName(), (Object)authToken.getUserName());
            Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), (Object)authToken.getRequestedPrivileges().getClusterPermissions());
            Assert.assertEquals(Collections.singletonList("r1"), (Object)authToken.getBase().getBackendRoles());
            Thread.sleep(10000L);
            try {
                authToken = authTokenService.getByIdFromIndex(id);
                Assert.fail((String)("" + authToken));
            }
            catch (NoSuchAuthTokenException noSuchAuthTokenException) {
                // empty catch block
            }
        }
        finally {
            authTokenService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void authTokenBasedOnAuthTokenTest() throws Exception {
        try (GenericRestClient restClient = cluster.getAdminCertRestClient();){
            User testUser = User.forUser((String)"test_user").backendRoles(new String[]{"r1", "r2", "r3"}).build();
            AuthTokenServiceConfig config = new AuthTokenServiceConfig();
            Actions actions = new Actions(null);
            config.setEnabled(true);
            config.setJwtSigningKey(TestJwk.OCT_1);
            config.setJwtAud("_test_aud");
            config.setMaxTokensPerUser(100);
            config.setExcludeClusterPermissions(Collections.emptyList());
            config.setCacheConfig(CacheConfig.DEFAULT);
            ConfigHistoryService configHistoryService = new ConfigHistoryService(configurationRepository, staticSgConfig, privilegedConfigClient, protectedConfigIndexService, actions, StaticSettings.EMPTY, privilegesEvaluator);
            AuthTokenService authTokenService = new AuthTokenService(privilegedConfigClient, authorizationService, privilegesEvaluator, configHistoryService, StaticSettings.EMPTY, threadPool, clusterService, protectedConfigIndexService, actions, config);
            try {
                authTokenService.setSendTokenUpdates(false);
                authTokenService.waitForInitComplete(10000L);
                RequestedPrivileges requestedPrivileges = RequestedPrivileges.parseYaml((String)"cluster_permissions:\n- cluster:test");
                CreateAuthTokenRequest request = new CreateAuthTokenRequest(requestedPrivileges);
                CreateAuthTokenResponse createAuthTokenResponse = authTokenService.createJwt(testUser, request);
                JwtParser jwtParser = Jwts.parser().setSigningKey((byte[])Decoders.BASE64URL.decode((Object)"eTDZjSqRD9Abhod9iqeGX_7o93a-eElTeXWAF6FmzQshmRIrPD-C9ET3pFjJ_IBrzmWIZDk8ig-X_PIyGmKsxNMsrU-0BNWF5gJq5xOp4rYTl8z66Tw9wr8tHLxLxgJqkLSuUCRBZvlZlQ7jNdhBBxgM-hdSSzsN1T33qdIwhrUeJ-KXI5yKUXHjoWFYb9tETbYQ4NvONowkCsXK_flp-E3F_OcKe_z5iVUszAV8QfCod1zhbya540kDejXCL6N_XMmhWJqum7UJ3hgf6DEtroPSnVpHt4iR5w9ArKK-IBgluPght03gNcoNqwz7p77TFbdOmUKF_PWy1bcdbaUoSg")).json(jsonDeserializer).build();
                Claims claims = (Claims)jwtParser.parseSignedClaims((CharSequence)createAuthTokenResponse.getJwt()).getPayload();
                Assert.assertEquals((Object)testUser.getName(), (Object)claims.getSubject());
                Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), ((Map)claims.get((Object)"requested")).get("cluster_permissions"));
                AuthToken baseAuthToken = authTokenService.getByClaims((Map)claims);
                Assert.assertEquals((Object)testUser.getName(), (Object)baseAuthToken.getUserName());
                Assert.assertEquals((Object)requestedPrivileges.getClusterPermissions(), (Object)baseAuthToken.getRequestedPrivileges().getClusterPermissions());
                GenericRestClient.HttpResponse roleUpdateResponse = restClient.putJson("/_searchguard/api/roles/new_test_role", "{\"cluster_permissions\": [\"*\"]}", new Header[0]);
                Assert.assertEquals((String)roleUpdateResponse.getBody(), (long)201L, (long)roleUpdateResponse.getStatusCode());
                Thread.sleep(500L);
                User authTokenTestUser = User.forUser((String)testUser.getName()).backendRoles(new String[]{"r1", "r2", "r3"}).type("sg_auth_token").specialAuthzConfig((Object)baseAuthToken.getId()).build();
                request.setTokenName("auth_token_based_on_auth_token");
                createAuthTokenResponse = authTokenService.createJwt(authTokenTestUser, request);
                claims = (Claims)jwtParser.parseSignedClaims((CharSequence)createAuthTokenResponse.getJwt()).getPayload();
                AuthToken authTokenBasedOnAuthToken = authTokenService.getByClaims((Map)claims);
                Assert.assertEquals((Object)baseAuthToken.getBase(), (Object)authTokenBasedOnAuthToken.getBase());
                request.setTokenName("auth_token_with_fresh_base");
                createAuthTokenResponse = authTokenService.createJwt(testUser, request);
                claims = (Claims)jwtParser.parseSignedClaims((CharSequence)createAuthTokenResponse.getJwt()).getPayload();
                AuthToken authTokenWithFreshBase = authTokenService.getByClaims((Map)claims);
                Assert.assertNotEquals((Object)baseAuthToken.getBase(), (Object)authTokenWithFreshBase.getBase());
            }
            finally {
                authTokenService.shutdown();
            }
        }
    }

    static {
        jsonDeserializer = new Deserializer<Map<String, ?>>(){

            public Map<String, ?> deserialize(byte[] bytes) throws DeserializationException {
                try {
                    return DocReader.json().readObject(bytes);
                }
                catch (DocumentParseException | UnexpectedDocumentStructureException e) {
                    throw new DeserializationException(e.getMessage(), e);
                }
            }

            public Map<String, ?> deserialize(Reader reader) throws DeserializationException {
                try {
                    return DocReader.json().readObject(reader);
                }
                catch (DocumentParseException | UnexpectedDocumentStructureException | IOException e) {
                    throw new DeserializationException(e.getMessage(), e);
                }
            }
        };
        cluster = new LocalCluster.Builder().resources("authtoken").singleNode().enterpriseModulesEnabled().sslEnabled().disableModule(AuthTokenModule.class).embedded().build();
    }
}

